package software.amazon.awscdk.services.cloudfront;

/**
 * A custom origin configuration.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.531Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CustomOriginConfig")
@software.amazon.jsii.Jsii.Proxy(CustomOriginConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CustomOriginConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name of the custom origin.
     * <p>
     * Should not include the path - that should be in the parent SourceConfiguration
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The SSL versions to use when interacting with the origin.
     * <p>
     * Default: OriginSslPolicy.TLS_V1_2
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getAllowedOriginSslVersions() {
        return null;
    }

    /**
     * The origin HTTP port.
     * <p>
     * Default: 80
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
        return null;
    }

    /**
     * The origin HTTPS port.
     * <p>
     * Default: 443
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
        return null;
    }

    /**
     * Any additional headers to pass to the origin.
     * <p>
     * Default: - No additional headers are passed.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
        return null;
    }

    /**
     * The keep alive timeout when making calls in seconds.
     * <p>
     * Default: Duration.seconds(5)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getOriginKeepaliveTimeout() {
        return null;
    }

    /**
     * The relative path to the origin root to use for sources.
     * <p>
     * Default: /
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
        return null;
    }

    /**
     * The protocol (http or https) policy to use when interacting with the origin.
     * <p>
     * Default: OriginProtocolPolicy.HttpsOnly
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getOriginProtocolPolicy() {
        return null;
    }

    /**
     * The read timeout when calling the origin in seconds.
     * <p>
     * Default: Duration.seconds(30)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getOriginReadTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CustomOriginConfig> {
        private java.lang.String domainName;
        private java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> allowedOriginSslVersions;
        private java.lang.Number httpPort;
        private java.lang.Number httpsPort;
        private java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private software.amazon.awscdk.core.Duration originKeepaliveTimeout;
        private java.lang.String originPath;
        private software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy originProtocolPolicy;
        private software.amazon.awscdk.core.Duration originReadTimeout;

        /**
         * Sets the value of {@link CustomOriginConfig#getDomainName}
         * @param domainName The domain name of the custom origin. This parameter is required.
         *                   Should not include the path - that should be in the parent SourceConfiguration
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getAllowedOriginSslVersions}
         * @param allowedOriginSslVersions The SSL versions to use when interacting with the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedOriginSslVersions(java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> allowedOriginSslVersions) {
            this.allowedOriginSslVersions = allowedOriginSslVersions;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getHttpPort}
         * @param httpPort The origin HTTP port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpPort(java.lang.Number httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getHttpsPort}
         * @param httpsPort The origin HTTPS port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpsPort(java.lang.Number httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getOriginHeaders}
         * @param originHeaders Any additional headers to pass to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originHeaders(java.util.Map<java.lang.String, java.lang.String> originHeaders) {
            this.originHeaders = originHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getOriginKeepaliveTimeout}
         * @param originKeepaliveTimeout The keep alive timeout when making calls in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originKeepaliveTimeout(software.amazon.awscdk.core.Duration originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getOriginPath}
         * @param originPath The relative path to the origin root to use for sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getOriginProtocolPolicy}
         * @param originProtocolPolicy The protocol (http or https) policy to use when interacting with the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originProtocolPolicy(software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CustomOriginConfig#getOriginReadTimeout}
         * @param originReadTimeout The read timeout when calling the origin in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originReadTimeout(software.amazon.awscdk.core.Duration originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomOriginConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CustomOriginConfig build() {
            return new Jsii$Proxy(domainName, allowedOriginSslVersions, httpPort, httpsPort, originHeaders, originKeepaliveTimeout, originPath, originProtocolPolicy, originReadTimeout);
        }
    }

    /**
     * An implementation for {@link CustomOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomOriginConfig {
        private final java.lang.String domainName;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> allowedOriginSslVersions;
        private final java.lang.Number httpPort;
        private final java.lang.Number httpsPort;
        private final java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private final software.amazon.awscdk.core.Duration originKeepaliveTimeout;
        private final java.lang.String originPath;
        private final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy originProtocolPolicy;
        private final software.amazon.awscdk.core.Duration originReadTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.allowedOriginSslVersions = this.jsiiGet("allowedOriginSSLVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginSslPolicy.class)));
            this.httpPort = this.jsiiGet("httpPort", java.lang.Number.class);
            this.httpsPort = this.jsiiGet("httpsPort", java.lang.Number.class);
            this.originHeaders = this.jsiiGet("originHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originKeepaliveTimeout = this.jsiiGet("originKeepaliveTimeout", software.amazon.awscdk.core.Duration.class);
            this.originPath = this.jsiiGet("originPath", java.lang.String.class);
            this.originProtocolPolicy = this.jsiiGet("originProtocolPolicy", software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy.class);
            this.originReadTimeout = this.jsiiGet("originReadTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String domainName, final java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> allowedOriginSslVersions, final java.lang.Number httpPort, final java.lang.Number httpsPort, final java.util.Map<java.lang.String, java.lang.String> originHeaders, final software.amazon.awscdk.core.Duration originKeepaliveTimeout, final java.lang.String originPath, final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy originProtocolPolicy, final software.amazon.awscdk.core.Duration originReadTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.allowedOriginSslVersions = allowedOriginSslVersions;
            this.httpPort = httpPort;
            this.httpsPort = httpsPort;
            this.originHeaders = originHeaders;
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            this.originPath = originPath;
            this.originProtocolPolicy = originProtocolPolicy;
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cloudfront.OriginSslPolicy> getAllowedOriginSslVersions() {
            return this.allowedOriginSslVersions;
        }

        @Override
        public java.lang.Number getHttpPort() {
            return this.httpPort;
        }

        @Override
        public java.lang.Number getHttpsPort() {
            return this.httpsPort;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
            return this.originHeaders;
        }

        @Override
        public software.amazon.awscdk.core.Duration getOriginKeepaliveTimeout() {
            return this.originKeepaliveTimeout;
        }

        @Override
        public java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy getOriginProtocolPolicy() {
            return this.originProtocolPolicy;
        }

        @Override
        public software.amazon.awscdk.core.Duration getOriginReadTimeout() {
            return this.originReadTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getAllowedOriginSslVersions() != null) {
                data.set("allowedOriginSSLVersions", om.valueToTree(this.getAllowedOriginSslVersions()));
            }
            if (this.getHttpPort() != null) {
                data.set("httpPort", om.valueToTree(this.getHttpPort()));
            }
            if (this.getHttpsPort() != null) {
                data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
            }
            if (this.getOriginHeaders() != null) {
                data.set("originHeaders", om.valueToTree(this.getOriginHeaders()));
            }
            if (this.getOriginKeepaliveTimeout() != null) {
                data.set("originKeepaliveTimeout", om.valueToTree(this.getOriginKeepaliveTimeout()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }
            if (this.getOriginProtocolPolicy() != null) {
                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
            }
            if (this.getOriginReadTimeout() != null) {
                data.set("originReadTimeout", om.valueToTree(this.getOriginReadTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CustomOriginConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomOriginConfig.Jsii$Proxy that = (CustomOriginConfig.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.allowedOriginSslVersions != null ? !this.allowedOriginSslVersions.equals(that.allowedOriginSslVersions) : that.allowedOriginSslVersions != null) return false;
            if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
            if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
            if (this.originHeaders != null ? !this.originHeaders.equals(that.originHeaders) : that.originHeaders != null) return false;
            if (this.originKeepaliveTimeout != null ? !this.originKeepaliveTimeout.equals(that.originKeepaliveTimeout) : that.originKeepaliveTimeout != null) return false;
            if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
            if (this.originProtocolPolicy != null ? !this.originProtocolPolicy.equals(that.originProtocolPolicy) : that.originProtocolPolicy != null) return false;
            return this.originReadTimeout != null ? this.originReadTimeout.equals(that.originReadTimeout) : that.originReadTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.allowedOriginSslVersions != null ? this.allowedOriginSslVersions.hashCode() : 0);
            result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
            result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
            result = 31 * result + (this.originHeaders != null ? this.originHeaders.hashCode() : 0);
            result = 31 * result + (this.originKeepaliveTimeout != null ? this.originKeepaliveTimeout.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            result = 31 * result + (this.originProtocolPolicy != null ? this.originProtocolPolicy.hashCode() : 0);
            result = 31 * result + (this.originReadTimeout != null ? this.originReadTimeout.hashCode() : 0);
            return result;
        }
    }
}
