package software.amazon.awscdk.services.cloudfront;

/**
 * Options for adding a new behavior to a Distribution.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.511Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.AddBehaviorOptions")
@software.amazon.jsii.Jsii.Proxy(AddBehaviorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AddBehaviorOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * HTTP methods to allow for this behavior.
     * <p>
     * Default: AllowedMethods.ALLOW_GET_HEAD
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
        return null;
    }

    /**
     * HTTP methods to cache for this behavior.
     * <p>
     * Default: CachedMethods.CACHE_GET_HEAD
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
        return null;
    }

    /**
     * Whether you want CloudFront to automatically compress certain files for this cache behavior.
     * <p>
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
     * for file types CloudFront will compress.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompress() {
        return null;
    }

    /**
     * The Lambda@Edge functions to invoke before serving the contents.
     * <p>
     * Default: - no Lambda functions will be invoked
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://aws.amazon.com/lambda/edge
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
        return null;
    }

    /**
     * Whether CloudFront will forward query strings to the origin.
     * <p>
     * If this is set to true, CloudFront will forward all query parameters to the origin, and cache
     * based on all parameters. See <code>forwardQueryStringCacheKeys</code> for a way to limit the query parameters
     * CloudFront caches on.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForwardQueryString() {
        return null;
    }

    /**
     * A set of query string parameter names to use for caching if `forwardQueryString` is set to true.
     * <p>
     * Default: []
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getForwardQueryStringCacheKeys() {
        return null;
    }

    /**
     * Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSmoothStreaming() {
        return null;
    }

    /**
     * The protocol that viewers can use to access the files controlled by this behavior.
     * <p>
     * Default: ViewerProtocolPolicy.ALLOW_ALL
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AddBehaviorOptions> {
        private software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        private software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        private java.lang.Boolean compress;
        private java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        private java.lang.Boolean forwardQueryString;
        private java.util.List<java.lang.String> forwardQueryStringCacheKeys;
        private java.lang.Boolean smoothStreaming;
        private software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Sets the value of {@link AddBehaviorOptions#getAllowedMethods}
         * @param allowedMethods HTTP methods to allow for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getCachedMethods}
         * @param cachedMethods HTTP methods to cache for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getCompress}
         * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
         *                 See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
         *                 for file types CloudFront will compress.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getEdgeLambdas}
         * @param edgeLambdas The Lambda@Edge functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder edgeLambdas(java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas) {
            this.edgeLambdas = edgeLambdas;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getForwardQueryString}
         * @param forwardQueryString Whether CloudFront will forward query strings to the origin.
         *                           If this is set to true, CloudFront will forward all query parameters to the origin, and cache
         *                           based on all parameters. See <code>forwardQueryStringCacheKeys</code> for a way to limit the query parameters
         *                           CloudFront caches on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forwardQueryString(java.lang.Boolean forwardQueryString) {
            this.forwardQueryString = forwardQueryString;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getForwardQueryStringCacheKeys}
         * @param forwardQueryStringCacheKeys A set of query string parameter names to use for caching if `forwardQueryString` is set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forwardQueryStringCacheKeys(java.util.List<java.lang.String> forwardQueryStringCacheKeys) {
            this.forwardQueryStringCacheKeys = forwardQueryStringCacheKeys;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getSmoothStreaming}
         * @param smoothStreaming Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getViewerProtocolPolicy}
         * @param viewerProtocolPolicy The protocol that viewers can use to access the files controlled by this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder viewerProtocolPolicy(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddBehaviorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AddBehaviorOptions build() {
            return new Jsii$Proxy(allowedMethods, cachedMethods, compress, edgeLambdas, forwardQueryString, forwardQueryStringCacheKeys, smoothStreaming, viewerProtocolPolicy);
        }
    }

    /**
     * An implementation for {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddBehaviorOptions {
        private final software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        private final java.lang.Boolean compress;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        private final java.lang.Boolean forwardQueryString;
        private final java.util.List<java.lang.String> forwardQueryStringCacheKeys;
        private final java.lang.Boolean smoothStreaming;
        private final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedMethods = this.jsiiGet("allowedMethods", software.amazon.awscdk.services.cloudfront.AllowedMethods.class);
            this.cachedMethods = this.jsiiGet("cachedMethods", software.amazon.awscdk.services.cloudfront.CachedMethods.class);
            this.compress = this.jsiiGet("compress", java.lang.Boolean.class);
            this.edgeLambdas = this.jsiiGet("edgeLambdas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.EdgeLambda.class)));
            this.forwardQueryString = this.jsiiGet("forwardQueryString", java.lang.Boolean.class);
            this.forwardQueryStringCacheKeys = this.jsiiGet("forwardQueryStringCacheKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.smoothStreaming = this.jsiiGet("smoothStreaming", java.lang.Boolean.class);
            this.viewerProtocolPolicy = this.jsiiGet("viewerProtocolPolicy", software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods, final software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods, final java.lang.Boolean compress, final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas, final java.lang.Boolean forwardQueryString, final java.util.List<java.lang.String> forwardQueryStringCacheKeys, final java.lang.Boolean smoothStreaming, final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = allowedMethods;
            this.cachedMethods = cachedMethods;
            this.compress = compress;
            this.edgeLambdas = edgeLambdas;
            this.forwardQueryString = forwardQueryString;
            this.forwardQueryStringCacheKeys = forwardQueryStringCacheKeys;
            this.smoothStreaming = smoothStreaming;
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
            return this.edgeLambdas;
        }

        @Override
        public java.lang.Boolean getForwardQueryString() {
            return this.forwardQueryString;
        }

        @Override
        public java.util.List<java.lang.String> getForwardQueryStringCacheKeys() {
            return this.forwardQueryStringCacheKeys;
        }

        @Override
        public java.lang.Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getEdgeLambdas() != null) {
                data.set("edgeLambdas", om.valueToTree(this.getEdgeLambdas()));
            }
            if (this.getForwardQueryString() != null) {
                data.set("forwardQueryString", om.valueToTree(this.getForwardQueryString()));
            }
            if (this.getForwardQueryStringCacheKeys() != null) {
                data.set("forwardQueryStringCacheKeys", om.valueToTree(this.getForwardQueryStringCacheKeys()));
            }
            if (this.getSmoothStreaming() != null) {
                data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
            }
            if (this.getViewerProtocolPolicy() != null) {
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.AddBehaviorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddBehaviorOptions.Jsii$Proxy that = (AddBehaviorOptions.Jsii$Proxy) o;

            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.edgeLambdas != null ? !this.edgeLambdas.equals(that.edgeLambdas) : that.edgeLambdas != null) return false;
            if (this.forwardQueryString != null ? !this.forwardQueryString.equals(that.forwardQueryString) : that.forwardQueryString != null) return false;
            if (this.forwardQueryStringCacheKeys != null ? !this.forwardQueryStringCacheKeys.equals(that.forwardQueryStringCacheKeys) : that.forwardQueryStringCacheKeys != null) return false;
            if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
            return this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.equals(that.viewerProtocolPolicy) : that.viewerProtocolPolicy == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowedMethods != null ? this.allowedMethods.hashCode() : 0;
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.edgeLambdas != null ? this.edgeLambdas.hashCode() : 0);
            result = 31 * result + (this.forwardQueryString != null ? this.forwardQueryString.hashCode() : 0);
            result = 31 * result + (this.forwardQueryStringCacheKeys != null ? this.forwardQueryStringCacheKeys.hashCode() : 0);
            result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
            result = 31 * result + (this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.hashCode() : 0);
            return result;
        }
    }
}
