package software.amazon.awscdk.services.cloudfront;

/**
 * The type of events that a Lambda@Edge function can be invoked in response to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket;
 * // A Lambda&#64;Edge function added to default behavior of a Distribution
 * // and triggered on every request
 * EdgeFunction myFunc = EdgeFunction.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(myBucket))
 *                 .edgeLambdas(List.of(EdgeLambda.builder()
 *                         .functionVersion(myFunc.getCurrentVersion())
 *                         .eventType(LambdaEdgeEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:32.936Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.LambdaEdgeEventType")
public enum LambdaEdgeEventType {
    /**
     * The origin-request specifies the request to the origin location (e.g. S3).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ORIGIN_REQUEST,
    /**
     * The origin-response specifies the response from the origin location (e.g. S3).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ORIGIN_RESPONSE,
    /**
     * The viewer-request specifies the incoming request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_REQUEST,
    /**
     * The viewer-response specifies the outgoing response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_RESPONSE,
}
