package software.amazon.awscdk.services.cloudfront;

/**
 * Amazon CloudFront is a global content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to your viewers with low latency and high transfer speeds.
 * <p>
 * CloudFront fronts user provided content and caches it at edge locations across the world.
 * <p>
 * Here's how you can use this construct:
 * <p>
 * <blockquote><pre>
 * Bucket sourceBucket = new Bucket(this, "Bucket");
 * CloudFrontWebDistribution distribution = CloudFrontWebDistribution.Builder.create(this, "MyDistribution")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(sourceBucket)
 *                         .build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will create a CloudFront distribution that uses your S3Bucket as it's origin.
 * <p>
 * You can customize the distribution using additional properties from the CloudFrontWebDistributionProps interface.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket sourceBucket;
 * ViewerCertificate viewerCertificate = ViewerCertificate.fromIamCertificate("MYIAMROLEIDENTIFIER", ViewerCertificateOptions.builder()
 *         .aliases(List.of("MYALIAS"))
 *         .build());
 * CloudFrontWebDistribution.Builder.create(this, "MyCfWebDistribution")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(sourceBucket)
 *                         .build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .viewerCertificate(viewerCertificate)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:32.907Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CloudFrontWebDistribution")
public class CloudFrontWebDistribution extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cloudfront.IDistribution {

    protected CloudFrontWebDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFrontWebDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFrontWebDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a construct that represents an external (imported) distribution.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IDistribution fromDistributionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution.class, "fromDistributionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IDistribution.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The domain name created by CloudFront for this distribution.
     * <p>
     * If you are using aliases for your distribution, this is the domainName your DNS records should point to.
     * (In Route53, you could create an ALIAS record to this value, for example.)
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionDomainName() {
        return software.amazon.jsii.Kernel.get(this, "distributionDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distribution ID for this distribution.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionId() {
        return software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) The domain name created by CloudFront for this distribution.
     * <p>
     * If you are using aliases for your distribution, this is the domainName your DNS records should point to.
     * (In Route53, you could create an ALIAS record to this value, for example.)
     * <p>
     * @deprecated - Use `distributionDomainName` instead.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The logging bucket for this CloudFront distribution.
     * <p>
     * If logging is not enabled for this distribution - this property will be undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getLoggingBucket() {
        return software.amazon.jsii.Kernel.get(this, "loggingBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionProps.Builder();
        }

        /**
         * The origin configurations for this distribution.
         * <p>
         * Behaviors are a part of the origin.
         * <p>
         * @return {@code this}
         * @param originConfigs The origin configurations for this distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originConfigs(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.SourceConfiguration> originConfigs) {
            this.props.originConfigs(originConfigs);
            return this;
        }

        /**
         * (deprecated) AliasConfiguration is used to configured CloudFront to respond to requests on custom domain names.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @deprecated see {@link CloudFrontWebDistributionProps#viewerCertificate} with {@link ViewerCertificate#acmCertificate}
         * @param aliasConfiguration AliasConfiguration is used to configured CloudFront to respond to requests on custom domain names. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder aliasConfiguration(final software.amazon.awscdk.services.cloudfront.AliasConfiguration aliasConfiguration) {
            this.props.aliasConfiguration(aliasConfiguration);
            return this;
        }

        /**
         * A comment for this distribution in the CloudFront console.
         * <p>
         * Default: - No comment is added to distribution.
         * <p>
         * @return {@code this}
         * @param comment A comment for this distribution in the CloudFront console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The default object to serve.
         * <p>
         * Default: - "index.html" is served.
         * <p>
         * @return {@code this}
         * @param defaultRootObject The default object to serve. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootObject(final java.lang.String defaultRootObject) {
            this.props.defaultRootObject(defaultRootObject);
            return this;
        }

        /**
         * Enable or disable the distribution.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Enable or disable the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * If your distribution should have IPv6 enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableIpV6 If your distribution should have IPv6 enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIpV6(final java.lang.Boolean enableIpV6) {
            this.props.enableIpV6(enableIpV6);
            return this;
        }

        /**
         * How CloudFront should handle requests that are not successful (eg PageNotFound).
         * <p>
         * By default, CloudFront does not replace HTTP status codes in the 4xx and 5xx range
         * with custom error messages. CloudFront does not cache HTTP status codes.
         * <p>
         * Default: - No custom error configuration.
         * <p>
         * @return {@code this}
         * @param errorConfigurations How CloudFront should handle requests that are not successful (eg PageNotFound). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorConfigurations(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomErrorResponseProperty> errorConfigurations) {
            this.props.errorConfigurations(errorConfigurations);
            return this;
        }

        /**
         * Controls the countries in which your content is distributed.
         * <p>
         * Default: No geo restriction
         * <p>
         * @return {@code this}
         * @param geoRestriction Controls the countries in which your content is distributed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoRestriction(final software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction) {
            this.props.geoRestriction(geoRestriction);
            return this;
        }

        /**
         * The max supported HTTP Versions.
         * <p>
         * Default: HttpVersion.HTTP2
         * <p>
         * @return {@code this}
         * @param httpVersion The max supported HTTP Versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpVersion(final software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion) {
            this.props.httpVersion(httpVersion);
            return this;
        }

        /**
         * Optional - if we should enable logging.
         * <p>
         * You can pass an empty object ({}) to have us auto create a bucket for logging.
         * Omission of this property indicates no logging is to be enabled.
         * <p>
         * Default: - no logging is enabled by default.
         * <p>
         * @return {@code this}
         * @param loggingConfig Optional - if we should enable logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(final software.amazon.awscdk.services.cloudfront.LoggingConfiguration loggingConfig) {
            this.props.loggingConfig(loggingConfig);
            return this;
        }

        /**
         * The price class for the distribution (this impacts how many locations CloudFront uses for your distribution, and billing).
         * <p>
         * Default: PriceClass.PRICE_CLASS_100 the cheapest option for CloudFront is picked by default.
         * <p>
         * @return {@code this}
         * @param priceClass The price class for the distribution (this impacts how many locations CloudFront uses for your distribution, and billing). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priceClass(final software.amazon.awscdk.services.cloudfront.PriceClass priceClass) {
            this.props.priceClass(priceClass);
            return this;
        }

        /**
         * Specifies whether you want viewers to use HTTP or HTTPS to request your objects, whether you're using an alternate domain name with HTTPS, and if so, if you're using AWS Certificate Manager (ACM) or a third-party certificate authority.
         * <p>
         * Default: ViewerCertificate.fromCloudFrontDefaultCertificate()
         * <p>
         * @return {@code this}
         * @see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/custom-ssl-certificate-cloudfront/">https://aws.amazon.com/premiumsupport/knowledge-center/custom-ssl-certificate-cloudfront/</a>
         * @param viewerCertificate Specifies whether you want viewers to use HTTP or HTTPS to request your objects, whether you're using an alternate domain name with HTTPS, and if so, if you're using AWS Certificate Manager (ACM) or a third-party certificate authority. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewerCertificate(final software.amazon.awscdk.services.cloudfront.ViewerCertificate viewerCertificate) {
            this.props.viewerCertificate(viewerCertificate);
            return this;
        }

        /**
         * The default viewer policy for incoming clients.
         * <p>
         * Default: RedirectToHTTPs
         * <p>
         * @return {@code this}
         * @param viewerProtocolPolicy The default viewer policy for incoming clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewerProtocolPolicy(final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.props.viewerProtocolPolicy(viewerProtocolPolicy);
            return this;
        }

        /**
         * Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
         * <p>
         * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
         * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * <p>
         * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * <p>
         * Default: - No AWS Web Application Firewall web access control list (web ACL).
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.">https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.</a>
         * @param webAclId Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclId(final java.lang.String webAclId) {
            this.props.webAclId(webAclId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CloudFrontWebDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
