package software.amazon.awscdk.cloudassembly.schema;

/**
 * Represents a missing piece of context.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:24:16.915Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.MissingContext")
@software.amazon.jsii.Jsii.Proxy(MissingContext.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MissingContext extends software.amazon.jsii.JsiiSerializable {

    /**
     * The missing context key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * A set of provider-specific options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProps();

    /**
     * The provider from which we expect this context key to be obtained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ContextProvider getProvider();

    /**
     * @return a {@link Builder} of {@link MissingContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MissingContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MissingContext> {
        private java.lang.String key;
        private java.lang.Object props;
        private software.amazon.awscdk.cloudassembly.schema.ContextProvider provider;

        /**
         * Sets the value of {@link MissingContext#getKey}
         * @param key The missing context key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.AmiContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.AvailabilityZonesContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.HostedZoneContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.SSMParameterContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.VpcContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProps}
         * @param props A set of provider-specific options. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.cloudassembly.schema.EndpointServiceAvailabilityZonesContextQuery props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link MissingContext#getProvider}
         * @param provider The provider from which we expect this context key to be obtained. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(software.amazon.awscdk.cloudassembly.schema.ContextProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MissingContext}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MissingContext build() {
            return new Jsii$Proxy(key, props, provider);
        }
    }

    /**
     * An implementation for {@link MissingContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MissingContext {
        private final java.lang.String key;
        private final java.lang.Object props;
        private final software.amazon.awscdk.cloudassembly.schema.ContextProvider provider;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = this.jsiiGet("key", java.lang.String.class);
            this.props = this.jsiiGet("props", java.lang.Object.class);
            this.provider = this.jsiiGet("provider", software.amazon.awscdk.cloudassembly.schema.ContextProvider.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String key, final java.lang.Object props, final software.amazon.awscdk.cloudassembly.schema.ContextProvider provider) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(key, "key is required");
            this.props = java.util.Objects.requireNonNull(props, "props is required");
            this.provider = java.util.Objects.requireNonNull(provider, "provider is required");
        }

        @Override
        public java.lang.String getKey() {
            return this.key;
        }

        @Override
        public java.lang.Object getProps() {
            return this.props;
        }

        @Override
        public software.amazon.awscdk.cloudassembly.schema.ContextProvider getProvider() {
            return this.provider;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("props", om.valueToTree(this.getProps()));
            data.set("provider", om.valueToTree(this.getProvider()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.MissingContext"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MissingContext.Jsii$Proxy that = (MissingContext.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!props.equals(that.props)) return false;
            return this.provider.equals(that.provider);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.props.hashCode());
            result = 31 * result + (this.provider.hashCode());
            return result;
        }
    }
}
