package software.amazon.awscdk.cloudassembly.schema;

/**
 * Query input for looking up a load balancer listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-01T11:09:03.102Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.LoadBalancerListenerContextQuery")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerListenerContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerListenerContextQuery extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.LoadBalancerFilter {

    /**
     * Query account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccount();

    /**
     * Query region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * Find by listener's arn.
     * <p>
     * Default: - does not find by listener arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getListenerArn() {
        return null;
    }

    /**
     * Filter listeners by listener port.
     * <p>
     * Default: - does not filter by a listener port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getListenerPort() {
        return null;
    }

    /**
     * Filter by listener protocol.
     * <p>
     * Default: - does not filter by listener protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol getListenerProtocol() {
        return null;
    }

    /**
     * The ARN of the role that should be used to look up the missing values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerListenerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerListenerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerListenerContextQuery> {
        private java.lang.String account;
        private java.lang.String region;
        private java.lang.String listenerArn;
        private java.lang.Number listenerPort;
        private software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol listenerProtocol;
        private java.lang.String lookupRoleArn;
        private software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        private java.lang.String loadBalancerArn;
        private java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getListenerArn}
         * @param listenerArn Find by listener's arn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getListenerPort}
         * @param listenerPort Filter listeners by listener port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getListenerProtocol}
         * @param listenerProtocol Filter by listener protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerProtocol(software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol listenerProtocol) {
            this.listenerProtocol = listenerProtocol;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getLoadBalancerType}
         * @param loadBalancerType Filter load balancers by their type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerType(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getLoadBalancerArn}
         * @param loadBalancerArn Find by load balancer's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListenerContextQuery#getLoadBalancerTags}
         * @param loadBalancerTags Match load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadBalancerTags(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags) {
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)loadBalancerTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerListenerContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerListenerContextQuery build() {
            return new Jsii$Proxy(account, region, listenerArn, listenerPort, listenerProtocol, lookupRoleArn, loadBalancerType, loadBalancerArn, loadBalancerTags);
        }
    }

    /**
     * An implementation for {@link LoadBalancerListenerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerListenerContextQuery {
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.lang.String listenerArn;
        private final java.lang.Number listenerPort;
        private final software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol listenerProtocol;
        private final java.lang.String lookupRoleArn;
        private final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        private final java.lang.String loadBalancerArn;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.listenerArn = software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.listenerPort = software.amazon.jsii.Kernel.get(this, "listenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.listenerProtocol = software.amazon.jsii.Kernel.get(this, "listenerProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol.class));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerType = software.amazon.jsii.Kernel.get(this, "loadBalancerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Tag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String account, final java.lang.String region, final java.lang.String listenerArn, final java.lang.Number listenerPort, final software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol listenerProtocol, final java.lang.String lookupRoleArn, final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType, final java.lang.String loadBalancerArn, final java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = java.util.Objects.requireNonNull(account, "account is required");
            this.region = java.util.Objects.requireNonNull(region, "region is required");
            this.listenerArn = listenerArn;
            this.listenerPort = listenerPort;
            this.listenerProtocol = listenerProtocol;
            this.lookupRoleArn = lookupRoleArn;
            this.loadBalancerType = java.util.Objects.requireNonNull(loadBalancerType, "loadBalancerType is required");
            this.loadBalancerArn = loadBalancerArn;
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)loadBalancerTags;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.LoadBalancerListenerProtocol getListenerProtocol() {
            return this.listenerProtocol;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getListenerArn() != null) {
                data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getListenerProtocol() != null) {
                data.set("listenerProtocol", om.valueToTree(this.getListenerProtocol()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            data.set("loadBalancerType", om.valueToTree(this.getLoadBalancerType()));
            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.LoadBalancerListenerContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerListenerContextQuery.Jsii$Proxy that = (LoadBalancerListenerContextQuery.Jsii$Proxy) o;

            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.listenerArn != null ? !this.listenerArn.equals(that.listenerArn) : that.listenerArn != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.listenerProtocol != null ? !this.listenerProtocol.equals(that.listenerProtocol) : that.listenerProtocol != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            if (!loadBalancerType.equals(that.loadBalancerType)) return false;
            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            return this.loadBalancerTags != null ? this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.listenerArn != null ? this.listenerArn.hashCode() : 0);
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.listenerProtocol != null ? this.listenerProtocol.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerType.hashCode());
            result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            return result;
        }
    }
}
