/**
 * <h1>AWS CDK Docker Image Assets</h1>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This module allows bundling Docker images as assets.</p>
 * <p>Images are built from a local Docker context directory (with a <code>Dockerfile</code>),
 * uploaded to ECR by the CDK toolkit and/or your app's CI-CD pipeline, and can be
 * naturally referenced in your CDK app.</p>
 * <pre><code class="language-typescript">import { DockerImageAsset } from '@aws-cdk/assets-docker';
 * 
 * const asset = new DockerImageAsset(this, 'MyBuildImage', {
 *   directory: path.join(__dirname, 'my-image')
 * });
 * </code></pre>
 * <p>The directory <code>my-image</code> must include a <code>Dockerfile</code>.</p>
 * <p>This will instruct the toolkit to build a Docker image from <code>my-image</code>, push it
 * to an AWS ECR repository and wire the name of the repository as CloudFormation
 * parameters to your stack.</p>
 * <p>Use <code>asset.imageUri</code> to reference the image (it includes both the ECR image URL
 * and tag.</p>
 * <p>You can optionally pass build args to the <code>docker build</code> command by specifying
 * the <code>buildArgs</code> property:</p>
 * <pre><code class="language-typescript">const asset = new DockerImageAsset(this, 'MyBuildImage', {
 *   directory: path.join(__dirname, 'my-image'),
 *   buildArgs: {
 *     HTTP_PROXY: 'http://10.20.30.2:1234'
 *   }
 * });
 * </code></pre>
 * <h3>Pull Permissions</h3>
 * <p>Depending on the consumer of your image asset, you will need to make sure
 * the principal has permissions to pull the image.</p>
 * <p>In most cases, you should use the <code>asset.repository.grantPull(principal)</code>
 * method. This will modify the IAM policy of the principal to allow it to
 * pull images from this repository.</p>
 * <p>If the pulling principal is not in the same account or is an AWS service that
 * doesn't assume a role in your account (e.g. AWS CodeBuild), pull permissions
 * must be granted on the <strong>resource policy</strong> (and not on the principal's policy).
 * To do that, you can use <code>asset.repository.addToResourcePolicy(statement)</code> to
 * grant the desired principal the following permissions: &quot;ecr:GetDownloadUrlForLayer&quot;,
 * &quot;ecr:BatchGetImage&quot; and &quot;ecr:BatchCheckLayerAvailability&quot;.</p>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.assets.docker;
