package software.amazon.awscdk.assets.docker;

@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:05:23.670Z")
public interface DockerImageAssetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.assets.CopyOptions {
    /**
     * The directory where the Dockerfile is stored.
     */
    java.lang.String getDirectory();
    /**
     * Build args to pass to the `docker build` command.
     * 
     * Default: no build args are passed
     */
    java.util.Map<java.lang.String, java.lang.String> getBuildArgs();
    /**
     * ECR repository name.
     * 
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     * 
     * Default: automatically derived from the asset's ID.
     */
    java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link DockerImageAssetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DockerImageAssetProps}
     */
    final class Builder {
        private java.lang.String _directory;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _buildArgs;
        @javax.annotation.Nullable
        private java.lang.String _repositoryName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _exclude;
        @javax.annotation.Nullable
        private software.amazon.awscdk.assets.FollowMode _follow;

        /**
         * Sets the value of Directory
         * @param value The directory where the Dockerfile is stored.
         * @return {@code this}
         */
        public Builder withDirectory(final java.lang.String value) {
            this._directory = java.util.Objects.requireNonNull(value, "directory is required");
            return this;
        }
        /**
         * Sets the value of BuildArgs
         * @param value Build args to pass to the `docker build` command.
         * @return {@code this}
         */
        public Builder withBuildArgs(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._buildArgs = value;
            return this;
        }
        /**
         * Sets the value of RepositoryName
         * @param value ECR repository name.
         * @return {@code this}
         */
        public Builder withRepositoryName(@javax.annotation.Nullable final java.lang.String value) {
            this._repositoryName = value;
            return this;
        }
        /**
         * Sets the value of Exclude
         * @param value Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        public Builder withExclude(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._exclude = value;
            return this;
        }
        /**
         * Sets the value of Follow
         * @param value A strategy for how to handle symlinks.
         * @return {@code this}
         */
        public Builder withFollow(@javax.annotation.Nullable final software.amazon.awscdk.assets.FollowMode value) {
            this._follow = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public DockerImageAssetProps build() {
            return new DockerImageAssetProps() {
                private final java.lang.String $directory = java.util.Objects.requireNonNull(_directory, "directory is required");
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $buildArgs = _buildArgs;
                @javax.annotation.Nullable
                private final java.lang.String $repositoryName = _repositoryName;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $exclude = _exclude;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.assets.FollowMode $follow = _follow;

                @Override
                public java.lang.String getDirectory() {
                    return this.$directory;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
                    return this.$buildArgs;
                }

                @Override
                public java.lang.String getRepositoryName() {
                    return this.$repositoryName;
                }

                @Override
                public java.util.List<java.lang.String> getExclude() {
                    return this.$exclude;
                }

                @Override
                public software.amazon.awscdk.assets.FollowMode getFollow() {
                    return this.$follow;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("directory", om.valueToTree(this.getDirectory()));
                    obj.set("buildArgs", om.valueToTree(this.getBuildArgs()));
                    obj.set("repositoryName", om.valueToTree(this.getRepositoryName()));
                    obj.set("exclude", om.valueToTree(this.getExclude()));
                    obj.set("follow", om.valueToTree(this.getFollow()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.assets.docker.DockerImageAssetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The directory where the Dockerfile is stored.
         */
        @Override
        public java.lang.String getDirectory() {
            return this.jsiiGet("directory", java.lang.String.class);
        }

        /**
         * Build args to pass to the `docker build` command.
         * 
         * Default: no build args are passed
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.jsiiGet("buildArgs", java.util.Map.class);
        }

        /**
         * ECR repository name.
         * 
         * Specify this property if you need to statically address the image, e.g.
         * from a Kubernetes Pod. Note, this is only the repository name, without the
         * registry and the tag parts.
         * 
         * Default: automatically derived from the asset's ID.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRepositoryName() {
            return this.jsiiGet("repositoryName", java.lang.String.class);
        }

        /**
         * Glob patterns to exclude from the copy.
         * 
         * Default: nothing is excluded
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getExclude() {
            return this.jsiiGet("exclude", java.util.List.class);
        }

        /**
         * A strategy for how to handle symlinks.
         * 
         * Default: Never
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.assets.FollowMode getFollow() {
            return this.jsiiGet("follow", software.amazon.awscdk.assets.FollowMode.class);
        }
    }
}
