package software.amazon.awscdk.assets.docker;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:40:37.728Z")
public interface DockerImageAssetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The directory where the Dockerfile is stored
     */
    java.lang.String getDirectory();
    /**
     * ECR repository name
     * 
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     * @default automatically derived from the asset's ID.
     */
    java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link DockerImageAssetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DockerImageAssetProps}
     */
    final class Builder {
        private java.lang.String _directory;
        @javax.annotation.Nullable
        private java.lang.String _repositoryName;

        /**
         * Sets the value of Directory
         * @param value The directory where the Dockerfile is stored
         * @return {@code this}
         */
        public Builder withDirectory(final java.lang.String value) {
            this._directory = java.util.Objects.requireNonNull(value, "directory is required");
            return this;
        }
        /**
         * Sets the value of RepositoryName
         * @param value ECR repository name

Specify this property if you need to statically address the image, e.g.
from a Kubernetes Pod. Note, this is only the repository name, without the
registry and the tag parts.
         * @return {@code this}
         */
        public Builder withRepositoryName(@javax.annotation.Nullable final java.lang.String value) {
            this._repositoryName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public DockerImageAssetProps build() {
            return new DockerImageAssetProps() {
                private final java.lang.String $directory = java.util.Objects.requireNonNull(_directory, "directory is required");
                @javax.annotation.Nullable
                private final java.lang.String $repositoryName = _repositoryName;

                @Override
                public java.lang.String getDirectory() {
                    return this.$directory;
                }

                @Override
                public java.lang.String getRepositoryName() {
                    return this.$repositoryName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("directory", om.valueToTree(this.getDirectory()));
                    obj.set("repositoryName", om.valueToTree(this.getRepositoryName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.assets.docker.DockerImageAssetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The directory where the Dockerfile is stored
         */
        @Override
        public java.lang.String getDirectory() {
            return this.jsiiGet("directory", java.lang.String.class);
        }

        /**
         * ECR repository name
         * 
         * Specify this property if you need to statically address the image, e.g.
         * from a Kubernetes Pod. Note, this is only the repository name, without the
         * registry and the tag parts.
         * @default automatically derived from the asset's ID.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRepositoryName() {
            return this.jsiiGet("repositoryName", java.lang.String.class);
        }
    }
}
