/**
 * <h1>AWS Lambda Layer with the NPM dependency proxy-agent</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module bundles the NPM dependency <a href="https://www.npmjs.com/package/proxy-agent"><code>proxy-agent</code></a>
 * as a local asset. It exposes constants <code>ASSET_FILE</code> and <code>LAYER_SOURCE_DIR</code> that can be consumed
 * via the CDK <code>Asset</code> construct.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>proxy-agent Version: 5.0.0</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * import { ASSET_FILE, LAYER_SOURCE_DIR } from '&#64;aws-cdk/asset-node-proxy-agent';
 * import * as lambda from 'aws-cdk-lib/aws-lambda';
 * import * as s3_assets from 'aws-cdk-lib/aws-s3-assets';
 * import { FileSystem } from 'aws-cdk-lib';
 * 
 * declare const fn: lambda.Function;
 * const asset = new s3_assets.Asset(this, 'layer-asset', {
 *   path: ASSET_FILE,
 *   assetHash: FileSystem.fingerprint(LAYER_SOURCE_DIR),
 * });
 * 
 * fn.addLayers(new lambda.LayerVersion(this, 'ProxyAgentLayer', {
 *   code: lambda.Code.fromBucket(asset.bucket, asset.s3ObjectKey),
 * }));
 * </pre></blockquote>
 * <p>
 * <a href="https://www.npmjs.com/package/proxy-agent"><code>proxy-agent</code></a> will be installed under <code>/nodejs/node_modules</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.asset.node.proxy.agent.v5;
