package software.amazon.awscdk.services.batch;

/**
 * Batch Job Queue.
 * <p>
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.613Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.JobQueue")
public class JobQueue extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.batch.IJobQueue {

    protected JobQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public JobQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Fetches an existing batch job queue by its amazon resource name.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobQueueArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobQueue fromJobQueueArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobQueueArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobQueue.class, "fromJobQueueArn", software.amazon.awscdk.services.batch.IJobQueue.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required") });
    }

    /**
     * The ARN of this batch job queue.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn() {
        return this.jsiiGet("jobQueueArn", java.lang.String.class);
    }

    /**
     * A name for the job queue.
     * <p>
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName() {
        return this.jsiiGet("jobQueueName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.JobQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.JobQueue> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.JobQueueProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.JobQueueProps.Builder();
        }

        /**
         * The set of compute environments mapped to a job queue and their order relative to each other.
         * <p>
         * The job scheduler uses this parameter to
         * determine which compute environment should execute a given job. Compute environments must be in the VALID state before you can associate them
         * with a job queue. You can associate up to three compute environments with a job queue.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param computeEnvironments The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironments(final java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments) {
            this.props.computeEnvironments(computeEnvironments);
            return this;
        }

        /**
         * The state of the job queue.
         * <p>
         * If set to true, it is able to accept jobs.
         * <p>
         * Default: true
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param enabled The state of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * A name for the job queue.
         * <p>
         * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * Default: - Cloudformation-generated name
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param jobQueueName A name for the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobQueueName(final java.lang.String jobQueueName) {
            this.props.jobQueueName(jobQueueName);
            return this;
        }

        /**
         * The priority of the job queue.
         * <p>
         * Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first
         * when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value
         * of 10 is given scheduling preference over a job queue with a priority value of 1.
         * <p>
         * Default: 1
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param priority The priority of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.JobQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.batch.JobQueue build() {
            return new software.amazon.awscdk.services.batch.JobQueue(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
