package software.amazon.awscdk.services.batch;

/**
 * Properties of a job definition container.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.JobDefinitionContainer")
@software.amazon.jsii.Jsii.Proxy(JobDefinitionContainer.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobDefinitionContainer extends software.amazon.jsii.JsiiSerializable {

    /**
     * The image used to start a container.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * The command that is passed to the container.
     * <p>
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     * <p>
     * Default: - CMD value built into container image.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to pass to the container.
     * <p>
     * Default: none
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * The number of GPUs reserved for all
     * containers in a job should not exceed the number of available GPUs on the compute resource that the job is launched on.
     * <p>
     * Default: - No GPU reservation.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuCount() {
        return null;
    }

    /**
     * The instance type to use for a multi-node parallel job.
     * <p>
     * Currently all node groups in a
     * multi-node parallel job must use the same instance type. This parameter is not valid
     * for single-node container jobs.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * The IAM role that the container can assume for AWS permissions.
     * <p>
     * Default: - An IAM role will created.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
        return null;
    }

    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     * <p>
     * For now, only the <code>devices</code> property is supported.
     * <p>
     * Default: - None will be used.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParams() {
        return null;
    }

    /**
     * The hard limit (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed
     * the memory specified here, the container is killed. You must specify at least 4 MiB of memory for a job.
     * <p>
     * Default: 4
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * The mount points for data volumes in your container.
     * <p>
     * Default: - No mount points will be used.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.MountPoint> getMountPoints() {
        return null;
    }

    /**
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * When this parameter is true, the container is given read-only access to its root file system.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadOnly() {
        return null;
    }

    /**
     * A list of ulimits to set in the container.
     * <p>
     * Default: - No limits.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.Ulimit> getUlimits() {
        return null;
    }

    /**
     * The user name to use inside the container.
     * <p>
     * Default: - None will be used.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * The number of vCPUs reserved for the container.
     * <p>
     * Each vCPU is equivalent to
     * 1,024 CPU shares. You must specify at least one vCPU.
     * <p>
     * Default: 1
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
        return null;
    }

    /**
     * A list of data volumes used in a job.
     * <p>
     * Default: - No data volumes will be used.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobDefinitionContainer> {
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private java.util.List<java.lang.String> command;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.Number gpuCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.iam.IRole jobRole;
        private software.amazon.awscdk.services.ecs.LinuxParameters linuxParams;
        private java.lang.Number memoryLimitMiB;
        private java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints;
        private java.lang.Boolean privileged;
        private java.lang.Boolean readOnly;
        private java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits;
        private java.lang.String user;
        private java.lang.Number vcpus;
        private java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link JobDefinitionContainer#getImage}
         * @param image The image used to start a container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getGpuCount}
         * @param gpuCount The number of physical GPUs to reserve for the container.
         *                 The number of GPUs reserved for all
         *                 containers in a job should not exceed the number of available GPUs on the compute resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getInstanceType}
         * @param instanceType The instance type to use for a multi-node parallel job.
         *                     Currently all node groups in a
         *                     multi-node parallel job must use the same instance type. This parameter is not valid
         *                     for single-node container jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getJobRole}
         * @param jobRole The IAM role that the container can assume for AWS permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobRole(software.amazon.awscdk.services.iam.IRole jobRole) {
            this.jobRole = jobRole;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getLinuxParams}
         * @param linuxParams Linux-specific modifications that are applied to the container, such as details for device mappings.
         *                    For now, only the <code>devices</code> property is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder linuxParams(software.amazon.awscdk.services.ecs.LinuxParameters linuxParams) {
            this.linuxParams = linuxParams;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getMemoryLimitMiB}
         * @param memoryLimitMiB The hard limit (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed
         *                       the memory specified here, the container is killed. You must specify at least 4 MiB of memory for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getMountPoints}
         * @param mountPoints The mount points for data volumes in your container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mountPoints(java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints) {
            this.mountPoints = mountPoints;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getPrivileged}
         * @param privileged When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getReadOnly}
         * @param readOnly When this parameter is true, the container is given read-only access to its root file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getUlimits}
         * @param ulimits A list of ulimits to set in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ulimits(java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits) {
            this.ulimits = ulimits;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getVcpus}
         * @param vcpus The number of vCPUs reserved for the container.
         *              Each vCPU is equivalent to
         *              1,024 CPU shares. You must specify at least one vCPU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vcpus(java.lang.Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getVolumes}
         * @param volumes A list of data volumes used in a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumes(java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDefinitionContainer}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobDefinitionContainer build() {
            return new Jsii$Proxy(image, command, environment, gpuCount, instanceType, jobRole, linuxParams, memoryLimitMiB, mountPoints, privileged, readOnly, ulimits, user, vcpus, volumes);
        }
    }

    /**
     * An implementation for {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDefinitionContainer {
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.iam.IRole jobRole;
        private final software.amazon.awscdk.services.ecs.LinuxParameters linuxParams;
        private final java.lang.Number memoryLimitMiB;
        private final java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints;
        private final java.lang.Boolean privileged;
        private final java.lang.Boolean readOnly;
        private final java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits;
        private final java.lang.String user;
        private final java.lang.Number vcpus;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = this.jsiiGet("gpuCount", java.lang.Number.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.jobRole = this.jsiiGet("jobRole", software.amazon.awscdk.services.iam.IRole.class);
            this.linuxParams = this.jsiiGet("linuxParams", software.amazon.awscdk.services.ecs.LinuxParameters.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.mountPoints = this.jsiiGet("mountPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MountPoint.class)));
            this.privileged = this.jsiiGet("privileged", java.lang.Boolean.class);
            this.readOnly = this.jsiiGet("readOnly", java.lang.Boolean.class);
            this.ulimits = this.jsiiGet("ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ulimit.class)));
            this.user = this.jsiiGet("user", java.lang.String.class);
            this.vcpus = this.jsiiGet("vcpus", java.lang.Number.class);
            this.volumes = this.jsiiGet("volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.ContainerImage image, final java.util.List<java.lang.String> command, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.Number gpuCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.services.iam.IRole jobRole, final software.amazon.awscdk.services.ecs.LinuxParameters linuxParams, final java.lang.Number memoryLimitMiB, final java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints, final java.lang.Boolean privileged, final java.lang.Boolean readOnly, final java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits, final java.lang.String user, final java.lang.Number vcpus, final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.command = command;
            this.environment = environment;
            this.gpuCount = gpuCount;
            this.instanceType = instanceType;
            this.jobRole = jobRole;
            this.linuxParams = linuxParams;
            this.memoryLimitMiB = memoryLimitMiB;
            this.mountPoints = mountPoints;
            this.privileged = privileged;
            this.readOnly = readOnly;
            this.ulimits = ulimits;
            this.user = user;
            this.vcpus = vcpus;
            this.volumes = volumes;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getJobRole() {
            return this.jobRole;
        }

        @Override
        public software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParams() {
            return this.linuxParams;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.MountPoint> getMountPoints() {
            return this.mountPoints;
        }

        @Override
        public java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.Ulimit> getUlimits() {
            return this.ulimits;
        }

        @Override
        public java.lang.String getUser() {
            return this.user;
        }

        @Override
        public java.lang.Number getVcpus() {
            return this.vcpus;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getJobRole() != null) {
                data.set("jobRole", om.valueToTree(this.getJobRole()));
            }
            if (this.getLinuxParams() != null) {
                data.set("linuxParams", om.valueToTree(this.getLinuxParams()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMountPoints() != null) {
                data.set("mountPoints", om.valueToTree(this.getMountPoints()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getReadOnly() != null) {
                data.set("readOnly", om.valueToTree(this.getReadOnly()));
            }
            if (this.getUlimits() != null) {
                data.set("ulimits", om.valueToTree(this.getUlimits()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVcpus() != null) {
                data.set("vcpus", om.valueToTree(this.getVcpus()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.JobDefinitionContainer"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDefinitionContainer.Jsii$Proxy that = (JobDefinitionContainer.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.jobRole != null ? !this.jobRole.equals(that.jobRole) : that.jobRole != null) return false;
            if (this.linuxParams != null ? !this.linuxParams.equals(that.linuxParams) : that.linuxParams != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
            if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.vcpus != null ? !this.vcpus.equals(that.vcpus) : that.vcpus != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.jobRole != null ? this.jobRole.hashCode() : 0);
            result = 31 * result + (this.linuxParams != null ? this.linuxParams.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
            result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
