package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Describes the training, validation or test dataset and the Amazon S3 location where it is stored.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * S3Location s3Location;
 * Channel channel = Channel.builder()
 *         .channelName("channelName")
 *         .dataSource(DataSource.builder()
 *                 .s3DataSource(S3DataSource.builder()
 *                         .s3Location(s3Location)
 *                         // the properties below are optional
 *                         .attributeNames(List.of("attributeNames"))
 *                         .s3DataDistributionType(S3DataDistributionType.FULLY_REPLICATED)
 *                         .s3DataType(S3DataType.MANIFEST_FILE)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .compressionType(CompressionType.NONE)
 *         .contentType("contentType")
 *         .inputMode(InputMode.PIPE)
 *         .recordWrapperType(RecordWrapperType.NONE)
 *         .shuffleConfig(ShuffleConfig.builder()
 *                 .seed(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.255Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.Channel")
@software.amazon.jsii.Jsii.Proxy(Channel.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Channel extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

    /**
     * Location of the channel data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DataSource getDataSource();

    /**
     * Compression type if training data is compressed.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
        return null;
    }

    /**
     * The MIME type of the data.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * Input mode to use for the data channel in a training job.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.InputMode getInputMode() {
        return null;
    }

    /**
     * Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format.
     * <p>
     * In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record.
     * If the input data is already in RecordIO format, you don't need to set this attribute.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType getRecordWrapperType() {
        return null;
    }

    /**
     * Shuffle config option for input data in a channel.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig getShuffleConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Channel> {
        java.lang.String channelName;
        software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource;
        software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        java.lang.String contentType;
        software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode;
        software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType;
        software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig;

        /**
         * Sets the value of {@link Channel#getChannelName}
         * @param channelName Name of the channel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getDataSource}
         * @param dataSource Location of the channel data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getCompressionType}
         * @param compressionType Compression type if training data is compressed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionType(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getContentType}
         * @param contentType The MIME type of the data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getInputMode}
         * @param inputMode Input mode to use for the data channel in a training job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputMode(software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getRecordWrapperType}
         * @param recordWrapperType Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format.
         *                          In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record.
         *                          If the input data is already in RecordIO format, you don't need to set this attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordWrapperType(software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType) {
            this.recordWrapperType = recordWrapperType;
            return this;
        }

        /**
         * Sets the value of {@link Channel#getShuffleConfig}
         * @param shuffleConfig Shuffle config option for input data in a channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shuffleConfig(software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig) {
            this.shuffleConfig = shuffleConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Channel}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Channel build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Channel {
        private final java.lang.String channelName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private final java.lang.String contentType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode;
        private final software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DataSource.class));
            this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputMode = software.amazon.jsii.Kernel.get(this, "inputMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.InputMode.class));
            this.recordWrapperType = software.amazon.jsii.Kernel.get(this, "recordWrapperType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType.class));
            this.shuffleConfig = software.amazon.jsii.Kernel.get(this, "shuffleConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
            this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
            this.compressionType = builder.compressionType;
            this.contentType = builder.contentType;
            this.inputMode = builder.inputMode;
            this.recordWrapperType = builder.recordWrapperType;
            this.shuffleConfig = builder.shuffleConfig;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.InputMode getInputMode() {
            return this.inputMode;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType getRecordWrapperType() {
            return this.recordWrapperType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig getShuffleConfig() {
            return this.shuffleConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelName", om.valueToTree(this.getChannelName()));
            data.set("dataSource", om.valueToTree(this.getDataSource()));
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getInputMode() != null) {
                data.set("inputMode", om.valueToTree(this.getInputMode()));
            }
            if (this.getRecordWrapperType() != null) {
                data.set("recordWrapperType", om.valueToTree(this.getRecordWrapperType()));
            }
            if (this.getShuffleConfig() != null) {
                data.set("shuffleConfig", om.valueToTree(this.getShuffleConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.Channel"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Channel.Jsii$Proxy that = (Channel.Jsii$Proxy) o;

            if (!channelName.equals(that.channelName)) return false;
            if (!dataSource.equals(that.dataSource)) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.inputMode != null ? !this.inputMode.equals(that.inputMode) : that.inputMode != null) return false;
            if (this.recordWrapperType != null ? !this.recordWrapperType.equals(that.recordWrapperType) : that.recordWrapperType != null) return false;
            return this.shuffleConfig != null ? this.shuffleConfig.equals(that.shuffleConfig) : that.shuffleConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelName.hashCode();
            result = 31 * result + (this.dataSource.hashCode());
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.inputMode != null ? this.inputMode.hashCode() : 0);
            result = 31 * result + (this.recordWrapperType != null ? this.recordWrapperType.hashCode() : 0);
            result = 31 * result + (this.shuffleConfig != null ? this.shuffleConfig.hashCode() : 0);
            return result;
        }
    }
}
