package software.amazon.awscdk.services.stepfunctions;

/**
 * Extract a field from the State Machine data or context that gets passed around between states.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Activity submitJobActivity = new Activity(this, "SubmitJob");
 * StepFunctionsInvokeActivity.Builder.create(this, "Submit Job")
 *         .activity(submitJobActivity)
 *         .parameters(Map.of(
 *                 "comment", "Selecting what I care about.",
 *                 "MyDetails", Map.of(
 *                         "size", JsonPath.stringAt("$.product.details.size"),
 *                         "exists", JsonPath.stringAt("$.product.availability"),
 *                         "StaticValue", "foo")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.190Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.JsonPath")
public class JsonPath extends software.amazon.jsii.JsiiObject {

    protected JsonPath(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonPath(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DISCARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "DISCARD", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Make an intrinsic States.Array expression.
     * <p>
     * Combine any number of string literals or JsonPath expressions into an array.
     * <p>
     * Use this function if the value of an array element directly has to come
     * from a JSON Path expression (either the State object or the Context object).
     * <p>
     * If the array contains object literals whose values come from a JSON path
     * expression, you do not need to use this function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String array(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "array", software.amazon.jsii.NativeType.forClass(java.lang.String.class), java.util.Arrays.<Object>stream(values).toArray(Object[]::new));
    }

    /**
     * Make an intrinsic States.ArrayContains expression.
     * <p>
     * Use this function to determine if a specific value is present in an array. For example, you can use this function to detect if there was an error in a Map state iteration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param array This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayContains(final @org.jetbrains.annotations.NotNull java.lang.Object array, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayContains", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { array, value });
    }

    /**
     * Make an intrinsic States.ArrayGetItem expression.
     * <p>
     * Use this function to get a specified index's value in an array.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param array This parameter is required.
     * @param index This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayGetItem(final @org.jetbrains.annotations.NotNull java.lang.Object array, final @org.jetbrains.annotations.NotNull java.lang.Number index) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayGetItem", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { array, java.util.Objects.requireNonNull(index, "index is required") });
    }

    /**
     * Make an intrinsic States.ArrayLength expression.
     * <p>
     * Use this function to get the length of an array.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param array This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayLength(final @org.jetbrains.annotations.NotNull java.lang.Object array) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { array });
    }

    /**
     * Make an intrinsic States.ArrayPartition expression.
     * <p>
     * Use this function to partition a large array. You can also use this intrinsic to slice the data and then send the payload in smaller chunks.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param array This parameter is required.
     * @param chunkSize This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayPartition(final @org.jetbrains.annotations.NotNull java.lang.Object array, final @org.jetbrains.annotations.NotNull java.lang.Number chunkSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayPartition", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { array, java.util.Objects.requireNonNull(chunkSize, "chunkSize is required") });
    }

    /**
     * Make an intrinsic States.ArrayRange expression.
     * <p>
     * Use this function to create a new array containing a specific range of elements. The new array can contain up to 1000 elements.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param start This parameter is required.
     * @param end This parameter is required.
     * @param step This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayRange(final @org.jetbrains.annotations.NotNull java.lang.Number start, final @org.jetbrains.annotations.NotNull java.lang.Number end, final @org.jetbrains.annotations.NotNull java.lang.Number step) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(end, "end is required"), java.util.Objects.requireNonNull(step, "step is required") });
    }

    /**
     * Make an intrinsic States.ArrayUnique expression.
     * <p>
     * Use this function to get the length of an array.
     * Use this function to remove duplicate values from an array and returns an array containing only unique elements. This function takes an array, which can be unsorted, as its sole argument.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param array This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arrayUnique(final @org.jetbrains.annotations.NotNull java.lang.Object array) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "arrayUnique", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { array });
    }

    /**
     * Make an intrinsic States.Base64Decode expression.
     * <p>
     * Use this function to decode data based on MIME Base64 decoding scheme. You can use this function to pass data to other AWS services without using a Lambda function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param base64 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String base64Decode(final @org.jetbrains.annotations.NotNull java.lang.String base64) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "base64Decode", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(base64, "base64 is required") });
    }

    /**
     * Make an intrinsic States.Base64Encode expression.
     * <p>
     * Use this function to encode data based on MIME Base64 encoding scheme. You can use this function to pass data to other AWS services without using an AWS Lambda function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param input This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String base64Encode(final @org.jetbrains.annotations.NotNull java.lang.String input) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "base64Encode", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
    }

    /**
     * Make an intrinsic States.Format expression.
     * <p>
     * This can be used to embed JSON Path variables inside a format string.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.format("Hello, my name is {}.", JsonPath.stringAt("$.name"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param formatString This parameter is required.
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String format(final @org.jetbrains.annotations.NotNull java.lang.String formatString, final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(formatString, "formatString is required") }), java.util.Arrays.<Object>stream(values)).toArray(Object[]::new));
    }

    /**
     * Make an intrinsic States.Hash expression.
     * <p>
     * Use this function to calculate the hash value of a given input. You can use this function to pass data to other AWS services without using a Lambda function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param data This parameter is required.
     * @param algorithm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String hash(final @org.jetbrains.annotations.NotNull java.lang.Object data, final @org.jetbrains.annotations.NotNull java.lang.String algorithm) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "hash", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { data, java.util.Objects.requireNonNull(algorithm, "algorithm is required") });
    }

    /**
     * Determines if the indicated string is an encoded JSON path.
     * <p>
     * @param value string to be evaluated. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEncodedJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "isEncodedJsonPath", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Make an intrinsic States.JsonMerge expression.
     * <p>
     * Use this function to merge two JSON objects into a single object.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param value1 This parameter is required.
     * @param value2 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String jsonMerge(final @org.jetbrains.annotations.NotNull java.lang.Object value1, final @org.jetbrains.annotations.NotNull java.lang.Object value2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "jsonMerge", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { value1, value2 });
    }

    /**
     * Make an intrinsic States.JsonToString expression.
     * <p>
     * During the execution of the Step Functions state machine, encode the
     * given object into a JSON string.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.jsonToString(JsonPath.objectAt("$.someObject"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String jsonToString(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "jsonToString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { value });
    }

    /**
     * Instead of using a literal string list, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "listAt", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(path, "path is required") }));
    }

    /**
     * Make an intrinsic States.MathAdd expression.
     * <p>
     * Use this function to return the sum of two numbers. For example, you can use this function to increment values inside a loop without invoking a Lambda function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param num1 This parameter is required.
     * @param num2 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String mathAdd(final @org.jetbrains.annotations.NotNull java.lang.Number num1, final @org.jetbrains.annotations.NotNull java.lang.Number num2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "mathAdd", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(num1, "num1 is required"), java.util.Objects.requireNonNull(num2, "num2 is required") });
    }

    /**
     * Make an intrinsic States.MathRandom expression.
     * <p>
     * Use this function to return a random number between the specified start and end number. For example, you can use this function to distribute a specific task between two or more resources.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param start This parameter is required.
     * @param end This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String mathRandom(final @org.jetbrains.annotations.NotNull java.lang.Number start, final @org.jetbrains.annotations.NotNull java.lang.Number end) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "mathRandom", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(end, "end is required") });
    }

    /**
     * Instead of using a literal number, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number numberAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "numberAt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Reference a complete (complex) object in a JSON path location.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable objectAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "objectAt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Instead of using a literal string, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stringAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Make an intrinsic States.StringSplit expression.
     * <p>
     * Use this function to split a string into an array of values. This function takes two arguments.The first argument is a string and the second argument is the delimiting character that the function will use to divide the string.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param inputString This parameter is required.
     * @param splitter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stringSplit(final @org.jetbrains.annotations.NotNull java.lang.String inputString, final @org.jetbrains.annotations.NotNull java.lang.String splitter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringSplit", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(inputString, "inputString is required"), java.util.Objects.requireNonNull(splitter, "splitter is required") });
    }

    /**
     * Make an intrinsic States.StringToJson expression.
     * <p>
     * During the execution of the Step Functions state machine, parse the given
     * argument as JSON into its object form.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.stringToJson(JsonPath.stringAt("$.someJsonBody"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param jsonString This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable stringToJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringToJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(jsonString, "jsonString is required") });
    }

    /**
     * Make an intrinsic States.UUID expression.
     * <p>
     * Use this function to return a version 4 universally unique identifier (v4 UUID) generated using random numbers. For example, you can use this function to call other AWS services or resources that need a UUID parameter or insert items in a DynamoDB table.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uuid() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "uuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Special string value to discard state input, output or result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DISCARD;

    /**
     * Use the entire context data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntireContext() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entireContext", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use the entire data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntirePayload() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entirePayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the Task Token field.
     * <p>
     * External actions will need this token to report step completion
     * back to StepFunctions using the <code>SendTaskSuccess</code> or <code>SendTaskFailure</code>
     * calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getTaskToken() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "taskToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
