package software.amazon.awscdk.services.ses;

/**
 * Properties for a dedicated IP pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * DedicatedIpPoolProps dedicatedIpPoolProps = DedicatedIpPoolProps.builder()
 *         .dedicatedIpPoolName("dedicatedIpPoolName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.001Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DedicatedIpPoolProps")
@software.amazon.jsii.Jsii.Proxy(DedicatedIpPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DedicatedIpPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the dedicated IP pool.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedIpPoolName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DedicatedIpPoolProps> {
        java.lang.String dedicatedIpPoolName;

        /**
         * Sets the value of {@link DedicatedIpPoolProps#getDedicatedIpPoolName}
         * @param dedicatedIpPoolName A name for the dedicated IP pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedIpPoolName(java.lang.String dedicatedIpPoolName) {
            this.dedicatedIpPoolName = dedicatedIpPoolName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DedicatedIpPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DedicatedIpPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DedicatedIpPoolProps {
        private final java.lang.String dedicatedIpPoolName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dedicatedIpPoolName = software.amazon.jsii.Kernel.get(this, "dedicatedIpPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dedicatedIpPoolName = builder.dedicatedIpPoolName;
        }

        @Override
        public final java.lang.String getDedicatedIpPoolName() {
            return this.dedicatedIpPoolName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDedicatedIpPoolName() != null) {
                data.set("dedicatedIpPoolName", om.valueToTree(this.getDedicatedIpPoolName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.DedicatedIpPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DedicatedIpPoolProps.Jsii$Proxy that = (DedicatedIpPoolProps.Jsii$Proxy) o;

            return this.dedicatedIpPoolName != null ? this.dedicatedIpPoolName.equals(that.dedicatedIpPoolName) : that.dedicatedIpPoolName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dedicatedIpPoolName != null ? this.dedicatedIpPoolName.hashCode() : 0;
            return result;
        }
    }
}
