package software.amazon.awscdk.services.secretsmanager;

/**
 * Properties for defining a `CfnRotationSchedule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnRotationScheduleProps cfnRotationScheduleProps = CfnRotationScheduleProps.builder()
 *         .secretId("secretId")
 *         // the properties below are optional
 *         .hostedRotationLambda(HostedRotationLambdaProperty.builder()
 *                 .rotationType("rotationType")
 *                 // the properties below are optional
 *                 .excludeCharacters("excludeCharacters")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .masterSecretArn("masterSecretArn")
 *                 .masterSecretKmsKeyArn("masterSecretKmsKeyArn")
 *                 .rotationLambdaName("rotationLambdaName")
 *                 .superuserSecretArn("superuserSecretArn")
 *                 .superuserSecretKmsKeyArn("superuserSecretKmsKeyArn")
 *                 .vpcSecurityGroupIds("vpcSecurityGroupIds")
 *                 .vpcSubnetIds("vpcSubnetIds")
 *                 .build())
 *         .rotateImmediatelyOnUpdate(false)
 *         .rotationLambdaArn("rotationLambdaArn")
 *         .rotationRules(RotationRulesProperty.builder()
 *                 .automaticallyAfterDays(123)
 *                 .duration("duration")
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.827Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRotationScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRotationScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN or name of the secret to rotate.
     * <p>
     * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecretId();

    /**
     * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHostedRotationLambda() {
        return null;
    }

    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
     * <p>
     * The rotation schedule is defined in <code>RotationRules</code> .
     * <p>
     * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
     * <p>
     * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotateImmediatelyOnUpdate() {
        return null;
    }

    /**
     * The ARN of an existing Lambda rotation function.
     * <p>
     * To specify a rotation function that is also defined in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function.
     * <p>
     * To create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> , specify <code>HostedRotationLambda</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaArn() {
        return null;
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotationRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRotationScheduleProps> {
        java.lang.String secretId;
        java.lang.Object hostedRotationLambda;
        java.lang.Object rotateImmediatelyOnUpdate;
        java.lang.String rotationLambdaArn;
        java.lang.Object rotationRules;

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getSecretId}
         * @param secretId The ARN or name of the secret to rotate. This parameter is required.
         *                 To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(java.lang.String secretId) {
            this.secretId = secretId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getHostedRotationLambda}
         * @param hostedRotationLambda Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty hostedRotationLambda) {
            this.hostedRotationLambda = hostedRotationLambda;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getHostedRotationLambda}
         * @param hostedRotationLambda Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(software.amazon.awscdk.IResolvable hostedRotationLambda) {
            this.hostedRotationLambda = hostedRotationLambda;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotateImmediatelyOnUpdate}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         *                                  The rotation schedule is defined in <code>RotationRules</code> .
         *                                  <p>
         *                                  If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
         *                                  <p>
         *                                  If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.rotateImmediatelyOnUpdate = rotateImmediatelyOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotateImmediatelyOnUpdate}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         *                                  The rotation schedule is defined in <code>RotationRules</code> .
         *                                  <p>
         *                                  If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
         *                                  <p>
         *                                  If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(software.amazon.awscdk.IResolvable rotateImmediatelyOnUpdate) {
            this.rotateImmediatelyOnUpdate = rotateImmediatelyOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationLambdaArn}
         * @param rotationLambdaArn The ARN of an existing Lambda rotation function.
         *                          To specify a rotation function that is also defined in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function.
         *                          <p>
         *                          To create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> , specify <code>HostedRotationLambda</code> instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambdaArn(java.lang.String rotationLambdaArn) {
            this.rotationLambdaArn = rotationLambdaArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationRules}
         * @param rotationRules A structure that defines the rotation configuration for this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationRules}
         * @param rotationRules A structure that defines the rotation configuration for this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(software.amazon.awscdk.IResolvable rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRotationScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRotationScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRotationScheduleProps {
        private final java.lang.String secretId;
        private final java.lang.Object hostedRotationLambda;
        private final java.lang.Object rotateImmediatelyOnUpdate;
        private final java.lang.String rotationLambdaArn;
        private final java.lang.Object rotationRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretId = software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostedRotationLambda = software.amazon.jsii.Kernel.get(this, "hostedRotationLambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rotateImmediatelyOnUpdate = software.amazon.jsii.Kernel.get(this, "rotateImmediatelyOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rotationLambdaArn = software.amazon.jsii.Kernel.get(this, "rotationLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rotationRules = software.amazon.jsii.Kernel.get(this, "rotationRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretId = java.util.Objects.requireNonNull(builder.secretId, "secretId is required");
            this.hostedRotationLambda = builder.hostedRotationLambda;
            this.rotateImmediatelyOnUpdate = builder.rotateImmediatelyOnUpdate;
            this.rotationLambdaArn = builder.rotationLambdaArn;
            this.rotationRules = builder.rotationRules;
        }

        @Override
        public final java.lang.String getSecretId() {
            return this.secretId;
        }

        @Override
        public final java.lang.Object getHostedRotationLambda() {
            return this.hostedRotationLambda;
        }

        @Override
        public final java.lang.Object getRotateImmediatelyOnUpdate() {
            return this.rotateImmediatelyOnUpdate;
        }

        @Override
        public final java.lang.String getRotationLambdaArn() {
            return this.rotationLambdaArn;
        }

        @Override
        public final java.lang.Object getRotationRules() {
            return this.rotationRules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secretId", om.valueToTree(this.getSecretId()));
            if (this.getHostedRotationLambda() != null) {
                data.set("hostedRotationLambda", om.valueToTree(this.getHostedRotationLambda()));
            }
            if (this.getRotateImmediatelyOnUpdate() != null) {
                data.set("rotateImmediatelyOnUpdate", om.valueToTree(this.getRotateImmediatelyOnUpdate()));
            }
            if (this.getRotationLambdaArn() != null) {
                data.set("rotationLambdaArn", om.valueToTree(this.getRotationLambdaArn()));
            }
            if (this.getRotationRules() != null) {
                data.set("rotationRules", om.valueToTree(this.getRotationRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnRotationScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRotationScheduleProps.Jsii$Proxy that = (CfnRotationScheduleProps.Jsii$Proxy) o;

            if (!secretId.equals(that.secretId)) return false;
            if (this.hostedRotationLambda != null ? !this.hostedRotationLambda.equals(that.hostedRotationLambda) : that.hostedRotationLambda != null) return false;
            if (this.rotateImmediatelyOnUpdate != null ? !this.rotateImmediatelyOnUpdate.equals(that.rotateImmediatelyOnUpdate) : that.rotateImmediatelyOnUpdate != null) return false;
            if (this.rotationLambdaArn != null ? !this.rotationLambdaArn.equals(that.rotationLambdaArn) : that.rotationLambdaArn != null) return false;
            return this.rotationRules != null ? this.rotationRules.equals(that.rotationRules) : that.rotationRules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secretId.hashCode();
            result = 31 * result + (this.hostedRotationLambda != null ? this.hostedRotationLambda.hashCode() : 0);
            result = 31 * result + (this.rotateImmediatelyOnUpdate != null ? this.rotateImmediatelyOnUpdate.hashCode() : 0);
            result = 31 * result + (this.rotationLambdaArn != null ? this.rotationLambdaArn.hashCode() : 0);
            result = 31 * result + (this.rotationRules != null ? this.rotationRules.hashCode() : 0);
            return result;
        }
    }
}
