package software.amazon.awscdk.services.scheduler;

/**
 * A CloudFormation `AWS::Scheduler::Schedule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.scheduler.*;
 * Object tags;
 * CfnSchedule cfnSchedule = CfnSchedule.Builder.create(this, "MyCfnSchedule")
 *         .flexibleTimeWindow(FlexibleTimeWindowProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .maximumWindowInMinutes(123)
 *                 .build())
 *         .scheduleExpression("scheduleExpression")
 *         .target(TargetProperty.builder()
 *                 .arn("arn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .ecsParameters(EcsParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tags(List.of(tags))
 *                         .taskCount(123)
 *                         .build())
 *                 .eventBridgeParameters(EventBridgeParametersProperty.builder()
 *                         .detailType("detailType")
 *                         .source("source")
 *                         .build())
 *                 .input("input")
 *                 .kinesisParameters(KinesisParametersProperty.builder()
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .retryPolicy(RetryPolicyProperty.builder()
 *                         .maximumEventAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .build())
 *                 .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsParameters(SqsParametersProperty.builder()
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .endDate("endDate")
 *         .groupName("groupName")
 *         .kmsKeyArn("kmsKeyArn")
 *         .name("name")
 *         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *         .startDate("startDate")
 *         .state("state")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.798Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule")
public class CfnSchedule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.scheduler.CfnSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Scheduler::Schedule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.CfnScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFlexibleTimeWindow() {
        return software.amazon.jsii.Kernel.get(this, "flexibleTimeWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlexibleTimeWindow(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.CfnSchedule.FlexibleTimeWindowProperty value) {
        software.amazon.jsii.Kernel.set(this, "flexibleTimeWindow", java.util.Objects.requireNonNull(value, "flexibleTimeWindow is required"));
    }

    /**
     * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlexibleTimeWindow(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "flexibleTimeWindow", java.util.Objects.requireNonNull(value, "flexibleTimeWindow is required"));
    }

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpression`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpression`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpression(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpression", java.util.Objects.requireNonNull(value, "scheduleExpression is required"));
    }

    /**
     * `AWS::Scheduler::Schedule.Target`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Scheduler::Schedule.Target`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.CfnSchedule.TargetProperty value) {
        software.amazon.jsii.Kernel.set(this, "target", java.util.Objects.requireNonNull(value, "target is required"));
    }

    /**
     * `AWS::Scheduler::Schedule.Target`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "target", java.util.Objects.requireNonNull(value, "target is required"));
    }

    /**
     * `AWS::Scheduler::Schedule.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::Scheduler::Schedule.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndDate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endDate", value);
    }

    /**
     * `AWS::Scheduler::Schedule.GroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.GroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupName", value);
    }

    /**
     * `AWS::Scheduler::Schedule.KmsKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.KmsKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * `AWS::Scheduler::Schedule.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpressionTimezone() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpressionTimezone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpressionTimezone", value);
    }

    /**
     * `AWS::Scheduler::Schedule.StartDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartDate() {
        return software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.StartDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartDate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startDate", value);
    }

    /**
     * `AWS::Scheduler::Schedule.State`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Scheduler::Schedule.State`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * AwsVpcConfigurationProperty awsVpcConfigurationProperty = AwsVpcConfigurationProperty.builder()
     *         .subnets(List.of("subnets"))
     *         // the properties below are optional
     *         .assignPublicIp("assignPublicIp")
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.AwsVpcConfigurationProperty.Subnets`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * `CfnSchedule.AwsVpcConfigurationProperty.AssignPublicIp`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * `CfnSchedule.AwsVpcConfigurationProperty.SecurityGroups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            java.util.List<java.lang.String> subnets;
            java.lang.String assignPublicIp;
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets `CfnSchedule.AwsVpcConfigurationProperty.Subnets`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp `CfnSchedule.AwsVpcConfigurationProperty.AssignPublicIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups `CfnSchedule.AwsVpcConfigurationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.assignPublicIp = builder.assignPublicIp;
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .capacityProvider("capacityProvider")
     *         // the properties below are optional
     *         .base(123)
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.CapacityProviderStrategyItemProperty.CapacityProvider`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCapacityProvider();

        /**
         * `CfnSchedule.CapacityProviderStrategyItemProperty.Base`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * `CfnSchedule.CapacityProviderStrategyItemProperty.Weight`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.String capacityProvider;
            java.lang.Number base;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider `CfnSchedule.CapacityProviderStrategyItemProperty.CapacityProvider`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base `CfnSchedule.CapacityProviderStrategyItemProperty.Base`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight `CfnSchedule.CapacityProviderStrategyItemProperty.Weight`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.String capacityProvider;
            private final java.lang.Number base;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityProvider = java.util.Objects.requireNonNull(builder.capacityProvider, "capacityProvider is required");
                this.base = builder.base;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (!capacityProvider.equals(that.capacityProvider)) return false;
                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityProvider.hashCode();
                result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * DeadLetterConfigProperty deadLetterConfigProperty = DeadLetterConfigProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeadLetterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeadLetterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.DeadLetterConfigProperty.Arn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link DeadLetterConfigProperty#getArn}
             * @param arn `CfnSchedule.DeadLetterConfigProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeadLetterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterConfigProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.DeadLetterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterConfigProperty.Jsii$Proxy that = (DeadLetterConfigProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * Object tags;
     * EcsParametersProperty ecsParametersProperty = EcsParametersProperty.builder()
     *         .taskDefinitionArn("taskDefinitionArn")
     *         // the properties below are optional
     *         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                 .capacityProvider("capacityProvider")
     *                 // the properties below are optional
     *                 .base(123)
     *                 .weight(123)
     *                 .build()))
     *         .enableEcsManagedTags(false)
     *         .enableExecuteCommand(false)
     *         .group("group")
     *         .launchType("launchType")
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                         .subnets(List.of("subnets"))
     *                         // the properties below are optional
     *                         .assignPublicIp("assignPublicIp")
     *                         .securityGroups(List.of("securityGroups"))
     *                         .build())
     *                 .build())
     *         .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                 .expression("expression")
     *                 .type("type")
     *                 .build()))
     *         .placementStrategy(List.of(PlacementStrategyProperty.builder()
     *                 .field("field")
     *                 .type("type")
     *                 .build()))
     *         .platformVersion("platformVersion")
     *         .propagateTags("propagateTags")
     *         .referenceId("referenceId")
     *         .tags(List.of(tags))
     *         .taskCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.EcsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.EcsParametersProperty.TaskDefinitionArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinitionArn();

        /**
         * `CfnSchedule.EcsParametersProperty.CapacityProviderStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderStrategy() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.EnableECSManagedTags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableEcsManagedTags() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.EnableExecuteCommand`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableExecuteCommand() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.Group`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroup() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.LaunchType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.NetworkConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.PlacementConstraints`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.PlacementStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementStrategy() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.PlatformVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.PropagateTags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.ReferenceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReferenceId() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.Tags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getTags() {
            return null;
        }

        /**
         * `CfnSchedule.EcsParametersProperty.TaskCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTaskCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsParametersProperty> {
            java.lang.String taskDefinitionArn;
            java.lang.Object capacityProviderStrategy;
            java.lang.Object enableEcsManagedTags;
            java.lang.Object enableExecuteCommand;
            java.lang.String group;
            java.lang.String launchType;
            java.lang.Object networkConfiguration;
            java.lang.Object placementConstraints;
            java.lang.Object placementStrategy;
            java.lang.String platformVersion;
            java.lang.String propagateTags;
            java.lang.String referenceId;
            java.util.List<java.lang.Object> tags;
            java.lang.Number taskCount;

            /**
             * Sets the value of {@link EcsParametersProperty#getTaskDefinitionArn}
             * @param taskDefinitionArn `CfnSchedule.EcsParametersProperty.TaskDefinitionArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskDefinitionArn(java.lang.String taskDefinitionArn) {
                this.taskDefinitionArn = taskDefinitionArn;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy `CfnSchedule.EcsParametersProperty.CapacityProviderStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(software.amazon.awscdk.IResolvable capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy `CfnSchedule.EcsParametersProperty.CapacityProviderStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(java.util.List<? extends java.lang.Object> capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags `CfnSchedule.EcsParametersProperty.EnableECSManagedTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags `CfnSchedule.EcsParametersProperty.EnableECSManagedTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(software.amazon.awscdk.IResolvable enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand `CfnSchedule.EcsParametersProperty.EnableExecuteCommand`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand `CfnSchedule.EcsParametersProperty.EnableExecuteCommand`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(software.amazon.awscdk.IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getGroup}
             * @param group `CfnSchedule.EcsParametersProperty.Group`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(java.lang.String group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getLaunchType}
             * @param launchType `CfnSchedule.EcsParametersProperty.LaunchType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchType(java.lang.String launchType) {
                this.launchType = launchType;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration `CfnSchedule.EcsParametersProperty.NetworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.scheduler.CfnSchedule.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration `CfnSchedule.EcsParametersProperty.NetworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementConstraints}
             * @param placementConstraints `CfnSchedule.EcsParametersProperty.PlacementConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(software.amazon.awscdk.IResolvable placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementConstraints}
             * @param placementConstraints `CfnSchedule.EcsParametersProperty.PlacementConstraints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(java.util.List<? extends java.lang.Object> placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementStrategy}
             * @param placementStrategy `CfnSchedule.EcsParametersProperty.PlacementStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategy(software.amazon.awscdk.IResolvable placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementStrategy}
             * @param placementStrategy `CfnSchedule.EcsParametersProperty.PlacementStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategy(java.util.List<? extends java.lang.Object> placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlatformVersion}
             * @param platformVersion `CfnSchedule.EcsParametersProperty.PlatformVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPropagateTags}
             * @param propagateTags `CfnSchedule.EcsParametersProperty.PropagateTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagateTags(java.lang.String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getReferenceId}
             * @param referenceId `CfnSchedule.EcsParametersProperty.ReferenceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceId(java.lang.String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getTags}
             * @param tags `CfnSchedule.EcsParametersProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends java.lang.Object> tags) {
                this.tags = (java.util.List<java.lang.Object>)tags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getTaskCount}
             * @param taskCount `CfnSchedule.EcsParametersProperty.TaskCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskCount(java.lang.Number taskCount) {
                this.taskCount = taskCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsParametersProperty {
            private final java.lang.String taskDefinitionArn;
            private final java.lang.Object capacityProviderStrategy;
            private final java.lang.Object enableEcsManagedTags;
            private final java.lang.Object enableExecuteCommand;
            private final java.lang.String group;
            private final java.lang.String launchType;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object placementConstraints;
            private final java.lang.Object placementStrategy;
            private final java.lang.String platformVersion;
            private final java.lang.String propagateTags;
            private final java.lang.String referenceId;
            private final java.util.List<java.lang.Object> tags;
            private final java.lang.Number taskCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.taskDefinitionArn = software.amazon.jsii.Kernel.get(this, "taskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityProviderStrategy = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchType = software.amazon.jsii.Kernel.get(this, "launchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementStrategy = software.amazon.jsii.Kernel.get(this, "placementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.referenceId = software.amazon.jsii.Kernel.get(this, "referenceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
                this.taskCount = software.amazon.jsii.Kernel.get(this, "taskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.taskDefinitionArn = java.util.Objects.requireNonNull(builder.taskDefinitionArn, "taskDefinitionArn is required");
                this.capacityProviderStrategy = builder.capacityProviderStrategy;
                this.enableEcsManagedTags = builder.enableEcsManagedTags;
                this.enableExecuteCommand = builder.enableExecuteCommand;
                this.group = builder.group;
                this.launchType = builder.launchType;
                this.networkConfiguration = builder.networkConfiguration;
                this.placementConstraints = builder.placementConstraints;
                this.placementStrategy = builder.placementStrategy;
                this.platformVersion = builder.platformVersion;
                this.propagateTags = builder.propagateTags;
                this.referenceId = builder.referenceId;
                this.tags = (java.util.List<java.lang.Object>)builder.tags;
                this.taskCount = builder.taskCount;
            }

            @Override
            public final java.lang.String getTaskDefinitionArn() {
                return this.taskDefinitionArn;
            }

            @Override
            public final java.lang.Object getCapacityProviderStrategy() {
                return this.capacityProviderStrategy;
            }

            @Override
            public final java.lang.Object getEnableEcsManagedTags() {
                return this.enableEcsManagedTags;
            }

            @Override
            public final java.lang.Object getEnableExecuteCommand() {
                return this.enableExecuteCommand;
            }

            @Override
            public final java.lang.String getGroup() {
                return this.group;
            }

            @Override
            public final java.lang.String getLaunchType() {
                return this.launchType;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getPlacementConstraints() {
                return this.placementConstraints;
            }

            @Override
            public final java.lang.Object getPlacementStrategy() {
                return this.placementStrategy;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            public final java.lang.String getPropagateTags() {
                return this.propagateTags;
            }

            @Override
            public final java.lang.String getReferenceId() {
                return this.referenceId;
            }

            @Override
            public final java.util.List<java.lang.Object> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.Number getTaskCount() {
                return this.taskCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("taskDefinitionArn", om.valueToTree(this.getTaskDefinitionArn()));
                if (this.getCapacityProviderStrategy() != null) {
                    data.set("capacityProviderStrategy", om.valueToTree(this.getCapacityProviderStrategy()));
                }
                if (this.getEnableEcsManagedTags() != null) {
                    data.set("enableEcsManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
                }
                if (this.getEnableExecuteCommand() != null) {
                    data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
                }
                if (this.getGroup() != null) {
                    data.set("group", om.valueToTree(this.getGroup()));
                }
                if (this.getLaunchType() != null) {
                    data.set("launchType", om.valueToTree(this.getLaunchType()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPlacementConstraints() != null) {
                    data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
                }
                if (this.getPlacementStrategy() != null) {
                    data.set("placementStrategy", om.valueToTree(this.getPlacementStrategy()));
                }
                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }
                if (this.getPropagateTags() != null) {
                    data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
                }
                if (this.getReferenceId() != null) {
                    data.set("referenceId", om.valueToTree(this.getReferenceId()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getTaskCount() != null) {
                    data.set("taskCount", om.valueToTree(this.getTaskCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.EcsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsParametersProperty.Jsii$Proxy that = (EcsParametersProperty.Jsii$Proxy) o;

                if (!taskDefinitionArn.equals(that.taskDefinitionArn)) return false;
                if (this.capacityProviderStrategy != null ? !this.capacityProviderStrategy.equals(that.capacityProviderStrategy) : that.capacityProviderStrategy != null) return false;
                if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
                if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
                if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
                if (this.launchType != null ? !this.launchType.equals(that.launchType) : that.launchType != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
                if (this.placementStrategy != null ? !this.placementStrategy.equals(that.placementStrategy) : that.placementStrategy != null) return false;
                if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
                if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
                if (this.referenceId != null ? !this.referenceId.equals(that.referenceId) : that.referenceId != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                return this.taskCount != null ? this.taskCount.equals(that.taskCount) : that.taskCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.taskDefinitionArn.hashCode();
                result = 31 * result + (this.capacityProviderStrategy != null ? this.capacityProviderStrategy.hashCode() : 0);
                result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
                result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
                result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
                result = 31 * result + (this.launchType != null ? this.launchType.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
                result = 31 * result + (this.placementStrategy != null ? this.placementStrategy.hashCode() : 0);
                result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
                result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
                result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * EventBridgeParametersProperty eventBridgeParametersProperty = EventBridgeParametersProperty.builder()
     *         .detailType("detailType")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.EventBridgeParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.EventBridgeParametersProperty.DetailType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDetailType();

        /**
         * `CfnSchedule.EventBridgeParametersProperty.Source`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * @return a {@link Builder} of {@link EventBridgeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeParametersProperty> {
            java.lang.String detailType;
            java.lang.String source;

            /**
             * Sets the value of {@link EventBridgeParametersProperty#getDetailType}
             * @param detailType `CfnSchedule.EventBridgeParametersProperty.DetailType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailType(java.lang.String detailType) {
                this.detailType = detailType;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeParametersProperty#getSource}
             * @param source `CfnSchedule.EventBridgeParametersProperty.Source`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeParametersProperty {
            private final java.lang.String detailType;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.detailType = java.util.Objects.requireNonNull(builder.detailType, "detailType is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getDetailType() {
                return this.detailType;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("detailType", om.valueToTree(this.getDetailType()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.EventBridgeParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeParametersProperty.Jsii$Proxy that = (EventBridgeParametersProperty.Jsii$Proxy) o;

                if (!detailType.equals(that.detailType)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.detailType.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * FlexibleTimeWindowProperty flexibleTimeWindowProperty = FlexibleTimeWindowProperty.builder()
     *         .mode("mode")
     *         // the properties below are optional
     *         .maximumWindowInMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.FlexibleTimeWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(FlexibleTimeWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlexibleTimeWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.FlexibleTimeWindowProperty.Mode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * `CfnSchedule.FlexibleTimeWindowProperty.MaximumWindowInMinutes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumWindowInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlexibleTimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlexibleTimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlexibleTimeWindowProperty> {
            java.lang.String mode;
            java.lang.Number maximumWindowInMinutes;

            /**
             * Sets the value of {@link FlexibleTimeWindowProperty#getMode}
             * @param mode `CfnSchedule.FlexibleTimeWindowProperty.Mode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link FlexibleTimeWindowProperty#getMaximumWindowInMinutes}
             * @param maximumWindowInMinutes `CfnSchedule.FlexibleTimeWindowProperty.MaximumWindowInMinutes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumWindowInMinutes(java.lang.Number maximumWindowInMinutes) {
                this.maximumWindowInMinutes = maximumWindowInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlexibleTimeWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlexibleTimeWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlexibleTimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlexibleTimeWindowProperty {
            private final java.lang.String mode;
            private final java.lang.Number maximumWindowInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumWindowInMinutes = software.amazon.jsii.Kernel.get(this, "maximumWindowInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.maximumWindowInMinutes = builder.maximumWindowInMinutes;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getMaximumWindowInMinutes() {
                return this.maximumWindowInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getMaximumWindowInMinutes() != null) {
                    data.set("maximumWindowInMinutes", om.valueToTree(this.getMaximumWindowInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.FlexibleTimeWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlexibleTimeWindowProperty.Jsii$Proxy that = (FlexibleTimeWindowProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.maximumWindowInMinutes != null ? this.maximumWindowInMinutes.equals(that.maximumWindowInMinutes) : that.maximumWindowInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.maximumWindowInMinutes != null ? this.maximumWindowInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * KinesisParametersProperty kinesisParametersProperty = KinesisParametersProperty.builder()
     *         .partitionKey("partitionKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.KinesisParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.KinesisParametersProperty.PartitionKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPartitionKey();

        /**
         * @return a {@link Builder} of {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisParametersProperty> {
            java.lang.String partitionKey;

            /**
             * Sets the value of {@link KinesisParametersProperty#getPartitionKey}
             * @param partitionKey `CfnSchedule.KinesisParametersProperty.PartitionKey`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKey(java.lang.String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisParametersProperty {
            private final java.lang.String partitionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            }

            @Override
            public final java.lang.String getPartitionKey() {
                return this.partitionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("partitionKey", om.valueToTree(this.getPartitionKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.KinesisParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisParametersProperty.Jsii$Proxy that = (KinesisParametersProperty.Jsii$Proxy) o;

                return this.partitionKey.equals(that.partitionKey);
            }

            @Override
            public final int hashCode() {
                int result = this.partitionKey.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                 .subnets(List.of("subnets"))
     *                 // the properties below are optional
     *                 .assignPublicIp("assignPublicIp")
     *                 .securityGroups(List.of("securityGroups"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.NetworkConfigurationProperty.AwsvpcConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsvpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object awsvpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration `CfnSchedule.NetworkConfigurationProperty.AwsvpcConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.services.scheduler.CfnSchedule.AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration `CfnSchedule.NetworkConfigurationProperty.AwsvpcConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsvpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsvpcConfiguration = software.amazon.jsii.Kernel.get(this, "awsvpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsvpcConfiguration = builder.awsvpcConfiguration;
            }

            @Override
            public final java.lang.Object getAwsvpcConfiguration() {
                return this.awsvpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsvpcConfiguration() != null) {
                    data.set("awsvpcConfiguration", om.valueToTree(this.getAwsvpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsvpcConfiguration != null ? this.awsvpcConfiguration.equals(that.awsvpcConfiguration) : that.awsvpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsvpcConfiguration != null ? this.awsvpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * PlacementConstraintProperty placementConstraintProperty = PlacementConstraintProperty.builder()
     *         .expression("expression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.PlacementConstraintProperty.Expression`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * `CfnSchedule.PlacementConstraintProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            java.lang.String expression;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementConstraintProperty#getExpression}
             * @param expression `CfnSchedule.PlacementConstraintProperty.Expression`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link PlacementConstraintProperty#getType}
             * @param type `CfnSchedule.PlacementConstraintProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementConstraintProperty {
            private final java.lang.String expression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.PlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementConstraintProperty.Jsii$Proxy that = (PlacementConstraintProperty.Jsii$Proxy) o;

                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * PlacementStrategyProperty placementStrategyProperty = PlacementStrategyProperty.builder()
     *         .field("field")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.PlacementStrategyProperty.Field`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * `CfnSchedule.PlacementStrategyProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            java.lang.String field;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementStrategyProperty#getField}
             * @param field `CfnSchedule.PlacementStrategyProperty.Field`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link PlacementStrategyProperty#getType}
             * @param type `CfnSchedule.PlacementStrategyProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementStrategyProperty {
            private final java.lang.String field;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = builder.field;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.PlacementStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementStrategyProperty.Jsii$Proxy that = (PlacementStrategyProperty.Jsii$Proxy) o;

                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field != null ? this.field.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * RetryPolicyProperty retryPolicyProperty = RetryPolicyProperty.builder()
     *         .maximumEventAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.RetryPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.RetryPolicyProperty.MaximumEventAgeInSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumEventAgeInSeconds() {
            return null;
        }

        /**
         * `CfnSchedule.RetryPolicyProperty.MaximumRetryAttempts`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryPolicyProperty> {
            java.lang.Number maximumEventAgeInSeconds;
            java.lang.Number maximumRetryAttempts;

            /**
             * Sets the value of {@link RetryPolicyProperty#getMaximumEventAgeInSeconds}
             * @param maximumEventAgeInSeconds `CfnSchedule.RetryPolicyProperty.MaximumEventAgeInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEventAgeInSeconds(java.lang.Number maximumEventAgeInSeconds) {
                this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link RetryPolicyProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts `CfnSchedule.RetryPolicyProperty.MaximumRetryAttempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryPolicyProperty {
            private final java.lang.Number maximumEventAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumEventAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumEventAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Number getMaximumEventAgeInSeconds() {
                return this.maximumEventAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumEventAgeInSeconds() != null) {
                    data.set("maximumEventAgeInSeconds", om.valueToTree(this.getMaximumEventAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.RetryPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryPolicyProperty.Jsii$Proxy that = (RetryPolicyProperty.Jsii$Proxy) o;

                if (this.maximumEventAgeInSeconds != null ? !this.maximumEventAgeInSeconds.equals(that.maximumEventAgeInSeconds) : that.maximumEventAgeInSeconds != null) return false;
                return this.maximumRetryAttempts != null ? this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumEventAgeInSeconds != null ? this.maximumEventAgeInSeconds.hashCode() : 0;
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * SageMakerPipelineParameterProperty sageMakerPipelineParameterProperty = SageMakerPipelineParameterProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.SageMakerPipelineParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerPipelineParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerPipelineParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.SageMakerPipelineParameterProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnSchedule.SageMakerPipelineParameterProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerPipelineParameterProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getName}
             * @param name `CfnSchedule.SageMakerPipelineParameterProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getValue}
             * @param value `CfnSchedule.SageMakerPipelineParameterProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerPipelineParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerPipelineParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerPipelineParameterProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.SageMakerPipelineParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerPipelineParameterProperty.Jsii$Proxy that = (SageMakerPipelineParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * SageMakerPipelineParametersProperty sageMakerPipelineParametersProperty = SageMakerPipelineParametersProperty.builder()
     *         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.SageMakerPipelineParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerPipelineParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerPipelineParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.SageMakerPipelineParametersProperty.PipelineParameterList`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineParameterList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerPipelineParametersProperty> {
            java.lang.Object pipelineParameterList;

            /**
             * Sets the value of {@link SageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList `CfnSchedule.SageMakerPipelineParametersProperty.PipelineParameterList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(software.amazon.awscdk.IResolvable pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList `CfnSchedule.SageMakerPipelineParametersProperty.PipelineParameterList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(java.util.List<? extends java.lang.Object> pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerPipelineParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerPipelineParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerPipelineParametersProperty {
            private final java.lang.Object pipelineParameterList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pipelineParameterList = software.amazon.jsii.Kernel.get(this, "pipelineParameterList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pipelineParameterList = builder.pipelineParameterList;
            }

            @Override
            public final java.lang.Object getPipelineParameterList() {
                return this.pipelineParameterList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPipelineParameterList() != null) {
                    data.set("pipelineParameterList", om.valueToTree(this.getPipelineParameterList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.SageMakerPipelineParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerPipelineParametersProperty.Jsii$Proxy that = (SageMakerPipelineParametersProperty.Jsii$Proxy) o;

                return this.pipelineParameterList != null ? this.pipelineParameterList.equals(that.pipelineParameterList) : that.pipelineParameterList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pipelineParameterList != null ? this.pipelineParameterList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * SqsParametersProperty sqsParametersProperty = SqsParametersProperty.builder()
     *         .messageGroupId("messageGroupId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.SqsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SqsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.SqsParametersProperty.MessageGroupId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageGroupId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqsParametersProperty> {
            java.lang.String messageGroupId;

            /**
             * Sets the value of {@link SqsParametersProperty#getMessageGroupId}
             * @param messageGroupId `CfnSchedule.SqsParametersProperty.MessageGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupId(java.lang.String messageGroupId) {
                this.messageGroupId = messageGroupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsParametersProperty {
            private final java.lang.String messageGroupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageGroupId = software.amazon.jsii.Kernel.get(this, "messageGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageGroupId = builder.messageGroupId;
            }

            @Override
            public final java.lang.String getMessageGroupId() {
                return this.messageGroupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessageGroupId() != null) {
                    data.set("messageGroupId", om.valueToTree(this.getMessageGroupId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.SqsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqsParametersProperty.Jsii$Proxy that = (SqsParametersProperty.Jsii$Proxy) o;

                return this.messageGroupId != null ? this.messageGroupId.equals(that.messageGroupId) : that.messageGroupId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageGroupId != null ? this.messageGroupId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.scheduler.*;
     * Object tags;
     * TargetProperty targetProperty = TargetProperty.builder()
     *         .arn("arn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .ecsParameters(EcsParametersProperty.builder()
     *                 .taskDefinitionArn("taskDefinitionArn")
     *                 // the properties below are optional
     *                 .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                         .capacityProvider("capacityProvider")
     *                         // the properties below are optional
     *                         .base(123)
     *                         .weight(123)
     *                         .build()))
     *                 .enableEcsManagedTags(false)
     *                 .enableExecuteCommand(false)
     *                 .group("group")
     *                 .launchType("launchType")
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                                 .subnets(List.of("subnets"))
     *                                 // the properties below are optional
     *                                 .assignPublicIp("assignPublicIp")
     *                                 .securityGroups(List.of("securityGroups"))
     *                                 .build())
     *                         .build())
     *                 .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                         .expression("expression")
     *                         .type("type")
     *                         .build()))
     *                 .placementStrategy(List.of(PlacementStrategyProperty.builder()
     *                         .field("field")
     *                         .type("type")
     *                         .build()))
     *                 .platformVersion("platformVersion")
     *                 .propagateTags("propagateTags")
     *                 .referenceId("referenceId")
     *                 .tags(List.of(tags))
     *                 .taskCount(123)
     *                 .build())
     *         .eventBridgeParameters(EventBridgeParametersProperty.builder()
     *                 .detailType("detailType")
     *                 .source("source")
     *                 .build())
     *         .input("input")
     *         .kinesisParameters(KinesisParametersProperty.builder()
     *                 .partitionKey("partitionKey")
     *                 .build())
     *         .retryPolicy(RetryPolicyProperty.builder()
     *                 .maximumEventAgeInSeconds(123)
     *                 .maximumRetryAttempts(123)
     *                 .build())
     *         .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
     *                 .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .sqsParameters(SqsParametersProperty.builder()
     *                 .messageGroupId("messageGroupId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnSchedule.TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedule.TargetProperty.Arn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * `CfnSchedule.TargetProperty.RoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * `CfnSchedule.TargetProperty.DeadLetterConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterConfig() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.EcsParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcsParameters() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.EventBridgeParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeParameters() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.KinesisParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisParameters() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.RetryPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryPolicy() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.SageMakerPipelineParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSageMakerPipelineParameters() {
            return null;
        }

        /**
         * `CfnSchedule.TargetProperty.SqsParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetProperty> {
            java.lang.String arn;
            java.lang.String roleArn;
            java.lang.Object deadLetterConfig;
            java.lang.Object ecsParameters;
            java.lang.Object eventBridgeParameters;
            java.lang.String input;
            java.lang.Object kinesisParameters;
            java.lang.Object retryPolicy;
            java.lang.Object sageMakerPipelineParameters;
            java.lang.Object sqsParameters;

            /**
             * Sets the value of {@link TargetProperty#getArn}
             * @param arn `CfnSchedule.TargetProperty.Arn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRoleArn}
             * @param roleArn `CfnSchedule.TargetProperty.RoleArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getDeadLetterConfig}
             * @param deadLetterConfig `CfnSchedule.TargetProperty.DeadLetterConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getDeadLetterConfig}
             * @param deadLetterConfig `CfnSchedule.TargetProperty.DeadLetterConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEcsParameters}
             * @param ecsParameters `CfnSchedule.TargetProperty.EcsParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEcsParameters}
             * @param ecsParameters `CfnSchedule.TargetProperty.EcsParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsParameters(software.amazon.awscdk.IResolvable ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEventBridgeParameters}
             * @param eventBridgeParameters `CfnSchedule.TargetProperty.EventBridgeParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty eventBridgeParameters) {
                this.eventBridgeParameters = eventBridgeParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEventBridgeParameters}
             * @param eventBridgeParameters `CfnSchedule.TargetProperty.EventBridgeParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeParameters(software.amazon.awscdk.IResolvable eventBridgeParameters) {
                this.eventBridgeParameters = eventBridgeParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getInput}
             * @param input `CfnSchedule.TargetProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getKinesisParameters}
             * @param kinesisParameters `CfnSchedule.TargetProperty.KinesisParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getKinesisParameters}
             * @param kinesisParameters `CfnSchedule.TargetProperty.KinesisParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisParameters(software.amazon.awscdk.IResolvable kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRetryPolicy}
             * @param retryPolicy `CfnSchedule.TargetProperty.RetryPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRetryPolicy}
             * @param retryPolicy `CfnSchedule.TargetProperty.RetryPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.IResolvable retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters `CfnSchedule.TargetProperty.SageMakerPipelineParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters `CfnSchedule.TargetProperty.SageMakerPipelineParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.IResolvable sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSqsParameters}
             * @param sqsParameters `CfnSchedule.TargetProperty.SqsParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSqsParameters}
             * @param sqsParameters `CfnSchedule.TargetProperty.SqsParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsParameters(software.amazon.awscdk.IResolvable sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetProperty {
            private final java.lang.String arn;
            private final java.lang.String roleArn;
            private final java.lang.Object deadLetterConfig;
            private final java.lang.Object ecsParameters;
            private final java.lang.Object eventBridgeParameters;
            private final java.lang.String input;
            private final java.lang.Object kinesisParameters;
            private final java.lang.Object retryPolicy;
            private final java.lang.Object sageMakerPipelineParameters;
            private final java.lang.Object sqsParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecsParameters = software.amazon.jsii.Kernel.get(this, "ecsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridgeParameters = software.amazon.jsii.Kernel.get(this, "eventBridgeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kinesisParameters = software.amazon.jsii.Kernel.get(this, "kinesisParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sageMakerPipelineParameters = software.amazon.jsii.Kernel.get(this, "sageMakerPipelineParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsParameters = software.amazon.jsii.Kernel.get(this, "sqsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.deadLetterConfig = builder.deadLetterConfig;
                this.ecsParameters = builder.ecsParameters;
                this.eventBridgeParameters = builder.eventBridgeParameters;
                this.input = builder.input;
                this.kinesisParameters = builder.kinesisParameters;
                this.retryPolicy = builder.retryPolicy;
                this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
                this.sqsParameters = builder.sqsParameters;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getDeadLetterConfig() {
                return this.deadLetterConfig;
            }

            @Override
            public final java.lang.Object getEcsParameters() {
                return this.ecsParameters;
            }

            @Override
            public final java.lang.Object getEventBridgeParameters() {
                return this.eventBridgeParameters;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.Object getKinesisParameters() {
                return this.kinesisParameters;
            }

            @Override
            public final java.lang.Object getRetryPolicy() {
                return this.retryPolicy;
            }

            @Override
            public final java.lang.Object getSageMakerPipelineParameters() {
                return this.sageMakerPipelineParameters;
            }

            @Override
            public final java.lang.Object getSqsParameters() {
                return this.sqsParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getDeadLetterConfig() != null) {
                    data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
                }
                if (this.getEcsParameters() != null) {
                    data.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
                }
                if (this.getEventBridgeParameters() != null) {
                    data.set("eventBridgeParameters", om.valueToTree(this.getEventBridgeParameters()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getKinesisParameters() != null) {
                    data.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
                }
                if (this.getRetryPolicy() != null) {
                    data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
                }
                if (this.getSageMakerPipelineParameters() != null) {
                    data.set("sageMakerPipelineParameters", om.valueToTree(this.getSageMakerPipelineParameters()));
                }
                if (this.getSqsParameters() != null) {
                    data.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnSchedule.TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetProperty.Jsii$Proxy that = (TargetProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
                if (this.ecsParameters != null ? !this.ecsParameters.equals(that.ecsParameters) : that.ecsParameters != null) return false;
                if (this.eventBridgeParameters != null ? !this.eventBridgeParameters.equals(that.eventBridgeParameters) : that.eventBridgeParameters != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                if (this.kinesisParameters != null ? !this.kinesisParameters.equals(that.kinesisParameters) : that.kinesisParameters != null) return false;
                if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
                if (this.sageMakerPipelineParameters != null ? !this.sageMakerPipelineParameters.equals(that.sageMakerPipelineParameters) : that.sageMakerPipelineParameters != null) return false;
                return this.sqsParameters != null ? this.sqsParameters.equals(that.sqsParameters) : that.sqsParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
                result = 31 * result + (this.ecsParameters != null ? this.ecsParameters.hashCode() : 0);
                result = 31 * result + (this.eventBridgeParameters != null ? this.eventBridgeParameters.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.kinesisParameters != null ? this.kinesisParameters.hashCode() : 0);
                result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
                result = 31 * result + (this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.hashCode() : 0);
                result = 31 * result + (this.sqsParameters != null ? this.sqsParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.CfnSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.CfnSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.scheduler.CfnScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.scheduler.CfnScheduleProps.Builder();
        }

        /**
         * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
         * <p>
         * @return {@code this}
         * @param flexibleTimeWindow `AWS::Scheduler::Schedule.FlexibleTimeWindow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(final software.amazon.awscdk.services.scheduler.CfnSchedule.FlexibleTimeWindowProperty flexibleTimeWindow) {
            this.props.flexibleTimeWindow(flexibleTimeWindow);
            return this;
        }
        /**
         * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
         * <p>
         * @return {@code this}
         * @param flexibleTimeWindow `AWS::Scheduler::Schedule.FlexibleTimeWindow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(final software.amazon.awscdk.IResolvable flexibleTimeWindow) {
            this.props.flexibleTimeWindow(flexibleTimeWindow);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.ScheduleExpression`.
         * <p>
         * @return {@code this}
         * @param scheduleExpression `AWS::Scheduler::Schedule.ScheduleExpression`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(final java.lang.String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.Target`.
         * <p>
         * @return {@code this}
         * @param target `AWS::Scheduler::Schedule.Target`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.scheduler.CfnSchedule.TargetProperty target) {
            this.props.target(target);
            return this;
        }
        /**
         * `AWS::Scheduler::Schedule.Target`.
         * <p>
         * @return {@code this}
         * @param target `AWS::Scheduler::Schedule.Target`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.IResolvable target) {
            this.props.target(target);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.Description`.
         * <p>
         * @return {@code this}
         * @param description `AWS::Scheduler::Schedule.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.EndDate`.
         * <p>
         * @return {@code this}
         * @param endDate `AWS::Scheduler::Schedule.EndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(final java.lang.String endDate) {
            this.props.endDate(endDate);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.GroupName`.
         * <p>
         * @return {@code this}
         * @param groupName `AWS::Scheduler::Schedule.GroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.KmsKeyArn`.
         * <p>
         * @return {@code this}
         * @param kmsKeyArn `AWS::Scheduler::Schedule.KmsKeyArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::Scheduler::Schedule.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`.
         * <p>
         * @return {@code this}
         * @param scheduleExpressionTimezone `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(final java.lang.String scheduleExpressionTimezone) {
            this.props.scheduleExpressionTimezone(scheduleExpressionTimezone);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.StartDate`.
         * <p>
         * @return {@code this}
         * @param startDate `AWS::Scheduler::Schedule.StartDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startDate(final java.lang.String startDate) {
            this.props.startDate(startDate);
            return this;
        }

        /**
         * `AWS::Scheduler::Schedule.State`.
         * <p>
         * @return {@code this}
         * @param state `AWS::Scheduler::Schedule.State`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.scheduler.CfnSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.CfnSchedule build() {
            return new software.amazon.awscdk.services.scheduler.CfnSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
