package software.amazon.awscdk.services.route53.targets;

/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * HostedZone zone;
 * InterfaceVpcEndpoint interfaceVpcEndpoint;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new InterfaceVpcEndpointTarget(interfaceVpcEndpoint)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.403Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.InterfaceVpcEndpointTarget")
public class InterfaceVpcEndpointTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected InterfaceVpcEndpointTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InterfaceVpcEndpointTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param vpcEndpoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint vpcEndpoint) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(vpcEndpoint, "vpcEndpoint is required") });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required"), _zone });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required") });
    }
}
