package software.amazon.awscdk.services.route53;

/**
 * Construction properties for a PublicHostedZone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PublicHostedZone subZone = PublicHostedZone.Builder.create(this, "SubZone")
 *         .zoneName("sub.someexample.com")
 *         .build();
 * // import the delegation role by constructing the roleArn
 * String delegationRoleArn = Stack.of(this).formatArn(ArnComponents.builder()
 *         .region("") // IAM is global in each partition
 *         .service("iam")
 *         .account("parent-account-id")
 *         .resource("role")
 *         .resourceName("MyDelegationRole")
 *         .build());
 * IRole delegationRole = Role.fromRoleArn(this, "DelegationRole", delegationRoleArn);
 * // create the record
 * // create the record
 * CrossAccountZoneDelegationRecord.Builder.create(this, "delegate")
 *         .delegatedZone(subZone)
 *         .parentHostedZoneName("someexample.com") // or you can use parentHostedZoneId
 *         .delegationRole(delegationRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.392Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.PublicHostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(PublicHostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicHostedZoneProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.CommonHostedZoneProps {

    /**
     * Whether to create a CAA record to restrict certificate authorities allowed to issue certificates for this domain to Amazon only.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCaaAmazon() {
        return null;
    }

    /**
     * A principal which is trusted to assume a role for zone delegation.
     * <p>
     * Default: - No delegation configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IPrincipal getCrossAccountZoneDelegationPrincipal() {
        return null;
    }

    /**
     * The name of the role created for cross account delegation.
     * <p>
     * Default: - A role name is generated automatically
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountZoneDelegationRoleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PublicHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicHostedZoneProps> {
        java.lang.Boolean caaAmazon;
        software.amazon.awscdk.services.iam.IPrincipal crossAccountZoneDelegationPrincipal;
        java.lang.String crossAccountZoneDelegationRoleName;
        java.lang.String zoneName;
        java.lang.String comment;
        java.lang.String queryLogsLogGroupArn;

        /**
         * Sets the value of {@link PublicHostedZoneProps#getCaaAmazon}
         * @param caaAmazon Whether to create a CAA record to restrict certificate authorities allowed to issue certificates for this domain to Amazon only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caaAmazon(java.lang.Boolean caaAmazon) {
            this.caaAmazon = caaAmazon;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneProps#getCrossAccountZoneDelegationPrincipal}
         * @param crossAccountZoneDelegationPrincipal A principal which is trusted to assume a role for zone delegation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountZoneDelegationPrincipal(software.amazon.awscdk.services.iam.IPrincipal crossAccountZoneDelegationPrincipal) {
            this.crossAccountZoneDelegationPrincipal = crossAccountZoneDelegationPrincipal;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneProps#getCrossAccountZoneDelegationRoleName}
         * @param crossAccountZoneDelegationRoleName The name of the role created for cross account delegation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountZoneDelegationRoleName(java.lang.String crossAccountZoneDelegationRoleName) {
            this.crossAccountZoneDelegationRoleName = crossAccountZoneDelegationRoleName;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneProps#getZoneName}
         * @param zoneName The name of the domain. This parameter is required.
         *                 For resource record types that include a domain
         *                 name, specify a fully qualified domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneProps#getComment}
         * @param comment Any comments that you want to include about the hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneProps#getQueryLogsLogGroupArn}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(java.lang.String queryLogsLogGroupArn) {
            this.queryLogsLogGroupArn = queryLogsLogGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicHostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicHostedZoneProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicHostedZoneProps {
        private final java.lang.Boolean caaAmazon;
        private final software.amazon.awscdk.services.iam.IPrincipal crossAccountZoneDelegationPrincipal;
        private final java.lang.String crossAccountZoneDelegationRoleName;
        private final java.lang.String zoneName;
        private final java.lang.String comment;
        private final java.lang.String queryLogsLogGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.caaAmazon = software.amazon.jsii.Kernel.get(this, "caaAmazon", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.crossAccountZoneDelegationPrincipal = software.amazon.jsii.Kernel.get(this, "crossAccountZoneDelegationPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
            this.crossAccountZoneDelegationRoleName = software.amazon.jsii.Kernel.get(this, "crossAccountZoneDelegationRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zoneName = software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "queryLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.caaAmazon = builder.caaAmazon;
            this.crossAccountZoneDelegationPrincipal = builder.crossAccountZoneDelegationPrincipal;
            this.crossAccountZoneDelegationRoleName = builder.crossAccountZoneDelegationRoleName;
            this.zoneName = java.util.Objects.requireNonNull(builder.zoneName, "zoneName is required");
            this.comment = builder.comment;
            this.queryLogsLogGroupArn = builder.queryLogsLogGroupArn;
        }

        @Override
        public final java.lang.Boolean getCaaAmazon() {
            return this.caaAmazon;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IPrincipal getCrossAccountZoneDelegationPrincipal() {
            return this.crossAccountZoneDelegationPrincipal;
        }

        @Override
        public final java.lang.String getCrossAccountZoneDelegationRoleName() {
            return this.crossAccountZoneDelegationRoleName;
        }

        @Override
        public final java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getQueryLogsLogGroupArn() {
            return this.queryLogsLogGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCaaAmazon() != null) {
                data.set("caaAmazon", om.valueToTree(this.getCaaAmazon()));
            }
            if (this.getCrossAccountZoneDelegationPrincipal() != null) {
                data.set("crossAccountZoneDelegationPrincipal", om.valueToTree(this.getCrossAccountZoneDelegationPrincipal()));
            }
            if (this.getCrossAccountZoneDelegationRoleName() != null) {
                data.set("crossAccountZoneDelegationRoleName", om.valueToTree(this.getCrossAccountZoneDelegationRoleName()));
            }
            data.set("zoneName", om.valueToTree(this.getZoneName()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLogsLogGroupArn() != null) {
                data.set("queryLogsLogGroupArn", om.valueToTree(this.getQueryLogsLogGroupArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.PublicHostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicHostedZoneProps.Jsii$Proxy that = (PublicHostedZoneProps.Jsii$Proxy) o;

            if (this.caaAmazon != null ? !this.caaAmazon.equals(that.caaAmazon) : that.caaAmazon != null) return false;
            if (this.crossAccountZoneDelegationPrincipal != null ? !this.crossAccountZoneDelegationPrincipal.equals(that.crossAccountZoneDelegationPrincipal) : that.crossAccountZoneDelegationPrincipal != null) return false;
            if (this.crossAccountZoneDelegationRoleName != null ? !this.crossAccountZoneDelegationRoleName.equals(that.crossAccountZoneDelegationRoleName) : that.crossAccountZoneDelegationRoleName != null) return false;
            if (!zoneName.equals(that.zoneName)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.equals(that.queryLogsLogGroupArn) : that.queryLogsLogGroupArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.caaAmazon != null ? this.caaAmazon.hashCode() : 0;
            result = 31 * result + (this.crossAccountZoneDelegationPrincipal != null ? this.crossAccountZoneDelegationPrincipal.hashCode() : 0);
            result = 31 * result + (this.crossAccountZoneDelegationRoleName != null ? this.crossAccountZoneDelegationRoleName.hashCode() : 0);
            result = 31 * result + (this.zoneName.hashCode());
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.hashCode() : 0);
            return result;
        }
    }
}
