package software.amazon.awscdk.services.resiliencehub;

/**
 * Properties for defining a `CfnApp`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resiliencehub.*;
 * CfnAppProps cfnAppProps = CfnAppProps.builder()
 *         .appTemplateBody("appTemplateBody")
 *         .name("name")
 *         .resourceMappings(List.of(ResourceMappingProperty.builder()
 *                 .mappingType("mappingType")
 *                 .physicalResourceId(PhysicalResourceIdProperty.builder()
 *                         .identifier("identifier")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .awsAccountId("awsAccountId")
 *                         .awsRegion("awsRegion")
 *                         .build())
 *                 // the properties below are optional
 *                 .logicalStackName("logicalStackName")
 *                 .resourceName("resourceName")
 *                 .terraformSourceName("terraformSourceName")
 *                 .build()))
 *         // the properties below are optional
 *         .appAssessmentSchedule("appAssessmentSchedule")
 *         .description("description")
 *         .resiliencyPolicyArn("resiliencyPolicyArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.276Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A string containing a full Resilience Hub app template body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppTemplateBody();

    /**
     * The name for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An array of ResourceMapping objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceMappings();

    /**
     * `AWS::ResilienceHub::App.AppAssessmentSchedule`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppAssessmentSchedule() {
        return null;
    }

    /**
     * The optional description for an app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResiliencyPolicyArn() {
        return null;
    }

    /**
     * The tags assigned to the resource.
     * <p>
     * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppProps> {
        java.lang.String appTemplateBody;
        java.lang.String name;
        java.lang.Object resourceMappings;
        java.lang.String appAssessmentSchedule;
        java.lang.String description;
        java.lang.String resiliencyPolicyArn;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAppProps#getAppTemplateBody}
         * @param appTemplateBody A string containing a full Resilience Hub app template body. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appTemplateBody(java.lang.String appTemplateBody) {
            this.appTemplateBody = appTemplateBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getName}
         * @param name The name for the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResourceMappings}
         * @param resourceMappings An array of ResourceMapping objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(software.amazon.awscdk.IResolvable resourceMappings) {
            this.resourceMappings = resourceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResourceMappings}
         * @param resourceMappings An array of ResourceMapping objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(java.util.List<? extends java.lang.Object> resourceMappings) {
            this.resourceMappings = resourceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAppAssessmentSchedule}
         * @param appAssessmentSchedule `AWS::ResilienceHub::App.AppAssessmentSchedule`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appAssessmentSchedule(java.lang.String appAssessmentSchedule) {
            this.appAssessmentSchedule = appAssessmentSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDescription}
         * @param description The optional description for an app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResiliencyPolicyArn}
         * @param resiliencyPolicyArn The Amazon Resource Name (ARN) of the resiliency policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resiliencyPolicyArn(java.lang.String resiliencyPolicyArn) {
            this.resiliencyPolicyArn = resiliencyPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getTags}
         * @param tags The tags assigned to the resource.
         *             A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppProps {
        private final java.lang.String appTemplateBody;
        private final java.lang.String name;
        private final java.lang.Object resourceMappings;
        private final java.lang.String appAssessmentSchedule;
        private final java.lang.String description;
        private final java.lang.String resiliencyPolicyArn;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appTemplateBody = software.amazon.jsii.Kernel.get(this, "appTemplateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceMappings = software.amazon.jsii.Kernel.get(this, "resourceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.appAssessmentSchedule = software.amazon.jsii.Kernel.get(this, "appAssessmentSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resiliencyPolicyArn = software.amazon.jsii.Kernel.get(this, "resiliencyPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appTemplateBody = java.util.Objects.requireNonNull(builder.appTemplateBody, "appTemplateBody is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.resourceMappings = java.util.Objects.requireNonNull(builder.resourceMappings, "resourceMappings is required");
            this.appAssessmentSchedule = builder.appAssessmentSchedule;
            this.description = builder.description;
            this.resiliencyPolicyArn = builder.resiliencyPolicyArn;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAppTemplateBody() {
            return this.appTemplateBody;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getResourceMappings() {
            return this.resourceMappings;
        }

        @Override
        public final java.lang.String getAppAssessmentSchedule() {
            return this.appAssessmentSchedule;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getResiliencyPolicyArn() {
            return this.resiliencyPolicyArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appTemplateBody", om.valueToTree(this.getAppTemplateBody()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("resourceMappings", om.valueToTree(this.getResourceMappings()));
            if (this.getAppAssessmentSchedule() != null) {
                data.set("appAssessmentSchedule", om.valueToTree(this.getAppAssessmentSchedule()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getResiliencyPolicyArn() != null) {
                data.set("resiliencyPolicyArn", om.valueToTree(this.getResiliencyPolicyArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppProps.Jsii$Proxy that = (CfnAppProps.Jsii$Proxy) o;

            if (!appTemplateBody.equals(that.appTemplateBody)) return false;
            if (!name.equals(that.name)) return false;
            if (!resourceMappings.equals(that.resourceMappings)) return false;
            if (this.appAssessmentSchedule != null ? !this.appAssessmentSchedule.equals(that.appAssessmentSchedule) : that.appAssessmentSchedule != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.resiliencyPolicyArn != null ? !this.resiliencyPolicyArn.equals(that.resiliencyPolicyArn) : that.resiliencyPolicyArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appTemplateBody.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.resourceMappings.hashCode());
            result = 31 * result + (this.appAssessmentSchedule != null ? this.appAssessmentSchedule.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.resiliencyPolicyArn != null ? this.resiliencyPolicyArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
