package software.amazon.awscdk.services.rekognition;

/**
 * Properties for defining a `CfnStreamProcessor`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rekognition.*;
 * CfnStreamProcessorProps cfnStreamProcessorProps = CfnStreamProcessorProps.builder()
 *         .kinesisVideoStream(KinesisVideoStreamProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .boundingBoxRegionsOfInterest(List.of(BoundingBoxProperty.builder()
 *                 .height(123)
 *                 .left(123)
 *                 .top(123)
 *                 .width(123)
 *                 .build()))
 *         .connectedHomeSettings(ConnectedHomeSettingsProperty.builder()
 *                 .labels(List.of("labels"))
 *                 // the properties below are optional
 *                 .minConfidence(123)
 *                 .build())
 *         .dataSharingPreference(DataSharingPreferenceProperty.builder()
 *                 .optIn(false)
 *                 .build())
 *         .faceSearchSettings(FaceSearchSettingsProperty.builder()
 *                 .collectionId("collectionId")
 *                 // the properties below are optional
 *                 .faceMatchThreshold(123)
 *                 .build())
 *         .kinesisDataStream(KinesisDataStreamProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .name("name")
 *         .notificationChannel(NotificationChannelProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .polygonRegionsOfInterest(List.of(PolygonProperty.builder()
 *                 .polygon(List.of(PointProperty.builder()
 *                         .x(123)
 *                         .y(123)
 *                         .build()))
 *                 .build()))
 *         .s3Destination(S3DestinationProperty.builder()
 *                 .bucketName("bucketName")
 *                 // the properties below are optional
 *                 .objectKeyPrefix("objectKeyPrefix")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessorProps")
@software.amazon.jsii.Jsii.Proxy(CfnStreamProcessorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamProcessorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKinesisVideoStream();

    /**
     * The ARN of the IAM role that allows access to the stream processor.
     * <p>
     * The IAM role provides Rekognition read permissions to the Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a connected home stream processor. This is required for both face search and connected home stream processors. For information about constraints, see the RoleArn section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * List of BoundingBox objects, each of which denotes a region of interest on screen.
     * <p>
     * For more information, see the BoundingBox field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBoundingBoxRegionsOfInterest() {
        return null;
    }

    /**
     * Connected home settings to use on a streaming video.
     * <p>
     * You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectedHomeSettings() {
        return null;
    }

    /**
     * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
     * <p>
     * You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSharingPreference() {
        return null;
    }

    /**
     * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
     * <p>
     * For more information regarding the contents of the parameters, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFaceSearchSettings() {
        return null;
    }

    /**
     * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
     * <p>
     * This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisDataStream() {
        return null;
    }

    /**
     * The identifier for your Amazon Key Management Service key (Amazon KMS key).
     * <p>
     * Optional parameter for connected home stream processors used to encrypt results and data published to your Amazon S3 bucket. For more information, see the KMSKeyId section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of [StreamProcessor](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor) . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     * <p>
     * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationChannel() {
        return null;
    }

    /**
     * A set of ordered lists of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. For more information, see the Polygon field of [RegionOfInterest](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolygonRegionsOfInterest() {
        return null;
    }

    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     * <p>
     * For more information, see the S3Destination section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput">StreamProcessorOutput</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
        return null;
    }

    /**
     * A set of tags (key-value pairs) that you want to attach to the stream processor.
     * <p>
     * For more information, see the Tags section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStreamProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStreamProcessorProps> {
        java.lang.Object kinesisVideoStream;
        java.lang.String roleArn;
        java.lang.Object boundingBoxRegionsOfInterest;
        java.lang.Object connectedHomeSettings;
        java.lang.Object dataSharingPreference;
        java.lang.Object faceSearchSettings;
        java.lang.Object kinesisDataStream;
        java.lang.String kmsKeyId;
        java.lang.String name;
        java.lang.Object notificationChannel;
        java.lang.Object polygonRegionsOfInterest;
        java.lang.Object s3Destination;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getKinesisVideoStream}
         * @param kinesisVideoStream The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. This parameter is required.
         *                           For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStream(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisVideoStreamProperty kinesisVideoStream) {
            this.kinesisVideoStream = kinesisVideoStream;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getKinesisVideoStream}
         * @param kinesisVideoStream The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. This parameter is required.
         *                           For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStream(software.amazon.awscdk.IResolvable kinesisVideoStream) {
            this.kinesisVideoStream = kinesisVideoStream;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getRoleArn}
         * @param roleArn The ARN of the IAM role that allows access to the stream processor. This parameter is required.
         *                The IAM role provides Rekognition read permissions to the Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a connected home stream processor. This is required for both face search and connected home stream processors. For information about constraints, see the RoleArn section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getBoundingBoxRegionsOfInterest}
         * @param boundingBoxRegionsOfInterest List of BoundingBox objects, each of which denotes a region of interest on screen.
         *                                     For more information, see the BoundingBox field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder boundingBoxRegionsOfInterest(software.amazon.awscdk.IResolvable boundingBoxRegionsOfInterest) {
            this.boundingBoxRegionsOfInterest = boundingBoxRegionsOfInterest;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getBoundingBoxRegionsOfInterest}
         * @param boundingBoxRegionsOfInterest List of BoundingBox objects, each of which denotes a region of interest on screen.
         *                                     For more information, see the BoundingBox field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder boundingBoxRegionsOfInterest(java.util.List<? extends java.lang.Object> boundingBoxRegionsOfInterest) {
            this.boundingBoxRegionsOfInterest = boundingBoxRegionsOfInterest;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getConnectedHomeSettings}
         * @param connectedHomeSettings Connected home settings to use on a streaming video.
         *                              You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectedHomeSettings(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.ConnectedHomeSettingsProperty connectedHomeSettings) {
            this.connectedHomeSettings = connectedHomeSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getConnectedHomeSettings}
         * @param connectedHomeSettings Connected home settings to use on a streaming video.
         *                              You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectedHomeSettings(software.amazon.awscdk.IResolvable connectedHomeSettings) {
            this.connectedHomeSettings = connectedHomeSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getDataSharingPreference}
         * @param dataSharingPreference Allows you to opt in or opt out to share data with Rekognition to improve model performance.
         *                              You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSharingPreference(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.DataSharingPreferenceProperty dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getDataSharingPreference}
         * @param dataSharingPreference Allows you to opt in or opt out to share data with Rekognition to improve model performance.
         *                              You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSharingPreference(software.amazon.awscdk.IResolvable dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getFaceSearchSettings}
         * @param faceSearchSettings The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
         *                           For more information regarding the contents of the parameters, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faceSearchSettings(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.FaceSearchSettingsProperty faceSearchSettings) {
            this.faceSearchSettings = faceSearchSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getFaceSearchSettings}
         * @param faceSearchSettings The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
         *                           For more information regarding the contents of the parameters, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faceSearchSettings(software.amazon.awscdk.IResolvable faceSearchSettings) {
            this.faceSearchSettings = faceSearchSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getKinesisDataStream}
         * @param kinesisDataStream Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
         *                          This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisDataStream(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisDataStreamProperty kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getKinesisDataStream}
         * @param kinesisDataStream Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
         *                          This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisDataStream(software.amazon.awscdk.IResolvable kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getKmsKeyId}
         * @param kmsKeyId The identifier for your Amazon Key Management Service key (Amazon KMS key).
         *                 Optional parameter for connected home stream processors used to encrypt results and data published to your Amazon S3 bucket. For more information, see the KMSKeyId section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getName}
         * @param name The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of [StreamProcessor](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor) . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getNotificationChannel}
         * @param notificationChannel The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
         *                            Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationChannel(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.NotificationChannelProperty notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getNotificationChannel}
         * @param notificationChannel The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
         *                            Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationChannel(software.amazon.awscdk.IResolvable notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getPolygonRegionsOfInterest}
         * @param polygonRegionsOfInterest A set of ordered lists of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. For more information, see the Polygon field of [RegionOfInterest](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder polygonRegionsOfInterest(software.amazon.awscdk.IResolvable polygonRegionsOfInterest) {
            this.polygonRegionsOfInterest = polygonRegionsOfInterest;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getPolygonRegionsOfInterest}
         * @param polygonRegionsOfInterest A set of ordered lists of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of [Point](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point) objects. For more information, see the Polygon field of [RegionOfInterest](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder polygonRegionsOfInterest(java.util.List<? extends java.lang.Object> polygonRegionsOfInterest) {
            this.polygonRegionsOfInterest = polygonRegionsOfInterest;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getS3Destination}
         * @param s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
         *                      For more information, see the S3Destination section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput">StreamProcessorOutput</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.S3DestinationProperty s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getS3Destination}
         * @param s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
         *                      For more information, see the S3Destination section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput">StreamProcessorOutput</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(software.amazon.awscdk.IResolvable s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProcessorProps#getTags}
         * @param tags A set of tags (key-value pairs) that you want to attach to the stream processor.
         *             For more information, see the Tags section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamProcessorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStreamProcessorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStreamProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamProcessorProps {
        private final java.lang.Object kinesisVideoStream;
        private final java.lang.String roleArn;
        private final java.lang.Object boundingBoxRegionsOfInterest;
        private final java.lang.Object connectedHomeSettings;
        private final java.lang.Object dataSharingPreference;
        private final java.lang.Object faceSearchSettings;
        private final java.lang.Object kinesisDataStream;
        private final java.lang.String kmsKeyId;
        private final java.lang.String name;
        private final java.lang.Object notificationChannel;
        private final java.lang.Object polygonRegionsOfInterest;
        private final java.lang.Object s3Destination;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kinesisVideoStream = software.amazon.jsii.Kernel.get(this, "kinesisVideoStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.boundingBoxRegionsOfInterest = software.amazon.jsii.Kernel.get(this, "boundingBoxRegionsOfInterest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectedHomeSettings = software.amazon.jsii.Kernel.get(this, "connectedHomeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSharingPreference = software.amazon.jsii.Kernel.get(this, "dataSharingPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.faceSearchSettings = software.amazon.jsii.Kernel.get(this, "faceSearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisDataStream = software.amazon.jsii.Kernel.get(this, "kinesisDataStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationChannel = software.amazon.jsii.Kernel.get(this, "notificationChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.polygonRegionsOfInterest = software.amazon.jsii.Kernel.get(this, "polygonRegionsOfInterest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3Destination = software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kinesisVideoStream = java.util.Objects.requireNonNull(builder.kinesisVideoStream, "kinesisVideoStream is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.boundingBoxRegionsOfInterest = builder.boundingBoxRegionsOfInterest;
            this.connectedHomeSettings = builder.connectedHomeSettings;
            this.dataSharingPreference = builder.dataSharingPreference;
            this.faceSearchSettings = builder.faceSearchSettings;
            this.kinesisDataStream = builder.kinesisDataStream;
            this.kmsKeyId = builder.kmsKeyId;
            this.name = builder.name;
            this.notificationChannel = builder.notificationChannel;
            this.polygonRegionsOfInterest = builder.polygonRegionsOfInterest;
            this.s3Destination = builder.s3Destination;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getKinesisVideoStream() {
            return this.kinesisVideoStream;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getBoundingBoxRegionsOfInterest() {
            return this.boundingBoxRegionsOfInterest;
        }

        @Override
        public final java.lang.Object getConnectedHomeSettings() {
            return this.connectedHomeSettings;
        }

        @Override
        public final java.lang.Object getDataSharingPreference() {
            return this.dataSharingPreference;
        }

        @Override
        public final java.lang.Object getFaceSearchSettings() {
            return this.faceSearchSettings;
        }

        @Override
        public final java.lang.Object getKinesisDataStream() {
            return this.kinesisDataStream;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNotificationChannel() {
            return this.notificationChannel;
        }

        @Override
        public final java.lang.Object getPolygonRegionsOfInterest() {
            return this.polygonRegionsOfInterest;
        }

        @Override
        public final java.lang.Object getS3Destination() {
            return this.s3Destination;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("kinesisVideoStream", om.valueToTree(this.getKinesisVideoStream()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getBoundingBoxRegionsOfInterest() != null) {
                data.set("boundingBoxRegionsOfInterest", om.valueToTree(this.getBoundingBoxRegionsOfInterest()));
            }
            if (this.getConnectedHomeSettings() != null) {
                data.set("connectedHomeSettings", om.valueToTree(this.getConnectedHomeSettings()));
            }
            if (this.getDataSharingPreference() != null) {
                data.set("dataSharingPreference", om.valueToTree(this.getDataSharingPreference()));
            }
            if (this.getFaceSearchSettings() != null) {
                data.set("faceSearchSettings", om.valueToTree(this.getFaceSearchSettings()));
            }
            if (this.getKinesisDataStream() != null) {
                data.set("kinesisDataStream", om.valueToTree(this.getKinesisDataStream()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNotificationChannel() != null) {
                data.set("notificationChannel", om.valueToTree(this.getNotificationChannel()));
            }
            if (this.getPolygonRegionsOfInterest() != null) {
                data.set("polygonRegionsOfInterest", om.valueToTree(this.getPolygonRegionsOfInterest()));
            }
            if (this.getS3Destination() != null) {
                data.set("s3Destination", om.valueToTree(this.getS3Destination()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamProcessorProps.Jsii$Proxy that = (CfnStreamProcessorProps.Jsii$Proxy) o;

            if (!kinesisVideoStream.equals(that.kinesisVideoStream)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.boundingBoxRegionsOfInterest != null ? !this.boundingBoxRegionsOfInterest.equals(that.boundingBoxRegionsOfInterest) : that.boundingBoxRegionsOfInterest != null) return false;
            if (this.connectedHomeSettings != null ? !this.connectedHomeSettings.equals(that.connectedHomeSettings) : that.connectedHomeSettings != null) return false;
            if (this.dataSharingPreference != null ? !this.dataSharingPreference.equals(that.dataSharingPreference) : that.dataSharingPreference != null) return false;
            if (this.faceSearchSettings != null ? !this.faceSearchSettings.equals(that.faceSearchSettings) : that.faceSearchSettings != null) return false;
            if (this.kinesisDataStream != null ? !this.kinesisDataStream.equals(that.kinesisDataStream) : that.kinesisDataStream != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.notificationChannel != null ? !this.notificationChannel.equals(that.notificationChannel) : that.notificationChannel != null) return false;
            if (this.polygonRegionsOfInterest != null ? !this.polygonRegionsOfInterest.equals(that.polygonRegionsOfInterest) : that.polygonRegionsOfInterest != null) return false;
            if (this.s3Destination != null ? !this.s3Destination.equals(that.s3Destination) : that.s3Destination != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kinesisVideoStream.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.boundingBoxRegionsOfInterest != null ? this.boundingBoxRegionsOfInterest.hashCode() : 0);
            result = 31 * result + (this.connectedHomeSettings != null ? this.connectedHomeSettings.hashCode() : 0);
            result = 31 * result + (this.dataSharingPreference != null ? this.dataSharingPreference.hashCode() : 0);
            result = 31 * result + (this.faceSearchSettings != null ? this.faceSearchSettings.hashCode() : 0);
            result = 31 * result + (this.kinesisDataStream != null ? this.kinesisDataStream.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.notificationChannel != null ? this.notificationChannel.hashCode() : 0);
            result = 31 * result + (this.polygonRegionsOfInterest != null ? this.polygonRegionsOfInterest.hashCode() : 0);
            result = 31 * result + (this.s3Destination != null ? this.s3Destination.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
