package software.amazon.awscdk.services.rds;

/**
 * Properties for ``DatabaseClusterFromSnapshot``.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseClusterFromSnapshot.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.aurora(AuroraClusterEngineProps.builder().version(AuroraEngineVersion.VER_1_22_2).build()))
 *         .instanceProps(InstanceProps.builder()
 *                 .vpc(vpc)
 *                 .build())
 *         .snapshotIdentifier("mySnapshot")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.131Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterFromSnapshotProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterFromSnapshotProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseClusterFromSnapshotProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What kind of database to start.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine getEngine();

    /**
     * Settings for the individual instances that are launched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceProps getInstanceProps();

    /**
     * The identifier for the DB instance snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
     * However, you can use only the ARN to specify a DB instance snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSnapshotIdentifier();

    /**
     * The number of seconds to set a cluster's target backtrack window to.
     * <p>
     * This feature is only supported by the Aurora MySQL database engine and
     * cannot be enabled on existing clusters.
     * <p>
     * Default: 0 seconds (no backtrack)
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getBacktrackWindow() {
        return null;
    }

    /**
     * Backup settings.
     * <p>
     * Default: - Backup retention period for automated backups is 1 day.
     * Backup preferred window is set to a 30-minute window selected at random from an
     * 8-hour block of time for each AWS Region, occurring on a random day of the week.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.BackupProps getBackup() {
        return null;
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * Default: - no log exports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloudwatchLogsExports() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>Infinity</code>.
     * <p>
     * Default: - logs never expire
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - a new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    /**
     * An optional identifier for the cluster.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return null;
    }

    /**
     * Whether to copy tags to the snapshot when a snapshot is created.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * (deprecated) Credentials for the administrative user.
     * <p>
     * Note - using this prop only works with <code>Credentials.fromPassword()</code> with the
     * username of the snapshot, <code>Credentials.fromUsername()</code> with the username and
     * password of the snapshot or <code>Credentials.fromSecret()</code> with a secret containing
     * the username and password of the snapshot.
     * <p>
     * Default: - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
     * that **will not be applied** to the cluster, use `snapshotCredentials` for the correct behavior.
     * <p>
     * @deprecated use `snapshotCredentials` which allows to generate a new password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.Credentials getCredentials() {
        return null;
    }

    /**
     * Name of a database which is automatically created inside the cluster.
     * <p>
     * Default: - Database is not created in cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultDatabaseName() {
        return null;
    }

    /**
     * Indicates whether the DB cluster should have deletion protection enabled.
     * <p>
     * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIamAuthentication() {
        return null;
    }

    /**
     * Base identifier for instances.
     * <p>
     * Every replica is named by appending the replica number to this string, 1-based.
     * <p>
     * Default: - clusterIdentifier is used with the word "Instance" appended.
     * If clusterIdentifier is not provided, the identifier is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceIdentifierBase() {
        return null;
    }

    /**
     * How many replicas/instances to create.
     * <p>
     * Has to be at least 1.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInstances() {
        return null;
    }

    /**
     * The ordering of updates for instances.
     * <p>
     * Default: InstanceUpdateBehaviour.BULK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.InstanceUpdateBehaviour getInstanceUpdateBehaviour() {
        return null;
    }

    /**
     * The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
     * <p>
     * Default: no enhanced monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMonitoringInterval() {
        return null;
    }

    /**
     * Role that will be used to manage DB instances monitoring.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
        return null;
    }

    /**
     * The network type of the DB instance.
     * <p>
     * Default: - IPV4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.NetworkType getNetworkType() {
        return null;
    }

    /**
     * Additional parameters to pass to the database engine.
     * <p>
     * Default: - No parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * The parameters in the DBClusterParameterGroup to create automatically.
     * <p>
     * You can only specify parameterGroup or parameters but not both.
     * You need to use a versioned engine to auto-generate a DBClusterParameterGroup.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * What port to listen on.
     * <p>
     * Default: - The default for the engine is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
     * <p>
     * Example: 'Sun:23:45-Mon:00:15'
     * <p>
     * Default: - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
     * <p>
     * Default: - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ExportRole</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
        return null;
    }

    /**
     * Role that will be associated with this DB cluster to enable S3 export.
     * <p>
     * This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ExportBuckets</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
        return null;
    }

    /**
     * S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ImportRole</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
        return null;
    }

    /**
     * Role that will be associated with this DB cluster to enable S3 import.
     * <p>
     * This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ImportBuckets</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
        return null;
    }

    /**
     * Master user credentials.
     * <p>
     * Note - It is not possible to change the master username for a snapshot;
     * however, it is possible to provide (or generate) a new password.
     * <p>
     * Default: - The existing username and password from the snapshot will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.SnapshotCredentials getSnapshotCredentials() {
        return null;
    }

    /**
     * Whether to enable storage encryption.
     * <p>
     * Default: - true if storageEncryptionKey is provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStorageEncrypted() {
        return null;
    }

    /**
     * The KMS key for storage encryption.
     * <p>
     * If specified, {&#64;link storageEncrypted} will be set to <code>true</code>.
     * <p>
     * Default: - if storageEncrypted is true then the default master key, no key otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
        return null;
    }

    /**
     * Existing subnet group for the cluster.
     * <p>
     * Default: - a new subnet group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterFromSnapshotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterFromSnapshotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterFromSnapshotProps> {
        software.amazon.awscdk.services.rds.IClusterEngine engine;
        software.amazon.awscdk.services.rds.InstanceProps instanceProps;
        java.lang.String snapshotIdentifier;
        software.amazon.awscdk.Duration backtrackWindow;
        software.amazon.awscdk.services.rds.BackupProps backup;
        java.util.List<java.lang.String> cloudwatchLogsExports;
        software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        java.lang.String clusterIdentifier;
        java.lang.Boolean copyTagsToSnapshot;
        software.amazon.awscdk.services.rds.Credentials credentials;
        java.lang.String defaultDatabaseName;
        java.lang.Boolean deletionProtection;
        java.lang.Boolean iamAuthentication;
        java.lang.String instanceIdentifierBase;
        java.lang.Number instances;
        software.amazon.awscdk.services.rds.InstanceUpdateBehaviour instanceUpdateBehaviour;
        software.amazon.awscdk.Duration monitoringInterval;
        software.amazon.awscdk.services.iam.IRole monitoringRole;
        software.amazon.awscdk.services.rds.NetworkType networkType;
        software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        java.lang.Number port;
        java.lang.String preferredMaintenanceWindow;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        software.amazon.awscdk.services.iam.IRole s3ExportRole;
        java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        software.amazon.awscdk.services.iam.IRole s3ImportRole;
        software.amazon.awscdk.services.rds.SnapshotCredentials snapshotCredentials;
        java.lang.Boolean storageEncrypted;
        software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getEngine}
         * @param engine What kind of database to start. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getInstanceProps}
         * @param instanceProps Settings for the individual instances that are launched. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProps(software.amazon.awscdk.services.rds.InstanceProps instanceProps) {
            this.instanceProps = instanceProps;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getSnapshotIdentifier}
         * @param snapshotIdentifier The identifier for the DB instance snapshot or DB cluster snapshot to restore from. This parameter is required.
         *                           You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
         *                           However, you can use only the ARN to specify a DB instance snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getBacktrackWindow}
         * @param backtrackWindow The number of seconds to set a cluster's target backtrack window to.
         *                        This feature is only supported by the Aurora MySQL database engine and
         *                        cannot be enabled on existing clusters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(software.amazon.awscdk.Duration backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getBackup}
         * @param backup Backup settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backup(software.amazon.awscdk.services.rds.BackupProps backup) {
            this.backup = backup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getCloudwatchLogsExports}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsExports(java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getCloudwatchLogsRetention}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs.
         *                                When updating
         *                                this property, unsetting it doesn't remove the log retention policy. To
         *                                remove the retention policy, set the value to <code>Infinity</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getCloudwatchLogsRetentionRole}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetentionRole(software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getClusterIdentifier}
         * @param clusterIdentifier An optional identifier for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Whether to copy tags to the snapshot when a snapshot is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getCredentials}
         * @param credentials Credentials for the administrative user.
         *                    Note - using this prop only works with <code>Credentials.fromPassword()</code> with the
         *                    username of the snapshot, <code>Credentials.fromUsername()</code> with the username and
         *                    password of the snapshot or <code>Credentials.fromSecret()</code> with a secret containing
         *                    the username and password of the snapshot.
         * @return {@code this}
         * @deprecated use `snapshotCredentials` which allows to generate a new password
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder credentials(software.amazon.awscdk.services.rds.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getDefaultDatabaseName}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDatabaseName(java.lang.String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getDeletionProtection}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getIamAuthentication}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthentication(java.lang.Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getInstanceIdentifierBase}
         * @param instanceIdentifierBase Base identifier for instances.
         *                               Every replica is named by appending the replica number to this string, 1-based.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifierBase(java.lang.String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getInstances}
         * @param instances How many replicas/instances to create.
         *                  Has to be at least 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(java.lang.Number instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getInstanceUpdateBehaviour}
         * @param instanceUpdateBehaviour The ordering of updates for instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceUpdateBehaviour(software.amazon.awscdk.services.rds.InstanceUpdateBehaviour instanceUpdateBehaviour) {
            this.instanceUpdateBehaviour = instanceUpdateBehaviour;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(software.amazon.awscdk.Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getMonitoringRole}
         * @param monitoringRole Role that will be used to manage DB instances monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getNetworkType}
         * @param networkType The network type of the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(software.amazon.awscdk.services.rds.NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getParameterGroup}
         * @param parameterGroup Additional parameters to pass to the database engine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getParameters}
         * @param parameters The parameters in the DBClusterParameterGroup to create automatically.
         *                   You can only specify parameterGroup or parameters but not both.
         *                   You need to use a versioned engine to auto-generate a DBClusterParameterGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getPort}
         * @param port What port to listen on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         *                                   Example: 'Sun:23:45-Mon:00:15'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getS3ExportBuckets}
         * @param s3ExportBuckets S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
         *                        This property must not be used if <code>s3ExportRole</code> is used.
         *                        <p>
         *                        For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder s3ExportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getS3ExportRole}
         * @param s3ExportRole Role that will be associated with this DB cluster to enable S3 export.
         *                     This feature is only supported by the Aurora database engine.
         *                     <p>
         *                     This property must not be used if <code>s3ExportBuckets</code> is used.
         *                     <p>
         *                     For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportRole(software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getS3ImportBuckets}
         * @param s3ImportBuckets S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
         *                        This property must not be used if <code>s3ImportRole</code> is used.
         *                        <p>
         *                        For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder s3ImportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getS3ImportRole}
         * @param s3ImportRole Role that will be associated with this DB cluster to enable S3 import.
         *                     This feature is only supported by the Aurora database engine.
         *                     <p>
         *                     This property must not be used if <code>s3ImportBuckets</code> is used.
         *                     <p>
         *                     For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportRole(software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getSnapshotCredentials}
         * @param snapshotCredentials Master user credentials.
         *                            Note - It is not possible to change the master username for a snapshot;
         *                            however, it is possible to provide (or generate) a new password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCredentials(software.amazon.awscdk.services.rds.SnapshotCredentials snapshotCredentials) {
            this.snapshotCredentials = snapshotCredentials;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getStorageEncrypted}
         * @param storageEncrypted Whether to enable storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getStorageEncryptionKey}
         * @param storageEncryptionKey The KMS key for storage encryption.
         *                             If specified, {&#64;link storageEncrypted} will be set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncryptionKey(software.amazon.awscdk.services.kms.IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterFromSnapshotProps#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterFromSnapshotProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseClusterFromSnapshotProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterFromSnapshotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterFromSnapshotProps {
        private final software.amazon.awscdk.services.rds.IClusterEngine engine;
        private final software.amazon.awscdk.services.rds.InstanceProps instanceProps;
        private final java.lang.String snapshotIdentifier;
        private final software.amazon.awscdk.Duration backtrackWindow;
        private final software.amazon.awscdk.services.rds.BackupProps backup;
        private final java.util.List<java.lang.String> cloudwatchLogsExports;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private final java.lang.String clusterIdentifier;
        private final java.lang.Boolean copyTagsToSnapshot;
        private final software.amazon.awscdk.services.rds.Credentials credentials;
        private final java.lang.String defaultDatabaseName;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean iamAuthentication;
        private final java.lang.String instanceIdentifierBase;
        private final java.lang.Number instances;
        private final software.amazon.awscdk.services.rds.InstanceUpdateBehaviour instanceUpdateBehaviour;
        private final software.amazon.awscdk.Duration monitoringInterval;
        private final software.amazon.awscdk.services.iam.IRole monitoringRole;
        private final software.amazon.awscdk.services.rds.NetworkType networkType;
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private final software.amazon.awscdk.services.rds.SnapshotCredentials snapshotCredentials;
        private final java.lang.Boolean storageEncrypted;
        private final software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        private final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
            this.instanceProps = software.amazon.jsii.Kernel.get(this, "instanceProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceProps.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backtrackWindow = software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.backup = software.amazon.jsii.Kernel.get(this, "backup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.BackupProps.class));
            this.cloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cloudwatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.cloudwatchLogsRetentionRole = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class));
            this.defaultDatabaseName = software.amazon.jsii.Kernel.get(this, "defaultDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iamAuthentication = software.amazon.jsii.Kernel.get(this, "iamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifierBase = software.amazon.jsii.Kernel.get(this, "instanceIdentifierBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceUpdateBehaviour = software.amazon.jsii.Kernel.get(this, "instanceUpdateBehaviour", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceUpdateBehaviour.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.monitoringRole = software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.NetworkType.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.s3ExportBuckets = software.amazon.jsii.Kernel.get(this, "s3ExportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ExportRole = software.amazon.jsii.Kernel.get(this, "s3ExportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3ImportBuckets = software.amazon.jsii.Kernel.get(this, "s3ImportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ImportRole = software.amazon.jsii.Kernel.get(this, "s3ImportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.snapshotCredentials = software.amazon.jsii.Kernel.get(this, "snapshotCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.storageEncryptionKey = software.amazon.jsii.Kernel.get(this, "storageEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.instanceProps = java.util.Objects.requireNonNull(builder.instanceProps, "instanceProps is required");
            this.snapshotIdentifier = java.util.Objects.requireNonNull(builder.snapshotIdentifier, "snapshotIdentifier is required");
            this.backtrackWindow = builder.backtrackWindow;
            this.backup = builder.backup;
            this.cloudwatchLogsExports = builder.cloudwatchLogsExports;
            this.cloudwatchLogsRetention = builder.cloudwatchLogsRetention;
            this.cloudwatchLogsRetentionRole = builder.cloudwatchLogsRetentionRole;
            this.clusterIdentifier = builder.clusterIdentifier;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.credentials = builder.credentials;
            this.defaultDatabaseName = builder.defaultDatabaseName;
            this.deletionProtection = builder.deletionProtection;
            this.iamAuthentication = builder.iamAuthentication;
            this.instanceIdentifierBase = builder.instanceIdentifierBase;
            this.instances = builder.instances;
            this.instanceUpdateBehaviour = builder.instanceUpdateBehaviour;
            this.monitoringInterval = builder.monitoringInterval;
            this.monitoringRole = builder.monitoringRole;
            this.networkType = builder.networkType;
            this.parameterGroup = builder.parameterGroup;
            this.parameters = builder.parameters;
            this.port = builder.port;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.removalPolicy = builder.removalPolicy;
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)builder.s3ExportBuckets;
            this.s3ExportRole = builder.s3ExportRole;
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)builder.s3ImportBuckets;
            this.s3ImportRole = builder.s3ImportRole;
            this.snapshotCredentials = builder.snapshotCredentials;
            this.storageEncrypted = builder.storageEncrypted;
            this.storageEncryptionKey = builder.storageEncryptionKey;
            this.subnetGroup = builder.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return this.engine;
        }

        @Override
        public final software.amazon.awscdk.services.rds.InstanceProps getInstanceProps() {
            return this.instanceProps;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final software.amazon.awscdk.Duration getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final software.amazon.awscdk.services.rds.BackupProps getBackup() {
            return this.backup;
        }

        @Override
        public final java.util.List<java.lang.String> getCloudwatchLogsExports() {
            return this.cloudwatchLogsExports;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
            return this.cloudwatchLogsRetention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
            return this.cloudwatchLogsRetentionRole;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final software.amazon.awscdk.services.rds.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.lang.String getDefaultDatabaseName() {
            return this.defaultDatabaseName;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Boolean getIamAuthentication() {
            return this.iamAuthentication;
        }

        @Override
        public final java.lang.String getInstanceIdentifierBase() {
            return this.instanceIdentifierBase;
        }

        @Override
        public final java.lang.Number getInstances() {
            return this.instances;
        }

        @Override
        public final software.amazon.awscdk.services.rds.InstanceUpdateBehaviour getInstanceUpdateBehaviour() {
            return this.instanceUpdateBehaviour;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
            return this.monitoringRole;
        }

        @Override
        public final software.amazon.awscdk.services.rds.NetworkType getNetworkType() {
            return this.networkType;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
            return this.s3ExportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
            return this.s3ExportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
            return this.s3ImportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
            return this.s3ImportRole;
        }

        @Override
        public final software.amazon.awscdk.services.rds.SnapshotCredentials getSnapshotCredentials() {
            return this.snapshotCredentials;
        }

        @Override
        public final java.lang.Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
            return this.storageEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("instanceProps", om.valueToTree(this.getInstanceProps()));
            data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            if (this.getBacktrackWindow() != null) {
                data.set("backtrackWindow", om.valueToTree(this.getBacktrackWindow()));
            }
            if (this.getBackup() != null) {
                data.set("backup", om.valueToTree(this.getBackup()));
            }
            if (this.getCloudwatchLogsExports() != null) {
                data.set("cloudwatchLogsExports", om.valueToTree(this.getCloudwatchLogsExports()));
            }
            if (this.getCloudwatchLogsRetention() != null) {
                data.set("cloudwatchLogsRetention", om.valueToTree(this.getCloudwatchLogsRetention()));
            }
            if (this.getCloudwatchLogsRetentionRole() != null) {
                data.set("cloudwatchLogsRetentionRole", om.valueToTree(this.getCloudwatchLogsRetentionRole()));
            }
            if (this.getClusterIdentifier() != null) {
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getDefaultDatabaseName() != null) {
                data.set("defaultDatabaseName", om.valueToTree(this.getDefaultDatabaseName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getIamAuthentication() != null) {
                data.set("iamAuthentication", om.valueToTree(this.getIamAuthentication()));
            }
            if (this.getInstanceIdentifierBase() != null) {
                data.set("instanceIdentifierBase", om.valueToTree(this.getInstanceIdentifierBase()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getInstanceUpdateBehaviour() != null) {
                data.set("instanceUpdateBehaviour", om.valueToTree(this.getInstanceUpdateBehaviour()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRole() != null) {
                data.set("monitoringRole", om.valueToTree(this.getMonitoringRole()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getS3ExportBuckets() != null) {
                data.set("s3ExportBuckets", om.valueToTree(this.getS3ExportBuckets()));
            }
            if (this.getS3ExportRole() != null) {
                data.set("s3ExportRole", om.valueToTree(this.getS3ExportRole()));
            }
            if (this.getS3ImportBuckets() != null) {
                data.set("s3ImportBuckets", om.valueToTree(this.getS3ImportBuckets()));
            }
            if (this.getS3ImportRole() != null) {
                data.set("s3ImportRole", om.valueToTree(this.getS3ImportRole()));
            }
            if (this.getSnapshotCredentials() != null) {
                data.set("snapshotCredentials", om.valueToTree(this.getSnapshotCredentials()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getStorageEncryptionKey() != null) {
                data.set("storageEncryptionKey", om.valueToTree(this.getStorageEncryptionKey()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseClusterFromSnapshotProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterFromSnapshotProps.Jsii$Proxy that = (DatabaseClusterFromSnapshotProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (!instanceProps.equals(that.instanceProps)) return false;
            if (!snapshotIdentifier.equals(that.snapshotIdentifier)) return false;
            if (this.backtrackWindow != null ? !this.backtrackWindow.equals(that.backtrackWindow) : that.backtrackWindow != null) return false;
            if (this.backup != null ? !this.backup.equals(that.backup) : that.backup != null) return false;
            if (this.cloudwatchLogsExports != null ? !this.cloudwatchLogsExports.equals(that.cloudwatchLogsExports) : that.cloudwatchLogsExports != null) return false;
            if (this.cloudwatchLogsRetention != null ? !this.cloudwatchLogsRetention.equals(that.cloudwatchLogsRetention) : that.cloudwatchLogsRetention != null) return false;
            if (this.cloudwatchLogsRetentionRole != null ? !this.cloudwatchLogsRetentionRole.equals(that.cloudwatchLogsRetentionRole) : that.cloudwatchLogsRetentionRole != null) return false;
            if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.defaultDatabaseName != null ? !this.defaultDatabaseName.equals(that.defaultDatabaseName) : that.defaultDatabaseName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.iamAuthentication != null ? !this.iamAuthentication.equals(that.iamAuthentication) : that.iamAuthentication != null) return false;
            if (this.instanceIdentifierBase != null ? !this.instanceIdentifierBase.equals(that.instanceIdentifierBase) : that.instanceIdentifierBase != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.instanceUpdateBehaviour != null ? !this.instanceUpdateBehaviour.equals(that.instanceUpdateBehaviour) : that.instanceUpdateBehaviour != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRole != null ? !this.monitoringRole.equals(that.monitoringRole) : that.monitoringRole != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.s3ExportBuckets != null ? !this.s3ExportBuckets.equals(that.s3ExportBuckets) : that.s3ExportBuckets != null) return false;
            if (this.s3ExportRole != null ? !this.s3ExportRole.equals(that.s3ExportRole) : that.s3ExportRole != null) return false;
            if (this.s3ImportBuckets != null ? !this.s3ImportBuckets.equals(that.s3ImportBuckets) : that.s3ImportBuckets != null) return false;
            if (this.s3ImportRole != null ? !this.s3ImportRole.equals(that.s3ImportRole) : that.s3ImportRole != null) return false;
            if (this.snapshotCredentials != null ? !this.snapshotCredentials.equals(that.snapshotCredentials) : that.snapshotCredentials != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.storageEncryptionKey != null ? !this.storageEncryptionKey.equals(that.storageEncryptionKey) : that.storageEncryptionKey != null) return false;
            return this.subnetGroup != null ? this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.instanceProps.hashCode());
            result = 31 * result + (this.snapshotIdentifier.hashCode());
            result = 31 * result + (this.backtrackWindow != null ? this.backtrackWindow.hashCode() : 0);
            result = 31 * result + (this.backup != null ? this.backup.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsExports != null ? this.cloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetention != null ? this.cloudwatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetentionRole != null ? this.cloudwatchLogsRetentionRole.hashCode() : 0);
            result = 31 * result + (this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.defaultDatabaseName != null ? this.defaultDatabaseName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.iamAuthentication != null ? this.iamAuthentication.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifierBase != null ? this.instanceIdentifierBase.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.instanceUpdateBehaviour != null ? this.instanceUpdateBehaviour.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRole != null ? this.monitoringRole.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.s3ExportBuckets != null ? this.s3ExportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ExportRole != null ? this.s3ExportRole.hashCode() : 0);
            result = 31 * result + (this.s3ImportBuckets != null ? this.s3ImportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ImportRole != null ? this.s3ImportRole.hashCode() : 0);
            result = 31 * result + (this.snapshotCredentials != null ? this.snapshotCredentials.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.storageEncryptionKey != null ? this.storageEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            return result;
        }
    }
}
