package software.amazon.awscdk.services.quicksight;

/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 * <p>
 * Creates a dashboard from a template. To first create a template, see the <code>CreateTemplate</code> API operation.
 * <p>
 * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different AWS account .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnDashboard cfnDashboard = CfnDashboard.Builder.create(this, "MyCfnDashboard")
 *         .awsAccountId("awsAccountId")
 *         .dashboardId("dashboardId")
 *         .sourceEntity(DashboardSourceEntityProperty.builder()
 *                 .sourceTemplate(DashboardSourceTemplateProperty.builder()
 *                         .arn("arn")
 *                         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .dataSetPlaceholder("dataSetPlaceholder")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .dashboardPublishOptions(DashboardPublishOptionsProperty.builder()
 *                 .adHocFilteringOption(AdHocFilteringOptionProperty.builder()
 *                         .availabilityStatus("availabilityStatus")
 *                         .build())
 *                 .exportToCsvOption(ExportToCSVOptionProperty.builder()
 *                         .availabilityStatus("availabilityStatus")
 *                         .build())
 *                 .sheetControlsOption(SheetControlsOptionProperty.builder()
 *                         .visibilityState("visibilityState")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .parameters(ParametersProperty.builder()
 *                 .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .decimalParameters(List.of(DecimalParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .integerParameters(List.of(IntegerParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .stringParameters(List.of(StringParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .themeArn("themeArn")
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.964Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard")
public class CfnDashboard extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDashboard(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDashboard(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnDashboard.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QuickSight::Dashboard`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnDashboardProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this dashboard version was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the dashboard was last published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastPublishedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastPublishedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the dashboard was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the AWS account where you want to create the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account where you want to create the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * The ID for the dashboard, also added to the IAM policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDashboardId() {
        return software.amazon.jsii.Kernel.get(this, "dashboardId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID for the dashboard, also added to the IAM policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashboardId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dashboardId", java.util.Objects.requireNonNull(value, "dashboardId is required"));
    }

    /**
     * The entity that you are using as a source when you create the dashboard.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceEntity() {
        return software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The entity that you are using as a source when you create the dashboard.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardSourceEntityProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * The entity that you are using as a source when you create the dashboard.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * Options for publishing the dashboard when you create it:.
     * <p>
     * <ul>
     * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
     * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
     * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashboardPublishOptions() {
        return software.amazon.jsii.Kernel.get(this, "dashboardPublishOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options for publishing the dashboard when you create it:.
     * <p>
     * <ul>
     * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
     * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
     * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashboardPublishOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardPublishOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dashboardPublishOptions", value);
    }

    /**
     * Options for publishing the dashboard when you create it:.
     * <p>
     * <ul>
     * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
     * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
     * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashboardPublishOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashboardPublishOptions", value);
    }

    /**
     * The display name of the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name of the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings.
     * <p>
     * A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings.
     * <p>
     * A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDashboard.ParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings.
     * <p>
     * A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A structure that contains the permissions of the dashboard.
     * <p>
     * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
     * <p>
     * To specify no permissions, omit the permissions list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the permissions of the dashboard.
     * <p>
     * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
     * <p>
     * To specify no permissions, omit the permissions list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A structure that contains the permissions of the dashboard.
     * <p>
     * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
     * <p>
     * To specify no permissions, omit the permissions list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDashboard.ResourcePermissionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDashboard.ResourcePermissionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
     * <p>
     * If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
        return software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
     * <p>
     * If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThemeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "themeArn", value);
    }

    /**
     * A description for the first version of the dashboard being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the first version of the dashboard being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }
    /**
     * Ad hoc (one-time) filtering option.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AdHocFilteringOptionProperty adHocFilteringOptionProperty = AdHocFilteringOptionProperty.builder()
     *         .availabilityStatus("availabilityStatus")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.AdHocFilteringOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(AdHocFilteringOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdHocFilteringOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Availability status.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdHocFilteringOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdHocFilteringOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdHocFilteringOptionProperty> {
            java.lang.String availabilityStatus;

            /**
             * Sets the value of {@link AdHocFilteringOptionProperty#getAvailabilityStatus}
             * @param availabilityStatus Availability status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityStatus(java.lang.String availabilityStatus) {
                this.availabilityStatus = availabilityStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdHocFilteringOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdHocFilteringOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdHocFilteringOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdHocFilteringOptionProperty {
            private final java.lang.String availabilityStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityStatus = software.amazon.jsii.Kernel.get(this, "availabilityStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityStatus = builder.availabilityStatus;
            }

            @Override
            public final java.lang.String getAvailabilityStatus() {
                return this.availabilityStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityStatus() != null) {
                    data.set("availabilityStatus", om.valueToTree(this.getAvailabilityStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.AdHocFilteringOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdHocFilteringOptionProperty.Jsii$Proxy that = (AdHocFilteringOptionProperty.Jsii$Proxy) o;

                return this.availabilityStatus != null ? this.availabilityStatus.equals(that.availabilityStatus) : that.availabilityStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityStatus != null ? this.availabilityStatus.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Dashboard publish options.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DashboardPublishOptionsProperty dashboardPublishOptionsProperty = DashboardPublishOptionsProperty.builder()
     *         .adHocFilteringOption(AdHocFilteringOptionProperty.builder()
     *                 .availabilityStatus("availabilityStatus")
     *                 .build())
     *         .exportToCsvOption(ExportToCSVOptionProperty.builder()
     *                 .availabilityStatus("availabilityStatus")
     *                 .build())
     *         .sheetControlsOption(SheetControlsOptionProperty.builder()
     *                 .visibilityState("visibilityState")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardPublishOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DashboardPublishOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashboardPublishOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Ad hoc (one-time) filtering option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdHocFilteringOption() {
            return null;
        }

        /**
         * Export to .csv option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportToCsvOption() {
            return null;
        }

        /**
         * Sheet controls option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheetControlsOption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashboardPublishOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashboardPublishOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashboardPublishOptionsProperty> {
            java.lang.Object adHocFilteringOption;
            java.lang.Object exportToCsvOption;
            java.lang.Object sheetControlsOption;

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getAdHocFilteringOption}
             * @param adHocFilteringOption Ad hoc (one-time) filtering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adHocFilteringOption(software.amazon.awscdk.services.quicksight.CfnDashboard.AdHocFilteringOptionProperty adHocFilteringOption) {
                this.adHocFilteringOption = adHocFilteringOption;
                return this;
            }

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getAdHocFilteringOption}
             * @param adHocFilteringOption Ad hoc (one-time) filtering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adHocFilteringOption(software.amazon.awscdk.IResolvable adHocFilteringOption) {
                this.adHocFilteringOption = adHocFilteringOption;
                return this;
            }

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getExportToCsvOption}
             * @param exportToCsvOption Export to .csv option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportToCsvOption(software.amazon.awscdk.services.quicksight.CfnDashboard.ExportToCSVOptionProperty exportToCsvOption) {
                this.exportToCsvOption = exportToCsvOption;
                return this;
            }

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getExportToCsvOption}
             * @param exportToCsvOption Export to .csv option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportToCsvOption(software.amazon.awscdk.IResolvable exportToCsvOption) {
                this.exportToCsvOption = exportToCsvOption;
                return this;
            }

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getSheetControlsOption}
             * @param sheetControlsOption Sheet controls option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetControlsOption(software.amazon.awscdk.services.quicksight.CfnDashboard.SheetControlsOptionProperty sheetControlsOption) {
                this.sheetControlsOption = sheetControlsOption;
                return this;
            }

            /**
             * Sets the value of {@link DashboardPublishOptionsProperty#getSheetControlsOption}
             * @param sheetControlsOption Sheet controls option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetControlsOption(software.amazon.awscdk.IResolvable sheetControlsOption) {
                this.sheetControlsOption = sheetControlsOption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashboardPublishOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashboardPublishOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashboardPublishOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardPublishOptionsProperty {
            private final java.lang.Object adHocFilteringOption;
            private final java.lang.Object exportToCsvOption;
            private final java.lang.Object sheetControlsOption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adHocFilteringOption = software.amazon.jsii.Kernel.get(this, "adHocFilteringOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportToCsvOption = software.amazon.jsii.Kernel.get(this, "exportToCsvOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheetControlsOption = software.amazon.jsii.Kernel.get(this, "sheetControlsOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adHocFilteringOption = builder.adHocFilteringOption;
                this.exportToCsvOption = builder.exportToCsvOption;
                this.sheetControlsOption = builder.sheetControlsOption;
            }

            @Override
            public final java.lang.Object getAdHocFilteringOption() {
                return this.adHocFilteringOption;
            }

            @Override
            public final java.lang.Object getExportToCsvOption() {
                return this.exportToCsvOption;
            }

            @Override
            public final java.lang.Object getSheetControlsOption() {
                return this.sheetControlsOption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdHocFilteringOption() != null) {
                    data.set("adHocFilteringOption", om.valueToTree(this.getAdHocFilteringOption()));
                }
                if (this.getExportToCsvOption() != null) {
                    data.set("exportToCsvOption", om.valueToTree(this.getExportToCsvOption()));
                }
                if (this.getSheetControlsOption() != null) {
                    data.set("sheetControlsOption", om.valueToTree(this.getSheetControlsOption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardPublishOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashboardPublishOptionsProperty.Jsii$Proxy that = (DashboardPublishOptionsProperty.Jsii$Proxy) o;

                if (this.adHocFilteringOption != null ? !this.adHocFilteringOption.equals(that.adHocFilteringOption) : that.adHocFilteringOption != null) return false;
                if (this.exportToCsvOption != null ? !this.exportToCsvOption.equals(that.exportToCsvOption) : that.exportToCsvOption != null) return false;
                return this.sheetControlsOption != null ? this.sheetControlsOption.equals(that.sheetControlsOption) : that.sheetControlsOption == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adHocFilteringOption != null ? this.adHocFilteringOption.hashCode() : 0;
                result = 31 * result + (this.exportToCsvOption != null ? this.exportToCsvOption.hashCode() : 0);
                result = 31 * result + (this.sheetControlsOption != null ? this.sheetControlsOption.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Dashboard source entity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DashboardSourceEntityProperty dashboardSourceEntityProperty = DashboardSourceEntityProperty.builder()
     *         .sourceTemplate(DashboardSourceTemplateProperty.builder()
     *                 .arn("arn")
     *                 .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                         .dataSetArn("dataSetArn")
     *                         .dataSetPlaceholder("dataSetPlaceholder")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardSourceEntityProperty")
    @software.amazon.jsii.Jsii.Proxy(DashboardSourceEntityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashboardSourceEntityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Source template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashboardSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashboardSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashboardSourceEntityProperty> {
            java.lang.Object sourceTemplate;

            /**
             * Sets the value of {@link DashboardSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate Source template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardSourceTemplateProperty sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Sets the value of {@link DashboardSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate Source template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.IResolvable sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashboardSourceEntityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashboardSourceEntityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashboardSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardSourceEntityProperty {
            private final java.lang.Object sourceTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceTemplate = software.amazon.jsii.Kernel.get(this, "sourceTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceTemplate = builder.sourceTemplate;
            }

            @Override
            public final java.lang.Object getSourceTemplate() {
                return this.sourceTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceTemplate() != null) {
                    data.set("sourceTemplate", om.valueToTree(this.getSourceTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardSourceEntityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashboardSourceEntityProperty.Jsii$Proxy that = (DashboardSourceEntityProperty.Jsii$Proxy) o;

                return this.sourceTemplate != null ? this.sourceTemplate.equals(that.sourceTemplate) : that.sourceTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceTemplate != null ? this.sourceTemplate.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Dashboard source template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DashboardSourceTemplateProperty dashboardSourceTemplateProperty = DashboardSourceTemplateProperty.builder()
     *         .arn("arn")
     *         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .dataSetPlaceholder("dataSetPlaceholder")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardSourceTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(DashboardSourceTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashboardSourceTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * Dataset references.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSetReferences();

        /**
         * @return a {@link Builder} of {@link DashboardSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashboardSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashboardSourceTemplateProperty> {
            java.lang.String arn;
            java.lang.Object dataSetReferences;

            /**
             * Sets the value of {@link DashboardSourceTemplateProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link DashboardSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences Dataset references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(software.amazon.awscdk.IResolvable dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Sets the value of {@link DashboardSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences Dataset references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(java.util.List<? extends java.lang.Object> dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashboardSourceTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashboardSourceTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashboardSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardSourceTemplateProperty {
            private final java.lang.String arn;
            private final java.lang.Object dataSetReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetReferences = software.amazon.jsii.Kernel.get(this, "dataSetReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.dataSetReferences = java.util.Objects.requireNonNull(builder.dataSetReferences, "dataSetReferences is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getDataSetReferences() {
                return this.dataSetReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("dataSetReferences", om.valueToTree(this.getDataSetReferences()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DashboardSourceTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashboardSourceTemplateProperty.Jsii$Proxy that = (DashboardSourceTemplateProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.dataSetReferences.equals(that.dataSetReferences);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.dataSetReferences.hashCode());
                return result;
            }
        }
    }
    /**
     * Dataset reference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetReferenceProperty dataSetReferenceProperty = DataSetReferenceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .dataSetPlaceholder("dataSetPlaceholder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DataSetReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Dataset Amazon Resource Name (ARN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetArn();

        /**
         * Dataset placeholder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetPlaceholder();

        /**
         * @return a {@link Builder} of {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetReferenceProperty> {
            java.lang.String dataSetArn;
            java.lang.String dataSetPlaceholder;

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetArn}
             * @param dataSetArn Dataset Amazon Resource Name (ARN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetPlaceholder}
             * @param dataSetPlaceholder Dataset placeholder. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetPlaceholder(java.lang.String dataSetPlaceholder) {
                this.dataSetPlaceholder = dataSetPlaceholder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetReferenceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.String dataSetPlaceholder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetPlaceholder = software.amazon.jsii.Kernel.get(this, "dataSetPlaceholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = java.util.Objects.requireNonNull(builder.dataSetArn, "dataSetArn is required");
                this.dataSetPlaceholder = java.util.Objects.requireNonNull(builder.dataSetPlaceholder, "dataSetPlaceholder is required");
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.String getDataSetPlaceholder() {
                return this.dataSetPlaceholder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                data.set("dataSetPlaceholder", om.valueToTree(this.getDataSetPlaceholder()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DataSetReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetReferenceProperty.Jsii$Proxy that = (DataSetReferenceProperty.Jsii$Proxy) o;

                if (!dataSetArn.equals(that.dataSetArn)) return false;
                return this.dataSetPlaceholder.equals(that.dataSetPlaceholder);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn.hashCode();
                result = 31 * result + (this.dataSetPlaceholder.hashCode());
                return result;
            }
        }
    }
    /**
     * A date-time parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeParameterProperty dateTimeParameterProperty = DateTimeParameterProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DateTimeParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the date-time parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the date-time parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeParameterProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link DateTimeParameterProperty#getName}
             * @param name A display name for the date-time parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeParameterProperty#getValues}
             * @param values The values for the date-time parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeParameterProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DateTimeParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeParameterProperty.Jsii$Proxy that = (DateTimeParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * A decimal parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalParameterProperty decimalParameterProperty = DecimalParameterProperty.builder()
     *         .name("name")
     *         .values(List.of(123))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.DecimalParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the decimal parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the decimal parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalParameterProperty> {
            java.lang.String name;
            java.lang.Object values;

            /**
             * Sets the value of {@link DecimalParameterProperty#getName}
             * @param name A display name for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DecimalParameterProperty#getValues}
             * @param values The values for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link DecimalParameterProperty#getValues}
             * @param values The values for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Number> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.DecimalParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalParameterProperty.Jsii$Proxy that = (DecimalParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Export to .csv option.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ExportToCSVOptionProperty exportToCSVOptionProperty = ExportToCSVOptionProperty.builder()
     *         .availabilityStatus("availabilityStatus")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.ExportToCSVOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExportToCSVOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExportToCSVOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Availability status.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExportToCSVOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExportToCSVOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExportToCSVOptionProperty> {
            java.lang.String availabilityStatus;

            /**
             * Sets the value of {@link ExportToCSVOptionProperty#getAvailabilityStatus}
             * @param availabilityStatus Availability status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityStatus(java.lang.String availabilityStatus) {
                this.availabilityStatus = availabilityStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExportToCSVOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExportToCSVOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExportToCSVOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExportToCSVOptionProperty {
            private final java.lang.String availabilityStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityStatus = software.amazon.jsii.Kernel.get(this, "availabilityStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityStatus = builder.availabilityStatus;
            }

            @Override
            public final java.lang.String getAvailabilityStatus() {
                return this.availabilityStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityStatus() != null) {
                    data.set("availabilityStatus", om.valueToTree(this.getAvailabilityStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.ExportToCSVOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExportToCSVOptionProperty.Jsii$Proxy that = (ExportToCSVOptionProperty.Jsii$Proxy) o;

                return this.availabilityStatus != null ? this.availabilityStatus.equals(that.availabilityStatus) : that.availabilityStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityStatus != null ? this.availabilityStatus.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An integer parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerParameterProperty integerParameterProperty = IntegerParameterProperty.builder()
     *         .name("name")
     *         .values(List.of(123))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.IntegerParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the integer parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the integer parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerParameterProperty> {
            java.lang.String name;
            java.lang.Object values;

            /**
             * Sets the value of {@link IntegerParameterProperty#getName}
             * @param name The name of the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntegerParameterProperty#getValues}
             * @param values The values for the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link IntegerParameterProperty#getValues}
             * @param values The values for the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Number> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.IntegerParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerParameterProperty.Jsii$Proxy that = (IntegerParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of Amazon QuickSight parameters and the list's override values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ParametersProperty parametersProperty = ParametersProperty.builder()
     *         .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .decimalParameters(List.of(DecimalParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of(123))
     *                 .build()))
     *         .integerParameters(List.of(IntegerParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of(123))
     *                 .build()))
     *         .stringParameters(List.of(StringParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters that have a data type of date-time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of decimal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of integer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersProperty> {
            java.lang.Object dateTimeParameters;
            java.lang.Object decimalParameters;
            java.lang.Object integerParameters;
            java.lang.Object stringParameters;

            /**
             * Sets the value of {@link ParametersProperty#getDateTimeParameters}
             * @param dateTimeParameters The parameters that have a data type of date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeParameters(software.amazon.awscdk.IResolvable dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDateTimeParameters}
             * @param dateTimeParameters The parameters that have a data type of date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeParameters(java.util.List<? extends java.lang.Object> dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDecimalParameters}
             * @param decimalParameters The parameters that have a data type of decimal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalParameters(software.amazon.awscdk.IResolvable decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDecimalParameters}
             * @param decimalParameters The parameters that have a data type of decimal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalParameters(java.util.List<? extends java.lang.Object> decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getIntegerParameters}
             * @param integerParameters The parameters that have a data type of integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerParameters(software.amazon.awscdk.IResolvable integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getIntegerParameters}
             * @param integerParameters The parameters that have a data type of integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerParameters(java.util.List<? extends java.lang.Object> integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getStringParameters}
             * @param stringParameters The parameters that have a data type of string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringParameters(software.amazon.awscdk.IResolvable stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getStringParameters}
             * @param stringParameters The parameters that have a data type of string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringParameters(java.util.List<? extends java.lang.Object> stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersProperty {
            private final java.lang.Object dateTimeParameters;
            private final java.lang.Object decimalParameters;
            private final java.lang.Object integerParameters;
            private final java.lang.Object stringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeParameters = software.amazon.jsii.Kernel.get(this, "dateTimeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decimalParameters = software.amazon.jsii.Kernel.get(this, "decimalParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerParameters = software.amazon.jsii.Kernel.get(this, "integerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringParameters = software.amazon.jsii.Kernel.get(this, "stringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeParameters = builder.dateTimeParameters;
                this.decimalParameters = builder.decimalParameters;
                this.integerParameters = builder.integerParameters;
                this.stringParameters = builder.stringParameters;
            }

            @Override
            public final java.lang.Object getDateTimeParameters() {
                return this.dateTimeParameters;
            }

            @Override
            public final java.lang.Object getDecimalParameters() {
                return this.decimalParameters;
            }

            @Override
            public final java.lang.Object getIntegerParameters() {
                return this.integerParameters;
            }

            @Override
            public final java.lang.Object getStringParameters() {
                return this.stringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeParameters() != null) {
                    data.set("dateTimeParameters", om.valueToTree(this.getDateTimeParameters()));
                }
                if (this.getDecimalParameters() != null) {
                    data.set("decimalParameters", om.valueToTree(this.getDecimalParameters()));
                }
                if (this.getIntegerParameters() != null) {
                    data.set("integerParameters", om.valueToTree(this.getIntegerParameters()));
                }
                if (this.getStringParameters() != null) {
                    data.set("stringParameters", om.valueToTree(this.getStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersProperty.Jsii$Proxy that = (ParametersProperty.Jsii$Proxy) o;

                if (this.dateTimeParameters != null ? !this.dateTimeParameters.equals(that.dateTimeParameters) : that.dateTimeParameters != null) return false;
                if (this.decimalParameters != null ? !this.decimalParameters.equals(that.decimalParameters) : that.decimalParameters != null) return false;
                if (this.integerParameters != null ? !this.integerParameters.equals(that.integerParameters) : that.integerParameters != null) return false;
                return this.stringParameters != null ? this.stringParameters.equals(that.stringParameters) : that.stringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeParameters != null ? this.dateTimeParameters.hashCode() : 0;
                result = 31 * result + (this.decimalParameters != null ? this.decimalParameters.hashCode() : 0);
                result = 31 * result + (this.integerParameters != null ? this.integerParameters.hashCode() : 0);
                result = 31 * result + (this.stringParameters != null ? this.stringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permissions on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permissions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * Sheet controls option.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SheetControlsOptionProperty sheetControlsOptionProperty = SheetControlsOptionProperty.builder()
     *         .visibilityState("visibilityState")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.SheetControlsOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(SheetControlsOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SheetControlsOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Visibility state.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVisibilityState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SheetControlsOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SheetControlsOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SheetControlsOptionProperty> {
            java.lang.String visibilityState;

            /**
             * Sets the value of {@link SheetControlsOptionProperty#getVisibilityState}
             * @param visibilityState Visibility state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visibilityState(java.lang.String visibilityState) {
                this.visibilityState = visibilityState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SheetControlsOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SheetControlsOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SheetControlsOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SheetControlsOptionProperty {
            private final java.lang.String visibilityState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.visibilityState = software.amazon.jsii.Kernel.get(this, "visibilityState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.visibilityState = builder.visibilityState;
            }

            @Override
            public final java.lang.String getVisibilityState() {
                return this.visibilityState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVisibilityState() != null) {
                    data.set("visibilityState", om.valueToTree(this.getVisibilityState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.SheetControlsOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SheetControlsOptionProperty.Jsii$Proxy that = (SheetControlsOptionProperty.Jsii$Proxy) o;

                return this.visibilityState != null ? this.visibilityState.equals(that.visibilityState) : that.visibilityState == null;
            }

            @Override
            public final int hashCode() {
                int result = this.visibilityState != null ? this.visibilityState.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A string parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * StringParameterProperty stringParameterProperty = StringParameterProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboard.StringParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for a string parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values of a string parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringParameterProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link StringParameterProperty#getName}
             * @param name A display name for a string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StringParameterProperty#getValues}
             * @param values The values of a string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringParameterProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboard.StringParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringParameterProperty.Jsii$Proxy that = (StringParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnDashboard}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnDashboard> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnDashboardProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnDashboardProps.Builder();
        }

        /**
         * The ID of the AWS account where you want to create the dashboard.
         * <p>
         * @return {@code this}
         * @param awsAccountId The ID of the AWS account where you want to create the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * The ID for the dashboard, also added to the IAM policy.
         * <p>
         * @return {@code this}
         * @param dashboardId The ID for the dashboard, also added to the IAM policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardId(final java.lang.String dashboardId) {
            this.props.dashboardId(dashboardId);
            return this;
        }

        /**
         * The entity that you are using as a source when you create the dashboard.
         * <p>
         * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * <p>
         * @return {@code this}
         * @param sourceEntity The entity that you are using as a source when you create the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardSourceEntityProperty sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }
        /**
         * The entity that you are using as a source when you create the dashboard.
         * <p>
         * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * <p>
         * @return {@code this}
         * @param sourceEntity The entity that you are using as a source when you create the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.IResolvable sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }

        /**
         * Options for publishing the dashboard when you create it:.
         * <p>
         * <ul>
         * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
         * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
         * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param dashboardPublishOptions Options for publishing the dashboard when you create it:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardPublishOptions(final software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardPublishOptionsProperty dashboardPublishOptions) {
            this.props.dashboardPublishOptions(dashboardPublishOptions);
            return this;
        }
        /**
         * Options for publishing the dashboard when you create it:.
         * <p>
         * <ul>
         * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
         * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
         * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param dashboardPublishOptions Options for publishing the dashboard when you create it:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardPublishOptions(final software.amazon.awscdk.IResolvable dashboardPublishOptions) {
            this.props.dashboardPublishOptions(dashboardPublishOptions);
            return this;
        }

        /**
         * The display name of the dashboard.
         * <p>
         * @return {@code this}
         * @param name The display name of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The parameters for the creation of the dashboard, which you want to use to override the default settings.
         * <p>
         * A dashboard can have any type of parameters, and some parameters might accept multiple values.
         * <p>
         * @return {@code this}
         * @param parameters The parameters for the creation of the dashboard, which you want to use to override the default settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.services.quicksight.CfnDashboard.ParametersProperty parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * The parameters for the creation of the dashboard, which you want to use to override the default settings.
         * <p>
         * A dashboard can have any type of parameters, and some parameters might accept multiple values.
         * <p>
         * @return {@code this}
         * @param parameters The parameters for the creation of the dashboard, which you want to use to override the default settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A structure that contains the permissions of the dashboard.
         * <p>
         * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
         * <p>
         * To specify no permissions, omit the permissions list.
         * <p>
         * @return {@code this}
         * @param permissions A structure that contains the permissions of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }
        /**
         * A structure that contains the permissions of the dashboard.
         * <p>
         * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
         * <p>
         * To specify no permissions, omit the permissions list.
         * <p>
         * @return {@code this}
         * @param permissions A structure that contains the permissions of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * <p>
         * @return {@code this}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
         * <p>
         * If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.
         * <p>
         * @return {@code this}
         * @param themeArn The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeArn(final java.lang.String themeArn) {
            this.props.themeArn(themeArn);
            return this;
        }

        /**
         * A description for the first version of the dashboard being created.
         * <p>
         * @return {@code this}
         * @param versionDescription A description for the first version of the dashboard being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props.versionDescription(versionDescription);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnDashboard}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnDashboard build() {
            return new software.amazon.awscdk.services.quicksight.CfnDashboard(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
