package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a `CfnAnalysis`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnAnalysisProps cfnAnalysisProps = CfnAnalysisProps.builder()
 *         .analysisId("analysisId")
 *         .awsAccountId("awsAccountId")
 *         .sourceEntity(AnalysisSourceEntityProperty.builder()
 *                 .sourceTemplate(AnalysisSourceTemplateProperty.builder()
 *                         .arn("arn")
 *                         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .dataSetPlaceholder("dataSetPlaceholder")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .errors(List.of(AnalysisErrorProperty.builder()
 *                 .message("message")
 *                 .type("type")
 *                 .build()))
 *         .name("name")
 *         .parameters(ParametersProperty.builder()
 *                 .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .decimalParameters(List.of(DecimalParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .integerParameters(List.of(IntegerParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .stringParameters(List.of(StringParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .themeArn("themeArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysisProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnalysisProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnalysisProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID for the analysis that you're creating.
     * <p>
     * This ID displays in the URL of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnalysisId();

    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * A source entity to use for the analysis that you're creating.
     * <p>
     * This metadata structure contains details that describe a source template and one or more datasets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceEntity();

    /**
     * `AWS::QuickSight::Analysis.Errors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getErrors() {
        return null;
    }

    /**
     * A descriptive name for the analysis that you're creating.
     * <p>
     * This name displays for the analysis in the Amazon QuickSight console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The parameter names and override values that you want to use.
     * <p>
     * An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     * <p>
     * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     * <p>
     * To specify no permissions, omit <code>Permissions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return null;
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     * <p>
     * To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnalysisProps> {
        java.lang.String analysisId;
        java.lang.String awsAccountId;
        java.lang.Object sourceEntity;
        java.lang.Object errors;
        java.lang.String name;
        java.lang.Object parameters;
        java.lang.Object permissions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String themeArn;

        /**
         * Sets the value of {@link CfnAnalysisProps#getAnalysisId}
         * @param analysisId The ID for the analysis that you're creating. This parameter is required.
         *                   This ID displays in the URL of the analysis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisId(java.lang.String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getAwsAccountId}
         * @param awsAccountId The ID of the AWS account where you are creating an analysis. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getSourceEntity}
         * @param sourceEntity A source entity to use for the analysis that you're creating. This parameter is required.
         *                     This metadata structure contains details that describe a source template and one or more datasets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceEntityProperty sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getSourceEntity}
         * @param sourceEntity A source entity to use for the analysis that you're creating. This parameter is required.
         *                     This metadata structure contains details that describe a source template and one or more datasets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(software.amazon.awscdk.IResolvable sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getErrors}
         * @param errors `AWS::QuickSight::Analysis.Errors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(software.amazon.awscdk.IResolvable errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getErrors}
         * @param errors `AWS::QuickSight::Analysis.Errors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(java.util.List<? extends java.lang.Object> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getName}
         * @param name A descriptive name for the analysis that you're creating.
         *             This name displays for the analysis in the Amazon QuickSight console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getParameters}
         * @param parameters The parameter names and override values that you want to use.
         *                   An analysis can have any parameter type, and some parameters might accept multiple values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.services.quicksight.CfnAnalysis.ParametersProperty parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getParameters}
         * @param parameters The parameter names and override values that you want to use.
         *                   An analysis can have any parameter type, and some parameters might accept multiple values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getPermissions}
         * @param permissions A structure that describes the principals and the resource-level permissions on an analysis.
         *                    You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
         *                    <p>
         *                    To specify no permissions, omit <code>Permissions</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(software.amazon.awscdk.IResolvable permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getPermissions}
         * @param permissions A structure that describes the principals and the resource-level permissions on an analysis.
         *                    You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
         *                    <p>
         *                    To specify no permissions, omit <code>Permissions</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<? extends java.lang.Object> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getTags}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalysisProps#getThemeArn}
         * @param themeArn The ARN for the theme to apply to the analysis that you're creating.
         *                 To see the theme in the Amazon QuickSight console, make sure that you have access to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeArn(java.lang.String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnalysisProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnalysisProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnalysisProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnalysisProps {
        private final java.lang.String analysisId;
        private final java.lang.String awsAccountId;
        private final java.lang.Object sourceEntity;
        private final java.lang.Object errors;
        private final java.lang.String name;
        private final java.lang.Object parameters;
        private final java.lang.Object permissions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String themeArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analysisId = software.amazon.jsii.Kernel.get(this, "analysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceEntity = software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.themeArn = software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analysisId = java.util.Objects.requireNonNull(builder.analysisId, "analysisId is required");
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.sourceEntity = java.util.Objects.requireNonNull(builder.sourceEntity, "sourceEntity is required");
            this.errors = builder.errors;
            this.name = builder.name;
            this.parameters = builder.parameters;
            this.permissions = builder.permissions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.themeArn = builder.themeArn;
        }

        @Override
        public final java.lang.String getAnalysisId() {
            return this.analysisId;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.Object getSourceEntity() {
            return this.sourceEntity;
        }

        @Override
        public final java.lang.Object getErrors() {
            return this.errors;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Object getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThemeArn() {
            return this.themeArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("analysisId", om.valueToTree(this.getAnalysisId()));
            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("sourceEntity", om.valueToTree(this.getSourceEntity()));
            if (this.getErrors() != null) {
                data.set("errors", om.valueToTree(this.getErrors()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThemeArn() != null) {
                data.set("themeArn", om.valueToTree(this.getThemeArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysisProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnalysisProps.Jsii$Proxy that = (CfnAnalysisProps.Jsii$Proxy) o;

            if (!analysisId.equals(that.analysisId)) return false;
            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!sourceEntity.equals(that.sourceEntity)) return false;
            if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.themeArn != null ? this.themeArn.equals(that.themeArn) : that.themeArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.analysisId.hashCode();
            result = 31 * result + (this.awsAccountId.hashCode());
            result = 31 * result + (this.sourceEntity.hashCode());
            result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.themeArn != null ? this.themeArn.hashCode() : 0);
            return result;
        }
    }
}
