package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a `CfnConnectAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectAttachmentProps cfnConnectAttachmentProps = CfnConnectAttachmentProps.builder()
 *         .coreNetworkId("coreNetworkId")
 *         .edgeLocation("edgeLocation")
 *         .options(ConnectAttachmentOptionsProperty.builder()
 *                 .protocol("protocol")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transportAttachmentId("transportAttachmentId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.720Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkId() {
        return null;
    }

    /**
     * The Region where the edge is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEdgeLocation() {
        return null;
    }

    /**
     * Options for creating a Connect attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * The tags associated with the Connect attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the attachment between the two connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransportAttachmentId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectAttachmentProps> {
        java.lang.String coreNetworkId;
        java.lang.String edgeLocation;
        java.lang.Object options;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String transportAttachmentId;

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getCoreNetworkId}
         * @param coreNetworkId The core network ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getEdgeLocation}
         * @param edgeLocation The Region where the edge is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edgeLocation(java.lang.String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getOptions}
         * @param options Options for creating a Connect attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.networkmanager.CfnConnectAttachment.ConnectAttachmentOptionsProperty options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getOptions}
         * @param options Options for creating a Connect attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.IResolvable options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getTags}
         * @param tags The tags associated with the Connect attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectAttachmentProps#getTransportAttachmentId}
         * @param transportAttachmentId The ID of the attachment between the two connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportAttachmentId(java.lang.String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectAttachmentProps {
        private final java.lang.String coreNetworkId;
        private final java.lang.String edgeLocation;
        private final java.lang.Object options;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String transportAttachmentId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.edgeLocation = software.amazon.jsii.Kernel.get(this, "edgeLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transportAttachmentId = software.amazon.jsii.Kernel.get(this, "transportAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkId = builder.coreNetworkId;
            this.edgeLocation = builder.edgeLocation;
            this.options = builder.options;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transportAttachmentId = builder.transportAttachmentId;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        public final java.lang.String getEdgeLocation() {
            return this.edgeLocation;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTransportAttachmentId() {
            return this.transportAttachmentId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCoreNetworkId() != null) {
                data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));
            }
            if (this.getEdgeLocation() != null) {
                data.set("edgeLocation", om.valueToTree(this.getEdgeLocation()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransportAttachmentId() != null) {
                data.set("transportAttachmentId", om.valueToTree(this.getTransportAttachmentId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnConnectAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectAttachmentProps.Jsii$Proxy that = (CfnConnectAttachmentProps.Jsii$Proxy) o;

            if (this.coreNetworkId != null ? !this.coreNetworkId.equals(that.coreNetworkId) : that.coreNetworkId != null) return false;
            if (this.edgeLocation != null ? !this.edgeLocation.equals(that.edgeLocation) : that.edgeLocation != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.transportAttachmentId != null ? this.transportAttachmentId.equals(that.transportAttachmentId) : that.transportAttachmentId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkId != null ? this.coreNetworkId.hashCode() : 0;
            result = 31 * result + (this.edgeLocation != null ? this.edgeLocation.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transportAttachmentId != null ? this.transportAttachmentId.hashCode() : 0);
            return result;
        }
    }
}
