package software.amazon.awscdk.services.lightsail;

/**
 * A CloudFormation `AWS::Lightsail::Container`.
 * <p>
 * The <code>AWS::Lightsail::Container</code> resource specifies a container service.
 * <p>
 * A Lightsail container service is a compute resource to which you can deploy containers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnContainer cfnContainer = CfnContainer.Builder.create(this, "MyCfnContainer")
 *         .power("power")
 *         .scale(123)
 *         .serviceName("serviceName")
 *         // the properties below are optional
 *         .containerServiceDeployment(ContainerServiceDeploymentProperty.builder()
 *                 .containers(List.of(ContainerProperty.builder()
 *                         .command(List.of("command"))
 *                         .containerName("containerName")
 *                         .environment(List.of(EnvironmentVariableProperty.builder()
 *                                 .value("value")
 *                                 .variable("variable")
 *                                 .build()))
 *                         .image("image")
 *                         .ports(List.of(PortInfoProperty.builder()
 *                                 .port("port")
 *                                 .protocol("protocol")
 *                                 .build()))
 *                         .build()))
 *                 .publicEndpoint(PublicEndpointProperty.builder()
 *                         .containerName("containerName")
 *                         .containerPort(123)
 *                         .healthCheckConfig(HealthCheckConfigProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalSeconds(123)
 *                                 .path("path")
 *                                 .successCodes("successCodes")
 *                                 .timeoutSeconds(123)
 *                                 .unhealthyThreshold(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .isDisabled(false)
 *         .publicDomainNames(List.of(PublicDomainNameProperty.builder()
 *                 .certificateName("certificateName")
 *                 .domainNames(List.of("domainNames"))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.282Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer")
public class CfnContainer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnContainer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnContainer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lightsail::Container`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnContainerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrContainerArn() {
        return software.amazon.jsii.Kernel.get(this, "attrContainerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The publicly accessible URL of the container service.
     * <p>
     * If no public endpoint is specified in the current deployment, this URL returns a 404 response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The power specification of the container service.
     * <p>
     * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPower() {
        return software.amazon.jsii.Kernel.get(this, "power", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The power specification of the container service.
     * <p>
     * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPower(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "power", java.util.Objects.requireNonNull(value, "power is required"));
    }

    /**
     * The scale specification of the container service.
     * <p>
     * The scale specifies the allocated compute nodes of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getScale() {
        return software.amazon.jsii.Kernel.get(this, "scale", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The scale specification of the container service.
     * <p>
     * The scale specifies the allocated compute nodes of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScale(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scale", java.util.Objects.requireNonNull(value, "scale is required"));
    }

    /**
     * The name of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", java.util.Objects.requireNonNull(value, "serviceName is required"));
    }

    /**
     * An object that describes the current container deployment of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerServiceDeployment() {
        return software.amazon.jsii.Kernel.get(this, "containerServiceDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that describes the current container deployment of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerServiceDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lightsail.CfnContainer.ContainerServiceDeploymentProperty value) {
        software.amazon.jsii.Kernel.set(this, "containerServiceDeployment", value);
    }

    /**
     * An object that describes the current container deployment of the container service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerServiceDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerServiceDeployment", value);
    }

    /**
     * A Boolean value indicating whether the container service is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsDisabled() {
        return software.amazon.jsii.Kernel.get(this, "isDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether the container service is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsDisabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isDisabled", value);
    }

    /**
     * A Boolean value indicating whether the container service is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsDisabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isDisabled", value);
    }

    /**
     * The public domain name of the container service, such as `example.com` and `www.example.com` .
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * <p>
     * <blockquote>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicDomainNames() {
        return software.amazon.jsii.Kernel.get(this, "publicDomainNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The public domain name of the container service, such as `example.com` and `www.example.com` .
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * <p>
     * <blockquote>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicDomainNames(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publicDomainNames", value);
    }

    /**
     * The public domain name of the container service, such as `example.com` and `www.example.com` .
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * <p>
     * <blockquote>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicDomainNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.lightsail.CfnContainer.PublicDomainNameProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.lightsail.CfnContainer.PublicDomainNameProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "publicDomainNames", value);
    }
    /**
     * `Container` is a property of the [ContainerServiceDeployment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-container-containerservicedeployment.html) property. It describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * ContainerProperty containerProperty = ContainerProperty.builder()
     *         .command(List.of("command"))
     *         .containerName("containerName")
     *         .environment(List.of(EnvironmentVariableProperty.builder()
     *                 .value("value")
     *                 .variable("variable")
     *                 .build()))
     *         .image("image")
     *         .ports(List.of(PortInfoProperty.builder()
     *                 .port("port")
     *                 .protocol("protocol")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.ContainerProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch command for the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The name of the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The environment variables of the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The name of the image used for the container.
         * <p>
         * Container images that are sourced from (registered and stored on) your container service start with a colon ( <code>:</code> ). For example, if your container service name is <code>container-service-1</code> , the container image label is <code>mystaticsite</code> , and you want to use the third version ( <code>3</code> ) of the registered container image, then you should specify <code>:container-service-1.mystaticsite.3</code> . To use the latest version of a container image, specify <code>latest</code> instead of a version number (for example, <code>:container-service-1.mystaticsite.latest</code> ). Your container service will automatically use the highest numbered version of the registered container image.
         * <p>
         * Container images that are sourced from a public registry like Docker Hub don’t start with a colon. For example, <code>nginx:latest</code> or <code>nginx</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImage() {
            return null;
        }

        /**
         * An object that describes the open firewall ports and protocols of the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPorts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerProperty> {
            java.util.List<java.lang.String> command;
            java.lang.String containerName;
            java.lang.Object environment;
            java.lang.String image;
            java.lang.Object ports;

            /**
             * Sets the value of {@link ContainerProperty#getCommand}
             * @param command The launch command for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getContainerName}
             * @param containerName The name of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getEnvironment}
             * @param environment The environment variables of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getEnvironment}
             * @param environment The environment variables of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getImage}
             * @param image The name of the image used for the container.
             *              Container images that are sourced from (registered and stored on) your container service start with a colon ( <code>:</code> ). For example, if your container service name is <code>container-service-1</code> , the container image label is <code>mystaticsite</code> , and you want to use the third version ( <code>3</code> ) of the registered container image, then you should specify <code>:container-service-1.mystaticsite.3</code> . To use the latest version of a container image, specify <code>latest</code> instead of a version number (for example, <code>:container-service-1.mystaticsite.latest</code> ). Your container service will automatically use the highest numbered version of the registered container image.
             *              <p>
             *              Container images that are sourced from a public registry like Docker Hub don’t start with a colon. For example, <code>nginx:latest</code> or <code>nginx</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getPorts}
             * @param ports An object that describes the open firewall ports and protocols of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(software.amazon.awscdk.IResolvable ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link ContainerProperty#getPorts}
             * @param ports An object that describes the open firewall ports and protocols of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(java.util.List<? extends java.lang.Object> ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.String containerName;
            private final java.lang.Object environment;
            private final java.lang.String image;
            private final java.lang.Object ports;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.containerName = builder.containerName;
                this.environment = builder.environment;
                this.image = builder.image;
                this.ports = builder.ports;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.Object getPorts() {
                return this.ports;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getImage() != null) {
                    data.set("image", om.valueToTree(this.getImage()));
                }
                if (this.getPorts() != null) {
                    data.set("ports", om.valueToTree(this.getPorts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.ContainerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerProperty.Jsii$Proxy that = (ContainerProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
                return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
                result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ContainerServiceDeployment` is a property of the [AWS::Lightsail::Container](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html) resource. It describes a container deployment configuration of a container service.
     * <p>
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * ContainerServiceDeploymentProperty containerServiceDeploymentProperty = ContainerServiceDeploymentProperty.builder()
     *         .containers(List.of(ContainerProperty.builder()
     *                 .command(List.of("command"))
     *                 .containerName("containerName")
     *                 .environment(List.of(EnvironmentVariableProperty.builder()
     *                         .value("value")
     *                         .variable("variable")
     *                         .build()))
     *                 .image("image")
     *                 .ports(List.of(PortInfoProperty.builder()
     *                         .port("port")
     *                         .protocol("protocol")
     *                         .build()))
     *                 .build()))
     *         .publicEndpoint(PublicEndpointProperty.builder()
     *                 .containerName("containerName")
     *                 .containerPort(123)
     *                 .healthCheckConfig(HealthCheckConfigProperty.builder()
     *                         .healthyThreshold(123)
     *                         .intervalSeconds(123)
     *                         .path("path")
     *                         .successCodes("successCodes")
     *                         .timeoutSeconds(123)
     *                         .unhealthyThreshold(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.ContainerServiceDeploymentProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerServiceDeploymentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerServiceDeploymentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that describes the configuration for the containers of the deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * An object that describes the endpoint of the deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublicEndpoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerServiceDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerServiceDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerServiceDeploymentProperty> {
            java.lang.Object containers;
            java.lang.Object publicEndpoint;

            /**
             * Sets the value of {@link ContainerServiceDeploymentProperty#getContainers}
             * @param containers An object that describes the configuration for the containers of the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link ContainerServiceDeploymentProperty#getContainers}
             * @param containers An object that describes the configuration for the containers of the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link ContainerServiceDeploymentProperty#getPublicEndpoint}
             * @param publicEndpoint An object that describes the endpoint of the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicEndpoint(software.amazon.awscdk.services.lightsail.CfnContainer.PublicEndpointProperty publicEndpoint) {
                this.publicEndpoint = publicEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ContainerServiceDeploymentProperty#getPublicEndpoint}
             * @param publicEndpoint An object that describes the endpoint of the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicEndpoint(software.amazon.awscdk.IResolvable publicEndpoint) {
                this.publicEndpoint = publicEndpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerServiceDeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerServiceDeploymentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerServiceDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerServiceDeploymentProperty {
            private final java.lang.Object containers;
            private final java.lang.Object publicEndpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publicEndpoint = software.amazon.jsii.Kernel.get(this, "publicEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = builder.containers;
                this.publicEndpoint = builder.publicEndpoint;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.Object getPublicEndpoint() {
                return this.publicEndpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getPublicEndpoint() != null) {
                    data.set("publicEndpoint", om.valueToTree(this.getPublicEndpoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.ContainerServiceDeploymentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerServiceDeploymentProperty.Jsii$Proxy that = (ContainerServiceDeploymentProperty.Jsii$Proxy) o;

                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                return this.publicEndpoint != null ? this.publicEndpoint.equals(that.publicEndpoint) : that.publicEndpoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers != null ? this.containers.hashCode() : 0;
                result = 31 * result + (this.publicEndpoint != null ? this.publicEndpoint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `EnvironmentVariable` is a property of the [Container](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-container-container.html) property. It describes the environment variables of a container on a container service which are key-value parameters that provide dynamic configuration of the application or script run by the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * EnvironmentVariableProperty environmentVariableProperty = EnvironmentVariableProperty.builder()
     *         .value("value")
     *         .variable("variable")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The environment variable value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * The environment variable key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVariable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            java.lang.String value;
            java.lang.String variable;

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getValue}
             * @param value The environment variable value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getVariable}
             * @param variable The environment variable key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variable(java.lang.String variable) {
                this.variable = variable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentVariableProperty {
            private final java.lang.String value;
            private final java.lang.String variable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variable = software.amazon.jsii.Kernel.get(this, "variable", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
                this.variable = builder.variable;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getVariable() {
                return this.variable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }
                if (this.getVariable() != null) {
                    data.set("variable", om.valueToTree(this.getVariable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.EnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentVariableProperty.Jsii$Proxy that = (EnvironmentVariableProperty.Jsii$Proxy) o;

                if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
                return this.variable != null ? this.variable.equals(that.variable) : that.variable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                result = 31 * result + (this.variable != null ? this.variable.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `HealthCheckConfig` is a property of the [PublicEndpoint](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-container-publicendpoint.html) property. It describes the healthcheck configuration of a container deployment on a container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * HealthCheckConfigProperty healthCheckConfigProperty = HealthCheckConfigProperty.builder()
     *         .healthyThreshold(123)
     *         .intervalSeconds(123)
     *         .path("path")
     *         .successCodes("successCodes")
     *         .timeoutSeconds(123)
     *         .unhealthyThreshold(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of consecutive health check successes required before moving the container to the `Healthy` state.
         * <p>
         * The default value is <code>2</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThreshold() {
            return null;
        }

        /**
         * The approximate interval, in seconds, between health checks of an individual container.
         * <p>
         * You can specify between <code>5</code> and <code>300</code> seconds. The default value is <code>5</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalSeconds() {
            return null;
        }

        /**
         * The path on the container on which to perform the health check.
         * <p>
         * The default value is <code>/</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The HTTP codes to use when checking for a successful response from a container.
         * <p>
         * You can specify values between <code>200</code> and <code>499</code> . You can specify multiple values (for example, <code>200,202</code> ) or a range of values (for example, <code>200-299</code> ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessCodes() {
            return null;
        }

        /**
         * The amount of time, in seconds, during which no response means a failed health check.
         * <p>
         * You can specify between <code>2</code> and <code>60</code> seconds. The default value is <code>2</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutSeconds() {
            return null;
        }

        /**
         * The number of consecutive health check failures required before moving the container to the `Unhealthy` state.
         * <p>
         * The default value is <code>2</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            java.lang.Number healthyThreshold;
            java.lang.Number intervalSeconds;
            java.lang.String path;
            java.lang.String successCodes;
            java.lang.Number timeoutSeconds;
            java.lang.Number unhealthyThreshold;

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getHealthyThreshold}
             * @param healthyThreshold The number of consecutive health check successes required before moving the container to the `Healthy` state.
             *                         The default value is <code>2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getIntervalSeconds}
             * @param intervalSeconds The approximate interval, in seconds, between health checks of an individual container.
             *                        You can specify between <code>5</code> and <code>300</code> seconds. The default value is <code>5</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalSeconds(java.lang.Number intervalSeconds) {
                this.intervalSeconds = intervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getPath}
             * @param path The path on the container on which to perform the health check.
             *             The default value is <code>/</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getSuccessCodes}
             * @param successCodes The HTTP codes to use when checking for a successful response from a container.
             *                     You can specify values between <code>200</code> and <code>499</code> . You can specify multiple values (for example, <code>200,202</code> ) or a range of values (for example, <code>200-299</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successCodes(java.lang.String successCodes) {
                this.successCodes = successCodes;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getTimeoutSeconds}
             * @param timeoutSeconds The amount of time, in seconds, during which no response means a failed health check.
             *                       You can specify between <code>2</code> and <code>60</code> seconds. The default value is <code>2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutSeconds(java.lang.Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold The number of consecutive health check failures required before moving the container to the `Unhealthy` state.
             *                           The default value is <code>2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckConfigProperty {
            private final java.lang.Number healthyThreshold;
            private final java.lang.Number intervalSeconds;
            private final java.lang.String path;
            private final java.lang.String successCodes;
            private final java.lang.Number timeoutSeconds;
            private final java.lang.Number unhealthyThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalSeconds = software.amazon.jsii.Kernel.get(this, "intervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.successCodes = software.amazon.jsii.Kernel.get(this, "successCodes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutSeconds = software.amazon.jsii.Kernel.get(this, "timeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = builder.healthyThreshold;
                this.intervalSeconds = builder.intervalSeconds;
                this.path = builder.path;
                this.successCodes = builder.successCodes;
                this.timeoutSeconds = builder.timeoutSeconds;
                this.unhealthyThreshold = builder.unhealthyThreshold;
            }

            @Override
            public final java.lang.Number getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public final java.lang.Number getIntervalSeconds() {
                return this.intervalSeconds;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getSuccessCodes() {
                return this.successCodes;
            }

            @Override
            public final java.lang.Number getTimeoutSeconds() {
                return this.timeoutSeconds;
            }

            @Override
            public final java.lang.Number getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthyThreshold() != null) {
                    data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                }
                if (this.getIntervalSeconds() != null) {
                    data.set("intervalSeconds", om.valueToTree(this.getIntervalSeconds()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getSuccessCodes() != null) {
                    data.set("successCodes", om.valueToTree(this.getSuccessCodes()));
                }
                if (this.getTimeoutSeconds() != null) {
                    data.set("timeoutSeconds", om.valueToTree(this.getTimeoutSeconds()));
                }
                if (this.getUnhealthyThreshold() != null) {
                    data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.HealthCheckConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckConfigProperty.Jsii$Proxy that = (HealthCheckConfigProperty.Jsii$Proxy) o;

                if (this.healthyThreshold != null ? !this.healthyThreshold.equals(that.healthyThreshold) : that.healthyThreshold != null) return false;
                if (this.intervalSeconds != null ? !this.intervalSeconds.equals(that.intervalSeconds) : that.intervalSeconds != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.successCodes != null ? !this.successCodes.equals(that.successCodes) : that.successCodes != null) return false;
                if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) return false;
                return this.unhealthyThreshold != null ? this.unhealthyThreshold.equals(that.unhealthyThreshold) : that.unhealthyThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthyThreshold != null ? this.healthyThreshold.hashCode() : 0;
                result = 31 * result + (this.intervalSeconds != null ? this.intervalSeconds.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.successCodes != null ? this.successCodes.hashCode() : 0);
                result = 31 * result + (this.timeoutSeconds != null ? this.timeoutSeconds.hashCode() : 0);
                result = 31 * result + (this.unhealthyThreshold != null ? this.unhealthyThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `PortInfo` is a property of the [Container](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-container-container.html) property. It describes the ports to open and the protocols to use for a container on a Amazon Lightsail container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * PortInfoProperty portInfoProperty = PortInfoProperty.builder()
     *         .port("port")
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.PortInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(PortInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The open firewall ports of the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * The protocol name for the open ports.
         * <p>
         * <em>Allowed values</em> : <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>UDP</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortInfoProperty> {
            java.lang.String port;
            java.lang.String protocol;

            /**
             * Sets the value of {@link PortInfoProperty#getPort}
             * @param port The open firewall ports of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link PortInfoProperty#getProtocol}
             * @param protocol The protocol name for the open ports.
             *                 <em>Allowed values</em> : <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>UDP</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortInfoProperty {
            private final java.lang.String port;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = builder.port;
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.PortInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortInfoProperty.Jsii$Proxy that = (PortInfoProperty.Jsii$Proxy) o;

                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port != null ? this.port.hashCode() : 0;
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `PublicDomainName` is a property of the [AWS::Lightsail::Container](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html) resource. It describes the public domain names to use with a container service, such as `example.com` and `www.example.com` . It also describes the certificates to use with a container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * PublicDomainNameProperty publicDomainNameProperty = PublicDomainNameProperty.builder()
     *         .certificateName("certificateName")
     *         .domainNames(List.of("domainNames"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.PublicDomainNameProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicDomainNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicDomainNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the certificate for the public domains.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
            return null;
        }

        /**
         * The public domain names to use with the container service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicDomainNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicDomainNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicDomainNameProperty> {
            java.lang.String certificateName;
            java.util.List<java.lang.String> domainNames;

            /**
             * Sets the value of {@link PublicDomainNameProperty#getCertificateName}
             * @param certificateName The name of the certificate for the public domains.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateName(java.lang.String certificateName) {
                this.certificateName = certificateName;
                return this;
            }

            /**
             * Sets the value of {@link PublicDomainNameProperty#getDomainNames}
             * @param domainNames The public domain names to use with the container service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainNames(java.util.List<java.lang.String> domainNames) {
                this.domainNames = domainNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicDomainNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicDomainNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicDomainNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicDomainNameProperty {
            private final java.lang.String certificateName;
            private final java.util.List<java.lang.String> domainNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainNames = software.amazon.jsii.Kernel.get(this, "domainNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateName = builder.certificateName;
                this.domainNames = builder.domainNames;
            }

            @Override
            public final java.lang.String getCertificateName() {
                return this.certificateName;
            }

            @Override
            public final java.util.List<java.lang.String> getDomainNames() {
                return this.domainNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateName() != null) {
                    data.set("certificateName", om.valueToTree(this.getCertificateName()));
                }
                if (this.getDomainNames() != null) {
                    data.set("domainNames", om.valueToTree(this.getDomainNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.PublicDomainNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicDomainNameProperty.Jsii$Proxy that = (PublicDomainNameProperty.Jsii$Proxy) o;

                if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
                return this.domainNames != null ? this.domainNames.equals(that.domainNames) : that.domainNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateName != null ? this.certificateName.hashCode() : 0;
                result = 31 * result + (this.domainNames != null ? this.domainNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `PublicEndpoint` is a property of the [ContainerServiceDeployment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-container-containerservicedeployment.html) property. It describes describes the settings of the public endpoint of a container on a container service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * PublicEndpointProperty publicEndpointProperty = PublicEndpointProperty.builder()
     *         .containerName("containerName")
     *         .containerPort(123)
     *         .healthCheckConfig(HealthCheckConfigProperty.builder()
     *                 .healthyThreshold(123)
     *                 .intervalSeconds(123)
     *                 .path("path")
     *                 .successCodes("successCodes")
     *                 .timeoutSeconds(123)
     *                 .unhealthyThreshold(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainer.PublicEndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicEndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicEndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the container entry of the deployment that the endpoint configuration applies to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The port of the specified container to which traffic is forwarded to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * An object that describes the health check configuration of the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicEndpointProperty> {
            java.lang.String containerName;
            java.lang.Number containerPort;
            java.lang.Object healthCheckConfig;

            /**
             * Sets the value of {@link PublicEndpointProperty#getContainerName}
             * @param containerName The name of the container entry of the deployment that the endpoint configuration applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link PublicEndpointProperty#getContainerPort}
             * @param containerPort The port of the specified container to which traffic is forwarded to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link PublicEndpointProperty#getHealthCheckConfig}
             * @param healthCheckConfig An object that describes the health check configuration of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckConfig(software.amazon.awscdk.services.lightsail.CfnContainer.HealthCheckConfigProperty healthCheckConfig) {
                this.healthCheckConfig = healthCheckConfig;
                return this;
            }

            /**
             * Sets the value of {@link PublicEndpointProperty#getHealthCheckConfig}
             * @param healthCheckConfig An object that describes the health check configuration of the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckConfig(software.amazon.awscdk.IResolvable healthCheckConfig) {
                this.healthCheckConfig = healthCheckConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicEndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicEndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicEndpointProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.Object healthCheckConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.healthCheckConfig = software.amazon.jsii.Kernel.get(this, "healthCheckConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = builder.containerName;
                this.containerPort = builder.containerPort;
                this.healthCheckConfig = builder.healthCheckConfig;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.Object getHealthCheckConfig() {
                return this.healthCheckConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getHealthCheckConfig() != null) {
                    data.set("healthCheckConfig", om.valueToTree(this.getHealthCheckConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainer.PublicEndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicEndpointProperty.Jsii$Proxy that = (PublicEndpointProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                return this.healthCheckConfig != null ? this.healthCheckConfig.equals(that.healthCheckConfig) : that.healthCheckConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.healthCheckConfig != null ? this.healthCheckConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnContainer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnContainer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnContainerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnContainerProps.Builder();
        }

        /**
         * The power specification of the container service.
         * <p>
         * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
         * <p>
         * @return {@code this}
         * @param power The power specification of the container service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder power(final java.lang.String power) {
            this.props.power(power);
            return this;
        }

        /**
         * The scale specification of the container service.
         * <p>
         * The scale specifies the allocated compute nodes of the container service.
         * <p>
         * @return {@code this}
         * @param scale The scale specification of the container service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scale(final java.lang.Number scale) {
            this.props.scale(scale);
            return this;
        }

        /**
         * The name of the container service.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the container service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * An object that describes the current container deployment of the container service.
         * <p>
         * @return {@code this}
         * @param containerServiceDeployment An object that describes the current container deployment of the container service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerServiceDeployment(final software.amazon.awscdk.services.lightsail.CfnContainer.ContainerServiceDeploymentProperty containerServiceDeployment) {
            this.props.containerServiceDeployment(containerServiceDeployment);
            return this;
        }
        /**
         * An object that describes the current container deployment of the container service.
         * <p>
         * @return {@code this}
         * @param containerServiceDeployment An object that describes the current container deployment of the container service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerServiceDeployment(final software.amazon.awscdk.IResolvable containerServiceDeployment) {
            this.props.containerServiceDeployment(containerServiceDeployment);
            return this;
        }

        /**
         * A Boolean value indicating whether the container service is disabled.
         * <p>
         * @return {@code this}
         * @param isDisabled A Boolean value indicating whether the container service is disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDisabled(final java.lang.Boolean isDisabled) {
            this.props.isDisabled(isDisabled);
            return this;
        }
        /**
         * A Boolean value indicating whether the container service is disabled.
         * <p>
         * @return {@code this}
         * @param isDisabled A Boolean value indicating whether the container service is disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDisabled(final software.amazon.awscdk.IResolvable isDisabled) {
            this.props.isDisabled(isDisabled);
            return this;
        }

        /**
         * The public domain name of the container service, such as `example.com` and `www.example.com` .
         * <p>
         * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
         * <p>
         * If you don't specify public domain names, then you can use the default domain of the container service.
         * <p>
         * <blockquote>
         * <p>
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param publicDomainNames The public domain name of the container service, such as `example.com` and `www.example.com` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDomainNames(final software.amazon.awscdk.IResolvable publicDomainNames) {
            this.props.publicDomainNames(publicDomainNames);
            return this;
        }
        /**
         * The public domain name of the container service, such as `example.com` and `www.example.com` .
         * <p>
         * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
         * <p>
         * If you don't specify public domain names, then you can use the default domain of the container service.
         * <p>
         * <blockquote>
         * <p>
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param publicDomainNames The public domain name of the container service, such as `example.com` and `www.example.com` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDomainNames(final java.util.List<? extends java.lang.Object> publicDomainNames) {
            this.props.publicDomainNames(publicDomainNames);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnContainer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnContainer build() {
            return new software.amazon.awscdk.services.lightsail.CfnContainer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
