package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a `CfnTagAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * Object catalog;
 * Object tableWildcard;
 * CfnTagAssociationProps cfnTagAssociationProps = CfnTagAssociationProps.builder()
 *         .lfTags(List.of(LFTagPairProperty.builder()
 *                 .catalogId("catalogId")
 *                 .tagKey("tagKey")
 *                 .tagValues(List.of("tagValues"))
 *                 .build()))
 *         .resource(ResourceProperty.builder()
 *                 .catalog(catalog)
 *                 .database(DatabaseResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .name("name")
 *                         .build())
 *                 .table(TableResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .tableWildcard(tableWildcard)
 *                         .build())
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .columnNames(List.of("columnNames"))
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.987Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTagAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTagAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::LakeFormation::TagAssociation.LFTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLfTags();

    /**
     * `AWS::LakeFormation::TagAssociation.Resource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResource();

    /**
     * @return a {@link Builder} of {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTagAssociationProps> {
        java.lang.Object lfTags;
        java.lang.Object resource;

        /**
         * Sets the value of {@link CfnTagAssociationProps#getLfTags}
         * @param lfTags `AWS::LakeFormation::TagAssociation.LFTags`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(software.amazon.awscdk.IResolvable lfTags) {
            this.lfTags = lfTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getLfTags}
         * @param lfTags `AWS::LakeFormation::TagAssociation.LFTags`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(java.util.List<? extends java.lang.Object> lfTags) {
            this.lfTags = lfTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getResource}
         * @param resource `AWS::LakeFormation::TagAssociation.Resource`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.ResourceProperty resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getResource}
         * @param resource `AWS::LakeFormation::TagAssociation.Resource`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.IResolvable resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTagAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTagAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTagAssociationProps {
        private final java.lang.Object lfTags;
        private final java.lang.Object resource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lfTags = software.amazon.jsii.Kernel.get(this, "lfTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lfTags = java.util.Objects.requireNonNull(builder.lfTags, "lfTags is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
        }

        @Override
        public final java.lang.Object getLfTags() {
            return this.lfTags;
        }

        @Override
        public final java.lang.Object getResource() {
            return this.resource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lfTags", om.valueToTree(this.getLfTags()));
            data.set("resource", om.valueToTree(this.getResource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTagAssociationProps.Jsii$Proxy that = (CfnTagAssociationProps.Jsii$Proxy) o;

            if (!lfTags.equals(that.lfTags)) return false;
            return this.resource.equals(that.resource);
        }

        @Override
        public final int hashCode() {
            int result = this.lfTags.hashCode();
            result = 31 * result + (this.resource.hashCode());
            return result;
        }
    }
}
