package software.amazon.awscdk.services.kms;

/**
 * Defines a KMS key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * Key encryptionKey = Key.Builder.create(this, "Key")
 *         .enableKeyRotation(true)
 *         .build();
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .encryptionKey(encryptionKey)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.970Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.Key")
public class Key extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.kms.IKey {

    protected Key(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Key(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Key(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.KeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Key(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Create a mutable {@link IKey} based on a low-level {@link CfnKey}.
     * <p>
     * This is most useful when combined with the cloudformation-include module.
     * This method is different than {&#64;link fromKeyArn()} because the {&#64;link IKey}
     * returned from this method is mutable;
     * meaning, calling any mutating methods on it,
     * like {&#64;link IKey.addToResourcePolicy()},
     * will actually be reflected in the resulting template,
     * as opposed to the object returned from {&#64;link fromKeyArn()},
     * on which calling those methods would have no effect.
     * <p>
     * @param cfnKey This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey fromCfnKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.CfnKey cfnKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Key.class, "fromCfnKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class), new Object[] { java.util.Objects.requireNonNull(cfnKey, "cfnKey is required") });
    }

    /**
     * Import an externally defined KMS Key using its ARN.
     * <p>
     * @param scope the construct that will "own" the imported key. This parameter is required.
     * @param id the id of the imported key in the construct tree. This parameter is required.
     * @param keyArn the ARN of an existing KMS key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey fromKeyArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String keyArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Key.class, "fromKeyArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(keyArn, "keyArn is required") });
    }

    /**
     * Import an existing Key by querying the AWS environment this stack is deployed to.
     * <p>
     * This function only needs to be used to use Keys not defined in your CDK
     * application. If you are looking to share a Key between stacks, you can
     * pass the <code>Key</code> object between stacks and use it as normal. In addition,
     * it's not necessary to use this method if an interface accepts an <code>IKey</code>.
     * In this case, <code>Alias.fromAliasName()</code> can be used which returns an alias
     * that extends <code>IKey</code>.
     * <p>
     * Calling this method will lead to a lookup when the CDK CLI is executed.
     * You can therefore not use any values that will only be available at
     * CloudFormation execution time (i.e., Tokens).
     * <p>
     * The Key information will be cached in <code>cdk.context.json</code> and the same Key
     * will be used on future runs. To refresh the lookup, you will have to
     * evict the value from the cache using the <code>cdk context</code> command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.KeyLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Key.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a new alias for the key.
     * <p>
     * @param aliasName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement The policy statement to add. This parameter is required.
     * @param allowNoOp If this is set to `false` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement, final @org.jetbrains.annotations.Nullable java.lang.Boolean allowNoOp) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required"), allowNoOp });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement The policy statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Grant the indicated permissions on this key to the given principal.
     * <p>
     * This modifies both the principal's policy as well as the resource policy,
     * since the default CloudFormation setup for KMS keys is that the policy
     * must not be empty and so default grants won't work.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant admins permissions using this key to the given principal.
     * <p>
     * Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
     * to use the key in cryptographic operations (e.g., encrypt, decrypt).
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAdmin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantAdmin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant decryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantDecrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantEncrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption and decryption permissions using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncryptDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantEncryptDecrypt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The ARN of the key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyId() {
        return software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional property to control trusting account identities.
     * <p>
     * If specified, grants will default identity policies instead of to both
     * resource and identity policies. This matches the default behavior when creating
     * KMS keys via the API or console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getTrustAccountIdentities() {
        return software.amazon.jsii.Kernel.get(this, "trustAccountIdentities", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Optional policy document that represents the resource policy of this key.
     * <p>
     * If specified, addToResourcePolicy can be used to edit this policy.
     * Otherwise this method will no-op.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kms.Key}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kms.Key> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kms.KeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of principals to add as key administrators to the key policy.
         * <p>
         * Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
         * to use the key in cryptographic operations (e.g., encrypt, decrypt).
         * <p>
         * These principals will be added to the default key policy (if none specified), or to the specified policy (if provided).
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param admins A list of principals to add as key administrators to the key policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(final java.util.List<? extends software.amazon.awscdk.services.iam.IPrincipal> admins) {
            this.props().admins(admins);
            return this;
        }

        /**
         * Initial alias to add to the key.
         * <p>
         * More aliases can be added later by calling <code>addAlias</code>.
         * <p>
         * Default: - No alias is added for the key.
         * <p>
         * @return {@code this}
         * @param alias Initial alias to add to the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(final java.lang.String alias) {
            this.props().alias(alias);
            return this;
        }

        /**
         * A description of the key.
         * <p>
         * Use a description that helps your users decide
         * whether the key is appropriate for a particular task.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Indicates whether the key is available for use.
         * <p>
         * Default: - Key is enabled.
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the key is available for use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * Indicates whether AWS KMS rotates the key.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Indicates whether AWS KMS rotates the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * The cryptographic configuration of the key. The valid value depends on usage of the key.
         * <p>
         * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
         * and a new key is created with the specified value.
         * <p>
         * Default: KeySpec.SYMMETRIC_DEFAULT
         * <p>
         * @return {@code this}
         * @param keySpec The cryptographic configuration of the key. The valid value depends on usage of the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySpec(final software.amazon.awscdk.services.kms.KeySpec keySpec) {
            this.props().keySpec(keySpec);
            return this;
        }

        /**
         * The cryptographic operations for which the key can be used.
         * <p>
         * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
         * and a new key is created with the specified value.
         * <p>
         * Default: KeyUsage.ENCRYPT_DECRYPT
         * <p>
         * @return {@code this}
         * @param keyUsage The cryptographic operations for which the key can be used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyUsage(final software.amazon.awscdk.services.kms.KeyUsage keyUsage) {
            this.props().keyUsage(keyUsage);
            return this;
        }

        /**
         * Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack.
         * <p>
         * When you remove a customer master key (CMK) from a CloudFormation stack, AWS KMS schedules the CMK for deletion
         * and starts the mandatory waiting period. The PendingWindowInDays property determines the length of waiting period.
         * During the waiting period, the key state of CMK is Pending Deletion, which prevents the CMK from being used in
         * cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the CMK.
         * <p>
         * Enter a value between 7 and 30 days.
         * <p>
         * Default: - 30 days
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays</a>
         * @param pendingWindow Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindow(final software.amazon.awscdk.Duration pendingWindow) {
            this.props().pendingWindow(pendingWindow);
            return this;
        }

        /**
         * Custom policy document to attach to the KMS key.
         * <p>
         * NOTE - If the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag is set (the default for new projects),
         * this policy will <em>override</em> the default key policy and become the only key policy for the key. If the
         * feature flag is not set, this policy will be appended to the default key policy.
         * <p>
         * Default: - A policy document with permissions for the account root to
         * administer the key will be created.
         * <p>
         * @return {@code this}
         * @param policy Custom policy document to attach to the KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * Whether the encryption key should be retained when it is removed from the Stack.
         * <p>
         * This is useful when one wants to
         * retain access to data that was encrypted with a key that is being retired.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether the encryption key should be retained when it is removed from the Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kms.Key}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kms.Key build() {
            return new software.amazon.awscdk.services.kms.Key(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kms.KeyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kms.KeyProps.Builder();
            }
            return this.props;
        }
    }
}
