package software.amazon.awscdk.services.kafkaconnect;

/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 * <p>
 * Creates a connector using the specified properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kafkaconnect.*;
 * CfnConnector cfnConnector = CfnConnector.Builder.create(this, "MyCfnConnector")
 *         .capacity(CapacityProperty.builder()
 *                 .autoScaling(AutoScalingProperty.builder()
 *                         .maxWorkerCount(123)
 *                         .mcuCount(123)
 *                         .minWorkerCount(123)
 *                         .scaleInPolicy(ScaleInPolicyProperty.builder()
 *                                 .cpuUtilizationPercentage(123)
 *                                 .build())
 *                         .scaleOutPolicy(ScaleOutPolicyProperty.builder()
 *                                 .cpuUtilizationPercentage(123)
 *                                 .build())
 *                         .build())
 *                 .provisionedCapacity(ProvisionedCapacityProperty.builder()
 *                         .workerCount(123)
 *                         // the properties below are optional
 *                         .mcuCount(123)
 *                         .build())
 *                 .build())
 *         .connectorConfiguration(Map.of(
 *                 "connectorConfigurationKey", "connectorConfiguration"))
 *         .connectorName("connectorName")
 *         .kafkaCluster(KafkaClusterProperty.builder()
 *                 .apacheKafkaCluster(ApacheKafkaClusterProperty.builder()
 *                         .bootstrapServers("bootstrapServers")
 *                         .vpc(VpcProperty.builder()
 *                                 .securityGroups(List.of("securityGroups"))
 *                                 .subnets(List.of("subnets"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 .build())
 *         .kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 .build())
 *         .kafkaConnectVersion("kafkaConnectVersion")
 *         .plugins(List.of(PluginProperty.builder()
 *                 .customPlugin(CustomPluginProperty.builder()
 *                         .customPluginArn("customPluginArn")
 *                         .revision(123)
 *                         .build())
 *                 .build()))
 *         .serviceExecutionRoleArn("serviceExecutionRoleArn")
 *         // the properties below are optional
 *         .connectorDescription("connectorDescription")
 *         .logDelivery(LogDeliveryProperty.builder()
 *                 .workerLogDelivery(WorkerLogDeliveryProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogsLogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .firehose(FirehoseLogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .s3(S3LogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .bucket("bucket")
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .revision(123)
 *                 .workerConfigurationArn("workerConfigurationArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.726Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector")
public class CfnConnector extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kafkaconnect.CfnConnector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::KafkaConnect::Connector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the newly created connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The connector's compute capacity settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCapacity() {
        return software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connector's compute capacity settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kafkaconnect.CfnConnector.CapacityProperty value) {
        software.amazon.jsii.Kernel.set(this, "capacity", java.util.Objects.requireNonNull(value, "capacity is required"));
    }

    /**
     * The connector's compute capacity settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capacity", java.util.Objects.requireNonNull(value, "capacity is required"));
    }

    /**
     * The configuration of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectorConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "connectorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectorConfiguration", java.util.Objects.requireNonNull(value, "connectorConfiguration is required"));
    }

    /**
     * The configuration of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorConfiguration(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "connectorConfiguration", java.util.Objects.requireNonNull(value, "connectorConfiguration is required"));
    }

    /**
     * The name of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorName() {
        return software.amazon.jsii.Kernel.get(this, "connectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorName", java.util.Objects.requireNonNull(value, "connectorName is required"));
    }

    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKafkaCluster() {
        return software.amazon.jsii.Kernel.get(this, "kafkaCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaCluster", java.util.Objects.requireNonNull(value, "kafkaCluster is required"));
    }

    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaCluster", java.util.Objects.requireNonNull(value, "kafkaCluster is required"));
    }

    /**
     * The type of client authentication used to connect to the Apache Kafka cluster.
     * <p>
     * The value is NONE when no client authentication is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusterClientAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "kafkaClusterClientAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of client authentication used to connect to the Apache Kafka cluster.
     * <p>
     * The value is NONE when no client authentication is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusterClientAuthentication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaClusterClientAuthentication", java.util.Objects.requireNonNull(value, "kafkaClusterClientAuthentication is required"));
    }

    /**
     * The type of client authentication used to connect to the Apache Kafka cluster.
     * <p>
     * The value is NONE when no client authentication is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusterClientAuthentication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaClusterClientAuthentication", java.util.Objects.requireNonNull(value, "kafkaClusterClientAuthentication is required"));
    }

    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusterEncryptionInTransit() {
        return software.amazon.jsii.Kernel.get(this, "kafkaClusterEncryptionInTransit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusterEncryptionInTransit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaClusterEncryptionInTransit", java.util.Objects.requireNonNull(value, "kafkaClusterEncryptionInTransit is required"));
    }

    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusterEncryptionInTransit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaClusterEncryptionInTransit", java.util.Objects.requireNonNull(value, "kafkaClusterEncryptionInTransit is required"));
    }

    /**
     * The version of Kafka Connect.
     * <p>
     * It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKafkaConnectVersion() {
        return software.amazon.jsii.Kernel.get(this, "kafkaConnectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of Kafka Connect.
     * <p>
     * It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaConnectVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kafkaConnectVersion", java.util.Objects.requireNonNull(value, "kafkaConnectVersion is required"));
    }

    /**
     * Specifies which plugin to use for the connector.
     * <p>
     * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPlugins() {
        return software.amazon.jsii.Kernel.get(this, "plugins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies which plugin to use for the connector.
     * <p>
     * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlugins(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "plugins", java.util.Objects.requireNonNull(value, "plugins is required"));
    }

    /**
     * Specifies which plugin to use for the connector.
     * <p>
     * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlugins(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.kafkaconnect.CfnConnector.PluginProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.kafkaconnect.CfnConnector.PluginProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "plugins", java.util.Objects.requireNonNull(value, "plugins is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceExecutionRoleArn", java.util.Objects.requireNonNull(value, "serviceExecutionRoleArn is required"));
    }

    /**
     * The description of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectorDescription() {
        return software.amazon.jsii.Kernel.get(this, "connectorDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorDescription", value);
    }

    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogDelivery() {
        return software.amazon.jsii.Kernel.get(this, "logDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDelivery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kafkaconnect.CfnConnector.LogDeliveryProperty value) {
        software.amazon.jsii.Kernel.set(this, "logDelivery", value);
    }

    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDelivery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logDelivery", value);
    }

    /**
     * The worker configurations that are in use with the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkerConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "workerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The worker configurations that are in use with the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kafkaconnect.CfnConnector.WorkerConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "workerConfiguration", value);
    }

    /**
     * The worker configurations that are in use with the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workerConfiguration", value);
    }
    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * ApacheKafkaClusterProperty apacheKafkaClusterProperty = ApacheKafkaClusterProperty.builder()
     *         .bootstrapServers("bootstrapServers")
     *         .vpc(VpcProperty.builder()
     *                 .securityGroups(List.of("securityGroups"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.ApacheKafkaClusterProperty")
    @software.amazon.jsii.Jsii.Proxy(ApacheKafkaClusterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApacheKafkaClusterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bootstrap servers of the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBootstrapServers();

        /**
         * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVpc();

        /**
         * @return a {@link Builder} of {@link ApacheKafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApacheKafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApacheKafkaClusterProperty> {
            java.lang.String bootstrapServers;
            java.lang.Object vpc;

            /**
             * Sets the value of {@link ApacheKafkaClusterProperty#getBootstrapServers}
             * @param bootstrapServers The bootstrap servers of the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bootstrapServers(java.lang.String bootstrapServers) {
                this.bootstrapServers = bootstrapServers;
                return this;
            }

            /**
             * Sets the value of {@link ApacheKafkaClusterProperty#getVpc}
             * @param vpc Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.services.kafkaconnect.CfnConnector.VpcProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Sets the value of {@link ApacheKafkaClusterProperty#getVpc}
             * @param vpc Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApacheKafkaClusterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApacheKafkaClusterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApacheKafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApacheKafkaClusterProperty {
            private final java.lang.String bootstrapServers;
            private final java.lang.Object vpc;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bootstrapServers = software.amazon.jsii.Kernel.get(this, "bootstrapServers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bootstrapServers = java.util.Objects.requireNonNull(builder.bootstrapServers, "bootstrapServers is required");
                this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            }

            @Override
            public final java.lang.String getBootstrapServers() {
                return this.bootstrapServers;
            }

            @Override
            public final java.lang.Object getVpc() {
                return this.vpc;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bootstrapServers", om.valueToTree(this.getBootstrapServers()));
                data.set("vpc", om.valueToTree(this.getVpc()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.ApacheKafkaClusterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApacheKafkaClusterProperty.Jsii$Proxy that = (ApacheKafkaClusterProperty.Jsii$Proxy) o;

                if (!bootstrapServers.equals(that.bootstrapServers)) return false;
                return this.vpc.equals(that.vpc);
            }

            @Override
            public final int hashCode() {
                int result = this.bootstrapServers.hashCode();
                result = 31 * result + (this.vpc.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies how the connector scales.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * AutoScalingProperty autoScalingProperty = AutoScalingProperty.builder()
     *         .maxWorkerCount(123)
     *         .mcuCount(123)
     *         .minWorkerCount(123)
     *         .scaleInPolicy(ScaleInPolicyProperty.builder()
     *                 .cpuUtilizationPercentage(123)
     *                 .build())
     *         .scaleOutPolicy(ScaleOutPolicyProperty.builder()
     *                 .cpuUtilizationPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.AutoScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of workers allocated to the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxWorkerCount();

        /**
         * The number of microcontroller units (MCUs) allocated to each connector worker.
         * <p>
         * The valid values are 1,2,4,8.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMcuCount();

        /**
         * The minimum number of workers allocated to the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinWorkerCount();

        /**
         * The sacle-in policy for the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getScaleInPolicy();

        /**
         * The sacle-out policy for the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getScaleOutPolicy();

        /**
         * @return a {@link Builder} of {@link AutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingProperty> {
            java.lang.Number maxWorkerCount;
            java.lang.Number mcuCount;
            java.lang.Number minWorkerCount;
            java.lang.Object scaleInPolicy;
            java.lang.Object scaleOutPolicy;

            /**
             * Sets the value of {@link AutoScalingProperty#getMaxWorkerCount}
             * @param maxWorkerCount The maximum number of workers allocated to the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxWorkerCount(java.lang.Number maxWorkerCount) {
                this.maxWorkerCount = maxWorkerCount;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getMcuCount}
             * @param mcuCount The number of microcontroller units (MCUs) allocated to each connector worker. This parameter is required.
             *                 The valid values are 1,2,4,8.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcuCount(java.lang.Number mcuCount) {
                this.mcuCount = mcuCount;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getMinWorkerCount}
             * @param minWorkerCount The minimum number of workers allocated to the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minWorkerCount(java.lang.Number minWorkerCount) {
                this.minWorkerCount = minWorkerCount;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getScaleInPolicy}
             * @param scaleInPolicy The sacle-in policy for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInPolicy(software.amazon.awscdk.services.kafkaconnect.CfnConnector.ScaleInPolicyProperty scaleInPolicy) {
                this.scaleInPolicy = scaleInPolicy;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getScaleInPolicy}
             * @param scaleInPolicy The sacle-in policy for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInPolicy(software.amazon.awscdk.IResolvable scaleInPolicy) {
                this.scaleInPolicy = scaleInPolicy;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getScaleOutPolicy}
             * @param scaleOutPolicy The sacle-out policy for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutPolicy(software.amazon.awscdk.services.kafkaconnect.CfnConnector.ScaleOutPolicyProperty scaleOutPolicy) {
                this.scaleOutPolicy = scaleOutPolicy;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingProperty#getScaleOutPolicy}
             * @param scaleOutPolicy The sacle-out policy for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutPolicy(software.amazon.awscdk.IResolvable scaleOutPolicy) {
                this.scaleOutPolicy = scaleOutPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingProperty {
            private final java.lang.Number maxWorkerCount;
            private final java.lang.Number mcuCount;
            private final java.lang.Number minWorkerCount;
            private final java.lang.Object scaleInPolicy;
            private final java.lang.Object scaleOutPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxWorkerCount = software.amazon.jsii.Kernel.get(this, "maxWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mcuCount = software.amazon.jsii.Kernel.get(this, "mcuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minWorkerCount = software.amazon.jsii.Kernel.get(this, "minWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleInPolicy = software.amazon.jsii.Kernel.get(this, "scaleInPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleOutPolicy = software.amazon.jsii.Kernel.get(this, "scaleOutPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxWorkerCount = java.util.Objects.requireNonNull(builder.maxWorkerCount, "maxWorkerCount is required");
                this.mcuCount = java.util.Objects.requireNonNull(builder.mcuCount, "mcuCount is required");
                this.minWorkerCount = java.util.Objects.requireNonNull(builder.minWorkerCount, "minWorkerCount is required");
                this.scaleInPolicy = java.util.Objects.requireNonNull(builder.scaleInPolicy, "scaleInPolicy is required");
                this.scaleOutPolicy = java.util.Objects.requireNonNull(builder.scaleOutPolicy, "scaleOutPolicy is required");
            }

            @Override
            public final java.lang.Number getMaxWorkerCount() {
                return this.maxWorkerCount;
            }

            @Override
            public final java.lang.Number getMcuCount() {
                return this.mcuCount;
            }

            @Override
            public final java.lang.Number getMinWorkerCount() {
                return this.minWorkerCount;
            }

            @Override
            public final java.lang.Object getScaleInPolicy() {
                return this.scaleInPolicy;
            }

            @Override
            public final java.lang.Object getScaleOutPolicy() {
                return this.scaleOutPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxWorkerCount", om.valueToTree(this.getMaxWorkerCount()));
                data.set("mcuCount", om.valueToTree(this.getMcuCount()));
                data.set("minWorkerCount", om.valueToTree(this.getMinWorkerCount()));
                data.set("scaleInPolicy", om.valueToTree(this.getScaleInPolicy()));
                data.set("scaleOutPolicy", om.valueToTree(this.getScaleOutPolicy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.AutoScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingProperty.Jsii$Proxy that = (AutoScalingProperty.Jsii$Proxy) o;

                if (!maxWorkerCount.equals(that.maxWorkerCount)) return false;
                if (!mcuCount.equals(that.mcuCount)) return false;
                if (!minWorkerCount.equals(that.minWorkerCount)) return false;
                if (!scaleInPolicy.equals(that.scaleInPolicy)) return false;
                return this.scaleOutPolicy.equals(that.scaleOutPolicy);
            }

            @Override
            public final int hashCode() {
                int result = this.maxWorkerCount.hashCode();
                result = 31 * result + (this.mcuCount.hashCode());
                result = 31 * result + (this.minWorkerCount.hashCode());
                result = 31 * result + (this.scaleInPolicy.hashCode());
                result = 31 * result + (this.scaleOutPolicy.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the capacity of the connector, whether it is auto scaled or provisioned.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * CapacityProperty capacityProperty = CapacityProperty.builder()
     *         .autoScaling(AutoScalingProperty.builder()
     *                 .maxWorkerCount(123)
     *                 .mcuCount(123)
     *                 .minWorkerCount(123)
     *                 .scaleInPolicy(ScaleInPolicyProperty.builder()
     *                         .cpuUtilizationPercentage(123)
     *                         .build())
     *                 .scaleOutPolicy(ScaleOutPolicyProperty.builder()
     *                         .cpuUtilizationPercentage(123)
     *                         .build())
     *                 .build())
     *         .provisionedCapacity(ProvisionedCapacityProperty.builder()
     *                 .workerCount(123)
     *                 // the properties below are optional
     *                 .mcuCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.CapacityProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the auto scaling parameters for the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScaling() {
            return null;
        }

        /**
         * Details about a fixed capacity allocated to a connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProperty> {
            java.lang.Object autoScaling;
            java.lang.Object provisionedCapacity;

            /**
             * Sets the value of {@link CapacityProperty#getAutoScaling}
             * @param autoScaling Information about the auto scaling parameters for the connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScaling(software.amazon.awscdk.services.kafkaconnect.CfnConnector.AutoScalingProperty autoScaling) {
                this.autoScaling = autoScaling;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProperty#getAutoScaling}
             * @param autoScaling Information about the auto scaling parameters for the connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScaling(software.amazon.awscdk.IResolvable autoScaling) {
                this.autoScaling = autoScaling;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProperty#getProvisionedCapacity}
             * @param provisionedCapacity Details about a fixed capacity allocated to a connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedCapacity(software.amazon.awscdk.services.kafkaconnect.CfnConnector.ProvisionedCapacityProperty provisionedCapacity) {
                this.provisionedCapacity = provisionedCapacity;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProperty#getProvisionedCapacity}
             * @param provisionedCapacity Details about a fixed capacity allocated to a connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedCapacity(software.amazon.awscdk.IResolvable provisionedCapacity) {
                this.provisionedCapacity = provisionedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProperty {
            private final java.lang.Object autoScaling;
            private final java.lang.Object provisionedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScaling = software.amazon.jsii.Kernel.get(this, "autoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.provisionedCapacity = software.amazon.jsii.Kernel.get(this, "provisionedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScaling = builder.autoScaling;
                this.provisionedCapacity = builder.provisionedCapacity;
            }

            @Override
            public final java.lang.Object getAutoScaling() {
                return this.autoScaling;
            }

            @Override
            public final java.lang.Object getProvisionedCapacity() {
                return this.provisionedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoScaling() != null) {
                    data.set("autoScaling", om.valueToTree(this.getAutoScaling()));
                }
                if (this.getProvisionedCapacity() != null) {
                    data.set("provisionedCapacity", om.valueToTree(this.getProvisionedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.CapacityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProperty.Jsii$Proxy that = (CapacityProperty.Jsii$Proxy) o;

                if (this.autoScaling != null ? !this.autoScaling.equals(that.autoScaling) : that.autoScaling != null) return false;
                return this.provisionedCapacity != null ? this.provisionedCapacity.equals(that.provisionedCapacity) : that.provisionedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoScaling != null ? this.autoScaling.hashCode() : 0;
                result = 31 * result + (this.provisionedCapacity != null ? this.provisionedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * CloudWatchLogsLogDeliveryProperty cloudWatchLogsLogDeliveryProperty = CloudWatchLogsLogDeliveryProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .logGroup("logGroup")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.CloudWatchLogsLogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsLogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsLogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether log delivery to Amazon CloudWatch Logs is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the CloudWatch log group that is the destination for log delivery.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsLogDeliveryProperty> {
            java.lang.Object enabled;
            java.lang.String logGroup;

            /**
             * Sets the value of {@link CloudWatchLogsLogDeliveryProperty#getEnabled}
             * @param enabled Whether log delivery to Amazon CloudWatch Logs is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsLogDeliveryProperty#getEnabled}
             * @param enabled Whether log delivery to Amazon CloudWatch Logs is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsLogDeliveryProperty#getLogGroup}
             * @param logGroup The name of the CloudWatch log group that is the destination for log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsLogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsLogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsLogDeliveryProperty {
            private final java.lang.Object enabled;
            private final java.lang.String logGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.logGroup = builder.logGroup;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getLogGroup() != null) {
                    data.set("logGroup", om.valueToTree(this.getLogGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.CloudWatchLogsLogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsLogDeliveryProperty.Jsii$Proxy that = (CloudWatchLogsLogDeliveryProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.logGroup != null ? this.logGroup.equals(that.logGroup) : that.logGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A plugin is an AWS resource that contains the code that defines a connector's logic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * CustomPluginProperty customPluginProperty = CustomPluginProperty.builder()
     *         .customPluginArn("customPluginArn")
     *         .revision(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.CustomPluginProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPluginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPluginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the custom plugin.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCustomPluginArn();

        /**
         * The revision of the custom plugin.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRevision();

        /**
         * @return a {@link Builder} of {@link CustomPluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPluginProperty> {
            java.lang.String customPluginArn;
            java.lang.Number revision;

            /**
             * Sets the value of {@link CustomPluginProperty#getCustomPluginArn}
             * @param customPluginArn The Amazon Resource Name (ARN) of the custom plugin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPluginArn(java.lang.String customPluginArn) {
                this.customPluginArn = customPluginArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomPluginProperty#getRevision}
             * @param revision The revision of the custom plugin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.Number revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPluginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPluginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPluginProperty {
            private final java.lang.String customPluginArn;
            private final java.lang.Number revision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customPluginArn = software.amazon.jsii.Kernel.get(this, "customPluginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customPluginArn = java.util.Objects.requireNonNull(builder.customPluginArn, "customPluginArn is required");
                this.revision = java.util.Objects.requireNonNull(builder.revision, "revision is required");
            }

            @Override
            public final java.lang.String getCustomPluginArn() {
                return this.customPluginArn;
            }

            @Override
            public final java.lang.Number getRevision() {
                return this.revision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customPluginArn", om.valueToTree(this.getCustomPluginArn()));
                data.set("revision", om.valueToTree(this.getRevision()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.CustomPluginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPluginProperty.Jsii$Proxy that = (CustomPluginProperty.Jsii$Proxy) o;

                if (!customPluginArn.equals(that.customPluginArn)) return false;
                return this.revision.equals(that.revision);
            }

            @Override
            public final int hashCode() {
                int result = this.customPluginArn.hashCode();
                result = 31 * result + (this.revision.hashCode());
                return result;
            }
        }
    }
    /**
     * The settings for delivering logs to Amazon Kinesis Data Firehose.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * FirehoseLogDeliveryProperty firehoseLogDeliveryProperty = FirehoseLogDeliveryProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .deliveryStream("deliveryStream")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.FirehoseLogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(FirehoseLogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirehoseLogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStream() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirehoseLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirehoseLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirehoseLogDeliveryProperty> {
            java.lang.Object enabled;
            java.lang.String deliveryStream;

            /**
             * Sets the value of {@link FirehoseLogDeliveryProperty#getEnabled}
             * @param enabled Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseLogDeliveryProperty#getEnabled}
             * @param enabled Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseLogDeliveryProperty#getDeliveryStream}
             * @param deliveryStream The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStream(java.lang.String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirehoseLogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirehoseLogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirehoseLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseLogDeliveryProperty {
            private final java.lang.Object enabled;
            private final java.lang.String deliveryStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deliveryStream = software.amazon.jsii.Kernel.get(this, "deliveryStream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.deliveryStream = builder.deliveryStream;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getDeliveryStream() {
                return this.deliveryStream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getDeliveryStream() != null) {
                    data.set("deliveryStream", om.valueToTree(this.getDeliveryStream()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.FirehoseLogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirehoseLogDeliveryProperty.Jsii$Proxy that = (FirehoseLogDeliveryProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.deliveryStream != null ? this.deliveryStream.equals(that.deliveryStream) : that.deliveryStream == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.deliveryStream != null ? this.deliveryStream.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The client authentication information used in order to authenticate with the Apache Kafka cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * KafkaClusterClientAuthenticationProperty kafkaClusterClientAuthenticationProperty = KafkaClusterClientAuthenticationProperty.builder()
     *         .authenticationType("authenticationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaClusterClientAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaClusterClientAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of client authentication used to connect to the Apache Kafka cluster.
         * <p>
         * Value NONE means that no client authentication is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * @return a {@link Builder} of {@link KafkaClusterClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaClusterClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaClusterClientAuthenticationProperty> {
            java.lang.String authenticationType;

            /**
             * Sets the value of {@link KafkaClusterClientAuthenticationProperty#getAuthenticationType}
             * @param authenticationType The type of client authentication used to connect to the Apache Kafka cluster. This parameter is required.
             *                           Value NONE means that no client authentication is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaClusterClientAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaClusterClientAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaClusterClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaClusterClientAuthenticationProperty {
            private final java.lang.String authenticationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaClusterClientAuthenticationProperty.Jsii$Proxy that = (KafkaClusterClientAuthenticationProperty.Jsii$Proxy) o;

                return this.authenticationType.equals(that.authenticationType);
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                return result;
            }
        }
    }
    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * KafkaClusterEncryptionInTransitProperty kafkaClusterEncryptionInTransitProperty = KafkaClusterEncryptionInTransitProperty.builder()
     *         .encryptionType("encryptionType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaClusterEncryptionInTransitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaClusterEncryptionInTransitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of encryption in transit to the Apache Kafka cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * @return a {@link Builder} of {@link KafkaClusterEncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaClusterEncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaClusterEncryptionInTransitProperty> {
            java.lang.String encryptionType;

            /**
             * Sets the value of {@link KafkaClusterEncryptionInTransitProperty#getEncryptionType}
             * @param encryptionType The type of encryption in transit to the Apache Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaClusterEncryptionInTransitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaClusterEncryptionInTransitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaClusterEncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaClusterEncryptionInTransitProperty {
            private final java.lang.String encryptionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = software.amazon.jsii.Kernel.get(this, "encryptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(builder.encryptionType, "encryptionType is required");
            }

            @Override
            public final java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaClusterEncryptionInTransitProperty.Jsii$Proxy that = (KafkaClusterEncryptionInTransitProperty.Jsii$Proxy) o;

                return this.encryptionType.equals(that.encryptionType);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionType.hashCode();
                return result;
            }
        }
    }
    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * KafkaClusterProperty kafkaClusterProperty = KafkaClusterProperty.builder()
     *         .apacheKafkaCluster(ApacheKafkaClusterProperty.builder()
     *                 .bootstrapServers("bootstrapServers")
     *                 .vpc(VpcProperty.builder()
     *                         .securityGroups(List.of("securityGroups"))
     *                         .subnets(List.of("subnets"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaClusterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaClusterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Apache Kafka cluster to which the connector is connected.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getApacheKafkaCluster();

        /**
         * @return a {@link Builder} of {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaClusterProperty> {
            java.lang.Object apacheKafkaCluster;

            /**
             * Sets the value of {@link KafkaClusterProperty#getApacheKafkaCluster}
             * @param apacheKafkaCluster The Apache Kafka cluster to which the connector is connected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apacheKafkaCluster(software.amazon.awscdk.services.kafkaconnect.CfnConnector.ApacheKafkaClusterProperty apacheKafkaCluster) {
                this.apacheKafkaCluster = apacheKafkaCluster;
                return this;
            }

            /**
             * Sets the value of {@link KafkaClusterProperty#getApacheKafkaCluster}
             * @param apacheKafkaCluster The Apache Kafka cluster to which the connector is connected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apacheKafkaCluster(software.amazon.awscdk.IResolvable apacheKafkaCluster) {
                this.apacheKafkaCluster = apacheKafkaCluster;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaClusterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaClusterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaClusterProperty {
            private final java.lang.Object apacheKafkaCluster;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apacheKafkaCluster = software.amazon.jsii.Kernel.get(this, "apacheKafkaCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apacheKafkaCluster = java.util.Objects.requireNonNull(builder.apacheKafkaCluster, "apacheKafkaCluster is required");
            }

            @Override
            public final java.lang.Object getApacheKafkaCluster() {
                return this.apacheKafkaCluster;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apacheKafkaCluster", om.valueToTree(this.getApacheKafkaCluster()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaClusterProperty.Jsii$Proxy that = (KafkaClusterProperty.Jsii$Proxy) o;

                return this.apacheKafkaCluster.equals(that.apacheKafkaCluster);
            }

            @Override
            public final int hashCode() {
                int result = this.apacheKafkaCluster.hashCode();
                return result;
            }
        }
    }
    /**
     * Details about log delivery.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * LogDeliveryProperty logDeliveryProperty = LogDeliveryProperty.builder()
     *         .workerLogDelivery(WorkerLogDeliveryProperty.builder()
     *                 .cloudWatchLogs(CloudWatchLogsLogDeliveryProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .logGroup("logGroup")
     *                         .build())
     *                 .firehose(FirehoseLogDeliveryProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .deliveryStream("deliveryStream")
     *                         .build())
     *                 .s3(S3LogDeliveryProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .bucket("bucket")
     *                         .prefix("prefix")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.LogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The workers can send worker logs to different destination types.
         * <p>
         * This configuration specifies the details of these destinations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWorkerLogDelivery();

        /**
         * @return a {@link Builder} of {@link LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDeliveryProperty> {
            java.lang.Object workerLogDelivery;

            /**
             * Sets the value of {@link LogDeliveryProperty#getWorkerLogDelivery}
             * @param workerLogDelivery The workers can send worker logs to different destination types. This parameter is required.
             *                          This configuration specifies the details of these destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerLogDelivery(software.amazon.awscdk.services.kafkaconnect.CfnConnector.WorkerLogDeliveryProperty workerLogDelivery) {
                this.workerLogDelivery = workerLogDelivery;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryProperty#getWorkerLogDelivery}
             * @param workerLogDelivery The workers can send worker logs to different destination types. This parameter is required.
             *                          This configuration specifies the details of these destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerLogDelivery(software.amazon.awscdk.IResolvable workerLogDelivery) {
                this.workerLogDelivery = workerLogDelivery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDeliveryProperty {
            private final java.lang.Object workerLogDelivery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workerLogDelivery = software.amazon.jsii.Kernel.get(this, "workerLogDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workerLogDelivery = java.util.Objects.requireNonNull(builder.workerLogDelivery, "workerLogDelivery is required");
            }

            @Override
            public final java.lang.Object getWorkerLogDelivery() {
                return this.workerLogDelivery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workerLogDelivery", om.valueToTree(this.getWorkerLogDelivery()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.LogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDeliveryProperty.Jsii$Proxy that = (LogDeliveryProperty.Jsii$Proxy) o;

                return this.workerLogDelivery.equals(that.workerLogDelivery);
            }

            @Override
            public final int hashCode() {
                int result = this.workerLogDelivery.hashCode();
                return result;
            }
        }
    }
    /**
     * A plugin is an AWS resource that contains the code that defines your connector logic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * PluginProperty pluginProperty = PluginProperty.builder()
     *         .customPlugin(CustomPluginProperty.builder()
     *                 .customPluginArn("customPluginArn")
     *                 .revision(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.PluginProperty")
    @software.amazon.jsii.Jsii.Proxy(PluginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PluginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about a custom plugin.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCustomPlugin();

        /**
         * @return a {@link Builder} of {@link PluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PluginProperty> {
            java.lang.Object customPlugin;

            /**
             * Sets the value of {@link PluginProperty#getCustomPlugin}
             * @param customPlugin Details about a custom plugin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPlugin(software.amazon.awscdk.services.kafkaconnect.CfnConnector.CustomPluginProperty customPlugin) {
                this.customPlugin = customPlugin;
                return this;
            }

            /**
             * Sets the value of {@link PluginProperty#getCustomPlugin}
             * @param customPlugin Details about a custom plugin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPlugin(software.amazon.awscdk.IResolvable customPlugin) {
                this.customPlugin = customPlugin;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PluginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PluginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PluginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PluginProperty {
            private final java.lang.Object customPlugin;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customPlugin = software.amazon.jsii.Kernel.get(this, "customPlugin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customPlugin = java.util.Objects.requireNonNull(builder.customPlugin, "customPlugin is required");
            }

            @Override
            public final java.lang.Object getCustomPlugin() {
                return this.customPlugin;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customPlugin", om.valueToTree(this.getCustomPlugin()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.PluginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PluginProperty.Jsii$Proxy that = (PluginProperty.Jsii$Proxy) o;

                return this.customPlugin.equals(that.customPlugin);
            }

            @Override
            public final int hashCode() {
                int result = this.customPlugin.hashCode();
                return result;
            }
        }
    }
    /**
     * Details about a connector's provisioned capacity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * ProvisionedCapacityProperty provisionedCapacityProperty = ProvisionedCapacityProperty.builder()
     *         .workerCount(123)
     *         // the properties below are optional
     *         .mcuCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.ProvisionedCapacityProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedCapacityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedCapacityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of workers that are allocated to the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWorkerCount();

        /**
         * The number of microcontroller units (MCUs) allocated to each connector worker.
         * <p>
         * The valid values are 1,2,4,8.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMcuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProvisionedCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedCapacityProperty> {
            java.lang.Number workerCount;
            java.lang.Number mcuCount;

            /**
             * Sets the value of {@link ProvisionedCapacityProperty#getWorkerCount}
             * @param workerCount The number of workers that are allocated to the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerCount(java.lang.Number workerCount) {
                this.workerCount = workerCount;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedCapacityProperty#getMcuCount}
             * @param mcuCount The number of microcontroller units (MCUs) allocated to each connector worker.
             *                 The valid values are 1,2,4,8.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcuCount(java.lang.Number mcuCount) {
                this.mcuCount = mcuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedCapacityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedCapacityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedCapacityProperty {
            private final java.lang.Number workerCount;
            private final java.lang.Number mcuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workerCount = software.amazon.jsii.Kernel.get(this, "workerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mcuCount = software.amazon.jsii.Kernel.get(this, "mcuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workerCount = java.util.Objects.requireNonNull(builder.workerCount, "workerCount is required");
                this.mcuCount = builder.mcuCount;
            }

            @Override
            public final java.lang.Number getWorkerCount() {
                return this.workerCount;
            }

            @Override
            public final java.lang.Number getMcuCount() {
                return this.mcuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workerCount", om.valueToTree(this.getWorkerCount()));
                if (this.getMcuCount() != null) {
                    data.set("mcuCount", om.valueToTree(this.getMcuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.ProvisionedCapacityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedCapacityProperty.Jsii$Proxy that = (ProvisionedCapacityProperty.Jsii$Proxy) o;

                if (!workerCount.equals(that.workerCount)) return false;
                return this.mcuCount != null ? this.mcuCount.equals(that.mcuCount) : that.mcuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.workerCount.hashCode();
                result = 31 * result + (this.mcuCount != null ? this.mcuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about delivering logs to Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * S3LogDeliveryProperty s3LogDeliveryProperty = S3LogDeliveryProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .bucket("bucket")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.S3LogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether connector logs get sent to the specified Amazon S3 destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the S3 bucket that is the destination for log delivery.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The S3 prefix that is the destination for log delivery.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LogDeliveryProperty> {
            java.lang.Object enabled;
            java.lang.String bucket;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3LogDeliveryProperty#getEnabled}
             * @param enabled Specifies whether connector logs get sent to the specified Amazon S3 destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogDeliveryProperty#getEnabled}
             * @param enabled Specifies whether connector logs get sent to the specified Amazon S3 destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogDeliveryProperty#getBucket}
             * @param bucket The name of the S3 bucket that is the destination for log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LogDeliveryProperty#getPrefix}
             * @param prefix The S3 prefix that is the destination for log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LogDeliveryProperty {
            private final java.lang.Object enabled;
            private final java.lang.String bucket;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.bucket = builder.bucket;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.S3LogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LogDeliveryProperty.Jsii$Proxy that = (S3LogDeliveryProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The scale-in policy for the connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * ScaleInPolicyProperty scaleInPolicyProperty = ScaleInPolicyProperty.builder()
     *         .cpuUtilizationPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleInPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScaleInPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScaleInPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getCpuUtilizationPercentage();

        /**
         * @return a {@link Builder} of {@link ScaleInPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScaleInPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScaleInPolicyProperty> {
            java.lang.Number cpuUtilizationPercentage;

            /**
             * Sets the value of {@link ScaleInPolicyProperty#getCpuUtilizationPercentage}
             * @param cpuUtilizationPercentage Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuUtilizationPercentage(java.lang.Number cpuUtilizationPercentage) {
                this.cpuUtilizationPercentage = cpuUtilizationPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScaleInPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScaleInPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScaleInPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScaleInPolicyProperty {
            private final java.lang.Number cpuUtilizationPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuUtilizationPercentage = software.amazon.jsii.Kernel.get(this, "cpuUtilizationPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuUtilizationPercentage = java.util.Objects.requireNonNull(builder.cpuUtilizationPercentage, "cpuUtilizationPercentage is required");
            }

            @Override
            public final java.lang.Number getCpuUtilizationPercentage() {
                return this.cpuUtilizationPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpuUtilizationPercentage", om.valueToTree(this.getCpuUtilizationPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleInPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScaleInPolicyProperty.Jsii$Proxy that = (ScaleInPolicyProperty.Jsii$Proxy) o;

                return this.cpuUtilizationPercentage.equals(that.cpuUtilizationPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.cpuUtilizationPercentage.hashCode();
                return result;
            }
        }
    }
    /**
     * The scale-out policy for the connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * ScaleOutPolicyProperty scaleOutPolicyProperty = ScaleOutPolicyProperty.builder()
     *         .cpuUtilizationPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleOutPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScaleOutPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScaleOutPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU utilization percentage threshold at which you want connector scale out to be triggered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getCpuUtilizationPercentage();

        /**
         * @return a {@link Builder} of {@link ScaleOutPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScaleOutPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScaleOutPolicyProperty> {
            java.lang.Number cpuUtilizationPercentage;

            /**
             * Sets the value of {@link ScaleOutPolicyProperty#getCpuUtilizationPercentage}
             * @param cpuUtilizationPercentage The CPU utilization percentage threshold at which you want connector scale out to be triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuUtilizationPercentage(java.lang.Number cpuUtilizationPercentage) {
                this.cpuUtilizationPercentage = cpuUtilizationPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScaleOutPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScaleOutPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScaleOutPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScaleOutPolicyProperty {
            private final java.lang.Number cpuUtilizationPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuUtilizationPercentage = software.amazon.jsii.Kernel.get(this, "cpuUtilizationPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuUtilizationPercentage = java.util.Objects.requireNonNull(builder.cpuUtilizationPercentage, "cpuUtilizationPercentage is required");
            }

            @Override
            public final java.lang.Number getCpuUtilizationPercentage() {
                return this.cpuUtilizationPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpuUtilizationPercentage", om.valueToTree(this.getCpuUtilizationPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleOutPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScaleOutPolicyProperty.Jsii$Proxy that = (ScaleOutPolicyProperty.Jsii$Proxy) o;

                return this.cpuUtilizationPercentage.equals(that.cpuUtilizationPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.cpuUtilizationPercentage.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the VPC in which the connector resides.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * VpcProperty vpcProperty = VpcProperty.builder()
     *         .securityGroups(List.of("securityGroups"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.VpcProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The security groups for the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroups();

        /**
         * The subnets for the connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcProperty> {
            java.util.List<java.lang.String> securityGroups;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcProperty#getSecurityGroups}
             * @param securityGroups The security groups for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link VpcProperty#getSubnets}
             * @param subnets The subnets for the connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcProperty {
            private final java.util.List<java.lang.String> securityGroups;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroups = java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.VpcProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcProperty.Jsii$Proxy that = (VpcProperty.Jsii$Proxy) o;

                if (!securityGroups.equals(that.securityGroups)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroups.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of the workers, which are the processes that run the connector logic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * WorkerConfigurationProperty workerConfigurationProperty = WorkerConfigurationProperty.builder()
     *         .revision(123)
     *         .workerConfigurationArn("workerConfigurationArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The revision of the worker configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRevision();

        /**
         * The Amazon Resource Name (ARN) of the worker configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkerConfigurationArn();

        /**
         * @return a {@link Builder} of {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkerConfigurationProperty> {
            java.lang.Number revision;
            java.lang.String workerConfigurationArn;

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getRevision}
             * @param revision The revision of the worker configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.Number revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getWorkerConfigurationArn}
             * @param workerConfigurationArn The Amazon Resource Name (ARN) of the worker configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerConfigurationArn(java.lang.String workerConfigurationArn) {
                this.workerConfigurationArn = workerConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerConfigurationProperty {
            private final java.lang.Number revision;
            private final java.lang.String workerConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.workerConfigurationArn = software.amazon.jsii.Kernel.get(this, "workerConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.revision = java.util.Objects.requireNonNull(builder.revision, "revision is required");
                this.workerConfigurationArn = java.util.Objects.requireNonNull(builder.workerConfigurationArn, "workerConfigurationArn is required");
            }

            @Override
            public final java.lang.Number getRevision() {
                return this.revision;
            }

            @Override
            public final java.lang.String getWorkerConfigurationArn() {
                return this.workerConfigurationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("revision", om.valueToTree(this.getRevision()));
                data.set("workerConfigurationArn", om.valueToTree(this.getWorkerConfigurationArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkerConfigurationProperty.Jsii$Proxy that = (WorkerConfigurationProperty.Jsii$Proxy) o;

                if (!revision.equals(that.revision)) return false;
                return this.workerConfigurationArn.equals(that.workerConfigurationArn);
            }

            @Override
            public final int hashCode() {
                int result = this.revision.hashCode();
                result = 31 * result + (this.workerConfigurationArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Workers can send worker logs to different destination types.
     * <p>
     * This configuration specifies the details of these destinations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kafkaconnect.*;
     * WorkerLogDeliveryProperty workerLogDeliveryProperty = WorkerLogDeliveryProperty.builder()
     *         .cloudWatchLogs(CloudWatchLogsLogDeliveryProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .logGroup("logGroup")
     *                 .build())
     *         .firehose(FirehoseLogDeliveryProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .deliveryStream("deliveryStream")
     *                 .build())
     *         .s3(S3LogDeliveryProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .bucket("bucket")
     *                 .prefix("prefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerLogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkerLogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkerLogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about delivering logs to Amazon CloudWatch Logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogs() {
            return null;
        }

        /**
         * Details about delivering logs to Amazon Kinesis Data Firehose.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirehose() {
            return null;
        }

        /**
         * Details about delivering logs to Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkerLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkerLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkerLogDeliveryProperty> {
            java.lang.Object cloudWatchLogs;
            java.lang.Object firehose;
            java.lang.Object s3;

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Details about delivering logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.services.kafkaconnect.CfnConnector.CloudWatchLogsLogDeliveryProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Details about delivering logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getFirehose}
             * @param firehose Details about delivering logs to Amazon Kinesis Data Firehose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.services.kafkaconnect.CfnConnector.FirehoseLogDeliveryProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getFirehose}
             * @param firehose Details about delivering logs to Amazon Kinesis Data Firehose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getS3}
             * @param s3 Details about delivering logs to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.kafkaconnect.CfnConnector.S3LogDeliveryProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link WorkerLogDeliveryProperty#getS3}
             * @param s3 Details about delivering logs to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkerLogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkerLogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkerLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerLogDeliveryProperty {
            private final java.lang.Object cloudWatchLogs;
            private final java.lang.Object firehose;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogs = software.amazon.jsii.Kernel.get(this, "cloudWatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firehose = software.amazon.jsii.Kernel.get(this, "firehose", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogs = builder.cloudWatchLogs;
                this.firehose = builder.firehose;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getCloudWatchLogs() {
                return this.cloudWatchLogs;
            }

            @Override
            public final java.lang.Object getFirehose() {
                return this.firehose;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogs() != null) {
                    data.set("cloudWatchLogs", om.valueToTree(this.getCloudWatchLogs()));
                }
                if (this.getFirehose() != null) {
                    data.set("firehose", om.valueToTree(this.getFirehose()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerLogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkerLogDeliveryProperty.Jsii$Proxy that = (WorkerLogDeliveryProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogs != null ? !this.cloudWatchLogs.equals(that.cloudWatchLogs) : that.cloudWatchLogs != null) return false;
                if (this.firehose != null ? !this.firehose.equals(that.firehose) : that.firehose != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogs != null ? this.cloudWatchLogs.hashCode() : 0;
                result = 31 * result + (this.firehose != null ? this.firehose.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kafkaconnect.CfnConnector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kafkaconnect.CfnConnector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps.Builder();
        }

        /**
         * The connector's compute capacity settings.
         * <p>
         * @return {@code this}
         * @param capacity The connector's compute capacity settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.CapacityProperty capacity) {
            this.props.capacity(capacity);
            return this;
        }
        /**
         * The connector's compute capacity settings.
         * <p>
         * @return {@code this}
         * @param capacity The connector's compute capacity settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final software.amazon.awscdk.IResolvable capacity) {
            this.props.capacity(capacity);
            return this;
        }

        /**
         * The configuration of the connector.
         * <p>
         * @return {@code this}
         * @param connectorConfiguration The configuration of the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorConfiguration(final software.amazon.awscdk.IResolvable connectorConfiguration) {
            this.props.connectorConfiguration(connectorConfiguration);
            return this;
        }
        /**
         * The configuration of the connector.
         * <p>
         * @return {@code this}
         * @param connectorConfiguration The configuration of the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorConfiguration(final java.util.Map<java.lang.String, java.lang.String> connectorConfiguration) {
            this.props.connectorConfiguration(connectorConfiguration);
            return this;
        }

        /**
         * The name of the connector.
         * <p>
         * @return {@code this}
         * @param connectorName The name of the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorName(final java.lang.String connectorName) {
            this.props.connectorName(connectorName);
            return this;
        }

        /**
         * The details of the Apache Kafka cluster to which the connector is connected.
         * <p>
         * @return {@code this}
         * @param kafkaCluster The details of the Apache Kafka cluster to which the connector is connected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaCluster(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterProperty kafkaCluster) {
            this.props.kafkaCluster(kafkaCluster);
            return this;
        }
        /**
         * The details of the Apache Kafka cluster to which the connector is connected.
         * <p>
         * @return {@code this}
         * @param kafkaCluster The details of the Apache Kafka cluster to which the connector is connected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaCluster(final software.amazon.awscdk.IResolvable kafkaCluster) {
            this.props.kafkaCluster(kafkaCluster);
            return this;
        }

        /**
         * The type of client authentication used to connect to the Apache Kafka cluster.
         * <p>
         * The value is NONE when no client authentication is used.
         * <p>
         * @return {@code this}
         * @param kafkaClusterClientAuthentication The type of client authentication used to connect to the Apache Kafka cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterClientAuthentication(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty kafkaClusterClientAuthentication) {
            this.props.kafkaClusterClientAuthentication(kafkaClusterClientAuthentication);
            return this;
        }
        /**
         * The type of client authentication used to connect to the Apache Kafka cluster.
         * <p>
         * The value is NONE when no client authentication is used.
         * <p>
         * @return {@code this}
         * @param kafkaClusterClientAuthentication The type of client authentication used to connect to the Apache Kafka cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterClientAuthentication(final software.amazon.awscdk.IResolvable kafkaClusterClientAuthentication) {
            this.props.kafkaClusterClientAuthentication(kafkaClusterClientAuthentication);
            return this;
        }

        /**
         * Details of encryption in transit to the Apache Kafka cluster.
         * <p>
         * @return {@code this}
         * @param kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterEncryptionInTransit(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty kafkaClusterEncryptionInTransit) {
            this.props.kafkaClusterEncryptionInTransit(kafkaClusterEncryptionInTransit);
            return this;
        }
        /**
         * Details of encryption in transit to the Apache Kafka cluster.
         * <p>
         * @return {@code this}
         * @param kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterEncryptionInTransit(final software.amazon.awscdk.IResolvable kafkaClusterEncryptionInTransit) {
            this.props.kafkaClusterEncryptionInTransit(kafkaClusterEncryptionInTransit);
            return this;
        }

        /**
         * The version of Kafka Connect.
         * <p>
         * It has to be compatible with both the Apache Kafka cluster's version and the plugins.
         * <p>
         * @return {@code this}
         * @param kafkaConnectVersion The version of Kafka Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaConnectVersion(final java.lang.String kafkaConnectVersion) {
            this.props.kafkaConnectVersion(kafkaConnectVersion);
            return this;
        }

        /**
         * Specifies which plugin to use for the connector.
         * <p>
         * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
         * <p>
         * @return {@code this}
         * @param plugins Specifies which plugin to use for the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(final software.amazon.awscdk.IResolvable plugins) {
            this.props.plugins(plugins);
            return this;
        }
        /**
         * Specifies which plugin to use for the connector.
         * <p>
         * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
         * <p>
         * @return {@code this}
         * @param plugins Specifies which plugin to use for the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(final java.util.List<? extends java.lang.Object> plugins) {
            this.props.plugins(plugins);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
         * <p>
         * @return {@code this}
         * @param serviceExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRoleArn(final java.lang.String serviceExecutionRoleArn) {
            this.props.serviceExecutionRoleArn(serviceExecutionRoleArn);
            return this;
        }

        /**
         * The description of the connector.
         * <p>
         * @return {@code this}
         * @param connectorDescription The description of the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDescription(final java.lang.String connectorDescription) {
            this.props.connectorDescription(connectorDescription);
            return this;
        }

        /**
         * The settings for delivering connector logs to Amazon CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @param logDelivery The settings for delivering connector logs to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDelivery(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.LogDeliveryProperty logDelivery) {
            this.props.logDelivery(logDelivery);
            return this;
        }
        /**
         * The settings for delivering connector logs to Amazon CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @param logDelivery The settings for delivering connector logs to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDelivery(final software.amazon.awscdk.IResolvable logDelivery) {
            this.props.logDelivery(logDelivery);
            return this;
        }

        /**
         * The worker configurations that are in use with the connector.
         * <p>
         * @return {@code this}
         * @param workerConfiguration The worker configurations that are in use with the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfiguration(final software.amazon.awscdk.services.kafkaconnect.CfnConnector.WorkerConfigurationProperty workerConfiguration) {
            this.props.workerConfiguration(workerConfiguration);
            return this;
        }
        /**
         * The worker configurations that are in use with the connector.
         * <p>
         * @return {@code this}
         * @param workerConfiguration The worker configurations that are in use with the connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfiguration(final software.amazon.awscdk.IResolvable workerConfiguration) {
            this.props.workerConfiguration(workerConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kafkaconnect.CfnConnector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kafkaconnect.CfnConnector build() {
            return new software.amazon.awscdk.services.kafkaconnect.CfnConnector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
