package software.amazon.awscdk.services.iotfleetwise;

/**
 * A CloudFormation `AWS::IoTFleetWise::DecoderManifest`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * Object networkInterfaces;
 * Object signalDecoders;
 * CfnDecoderManifest cfnDecoderManifest = CfnDecoderManifest.Builder.create(this, "MyCfnDecoderManifest")
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .networkInterfaces(List.of(networkInterfaces))
 *         .signalDecoders(List.of(signalDecoders))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.613Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest")
public class CfnDecoderManifest extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTFleetWise::DecoderManifest`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDecoderManifest(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn() {
        return software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelManifestArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelManifestArn", java.util.Objects.requireNonNull(value, "modelManifestArn is required"));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
            }
        }
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSignalDecoders() {
        return software.amazon.jsii.Kernel.get(this, "signalDecoders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
            }
        }
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Status`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Status`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanInterfaceProperty canInterfaceProperty = CanInterfaceProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .protocolName("protocolName")
     *         .protocolVersion("protocolVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(CanInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.CanInterfaceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnDecoderManifest.CanInterfaceProperty.ProtocolName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolName() {
            return null;
        }

        /**
         * `CfnDecoderManifest.CanInterfaceProperty.ProtocolVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanInterfaceProperty> {
            java.lang.String name;
            java.lang.String protocolName;
            java.lang.String protocolVersion;

            /**
             * Sets the value of {@link CanInterfaceProperty#getName}
             * @param name `CfnDecoderManifest.CanInterfaceProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolName}
             * @param protocolName `CfnDecoderManifest.CanInterfaceProperty.ProtocolName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolName(java.lang.String protocolName) {
                this.protocolName = protocolName;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolVersion}
             * @param protocolVersion `CfnDecoderManifest.CanInterfaceProperty.ProtocolVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolVersion(java.lang.String protocolVersion) {
                this.protocolVersion = protocolVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String protocolName;
            private final java.lang.String protocolVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolName = software.amazon.jsii.Kernel.get(this, "protocolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolVersion = software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.protocolName = builder.protocolName;
                this.protocolVersion = builder.protocolVersion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocolName() {
                return this.protocolName;
            }

            @Override
            public final java.lang.String getProtocolVersion() {
                return this.protocolVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getProtocolName() != null) {
                    data.set("protocolName", om.valueToTree(this.getProtocolName()));
                }
                if (this.getProtocolVersion() != null) {
                    data.set("protocolVersion", om.valueToTree(this.getProtocolVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanInterfaceProperty.Jsii$Proxy that = (CanInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.protocolName != null ? !this.protocolName.equals(that.protocolName) : that.protocolName != null) return false;
                return this.protocolVersion != null ? this.protocolVersion.equals(that.protocolVersion) : that.protocolVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.protocolName != null ? this.protocolName.hashCode() : 0);
                result = 31 * result + (this.protocolVersion != null ? this.protocolVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanNetworkInterfaceProperty canNetworkInterfaceProperty = CanNetworkInterfaceProperty.builder()
     *         .canInterface(CanInterfaceProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .protocolName("protocolName")
     *                 .protocolVersion("protocolVersion")
     *                 .build())
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanNetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(CanNetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanNetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.CanInterface`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCanInterface();

        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanNetworkInterfaceProperty> {
            java.lang.Object canInterface;
            java.lang.String interfaceId;
            java.lang.String type;

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getCanInterface}
             * @param canInterface `CfnDecoderManifest.CanNetworkInterfaceProperty.CanInterface`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanInterfaceProperty canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getCanInterface}
             * @param canInterface `CfnDecoderManifest.CanNetworkInterfaceProperty.CanInterface`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.IResolvable canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.CanNetworkInterfaceProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link CanNetworkInterfaceProperty#getType}
             * @param type `CfnDecoderManifest.CanNetworkInterfaceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanNetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanNetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanNetworkInterfaceProperty {
            private final java.lang.Object canInterface;
            private final java.lang.String interfaceId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.canInterface = software.amazon.jsii.Kernel.get(this, "canInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.canInterface = java.util.Objects.requireNonNull(builder.canInterface, "canInterface is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getCanInterface() {
                return this.canInterface;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("canInterface", om.valueToTree(this.getCanInterface()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanNetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanNetworkInterfaceProperty.Jsii$Proxy that = (CanNetworkInterfaceProperty.Jsii$Proxy) o;

                if (!canInterface.equals(that.canInterface)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.canInterface.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object factor;
     * Object isBigEndian;
     * Object isSigned;
     * Object length;
     * Object messageId;
     * Object offset;
     * Object startBit;
     * CanSignalDecoderProperty canSignalDecoderProperty = CanSignalDecoderProperty.builder()
     *         .canSignal(CanSignalProperty.builder()
     *                 .factor(factor)
     *                 .isBigEndian(isBigEndian)
     *                 .isSigned(isSigned)
     *                 .length(length)
     *                 .messageId(messageId)
     *                 .offset(offset)
     *                 .startBit(startBit)
     *                 // the properties below are optional
     *                 .name("name")
     *                 .build())
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalDecoderProperty")
    @software.amazon.jsii.Jsii.Proxy(CanSignalDecoderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanSignalDecoderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.CanSignal`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCanSignal();

        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.FullyQualifiedName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanSignalDecoderProperty> {
            java.lang.Object canSignal;
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.String type;

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getCanSignal}
             * @param canSignal `CfnDecoderManifest.CanSignalDecoderProperty.CanSignal`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanSignalProperty canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getCanSignal}
             * @param canSignal `CfnDecoderManifest.CanSignalDecoderProperty.CanSignal`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.IResolvable canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getFullyQualifiedName}
             * @param fullyQualifiedName `CfnDecoderManifest.CanSignalDecoderProperty.FullyQualifiedName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.CanSignalDecoderProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalDecoderProperty#getType}
             * @param type `CfnDecoderManifest.CanSignalDecoderProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanSignalDecoderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanSignalDecoderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanSignalDecoderProperty {
            private final java.lang.Object canSignal;
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.canSignal = software.amazon.jsii.Kernel.get(this, "canSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.canSignal = java.util.Objects.requireNonNull(builder.canSignal, "canSignal is required");
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getCanSignal() {
                return this.canSignal;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("canSignal", om.valueToTree(this.getCanSignal()));
                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalDecoderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanSignalDecoderProperty.Jsii$Proxy that = (CanSignalDecoderProperty.Jsii$Proxy) o;

                if (!canSignal.equals(that.canSignal)) return false;
                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.canSignal.hashCode();
                result = 31 * result + (this.fullyQualifiedName.hashCode());
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object factor;
     * Object isBigEndian;
     * Object isSigned;
     * Object length;
     * Object messageId;
     * Object offset;
     * Object startBit;
     * CanSignalProperty canSignalProperty = CanSignalProperty.builder()
     *         .factor(factor)
     *         .isBigEndian(isBigEndian)
     *         .isSigned(isSigned)
     *         .length(length)
     *         .messageId(messageId)
     *         .offset(offset)
     *         .startBit(startBit)
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(CanSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.CanSignalProperty.Factor`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFactor();

        /**
         * `CfnDecoderManifest.CanSignalProperty.IsBigEndian`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsBigEndian();

        /**
         * `CfnDecoderManifest.CanSignalProperty.IsSigned`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsSigned();

        /**
         * `CfnDecoderManifest.CanSignalProperty.Length`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLength();

        /**
         * `CfnDecoderManifest.CanSignalProperty.MessageId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageId();

        /**
         * `CfnDecoderManifest.CanSignalProperty.Offset`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOffset();

        /**
         * `CfnDecoderManifest.CanSignalProperty.StartBit`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStartBit();

        /**
         * `CfnDecoderManifest.CanSignalProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanSignalProperty> {
            java.lang.Object factor;
            java.lang.Object isBigEndian;
            java.lang.Object isSigned;
            java.lang.Object length;
            java.lang.Object messageId;
            java.lang.Object offset;
            java.lang.Object startBit;
            java.lang.String name;

            /**
             * Sets the value of {@link CanSignalProperty#getFactor}
             * @param factor `CfnDecoderManifest.CanSignalProperty.Factor`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder factor(java.lang.Object factor) {
                this.factor = factor;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsBigEndian}
             * @param isBigEndian `CfnDecoderManifest.CanSignalProperty.IsBigEndian`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isBigEndian(java.lang.Object isBigEndian) {
                this.isBigEndian = isBigEndian;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsSigned}
             * @param isSigned `CfnDecoderManifest.CanSignalProperty.IsSigned`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(java.lang.Object isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getLength}
             * @param length `CfnDecoderManifest.CanSignalProperty.Length`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder length(java.lang.Object length) {
                this.length = length;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getMessageId}
             * @param messageId `CfnDecoderManifest.CanSignalProperty.MessageId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageId(java.lang.Object messageId) {
                this.messageId = messageId;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getOffset}
             * @param offset `CfnDecoderManifest.CanSignalProperty.Offset`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.Object offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getStartBit}
             * @param startBit `CfnDecoderManifest.CanSignalProperty.StartBit`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startBit(java.lang.Object startBit) {
                this.startBit = startBit;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getName}
             * @param name `CfnDecoderManifest.CanSignalProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanSignalProperty {
            private final java.lang.Object factor;
            private final java.lang.Object isBigEndian;
            private final java.lang.Object isSigned;
            private final java.lang.Object length;
            private final java.lang.Object messageId;
            private final java.lang.Object offset;
            private final java.lang.Object startBit;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.factor = software.amazon.jsii.Kernel.get(this, "factor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isBigEndian = software.amazon.jsii.Kernel.get(this, "isBigEndian", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isSigned = software.amazon.jsii.Kernel.get(this, "isSigned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.length = software.amazon.jsii.Kernel.get(this, "length", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageId = software.amazon.jsii.Kernel.get(this, "messageId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startBit = software.amazon.jsii.Kernel.get(this, "startBit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.factor = java.util.Objects.requireNonNull(builder.factor, "factor is required");
                this.isBigEndian = java.util.Objects.requireNonNull(builder.isBigEndian, "isBigEndian is required");
                this.isSigned = java.util.Objects.requireNonNull(builder.isSigned, "isSigned is required");
                this.length = java.util.Objects.requireNonNull(builder.length, "length is required");
                this.messageId = java.util.Objects.requireNonNull(builder.messageId, "messageId is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.startBit = java.util.Objects.requireNonNull(builder.startBit, "startBit is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getFactor() {
                return this.factor;
            }

            @Override
            public final java.lang.Object getIsBigEndian() {
                return this.isBigEndian;
            }

            @Override
            public final java.lang.Object getIsSigned() {
                return this.isSigned;
            }

            @Override
            public final java.lang.Object getLength() {
                return this.length;
            }

            @Override
            public final java.lang.Object getMessageId() {
                return this.messageId;
            }

            @Override
            public final java.lang.Object getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.Object getStartBit() {
                return this.startBit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("factor", om.valueToTree(this.getFactor()));
                data.set("isBigEndian", om.valueToTree(this.getIsBigEndian()));
                data.set("isSigned", om.valueToTree(this.getIsSigned()));
                data.set("length", om.valueToTree(this.getLength()));
                data.set("messageId", om.valueToTree(this.getMessageId()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("startBit", om.valueToTree(this.getStartBit()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanSignalProperty.Jsii$Proxy that = (CanSignalProperty.Jsii$Proxy) o;

                if (!factor.equals(that.factor)) return false;
                if (!isBigEndian.equals(that.isBigEndian)) return false;
                if (!isSigned.equals(that.isSigned)) return false;
                if (!length.equals(that.length)) return false;
                if (!messageId.equals(that.messageId)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!startBit.equals(that.startBit)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.factor.hashCode();
                result = 31 * result + (this.isBigEndian.hashCode());
                result = 31 * result + (this.isSigned.hashCode());
                result = 31 * result + (this.length.hashCode());
                result = 31 * result + (this.messageId.hashCode());
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.startBit.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object dtcRequestIntervalSeconds;
     * Object hasTransmissionEcu;
     * Object pidRequestIntervalSeconds;
     * Object requestMessageId;
     * Object useExtendedIds;
     * ObdInterfaceProperty obdInterfaceProperty = ObdInterfaceProperty.builder()
     *         .name("name")
     *         .requestMessageId(requestMessageId)
     *         // the properties below are optional
     *         .dtcRequestIntervalSeconds(dtcRequestIntervalSeconds)
     *         .hasTransmissionEcu(hasTransmissionEcu)
     *         .obdStandard("obdStandard")
     *         .pidRequestIntervalSeconds(pidRequestIntervalSeconds)
     *         .useExtendedIds(useExtendedIds)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.RequestMessageId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRequestMessageId();

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.DtcRequestIntervalSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDtcRequestIntervalSeconds() {
            return null;
        }

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.HasTransmissionEcu`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHasTransmissionEcu() {
            return null;
        }

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.ObdStandard`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObdStandard() {
            return null;
        }

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.PidRequestIntervalSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPidRequestIntervalSeconds() {
            return null;
        }

        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.UseExtendedIds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseExtendedIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdInterfaceProperty> {
            java.lang.String name;
            java.lang.Object requestMessageId;
            java.lang.Object dtcRequestIntervalSeconds;
            java.lang.Object hasTransmissionEcu;
            java.lang.String obdStandard;
            java.lang.Object pidRequestIntervalSeconds;
            java.lang.Object useExtendedIds;

            /**
             * Sets the value of {@link ObdInterfaceProperty#getName}
             * @param name `CfnDecoderManifest.ObdInterfaceProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getRequestMessageId}
             * @param requestMessageId `CfnDecoderManifest.ObdInterfaceProperty.RequestMessageId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestMessageId(java.lang.Object requestMessageId) {
                this.requestMessageId = requestMessageId;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getDtcRequestIntervalSeconds}
             * @param dtcRequestIntervalSeconds `CfnDecoderManifest.ObdInterfaceProperty.DtcRequestIntervalSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dtcRequestIntervalSeconds(java.lang.Object dtcRequestIntervalSeconds) {
                this.dtcRequestIntervalSeconds = dtcRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getHasTransmissionEcu}
             * @param hasTransmissionEcu `CfnDecoderManifest.ObdInterfaceProperty.HasTransmissionEcu`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hasTransmissionEcu(java.lang.Object hasTransmissionEcu) {
                this.hasTransmissionEcu = hasTransmissionEcu;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getObdStandard}
             * @param obdStandard `CfnDecoderManifest.ObdInterfaceProperty.ObdStandard`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdStandard(java.lang.String obdStandard) {
                this.obdStandard = obdStandard;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getPidRequestIntervalSeconds}
             * @param pidRequestIntervalSeconds `CfnDecoderManifest.ObdInterfaceProperty.PidRequestIntervalSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidRequestIntervalSeconds(java.lang.Object pidRequestIntervalSeconds) {
                this.pidRequestIntervalSeconds = pidRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getUseExtendedIds}
             * @param useExtendedIds `CfnDecoderManifest.ObdInterfaceProperty.UseExtendedIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExtendedIds(java.lang.Object useExtendedIds) {
                this.useExtendedIds = useExtendedIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.Object requestMessageId;
            private final java.lang.Object dtcRequestIntervalSeconds;
            private final java.lang.Object hasTransmissionEcu;
            private final java.lang.String obdStandard;
            private final java.lang.Object pidRequestIntervalSeconds;
            private final java.lang.Object useExtendedIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestMessageId = software.amazon.jsii.Kernel.get(this, "requestMessageId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dtcRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "dtcRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hasTransmissionEcu = software.amazon.jsii.Kernel.get(this, "hasTransmissionEcu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obdStandard = software.amazon.jsii.Kernel.get(this, "obdStandard", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "pidRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useExtendedIds = software.amazon.jsii.Kernel.get(this, "useExtendedIds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.requestMessageId = java.util.Objects.requireNonNull(builder.requestMessageId, "requestMessageId is required");
                this.dtcRequestIntervalSeconds = builder.dtcRequestIntervalSeconds;
                this.hasTransmissionEcu = builder.hasTransmissionEcu;
                this.obdStandard = builder.obdStandard;
                this.pidRequestIntervalSeconds = builder.pidRequestIntervalSeconds;
                this.useExtendedIds = builder.useExtendedIds;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRequestMessageId() {
                return this.requestMessageId;
            }

            @Override
            public final java.lang.Object getDtcRequestIntervalSeconds() {
                return this.dtcRequestIntervalSeconds;
            }

            @Override
            public final java.lang.Object getHasTransmissionEcu() {
                return this.hasTransmissionEcu;
            }

            @Override
            public final java.lang.String getObdStandard() {
                return this.obdStandard;
            }

            @Override
            public final java.lang.Object getPidRequestIntervalSeconds() {
                return this.pidRequestIntervalSeconds;
            }

            @Override
            public final java.lang.Object getUseExtendedIds() {
                return this.useExtendedIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("requestMessageId", om.valueToTree(this.getRequestMessageId()));
                if (this.getDtcRequestIntervalSeconds() != null) {
                    data.set("dtcRequestIntervalSeconds", om.valueToTree(this.getDtcRequestIntervalSeconds()));
                }
                if (this.getHasTransmissionEcu() != null) {
                    data.set("hasTransmissionEcu", om.valueToTree(this.getHasTransmissionEcu()));
                }
                if (this.getObdStandard() != null) {
                    data.set("obdStandard", om.valueToTree(this.getObdStandard()));
                }
                if (this.getPidRequestIntervalSeconds() != null) {
                    data.set("pidRequestIntervalSeconds", om.valueToTree(this.getPidRequestIntervalSeconds()));
                }
                if (this.getUseExtendedIds() != null) {
                    data.set("useExtendedIds", om.valueToTree(this.getUseExtendedIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdInterfaceProperty.Jsii$Proxy that = (ObdInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!requestMessageId.equals(that.requestMessageId)) return false;
                if (this.dtcRequestIntervalSeconds != null ? !this.dtcRequestIntervalSeconds.equals(that.dtcRequestIntervalSeconds) : that.dtcRequestIntervalSeconds != null) return false;
                if (this.hasTransmissionEcu != null ? !this.hasTransmissionEcu.equals(that.hasTransmissionEcu) : that.hasTransmissionEcu != null) return false;
                if (this.obdStandard != null ? !this.obdStandard.equals(that.obdStandard) : that.obdStandard != null) return false;
                if (this.pidRequestIntervalSeconds != null ? !this.pidRequestIntervalSeconds.equals(that.pidRequestIntervalSeconds) : that.pidRequestIntervalSeconds != null) return false;
                return this.useExtendedIds != null ? this.useExtendedIds.equals(that.useExtendedIds) : that.useExtendedIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.requestMessageId.hashCode());
                result = 31 * result + (this.dtcRequestIntervalSeconds != null ? this.dtcRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.hasTransmissionEcu != null ? this.hasTransmissionEcu.hashCode() : 0);
                result = 31 * result + (this.obdStandard != null ? this.obdStandard.hashCode() : 0);
                result = 31 * result + (this.pidRequestIntervalSeconds != null ? this.pidRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.useExtendedIds != null ? this.useExtendedIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object dtcRequestIntervalSeconds;
     * Object hasTransmissionEcu;
     * Object pidRequestIntervalSeconds;
     * Object requestMessageId;
     * Object useExtendedIds;
     * ObdNetworkInterfaceProperty obdNetworkInterfaceProperty = ObdNetworkInterfaceProperty.builder()
     *         .interfaceId("interfaceId")
     *         .obdInterface(ObdInterfaceProperty.builder()
     *                 .name("name")
     *                 .requestMessageId(requestMessageId)
     *                 // the properties below are optional
     *                 .dtcRequestIntervalSeconds(dtcRequestIntervalSeconds)
     *                 .hasTransmissionEcu(hasTransmissionEcu)
     *                 .obdStandard("obdStandard")
     *                 .pidRequestIntervalSeconds(pidRequestIntervalSeconds)
     *                 .useExtendedIds(useExtendedIds)
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdNetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdNetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdNetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.ObdInterface`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObdInterface();

        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdNetworkInterfaceProperty> {
            java.lang.String interfaceId;
            java.lang.Object obdInterface;
            java.lang.String type;

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.ObdNetworkInterfaceProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getObdInterface}
             * @param obdInterface `CfnDecoderManifest.ObdNetworkInterfaceProperty.ObdInterface`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getObdInterface}
             * @param obdInterface `CfnDecoderManifest.ObdNetworkInterfaceProperty.ObdInterface`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.IResolvable obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link ObdNetworkInterfaceProperty#getType}
             * @param type `CfnDecoderManifest.ObdNetworkInterfaceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdNetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdNetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdNetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdNetworkInterfaceProperty {
            private final java.lang.String interfaceId;
            private final java.lang.Object obdInterface;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdInterface = software.amazon.jsii.Kernel.get(this, "obdInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.obdInterface = java.util.Objects.requireNonNull(builder.obdInterface, "obdInterface is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.Object getObdInterface() {
                return this.obdInterface;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("obdInterface", om.valueToTree(this.getObdInterface()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdNetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdNetworkInterfaceProperty.Jsii$Proxy that = (ObdNetworkInterfaceProperty.Jsii$Proxy) o;

                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!obdInterface.equals(that.obdInterface)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.interfaceId.hashCode();
                result = 31 * result + (this.obdInterface.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object bitMaskLength;
     * Object bitRightShift;
     * Object byteLength;
     * Object offset;
     * Object pid;
     * Object pidResponseLength;
     * Object scaling;
     * Object serviceMode;
     * Object startByte;
     * ObdSignalDecoderProperty obdSignalDecoderProperty = ObdSignalDecoderProperty.builder()
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .obdSignal(ObdSignalProperty.builder()
     *                 .byteLength(byteLength)
     *                 .offset(offset)
     *                 .pid(pid)
     *                 .pidResponseLength(pidResponseLength)
     *                 .scaling(scaling)
     *                 .serviceMode(serviceMode)
     *                 .startByte(startByte)
     *                 // the properties below are optional
     *                 .bitMaskLength(bitMaskLength)
     *                 .bitRightShift(bitRightShift)
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalDecoderProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdSignalDecoderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdSignalDecoderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.FullyQualifiedName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.ObdSignal`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObdSignal();

        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdSignalDecoderProperty> {
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.Object obdSignal;
            java.lang.String type;

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getFullyQualifiedName}
             * @param fullyQualifiedName `CfnDecoderManifest.ObdSignalDecoderProperty.FullyQualifiedName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.ObdSignalDecoderProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getObdSignal}
             * @param obdSignal `CfnDecoderManifest.ObdSignalDecoderProperty.ObdSignal`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdSignalProperty obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getObdSignal}
             * @param obdSignal `CfnDecoderManifest.ObdSignalDecoderProperty.ObdSignal`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.IResolvable obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalDecoderProperty#getType}
             * @param type `CfnDecoderManifest.ObdSignalDecoderProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdSignalDecoderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdSignalDecoderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdSignalDecoderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdSignalDecoderProperty {
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.Object obdSignal;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdSignal = software.amazon.jsii.Kernel.get(this, "obdSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.obdSignal = java.util.Objects.requireNonNull(builder.obdSignal, "obdSignal is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.Object getObdSignal() {
                return this.obdSignal;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("obdSignal", om.valueToTree(this.getObdSignal()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalDecoderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdSignalDecoderProperty.Jsii$Proxy that = (ObdSignalDecoderProperty.Jsii$Proxy) o;

                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!obdSignal.equals(that.obdSignal)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.fullyQualifiedName.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.obdSignal.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object bitMaskLength;
     * Object bitRightShift;
     * Object byteLength;
     * Object offset;
     * Object pid;
     * Object pidResponseLength;
     * Object scaling;
     * Object serviceMode;
     * Object startByte;
     * ObdSignalProperty obdSignalProperty = ObdSignalProperty.builder()
     *         .byteLength(byteLength)
     *         .offset(offset)
     *         .pid(pid)
     *         .pidResponseLength(pidResponseLength)
     *         .scaling(scaling)
     *         .serviceMode(serviceMode)
     *         .startByte(startByte)
     *         // the properties below are optional
     *         .bitMaskLength(bitMaskLength)
     *         .bitRightShift(bitRightShift)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.ObdSignalProperty.ByteLength`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getByteLength();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.Offset`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOffset();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.Pid`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPid();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.PidResponseLength`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPidResponseLength();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.Scaling`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getScaling();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.ServiceMode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServiceMode();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.StartByte`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStartByte();

        /**
         * `CfnDecoderManifest.ObdSignalProperty.BitMaskLength`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBitMaskLength() {
            return null;
        }

        /**
         * `CfnDecoderManifest.ObdSignalProperty.BitRightShift`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBitRightShift() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdSignalProperty> {
            java.lang.Object byteLength;
            java.lang.Object offset;
            java.lang.Object pid;
            java.lang.Object pidResponseLength;
            java.lang.Object scaling;
            java.lang.Object serviceMode;
            java.lang.Object startByte;
            java.lang.Object bitMaskLength;
            java.lang.Object bitRightShift;

            /**
             * Sets the value of {@link ObdSignalProperty#getByteLength}
             * @param byteLength `CfnDecoderManifest.ObdSignalProperty.ByteLength`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder byteLength(java.lang.Object byteLength) {
                this.byteLength = byteLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getOffset}
             * @param offset `CfnDecoderManifest.ObdSignalProperty.Offset`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.Object offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPid}
             * @param pid `CfnDecoderManifest.ObdSignalProperty.Pid`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.Object pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPidResponseLength}
             * @param pidResponseLength `CfnDecoderManifest.ObdSignalProperty.PidResponseLength`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidResponseLength(java.lang.Object pidResponseLength) {
                this.pidResponseLength = pidResponseLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getScaling}
             * @param scaling `CfnDecoderManifest.ObdSignalProperty.Scaling`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaling(java.lang.Object scaling) {
                this.scaling = scaling;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getServiceMode}
             * @param serviceMode `CfnDecoderManifest.ObdSignalProperty.ServiceMode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceMode(java.lang.Object serviceMode) {
                this.serviceMode = serviceMode;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getStartByte}
             * @param startByte `CfnDecoderManifest.ObdSignalProperty.StartByte`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startByte(java.lang.Object startByte) {
                this.startByte = startByte;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitMaskLength}
             * @param bitMaskLength `CfnDecoderManifest.ObdSignalProperty.BitMaskLength`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitMaskLength(java.lang.Object bitMaskLength) {
                this.bitMaskLength = bitMaskLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitRightShift}
             * @param bitRightShift `CfnDecoderManifest.ObdSignalProperty.BitRightShift`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitRightShift(java.lang.Object bitRightShift) {
                this.bitRightShift = bitRightShift;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdSignalProperty {
            private final java.lang.Object byteLength;
            private final java.lang.Object offset;
            private final java.lang.Object pid;
            private final java.lang.Object pidResponseLength;
            private final java.lang.Object scaling;
            private final java.lang.Object serviceMode;
            private final java.lang.Object startByte;
            private final java.lang.Object bitMaskLength;
            private final java.lang.Object bitRightShift;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.byteLength = software.amazon.jsii.Kernel.get(this, "byteLength", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pidResponseLength = software.amazon.jsii.Kernel.get(this, "pidResponseLength", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaling = software.amazon.jsii.Kernel.get(this, "scaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceMode = software.amazon.jsii.Kernel.get(this, "serviceMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startByte = software.amazon.jsii.Kernel.get(this, "startByte", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bitMaskLength = software.amazon.jsii.Kernel.get(this, "bitMaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bitRightShift = software.amazon.jsii.Kernel.get(this, "bitRightShift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.byteLength = java.util.Objects.requireNonNull(builder.byteLength, "byteLength is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.pid = java.util.Objects.requireNonNull(builder.pid, "pid is required");
                this.pidResponseLength = java.util.Objects.requireNonNull(builder.pidResponseLength, "pidResponseLength is required");
                this.scaling = java.util.Objects.requireNonNull(builder.scaling, "scaling is required");
                this.serviceMode = java.util.Objects.requireNonNull(builder.serviceMode, "serviceMode is required");
                this.startByte = java.util.Objects.requireNonNull(builder.startByte, "startByte is required");
                this.bitMaskLength = builder.bitMaskLength;
                this.bitRightShift = builder.bitRightShift;
            }

            @Override
            public final java.lang.Object getByteLength() {
                return this.byteLength;
            }

            @Override
            public final java.lang.Object getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.Object getPid() {
                return this.pid;
            }

            @Override
            public final java.lang.Object getPidResponseLength() {
                return this.pidResponseLength;
            }

            @Override
            public final java.lang.Object getScaling() {
                return this.scaling;
            }

            @Override
            public final java.lang.Object getServiceMode() {
                return this.serviceMode;
            }

            @Override
            public final java.lang.Object getStartByte() {
                return this.startByte;
            }

            @Override
            public final java.lang.Object getBitMaskLength() {
                return this.bitMaskLength;
            }

            @Override
            public final java.lang.Object getBitRightShift() {
                return this.bitRightShift;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("byteLength", om.valueToTree(this.getByteLength()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("pid", om.valueToTree(this.getPid()));
                data.set("pidResponseLength", om.valueToTree(this.getPidResponseLength()));
                data.set("scaling", om.valueToTree(this.getScaling()));
                data.set("serviceMode", om.valueToTree(this.getServiceMode()));
                data.set("startByte", om.valueToTree(this.getStartByte()));
                if (this.getBitMaskLength() != null) {
                    data.set("bitMaskLength", om.valueToTree(this.getBitMaskLength()));
                }
                if (this.getBitRightShift() != null) {
                    data.set("bitRightShift", om.valueToTree(this.getBitRightShift()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdSignalProperty.Jsii$Proxy that = (ObdSignalProperty.Jsii$Proxy) o;

                if (!byteLength.equals(that.byteLength)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!pid.equals(that.pid)) return false;
                if (!pidResponseLength.equals(that.pidResponseLength)) return false;
                if (!scaling.equals(that.scaling)) return false;
                if (!serviceMode.equals(that.serviceMode)) return false;
                if (!startByte.equals(that.startByte)) return false;
                if (this.bitMaskLength != null ? !this.bitMaskLength.equals(that.bitMaskLength) : that.bitMaskLength != null) return false;
                return this.bitRightShift != null ? this.bitRightShift.equals(that.bitRightShift) : that.bitRightShift == null;
            }

            @Override
            public final int hashCode() {
                int result = this.byteLength.hashCode();
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.pid.hashCode());
                result = 31 * result + (this.pidResponseLength.hashCode());
                result = 31 * result + (this.scaling.hashCode());
                result = 31 * result + (this.serviceMode.hashCode());
                result = 31 * result + (this.startByte.hashCode());
                result = 31 * result + (this.bitMaskLength != null ? this.bitMaskLength.hashCode() : 0);
                result = 31 * result + (this.bitRightShift != null ? this.bitRightShift.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder();
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`.
         * <p>
         * @return {@code this}
         * @param modelManifestArn `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(final java.lang.String modelManifestArn) {
            this.props.modelManifestArn(modelManifestArn);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::IoTFleetWise::DecoderManifest.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.Description`.
         * <p>
         * @return {@code this}
         * @param description `AWS::IoTFleetWise::DecoderManifest.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
         * <p>
         * @return {@code this}
         * @param networkInterfaces `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
         * <p>
         * @return {@code this}
         * @param networkInterfaces `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final software.amazon.awscdk.IResolvable networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
         * <p>
         * @return {@code this}
         * @param signalDecoders `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final java.util.List<? extends java.lang.Object> signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
         * <p>
         * @return {@code this}
         * @param signalDecoders `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final software.amazon.awscdk.IResolvable signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.Status`.
         * <p>
         * @return {@code this}
         * @param status `AWS::IoTFleetWise::DecoderManifest.Status`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::IoTFleetWise::DecoderManifest.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
