package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation `AWS::IoT::CACertificate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCACertificate cfnCACertificate = CfnCACertificate.Builder.create(this, "MyCfnCACertificate")
 *         .caCertificatePem("caCertificatePem")
 *         .status("status")
 *         // the properties below are optional
 *         .autoRegistrationStatus("autoRegistrationStatus")
 *         .certificateMode("certificateMode")
 *         .registrationConfig(RegistrationConfigProperty.builder()
 *                 .roleArn("roleArn")
 *                 .templateBody("templateBody")
 *                 .templateName("templateName")
 *                 .build())
 *         .removeAutoRegistration(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .verificationCertificatePem("verificationCertificatePem")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.418Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnCACertificate")
public class CfnCACertificate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCACertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCACertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnCACertificate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoT::CACertificate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCACertificate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnCACertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::IoT::CACertificate.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::IoT::CACertificate.CACertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCaCertificatePem() {
        return software.amazon.jsii.Kernel.get(this, "caCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoT::CACertificate.CACertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaCertificatePem(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "caCertificatePem", java.util.Objects.requireNonNull(value, "caCertificatePem is required"));
    }

    /**
     * `AWS::IoT::CACertificate.Status`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoT::CACertificate.Status`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", java.util.Objects.requireNonNull(value, "status is required"));
    }

    /**
     * `AWS::IoT::CACertificate.AutoRegistrationStatus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoRegistrationStatus() {
        return software.amazon.jsii.Kernel.get(this, "autoRegistrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoT::CACertificate.AutoRegistrationStatus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoRegistrationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoRegistrationStatus", value);
    }

    /**
     * `AWS::IoT::CACertificate.CertificateMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateMode() {
        return software.amazon.jsii.Kernel.get(this, "certificateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoT::CACertificate.CertificateMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateMode", value);
    }

    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegistrationConfig() {
        return software.amazon.jsii.Kernel.get(this, "registrationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegistrationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnCACertificate.RegistrationConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "registrationConfig", value);
    }

    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegistrationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "registrationConfig", value);
    }

    /**
     * `AWS::IoT::CACertificate.RemoveAutoRegistration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRemoveAutoRegistration() {
        return software.amazon.jsii.Kernel.get(this, "removeAutoRegistration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoT::CACertificate.RemoveAutoRegistration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveAutoRegistration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "removeAutoRegistration", value);
    }

    /**
     * `AWS::IoT::CACertificate.RemoveAutoRegistration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveAutoRegistration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "removeAutoRegistration", value);
    }

    /**
     * `AWS::IoT::CACertificate.VerificationCertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVerificationCertificatePem() {
        return software.amazon.jsii.Kernel.get(this, "verificationCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoT::CACertificate.VerificationCertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVerificationCertificatePem(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "verificationCertificatePem", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RegistrationConfigProperty registrationConfigProperty = RegistrationConfigProperty.builder()
     *         .roleArn("roleArn")
     *         .templateBody("templateBody")
     *         .templateName("templateName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnCACertificate.RegistrationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RegistrationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegistrationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCACertificate.RegistrationConfigProperty.RoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * `CfnCACertificate.RegistrationConfigProperty.TemplateBody`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
            return null;
        }

        /**
         * `CfnCACertificate.RegistrationConfigProperty.TemplateName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegistrationConfigProperty> {
            java.lang.String roleArn;
            java.lang.String templateBody;
            java.lang.String templateName;

            /**
             * Sets the value of {@link RegistrationConfigProperty#getRoleArn}
             * @param roleArn `CfnCACertificate.RegistrationConfigProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RegistrationConfigProperty#getTemplateBody}
             * @param templateBody `CfnCACertificate.RegistrationConfigProperty.TemplateBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateBody(java.lang.String templateBody) {
                this.templateBody = templateBody;
                return this;
            }

            /**
             * Sets the value of {@link RegistrationConfigProperty#getTemplateName}
             * @param templateName `CfnCACertificate.RegistrationConfigProperty.TemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateName(java.lang.String templateName) {
                this.templateName = templateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegistrationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegistrationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegistrationConfigProperty {
            private final java.lang.String roleArn;
            private final java.lang.String templateBody;
            private final java.lang.String templateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateBody = software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = builder.roleArn;
                this.templateBody = builder.templateBody;
                this.templateName = builder.templateName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTemplateBody() {
                return this.templateBody;
            }

            @Override
            public final java.lang.String getTemplateName() {
                return this.templateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getTemplateBody() != null) {
                    data.set("templateBody", om.valueToTree(this.getTemplateBody()));
                }
                if (this.getTemplateName() != null) {
                    data.set("templateName", om.valueToTree(this.getTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnCACertificate.RegistrationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegistrationConfigProperty.Jsii$Proxy that = (RegistrationConfigProperty.Jsii$Proxy) o;

                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.templateBody != null ? !this.templateBody.equals(that.templateBody) : that.templateBody != null) return false;
                return this.templateName != null ? this.templateName.equals(that.templateName) : that.templateName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn != null ? this.roleArn.hashCode() : 0;
                result = 31 * result + (this.templateBody != null ? this.templateBody.hashCode() : 0);
                result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnCACertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnCACertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnCACertificateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnCACertificateProps.Builder();
        }

        /**
         * `AWS::IoT::CACertificate.CACertificatePem`.
         * <p>
         * @return {@code this}
         * @param caCertificatePem `AWS::IoT::CACertificate.CACertificatePem`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatePem(final java.lang.String caCertificatePem) {
            this.props.caCertificatePem(caCertificatePem);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.Status`.
         * <p>
         * @return {@code this}
         * @param status `AWS::IoT::CACertificate.Status`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.AutoRegistrationStatus`.
         * <p>
         * @return {@code this}
         * @param autoRegistrationStatus `AWS::IoT::CACertificate.AutoRegistrationStatus`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRegistrationStatus(final java.lang.String autoRegistrationStatus) {
            this.props.autoRegistrationStatus(autoRegistrationStatus);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.CertificateMode`.
         * <p>
         * @return {@code this}
         * @param certificateMode `AWS::IoT::CACertificate.CertificateMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateMode(final java.lang.String certificateMode) {
            this.props.certificateMode(certificateMode);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.RegistrationConfig`.
         * <p>
         * @return {@code this}
         * @param registrationConfig `AWS::IoT::CACertificate.RegistrationConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(final software.amazon.awscdk.services.iot.CfnCACertificate.RegistrationConfigProperty registrationConfig) {
            this.props.registrationConfig(registrationConfig);
            return this;
        }
        /**
         * `AWS::IoT::CACertificate.RegistrationConfig`.
         * <p>
         * @return {@code this}
         * @param registrationConfig `AWS::IoT::CACertificate.RegistrationConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(final software.amazon.awscdk.IResolvable registrationConfig) {
            this.props.registrationConfig(registrationConfig);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.RemoveAutoRegistration`.
         * <p>
         * @return {@code this}
         * @param removeAutoRegistration `AWS::IoT::CACertificate.RemoveAutoRegistration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeAutoRegistration(final java.lang.Boolean removeAutoRegistration) {
            this.props.removeAutoRegistration(removeAutoRegistration);
            return this;
        }
        /**
         * `AWS::IoT::CACertificate.RemoveAutoRegistration`.
         * <p>
         * @return {@code this}
         * @param removeAutoRegistration `AWS::IoT::CACertificate.RemoveAutoRegistration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeAutoRegistration(final software.amazon.awscdk.IResolvable removeAutoRegistration) {
            this.props.removeAutoRegistration(removeAutoRegistration);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::IoT::CACertificate.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::IoT::CACertificate.VerificationCertificatePem`.
         * <p>
         * @return {@code this}
         * @param verificationCertificatePem `AWS::IoT::CACertificate.VerificationCertificatePem`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationCertificatePem(final java.lang.String verificationCertificatePem) {
            this.props.verificationCertificatePem(verificationCertificatePem);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.CfnCACertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnCACertificate build() {
            return new software.amazon.awscdk.services.iot.CfnCACertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
