package software.amazon.awscdk.services.greengrassv2;

/**
 * Properties for defining a `CfnComponentVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrassv2.*;
 * CfnComponentVersionProps cfnComponentVersionProps = CfnComponentVersionProps.builder()
 *         .inlineRecipe("inlineRecipe")
 *         .lambdaFunction(LambdaFunctionRecipeSourceProperty.builder()
 *                 .componentDependencies(Map.of(
 *                         "componentDependenciesKey", ComponentDependencyRequirementProperty.builder()
 *                                 .dependencyType("dependencyType")
 *                                 .versionRequirement("versionRequirement")
 *                                 .build()))
 *                 .componentLambdaParameters(LambdaExecutionParametersProperty.builder()
 *                         .environmentVariables(Map.of(
 *                                 "environmentVariablesKey", "environmentVariables"))
 *                         .eventSources(List.of(LambdaEventSourceProperty.builder()
 *                                 .topic("topic")
 *                                 .type("type")
 *                                 .build()))
 *                         .execArgs(List.of("execArgs"))
 *                         .inputPayloadEncodingType("inputPayloadEncodingType")
 *                         .linuxProcessParams(LambdaLinuxProcessParamsProperty.builder()
 *                                 .containerParams(LambdaContainerParamsProperty.builder()
 *                                         .devices(List.of(LambdaDeviceMountProperty.builder()
 *                                                 .addGroupOwner(false)
 *                                                 .path("path")
 *                                                 .permission("permission")
 *                                                 .build()))
 *                                         .memorySizeInKb(123)
 *                                         .mountRoSysfs(false)
 *                                         .volumes(List.of(LambdaVolumeMountProperty.builder()
 *                                                 .addGroupOwner(false)
 *                                                 .destinationPath("destinationPath")
 *                                                 .permission("permission")
 *                                                 .sourcePath("sourcePath")
 *                                                 .build()))
 *                                         .build())
 *                                 .isolationMode("isolationMode")
 *                                 .build())
 *                         .maxIdleTimeInSeconds(123)
 *                         .maxInstancesCount(123)
 *                         .maxQueueSize(123)
 *                         .pinned(false)
 *                         .statusTimeoutInSeconds(123)
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .componentName("componentName")
 *                 .componentPlatforms(List.of(ComponentPlatformProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .name("name")
 *                         .build()))
 *                 .componentVersion("componentVersion")
 *                 .lambdaArn("lambdaArn")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.223Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnComponentVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnComponentVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComponentVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The recipe to use to create the component.
     * <p>
     * The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
     * <p>
     * You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInlineRecipe() {
        return null;
    }

    /**
     * The parameters to create a component from a Lambda function.
     * <p>
     * You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunction() {
        return null;
    }

    /**
     * Application-specific metadata to attach to the component version.
     * <p>
     * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
     * <p>
     * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
     * <p>
     * <blockquote><pre>
     * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
     * }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComponentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComponentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComponentVersionProps> {
        java.lang.String inlineRecipe;
        java.lang.Object lambdaFunction;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnComponentVersionProps#getInlineRecipe}
         * @param inlineRecipe The recipe to use to create the component.
         *                     The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
         *                     <p>
         *                     You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineRecipe(java.lang.String inlineRecipe) {
            this.inlineRecipe = inlineRecipe;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentVersionProps#getLambdaFunction}
         * @param lambdaFunction The parameters to create a component from a Lambda function.
         *                       You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(software.amazon.awscdk.services.greengrassv2.CfnComponentVersion.LambdaFunctionRecipeSourceProperty lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentVersionProps#getLambdaFunction}
         * @param lambdaFunction The parameters to create a component from a Lambda function.
         *                       You must specify either <code>InlineRecipe</code> or <code>LambdaFunction</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(software.amazon.awscdk.IResolvable lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentVersionProps#getTags}
         * @param tags Application-specific metadata to attach to the component version.
         *             You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         *             <p>
         *             This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         *             <p>
         *             <blockquote><pre>
         *             "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         *             }
         *             </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComponentVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComponentVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComponentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComponentVersionProps {
        private final java.lang.String inlineRecipe;
        private final java.lang.Object lambdaFunction;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inlineRecipe = software.amazon.jsii.Kernel.get(this, "inlineRecipe", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inlineRecipe = builder.inlineRecipe;
            this.lambdaFunction = builder.lambdaFunction;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getInlineRecipe() {
            return this.inlineRecipe;
        }

        @Override
        public final java.lang.Object getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInlineRecipe() != null) {
                data.set("inlineRecipe", om.valueToTree(this.getInlineRecipe()));
            }
            if (this.getLambdaFunction() != null) {
                data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnComponentVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComponentVersionProps.Jsii$Proxy that = (CfnComponentVersionProps.Jsii$Proxy) o;

            if (this.inlineRecipe != null ? !this.inlineRecipe.equals(that.inlineRecipe) : that.inlineRecipe != null) return false;
            if (this.lambdaFunction != null ? !this.lambdaFunction.equals(that.lambdaFunction) : that.lambdaFunction != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inlineRecipe != null ? this.inlineRecipe.hashCode() : 0;
            result = 31 * result + (this.lambdaFunction != null ? this.lambdaFunction.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
