package software.amazon.awscdk.services.glue;

/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 * <p>
 * The AWS::Glue::MLTransform is an AWS Glue resource type that manages machine learning transforms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object tags;
 * CfnMLTransform cfnMLTransform = CfnMLTransform.Builder.create(this, "MyCfnMLTransform")
 *         .inputRecordTables(InputRecordTablesProperty.builder()
 *                 .glueTables(List.of(GlueTablesProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .catalogId("catalogId")
 *                         .connectionName("connectionName")
 *                         .build()))
 *                 .build())
 *         .role("role")
 *         .transformParameters(TransformParametersProperty.builder()
 *                 .transformType("transformType")
 *                 // the properties below are optional
 *                 .findMatchesParameters(FindMatchesParametersProperty.builder()
 *                         .primaryKeyColumnName("primaryKeyColumnName")
 *                         // the properties below are optional
 *                         .accuracyCostTradeoff(123)
 *                         .enforceProvidedLabels(false)
 *                         .precisionRecallTradeoff(123)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .glueVersion("glueVersion")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .name("name")
 *         .numberOfWorkers(123)
 *         .tags(tags)
 *         .timeout(123)
 *         .transformEncryption(TransformEncryptionProperty.builder()
 *                 .mlUserDataEncryption(MLUserDataEncryptionProperty.builder()
 *                         .mlUserDataEncryptionMode("mlUserDataEncryptionMode")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .taskRunSecurityConfigurationName("taskRunSecurityConfigurationName")
 *                 .build())
 *         .workerType("workerType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.103Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform")
public class CfnMLTransform extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMLTransform(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMLTransform(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnMLTransform.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Glue::MLTransform`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMLTransform(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnMLTransformProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to use with this machine learning transform.
     * <p>
     * You may use tags to limit access to the machine learning transform. For more information about tags in AWS Glue , see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of AWS Glue table definitions used by the transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputRecordTables() {
        return software.amazon.jsii.Kernel.get(this, "inputRecordTables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of AWS Glue table definitions used by the transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputRecordTables(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnMLTransform.InputRecordTablesProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputRecordTables", java.util.Objects.requireNonNull(value, "inputRecordTables is required"));
    }

    /**
     * A list of AWS Glue table definitions used by the transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputRecordTables(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputRecordTables", java.util.Objects.requireNonNull(value, "inputRecordTables is required"));
    }

    /**
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     * <p>
     * The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform.
     * <p>
     * <ul>
     * <li>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue . See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a> .</li>
     * <li>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     * <p>
     * The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform.
     * <p>
     * <ul>
     * <li>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue . See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a> .</li>
     * <li>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", java.util.Objects.requireNonNull(value, "role is required"));
    }

    /**
     * The algorithm-specific parameters that are associated with the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTransformParameters() {
        return software.amazon.jsii.Kernel.get(this, "transformParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The algorithm-specific parameters that are associated with the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnMLTransform.TransformParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "transformParameters", java.util.Objects.requireNonNull(value, "transformParameters is required"));
    }

    /**
     * The algorithm-specific parameters that are associated with the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transformParameters", java.util.Objects.requireNonNull(value, "transformParameters is required"));
    }

    /**
     * A user-defined, long-form description text for the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-defined, long-form description text for the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * This value determines which version of AWS Glue this machine learning transform is compatible with.
     * <p>
     * Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlueVersion() {
        return software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This value determines which version of AWS Glue this machine learning transform is compatible with.
     * <p>
     * Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlueVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "glueVersion", value);
    }

    /**
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     * <p>
     * You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/glue/pricing/">AWS Glue pricing page</a> .
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code> , the <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     * <p>
     * You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/glue/pricing/">AWS Glue pricing page</a> .
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code> , the <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCapacity", value);
    }

    /**
     * The maximum number of times to retry after an `MLTaskRun` of the machine learning transform fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of times to retry after an `MLTaskRun` of the machine learning transform fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxRetries(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxRetries", value);
    }

    /**
     * A user-defined name for the machine learning transform. Names are required to be unique. `Name` is optional:.
     * <p>
     * <ul>
     * <li>If you supply <code>Name</code> , the stack cannot be repeatedly created.</li>
     * <li>If <code>Name</code> is not provided, a randomly generated name will be used instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-defined name for the machine learning transform. Names are required to be unique. `Name` is optional:.
     * <p>
     * <ul>
     * <li>If you supply <code>Name</code> , the stack cannot be repeatedly created.</li>
     * <li>If <code>Name</code> is not provided, a randomly generated name will be used instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The number of workers of a defined `workerType` that are allocated when a task of the transform runs.
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfWorkers() {
        return software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of workers of a defined `workerType` that are allocated when a task of the transform runs.
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumberOfWorkers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numberOfWorkers", value);
    }

    /**
     * The timeout in minutes of the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The timeout in minutes of the machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Machine learning
     * transforms can access user data encrypted in Amazon S3 using KMS.
     * <p>
     * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
     * KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTransformEncryption() {
        return software.amazon.jsii.Kernel.get(this, "transformEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Machine learning
     * transforms can access user data encrypted in Amazon S3 using KMS.
     * <p>
     * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
     * KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnMLTransform.TransformEncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "transformEncryption", value);
    }

    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Machine learning
     * transforms can access user data encrypted in Amazon S3 using KMS.
     * <p>
     * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
     * KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transformEncryption", value);
    }

    /**
     * The type of predefined worker that is allocated when a task of this transform runs.
     * <p>
     * Accepts a value of Standard, G.1X, or G.2X.
     * <p>
     * <ul>
     * <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
     * <li>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</li>
     * <li>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkerType() {
        return software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of predefined worker that is allocated when a task of this transform runs.
     * <p>
     * Accepts a value of Standard, G.1X, or G.2X.
     * <p>
     * <ul>
     * <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
     * <li>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</li>
     * <li>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workerType", value);
    }
    /**
     * The parameters to configure the find matches transform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * FindMatchesParametersProperty findMatchesParametersProperty = FindMatchesParametersProperty.builder()
     *         .primaryKeyColumnName("primaryKeyColumnName")
     *         // the properties below are optional
     *         .accuracyCostTradeoff(123)
     *         .enforceProvidedLabels(false)
     *         .precisionRecallTradeoff(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.FindMatchesParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(FindMatchesParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FindMatchesParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a column that uniquely identifies rows in the source table.
         * <p>
         * Used to help identify matching records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimaryKeyColumnName();

        /**
         * The value that is selected when tuning your transform for a balance between accuracy and cost.
         * <p>
         * A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for accuracy, which typically results in a higher cost, sometimes substantially higher. A value of 0.0 means a bias purely for cost, which results in a less accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.
         * <p>
         * Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall.
         * <p>
         * Cost measures how many compute resources, and thus money, are consumed to run the transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAccuracyCostTradeoff() {
            return null;
        }

        /**
         * The value to switch on or off to force the output to match the provided labels from users.
         * <p>
         * If the value is <code>True</code> , the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code> , the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.
         * <p>
         * Note that setting this value to true may increase the conflation execution time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceProvidedLabels() {
            return null;
        }

        /**
         * The value selected when tuning your transform for a balance between precision and recall.
         * <p>
         * A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing values close to 0.0 results in very low precision.
         * <p>
         * The precision metric indicates how often your model is correct when it predicts a match.
         * <p>
         * The recall metric indicates that for an actual match, how often your model predicts the match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPrecisionRecallTradeoff() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FindMatchesParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FindMatchesParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FindMatchesParametersProperty> {
            java.lang.String primaryKeyColumnName;
            java.lang.Number accuracyCostTradeoff;
            java.lang.Object enforceProvidedLabels;
            java.lang.Number precisionRecallTradeoff;

            /**
             * Sets the value of {@link FindMatchesParametersProperty#getPrimaryKeyColumnName}
             * @param primaryKeyColumnName The name of a column that uniquely identifies rows in the source table. This parameter is required.
             *                             Used to help identify matching records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryKeyColumnName(java.lang.String primaryKeyColumnName) {
                this.primaryKeyColumnName = primaryKeyColumnName;
                return this;
            }

            /**
             * Sets the value of {@link FindMatchesParametersProperty#getAccuracyCostTradeoff}
             * @param accuracyCostTradeoff The value that is selected when tuning your transform for a balance between accuracy and cost.
             *                             A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for accuracy, which typically results in a higher cost, sometimes substantially higher. A value of 0.0 means a bias purely for cost, which results in a less accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.
             *                             <p>
             *                             Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall.
             *                             <p>
             *                             Cost measures how many compute resources, and thus money, are consumed to run the transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accuracyCostTradeoff(java.lang.Number accuracyCostTradeoff) {
                this.accuracyCostTradeoff = accuracyCostTradeoff;
                return this;
            }

            /**
             * Sets the value of {@link FindMatchesParametersProperty#getEnforceProvidedLabels}
             * @param enforceProvidedLabels The value to switch on or off to force the output to match the provided labels from users.
             *                              If the value is <code>True</code> , the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code> , the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.
             *                              <p>
             *                              Note that setting this value to true may increase the conflation execution time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceProvidedLabels(java.lang.Boolean enforceProvidedLabels) {
                this.enforceProvidedLabels = enforceProvidedLabels;
                return this;
            }

            /**
             * Sets the value of {@link FindMatchesParametersProperty#getEnforceProvidedLabels}
             * @param enforceProvidedLabels The value to switch on or off to force the output to match the provided labels from users.
             *                              If the value is <code>True</code> , the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code> , the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.
             *                              <p>
             *                              Note that setting this value to true may increase the conflation execution time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceProvidedLabels(software.amazon.awscdk.IResolvable enforceProvidedLabels) {
                this.enforceProvidedLabels = enforceProvidedLabels;
                return this;
            }

            /**
             * Sets the value of {@link FindMatchesParametersProperty#getPrecisionRecallTradeoff}
             * @param precisionRecallTradeoff The value selected when tuning your transform for a balance between precision and recall.
             *                                A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing values close to 0.0 results in very low precision.
             *                                <p>
             *                                The precision metric indicates how often your model is correct when it predicts a match.
             *                                <p>
             *                                The recall metric indicates that for an actual match, how often your model predicts the match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder precisionRecallTradeoff(java.lang.Number precisionRecallTradeoff) {
                this.precisionRecallTradeoff = precisionRecallTradeoff;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FindMatchesParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FindMatchesParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FindMatchesParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FindMatchesParametersProperty {
            private final java.lang.String primaryKeyColumnName;
            private final java.lang.Number accuracyCostTradeoff;
            private final java.lang.Object enforceProvidedLabels;
            private final java.lang.Number precisionRecallTradeoff;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primaryKeyColumnName = software.amazon.jsii.Kernel.get(this, "primaryKeyColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accuracyCostTradeoff = software.amazon.jsii.Kernel.get(this, "accuracyCostTradeoff", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enforceProvidedLabels = software.amazon.jsii.Kernel.get(this, "enforceProvidedLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.precisionRecallTradeoff = software.amazon.jsii.Kernel.get(this, "precisionRecallTradeoff", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primaryKeyColumnName = java.util.Objects.requireNonNull(builder.primaryKeyColumnName, "primaryKeyColumnName is required");
                this.accuracyCostTradeoff = builder.accuracyCostTradeoff;
                this.enforceProvidedLabels = builder.enforceProvidedLabels;
                this.precisionRecallTradeoff = builder.precisionRecallTradeoff;
            }

            @Override
            public final java.lang.String getPrimaryKeyColumnName() {
                return this.primaryKeyColumnName;
            }

            @Override
            public final java.lang.Number getAccuracyCostTradeoff() {
                return this.accuracyCostTradeoff;
            }

            @Override
            public final java.lang.Object getEnforceProvidedLabels() {
                return this.enforceProvidedLabels;
            }

            @Override
            public final java.lang.Number getPrecisionRecallTradeoff() {
                return this.precisionRecallTradeoff;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primaryKeyColumnName", om.valueToTree(this.getPrimaryKeyColumnName()));
                if (this.getAccuracyCostTradeoff() != null) {
                    data.set("accuracyCostTradeoff", om.valueToTree(this.getAccuracyCostTradeoff()));
                }
                if (this.getEnforceProvidedLabels() != null) {
                    data.set("enforceProvidedLabels", om.valueToTree(this.getEnforceProvidedLabels()));
                }
                if (this.getPrecisionRecallTradeoff() != null) {
                    data.set("precisionRecallTradeoff", om.valueToTree(this.getPrecisionRecallTradeoff()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.FindMatchesParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FindMatchesParametersProperty.Jsii$Proxy that = (FindMatchesParametersProperty.Jsii$Proxy) o;

                if (!primaryKeyColumnName.equals(that.primaryKeyColumnName)) return false;
                if (this.accuracyCostTradeoff != null ? !this.accuracyCostTradeoff.equals(that.accuracyCostTradeoff) : that.accuracyCostTradeoff != null) return false;
                if (this.enforceProvidedLabels != null ? !this.enforceProvidedLabels.equals(that.enforceProvidedLabels) : that.enforceProvidedLabels != null) return false;
                return this.precisionRecallTradeoff != null ? this.precisionRecallTradeoff.equals(that.precisionRecallTradeoff) : that.precisionRecallTradeoff == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primaryKeyColumnName.hashCode();
                result = 31 * result + (this.accuracyCostTradeoff != null ? this.accuracyCostTradeoff.hashCode() : 0);
                result = 31 * result + (this.enforceProvidedLabels != null ? this.enforceProvidedLabels.hashCode() : 0);
                result = 31 * result + (this.precisionRecallTradeoff != null ? this.precisionRecallTradeoff.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The database and table in the AWS Glue Data Catalog that is used for input or output data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * GlueTablesProperty glueTablesProperty = GlueTablesProperty.builder()
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .catalogId("catalogId")
     *         .connectionName("connectionName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.GlueTablesProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueTablesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueTablesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A database name in the AWS Glue Data Catalog .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * A table name in the AWS Glue Data Catalog .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * A unique identifier for the AWS Glue Data Catalog .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * The name of the connection to the AWS Glue Data Catalog .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlueTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueTablesProperty> {
            java.lang.String databaseName;
            java.lang.String tableName;
            java.lang.String catalogId;
            java.lang.String connectionName;

            /**
             * Sets the value of {@link GlueTablesProperty#getDatabaseName}
             * @param databaseName A database name in the AWS Glue Data Catalog . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GlueTablesProperty#getTableName}
             * @param tableName A table name in the AWS Glue Data Catalog . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link GlueTablesProperty#getCatalogId}
             * @param catalogId A unique identifier for the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link GlueTablesProperty#getConnectionName}
             * @param connectionName The name of the connection to the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueTablesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueTablesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueTablesProperty {
            private final java.lang.String databaseName;
            private final java.lang.String tableName;
            private final java.lang.String catalogId;
            private final java.lang.String connectionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.catalogId = builder.catalogId;
                this.connectionName = builder.connectionName;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.GlueTablesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueTablesProperty.Jsii$Proxy that = (GlueTablesProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                return this.connectionName != null ? this.connectionName.equals(that.connectionName) : that.connectionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.catalogId != null ? this.catalogId.hashCode() : 0);
                result = 31 * result + (this.connectionName != null ? this.connectionName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of AWS Glue table definitions used by the transform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * InputRecordTablesProperty inputRecordTablesProperty = InputRecordTablesProperty.builder()
     *         .glueTables(List.of(GlueTablesProperty.builder()
     *                 .databaseName("databaseName")
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .catalogId("catalogId")
     *                 .connectionName("connectionName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.InputRecordTablesProperty")
    @software.amazon.jsii.Jsii.Proxy(InputRecordTablesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputRecordTablesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The database and table in the AWS Glue Data Catalog that is used for input or output data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueTables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputRecordTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputRecordTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputRecordTablesProperty> {
            java.lang.Object glueTables;

            /**
             * Sets the value of {@link InputRecordTablesProperty#getGlueTables}
             * @param glueTables The database and table in the AWS Glue Data Catalog that is used for input or output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueTables(software.amazon.awscdk.IResolvable glueTables) {
                this.glueTables = glueTables;
                return this;
            }

            /**
             * Sets the value of {@link InputRecordTablesProperty#getGlueTables}
             * @param glueTables The database and table in the AWS Glue Data Catalog that is used for input or output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueTables(java.util.List<? extends java.lang.Object> glueTables) {
                this.glueTables = glueTables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputRecordTablesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputRecordTablesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputRecordTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputRecordTablesProperty {
            private final java.lang.Object glueTables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueTables = software.amazon.jsii.Kernel.get(this, "glueTables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueTables = builder.glueTables;
            }

            @Override
            public final java.lang.Object getGlueTables() {
                return this.glueTables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueTables() != null) {
                    data.set("glueTables", om.valueToTree(this.getGlueTables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.InputRecordTablesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputRecordTablesProperty.Jsii$Proxy that = (InputRecordTablesProperty.Jsii$Proxy) o;

                return this.glueTables != null ? this.glueTables.equals(that.glueTables) : that.glueTables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueTables != null ? this.glueTables.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * MLUserDataEncryptionProperty mLUserDataEncryptionProperty = MLUserDataEncryptionProperty.builder()
     *         .mlUserDataEncryptionMode("mlUserDataEncryptionMode")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.MLUserDataEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(MLUserDataEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MLUserDataEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption mode applied to user data. Valid values are:.
         * <p>
         * <ul>
         * <li>DISABLED: encryption is disabled.</li>
         * <li>SSEKMS: use of server-side encryption with AWS Key Management Service (SSE-KMS) for user data
         * stored in Amazon S3.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMlUserDataEncryptionMode();

        /**
         * The ID for the customer-provided KMS key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MLUserDataEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MLUserDataEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MLUserDataEncryptionProperty> {
            java.lang.String mlUserDataEncryptionMode;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link MLUserDataEncryptionProperty#getMlUserDataEncryptionMode}
             * @param mlUserDataEncryptionMode The encryption mode applied to user data. Valid values are:. This parameter is required.
             *                                 <ul>
             *                                 <li>DISABLED: encryption is disabled.</li>
             *                                 <li>SSEKMS: use of server-side encryption with AWS Key Management Service (SSE-KMS) for user data
             *                                 stored in Amazon S3.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlUserDataEncryptionMode(java.lang.String mlUserDataEncryptionMode) {
                this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
                return this;
            }

            /**
             * Sets the value of {@link MLUserDataEncryptionProperty#getKmsKeyId}
             * @param kmsKeyId The ID for the customer-provided KMS key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MLUserDataEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MLUserDataEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MLUserDataEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MLUserDataEncryptionProperty {
            private final java.lang.String mlUserDataEncryptionMode;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mlUserDataEncryptionMode = software.amazon.jsii.Kernel.get(this, "mlUserDataEncryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mlUserDataEncryptionMode = java.util.Objects.requireNonNull(builder.mlUserDataEncryptionMode, "mlUserDataEncryptionMode is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getMlUserDataEncryptionMode() {
                return this.mlUserDataEncryptionMode;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mlUserDataEncryptionMode", om.valueToTree(this.getMlUserDataEncryptionMode()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.MLUserDataEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MLUserDataEncryptionProperty.Jsii$Proxy that = (MLUserDataEncryptionProperty.Jsii$Proxy) o;

                if (!mlUserDataEncryptionMode.equals(that.mlUserDataEncryptionMode)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mlUserDataEncryptionMode.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Machine learning
     * transforms can access user data encrypted in Amazon S3 using KMS.
     * <p>
     * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
     * KMS key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TransformEncryptionProperty transformEncryptionProperty = TransformEncryptionProperty.builder()
     *         .mlUserDataEncryption(MLUserDataEncryptionProperty.builder()
     *                 .mlUserDataEncryptionMode("mlUserDataEncryptionMode")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .taskRunSecurityConfigurationName("taskRunSecurityConfigurationName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.TransformEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption-at-rest settings of the transform that apply to accessing user data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMlUserDataEncryption() {
            return null;
        }

        /**
         * The name of the security configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskRunSecurityConfigurationName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformEncryptionProperty> {
            java.lang.Object mlUserDataEncryption;
            java.lang.String taskRunSecurityConfigurationName;

            /**
             * Sets the value of {@link TransformEncryptionProperty#getMlUserDataEncryption}
             * @param mlUserDataEncryption The encryption-at-rest settings of the transform that apply to accessing user data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlUserDataEncryption(software.amazon.awscdk.services.glue.CfnMLTransform.MLUserDataEncryptionProperty mlUserDataEncryption) {
                this.mlUserDataEncryption = mlUserDataEncryption;
                return this;
            }

            /**
             * Sets the value of {@link TransformEncryptionProperty#getMlUserDataEncryption}
             * @param mlUserDataEncryption The encryption-at-rest settings of the transform that apply to accessing user data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlUserDataEncryption(software.amazon.awscdk.IResolvable mlUserDataEncryption) {
                this.mlUserDataEncryption = mlUserDataEncryption;
                return this;
            }

            /**
             * Sets the value of {@link TransformEncryptionProperty#getTaskRunSecurityConfigurationName}
             * @param taskRunSecurityConfigurationName The name of the security configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskRunSecurityConfigurationName(java.lang.String taskRunSecurityConfigurationName) {
                this.taskRunSecurityConfigurationName = taskRunSecurityConfigurationName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformEncryptionProperty {
            private final java.lang.Object mlUserDataEncryption;
            private final java.lang.String taskRunSecurityConfigurationName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mlUserDataEncryption = software.amazon.jsii.Kernel.get(this, "mlUserDataEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskRunSecurityConfigurationName = software.amazon.jsii.Kernel.get(this, "taskRunSecurityConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mlUserDataEncryption = builder.mlUserDataEncryption;
                this.taskRunSecurityConfigurationName = builder.taskRunSecurityConfigurationName;
            }

            @Override
            public final java.lang.Object getMlUserDataEncryption() {
                return this.mlUserDataEncryption;
            }

            @Override
            public final java.lang.String getTaskRunSecurityConfigurationName() {
                return this.taskRunSecurityConfigurationName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMlUserDataEncryption() != null) {
                    data.set("mlUserDataEncryption", om.valueToTree(this.getMlUserDataEncryption()));
                }
                if (this.getTaskRunSecurityConfigurationName() != null) {
                    data.set("taskRunSecurityConfigurationName", om.valueToTree(this.getTaskRunSecurityConfigurationName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.TransformEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformEncryptionProperty.Jsii$Proxy that = (TransformEncryptionProperty.Jsii$Proxy) o;

                if (this.mlUserDataEncryption != null ? !this.mlUserDataEncryption.equals(that.mlUserDataEncryption) : that.mlUserDataEncryption != null) return false;
                return this.taskRunSecurityConfigurationName != null ? this.taskRunSecurityConfigurationName.equals(that.taskRunSecurityConfigurationName) : that.taskRunSecurityConfigurationName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mlUserDataEncryption != null ? this.mlUserDataEncryption.hashCode() : 0;
                result = 31 * result + (this.taskRunSecurityConfigurationName != null ? this.taskRunSecurityConfigurationName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The algorithm-specific parameters that are associated with the machine learning transform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TransformParametersProperty transformParametersProperty = TransformParametersProperty.builder()
     *         .transformType("transformType")
     *         // the properties below are optional
     *         .findMatchesParameters(FindMatchesParametersProperty.builder()
     *                 .primaryKeyColumnName("primaryKeyColumnName")
     *                 // the properties below are optional
     *                 .accuracyCostTradeoff(123)
     *                 .enforceProvidedLabels(false)
     *                 .precisionRecallTradeoff(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransform.TransformParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of machine learning transform. `FIND_MATCHES` is the only option.
         * <p>
         * For information about the types of machine learning transforms, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTransformType();

        /**
         * The parameters for the find matches algorithm.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindMatchesParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformParametersProperty> {
            java.lang.String transformType;
            java.lang.Object findMatchesParameters;

            /**
             * Sets the value of {@link TransformParametersProperty#getTransformType}
             * @param transformType The type of machine learning transform. `FIND_MATCHES` is the only option. This parameter is required.
             *                      For information about the types of machine learning transforms, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformType(java.lang.String transformType) {
                this.transformType = transformType;
                return this;
            }

            /**
             * Sets the value of {@link TransformParametersProperty#getFindMatchesParameters}
             * @param findMatchesParameters The parameters for the find matches algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findMatchesParameters(software.amazon.awscdk.services.glue.CfnMLTransform.FindMatchesParametersProperty findMatchesParameters) {
                this.findMatchesParameters = findMatchesParameters;
                return this;
            }

            /**
             * Sets the value of {@link TransformParametersProperty#getFindMatchesParameters}
             * @param findMatchesParameters The parameters for the find matches algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findMatchesParameters(software.amazon.awscdk.IResolvable findMatchesParameters) {
                this.findMatchesParameters = findMatchesParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformParametersProperty {
            private final java.lang.String transformType;
            private final java.lang.Object findMatchesParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transformType = software.amazon.jsii.Kernel.get(this, "transformType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.findMatchesParameters = software.amazon.jsii.Kernel.get(this, "findMatchesParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transformType = java.util.Objects.requireNonNull(builder.transformType, "transformType is required");
                this.findMatchesParameters = builder.findMatchesParameters;
            }

            @Override
            public final java.lang.String getTransformType() {
                return this.transformType;
            }

            @Override
            public final java.lang.Object getFindMatchesParameters() {
                return this.findMatchesParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("transformType", om.valueToTree(this.getTransformType()));
                if (this.getFindMatchesParameters() != null) {
                    data.set("findMatchesParameters", om.valueToTree(this.getFindMatchesParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransform.TransformParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformParametersProperty.Jsii$Proxy that = (TransformParametersProperty.Jsii$Proxy) o;

                if (!transformType.equals(that.transformType)) return false;
                return this.findMatchesParameters != null ? this.findMatchesParameters.equals(that.findMatchesParameters) : that.findMatchesParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transformType.hashCode();
                result = 31 * result + (this.findMatchesParameters != null ? this.findMatchesParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnMLTransform}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnMLTransform> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnMLTransformProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnMLTransformProps.Builder();
        }

        /**
         * A list of AWS Glue table definitions used by the transform.
         * <p>
         * @return {@code this}
         * @param inputRecordTables A list of AWS Glue table definitions used by the transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputRecordTables(final software.amazon.awscdk.services.glue.CfnMLTransform.InputRecordTablesProperty inputRecordTables) {
            this.props.inputRecordTables(inputRecordTables);
            return this;
        }
        /**
         * A list of AWS Glue table definitions used by the transform.
         * <p>
         * @return {@code this}
         * @param inputRecordTables A list of AWS Glue table definitions used by the transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputRecordTables(final software.amazon.awscdk.IResolvable inputRecordTables) {
            this.props.inputRecordTables(inputRecordTables);
            return this;
        }

        /**
         * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
         * <p>
         * The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform.
         * <p>
         * <ul>
         * <li>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue . See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a> .</li>
         * <li>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param role The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props.role(role);
            return this;
        }

        /**
         * The algorithm-specific parameters that are associated with the machine learning transform.
         * <p>
         * @return {@code this}
         * @param transformParameters The algorithm-specific parameters that are associated with the machine learning transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformParameters(final software.amazon.awscdk.services.glue.CfnMLTransform.TransformParametersProperty transformParameters) {
            this.props.transformParameters(transformParameters);
            return this;
        }
        /**
         * The algorithm-specific parameters that are associated with the machine learning transform.
         * <p>
         * @return {@code this}
         * @param transformParameters The algorithm-specific parameters that are associated with the machine learning transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformParameters(final software.amazon.awscdk.IResolvable transformParameters) {
            this.props.transformParameters(transformParameters);
            return this;
        }

        /**
         * A user-defined, long-form description text for the machine learning transform.
         * <p>
         * @return {@code this}
         * @param description A user-defined, long-form description text for the machine learning transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * This value determines which version of AWS Glue this machine learning transform is compatible with.
         * <p>
         * Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.
         * <p>
         * @return {@code this}
         * @param glueVersion This value determines which version of AWS Glue this machine learning transform is compatible with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glueVersion(final java.lang.String glueVersion) {
            this.props.glueVersion(glueVersion);
            return this;
        }

        /**
         * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
         * <p>
         * You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/glue/pricing/">AWS Glue pricing page</a> .
         * <p>
         * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
         * <p>
         * <ul>
         * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
         * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
         * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
         * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
         * </ul>
         * <p>
         * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code> , the <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * <p>
         * @return {@code this}
         * @param maxCapacity The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The maximum number of times to retry after an `MLTaskRun` of the machine learning transform fails.
         * <p>
         * @return {@code this}
         * @param maxRetries The maximum number of times to retry after an `MLTaskRun` of the machine learning transform fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(final java.lang.Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        /**
         * A user-defined name for the machine learning transform. Names are required to be unique. `Name` is optional:.
         * <p>
         * <ul>
         * <li>If you supply <code>Name</code> , the stack cannot be repeatedly created.</li>
         * <li>If <code>Name</code> is not provided, a randomly generated name will be used instead.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param name A user-defined name for the machine learning transform. Names are required to be unique. `Name` is optional:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The number of workers of a defined `workerType` that are allocated when a task of the transform runs.
         * <p>
         * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * <p>
         * @return {@code this}
         * @param numberOfWorkers The number of workers of a defined `workerType` that are allocated when a task of the transform runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfWorkers(final java.lang.Number numberOfWorkers) {
            this.props.numberOfWorkers(numberOfWorkers);
            return this;
        }

        /**
         * The tags to use with this machine learning transform.
         * <p>
         * You may use tags to limit access to the machine learning transform. For more information about tags in AWS Glue , see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.
         * <p>
         * @return {@code this}
         * @param tags The tags to use with this machine learning transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The timeout in minutes of the machine learning transform.
         * <p>
         * @return {@code this}
         * @param timeout The timeout in minutes of the machine learning transform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final java.lang.Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The encryption-at-rest settings of the transform that apply to accessing user data.
         * <p>
         * Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * <p>
         * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
         * KMS key.
         * <p>
         * @return {@code this}
         * @param transformEncryption The encryption-at-rest settings of the transform that apply to accessing user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformEncryption(final software.amazon.awscdk.services.glue.CfnMLTransform.TransformEncryptionProperty transformEncryption) {
            this.props.transformEncryption(transformEncryption);
            return this;
        }
        /**
         * The encryption-at-rest settings of the transform that apply to accessing user data.
         * <p>
         * Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * <p>
         * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
         * KMS key.
         * <p>
         * @return {@code this}
         * @param transformEncryption The encryption-at-rest settings of the transform that apply to accessing user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformEncryption(final software.amazon.awscdk.IResolvable transformEncryption) {
            this.props.transformEncryption(transformEncryption);
            return this;
        }

        /**
         * The type of predefined worker that is allocated when a task of this transform runs.
         * <p>
         * Accepts a value of Standard, G.1X, or G.2X.
         * <p>
         * <ul>
         * <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
         * <li>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</li>
         * <li>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</li>
         * </ul>
         * <p>
         * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
         * <p>
         * <ul>
         * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
         * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
         * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
         * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param workerType The type of predefined worker that is allocated when a task of this transform runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerType(final java.lang.String workerType) {
            this.props.workerType(workerType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.glue.CfnMLTransform}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnMLTransform build() {
            return new software.amazon.awscdk.services.glue.CfnMLTransform(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
