package software.amazon.awscdk.services.elasticloadbalancingv2.targets;

/**
 * A single Application Load Balancer as the target for load balancing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * Vpc vpc;
 * FargateTaskDefinition task = FargateTaskDefinition.Builder.create(this, "Task").cpu(256).memoryLimitMiB(512).build();
 * task.addContainer("nginx", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("public.ecr.aws/nginx/nginx:latest"))
 *         .portMappings(List.of(PortMapping.builder().containerPort(80).build()))
 *         .build());
 * ApplicationLoadBalancedFargateService svc = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .vpc(vpc)
 *         .taskDefinition(task)
 *         .publicLoadBalancer(false)
 *         .build();
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "Nlb")
 *         .vpc(vpc)
 *         .crossZoneEnabled(true)
 *         .internetFacing(true)
 *         .build();
 * NetworkListener listener = nlb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("Targets", AddNetworkTargetsProps.builder()
 *         .targets(List.of(new AlbTarget(svc.getLoadBalancer(), 80)))
 *         .port(80)
 *         .build());
 * CfnOutput.Builder.create(this, "NlbEndpoint").value(String.format("http://%s", nlb.getLoadBalancerDnsName())).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2_targets.AlbTarget")
public class AlbTarget extends software.amazon.awscdk.services.elasticloadbalancingv2.targets.AlbArnTarget {

    protected AlbTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param alb The application load balancer to load balance to. This parameter is required.
     * @param port The port on which the target is listening. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AlbTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer alb, final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(alb, "alb is required"), java.util.Objects.requireNonNull(port, "port is required") });
    }
}
