package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * SecurityGroup securityGroup;
 * ApplicationListenerAttributes applicationListenerAttributes = ApplicationListenerAttributes.builder()
 *         .listenerArn("listenerArn")
 *         .securityGroup(securityGroup)
 *         // the properties below are optional
 *         .defaultPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.577Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerAttributes")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getListenerArn();

    /**
     * Security group of the load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * The default port on which this listener is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerAttributes> {
        java.lang.String listenerArn;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.Number defaultPort;

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getListenerArn}
         * @param listenerArn ARN of the listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getSecurityGroup}
         * @param securityGroup Security group of the load balancer this listener is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getDefaultPort}
         * @param defaultPort The default port on which this listener is listening.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.Number defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerAttributes {
        private final java.lang.String listenerArn;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Number defaultPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listenerArn = software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.defaultPort = software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listenerArn = java.util.Objects.requireNonNull(builder.listenerArn, "listenerArn is required");
            this.securityGroup = java.util.Objects.requireNonNull(builder.securityGroup, "securityGroup is required");
            this.defaultPort = builder.defaultPort;
        }

        @Override
        public final java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.Number getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerAttributes.Jsii$Proxy that = (ApplicationListenerAttributes.Jsii$Proxy) o;

            if (!listenerArn.equals(that.listenerArn)) return false;
            if (!securityGroup.equals(that.securityGroup)) return false;
            return this.defaultPort != null ? this.defaultPort.equals(that.defaultPort) : that.defaultPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listenerArn.hashCode();
            result = 31 * result + (this.securityGroup.hashCode());
            result = 31 * result + (this.defaultPort != null ? this.defaultPort.hashCode() : 0);
            return result;
        }
    }
}
