package software.amazon.awscdk.services.ecs;

/**
 * The details on a data volume from another container in the same task definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * VolumeFrom volumeFrom = VolumeFrom.builder()
 *         .readOnly(false)
 *         .sourceContainer("sourceContainer")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.288Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.VolumeFrom")
@software.amazon.jsii.Jsii.Proxy(VolumeFrom.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VolumeFrom extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the container has read-only access to the volume.
     * <p>
     * If this value is true, the container has read-only access to the volume.
     * If this value is false, then the container can write to the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getReadOnly();

    /**
     * The name of another container within the same task definition from which to mount volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceContainer();

    /**
     * @return a {@link Builder} of {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VolumeFrom> {
        java.lang.Boolean readOnly;
        java.lang.String sourceContainer;

        /**
         * Sets the value of {@link VolumeFrom#getReadOnly}
         * @param readOnly Specifies whether the container has read-only access to the volume. This parameter is required.
         *                 If this value is true, the container has read-only access to the volume.
         *                 If this value is false, then the container can write to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link VolumeFrom#getSourceContainer}
         * @param sourceContainer The name of another container within the same task definition from which to mount volumes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceContainer(java.lang.String sourceContainer) {
            this.sourceContainer = sourceContainer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VolumeFrom}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VolumeFrom build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeFrom {
        private final java.lang.Boolean readOnly;
        private final java.lang.String sourceContainer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceContainer = software.amazon.jsii.Kernel.get(this, "sourceContainer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readOnly = java.util.Objects.requireNonNull(builder.readOnly, "readOnly is required");
            this.sourceContainer = java.util.Objects.requireNonNull(builder.sourceContainer, "sourceContainer is required");
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.lang.String getSourceContainer() {
            return this.sourceContainer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("readOnly", om.valueToTree(this.getReadOnly()));
            data.set("sourceContainer", om.valueToTree(this.getSourceContainer()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.VolumeFrom"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VolumeFrom.Jsii$Proxy that = (VolumeFrom.Jsii$Proxy) o;

            if (!readOnly.equals(that.readOnly)) return false;
            return this.sourceContainer.equals(that.sourceContainer);
        }

        @Override
        public final int hashCode() {
            int result = this.readOnly.hashCode();
            result = 31 * result + (this.sourceContainer.hashCode());
            return result;
        }
    }
}
