package software.amazon.awscdk.services.ecs;

/**
 * The details of a tmpfs mount for a container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * Tmpfs tmpfs = Tmpfs.builder()
 *         .containerPath("containerPath")
 *         .size(123)
 *         // the properties below are optional
 *         .mountOptions(List.of(TmpfsMountOption.DEFAULTS))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.278Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Tmpfs")
@software.amazon.jsii.Jsii.Proxy(Tmpfs.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Tmpfs extends software.amazon.jsii.JsiiSerializable {

    /**
     * The absolute file path where the tmpfs volume is to be mounted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerPath();

    /**
     * The size (in MiB) of the tmpfs volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSize();

    /**
     * The list of tmpfs volume mount options.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Tmpfs.html">TmpfsMountOptions</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption> getMountOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Tmpfs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Tmpfs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Tmpfs> {
        java.lang.String containerPath;
        java.lang.Number size;
        java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption> mountOptions;

        /**
         * Sets the value of {@link Tmpfs#getContainerPath}
         * @param containerPath The absolute file path where the tmpfs volume is to be mounted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link Tmpfs#getSize}
         * @param size The size (in MiB) of the tmpfs volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.Number size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link Tmpfs#getMountOptions}
         * @param mountOptions The list of tmpfs volume mount options.
         *                     For more information, see
         *                     <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Tmpfs.html">TmpfsMountOptions</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder mountOptions(java.util.List<? extends software.amazon.awscdk.services.ecs.TmpfsMountOption> mountOptions) {
            this.mountOptions = (java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption>)mountOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Tmpfs}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Tmpfs build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Tmpfs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Tmpfs {
        private final java.lang.String containerPath;
        private final java.lang.Number size;
        private final java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption> mountOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TmpfsMountOption.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
            this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
            this.mountOptions = (java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption>)builder.mountOptions;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.Number getSize() {
            return this.size;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.TmpfsMountOption> getMountOptions() {
            return this.mountOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("size", om.valueToTree(this.getSize()));
            if (this.getMountOptions() != null) {
                data.set("mountOptions", om.valueToTree(this.getMountOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.Tmpfs"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Tmpfs.Jsii$Proxy that = (Tmpfs.Jsii$Proxy) o;

            if (!containerPath.equals(that.containerPath)) return false;
            if (!size.equals(that.size)) return false;
            return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerPath.hashCode();
            result = 31 * result + (this.size.hashCode());
            result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
            return result;
        }
    }
}
