package software.amazon.awscdk.services.ecs;

/**
 * A CloudFormation `AWS::ECS::Service`.
 * <p>
 * The <code>AWS::ECS::Service</code> resource creates an Amazon Elastic Container Service (Amazon ECS) service that runs and maintains the requested number of tasks and associated load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnService cfnService = CfnService.Builder.create(this, "MyCfnService")
 *         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                 .base(123)
 *                 .capacityProvider("capacityProvider")
 *                 .weight(123)
 *                 .build()))
 *         .cluster("cluster")
 *         .deploymentConfiguration(DeploymentConfigurationProperty.builder()
 *                 .deploymentCircuitBreaker(DeploymentCircuitBreakerProperty.builder()
 *                         .enable(false)
 *                         .rollback(false)
 *                         .build())
 *                 .maximumPercent(123)
 *                 .minimumHealthyPercent(123)
 *                 .build())
 *         .deploymentController(DeploymentControllerProperty.builder()
 *                 .type("type")
 *                 .build())
 *         .desiredCount(123)
 *         .enableEcsManagedTags(false)
 *         .enableExecuteCommand(false)
 *         .healthCheckGracePeriodSeconds(123)
 *         .launchType("launchType")
 *         .loadBalancers(List.of(LoadBalancerProperty.builder()
 *                 .containerPort(123)
 *                 // the properties below are optional
 *                 .containerName("containerName")
 *                 .loadBalancerName("loadBalancerName")
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                         .subnets(List.of("subnets"))
 *                         // the properties below are optional
 *                         .assignPublicIp("assignPublicIp")
 *                         .securityGroups(List.of("securityGroups"))
 *                         .build())
 *                 .build())
 *         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .expression("expression")
 *                 .build()))
 *         .placementStrategies(List.of(PlacementStrategyProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .field("field")
 *                 .build()))
 *         .platformVersion("platformVersion")
 *         .propagateTags("propagateTags")
 *         .role("role")
 *         .schedulingStrategy("schedulingStrategy")
 *         .serviceName("serviceName")
 *         .serviceRegistries(List.of(ServiceRegistryProperty.builder()
 *                 .containerName("containerName")
 *                 .containerPort(123)
 *                 .port(123)
 *                 .registryArn("registryArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskDefinition("taskDefinition")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService")
public class CfnService extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ECS::Service`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ECS::Service`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the Amazon ECS service, such as `sample-webapp` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Not currently supported in AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The metadata that you apply to the service to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
     * <li>Tag keys and values are case-sensitive.</li>
     * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The capacity provider strategy to use for the service.
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * <p>
     * Review the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html#capacity-providers-considerations">Capacity provider considerations</a> in the <em>Amazon Elastic Container Service Developer Guide.</em>
     * <p>
     * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     * <p>
     * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderStrategy() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The capacity provider strategy to use for the service.
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * <p>
     * Review the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html#capacity-providers-considerations">Capacity provider considerations</a> in the <em>Amazon Elastic Container Service Developer Guide.</em>
     * <p>
     * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     * <p>
     * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviderStrategy", value);
    }

    /**
     * The capacity provider strategy to use for the service.
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * <p>
     * Review the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html#capacity-providers-considerations">Capacity provider considerations</a> in the <em>Amazon Elastic Container Service Developer Guide.</em>
     * <p>
     * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     * <p>
     * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.CapacityProviderStrategyItemProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnService.CapacityProviderStrategyItemProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "capacityProviderStrategy", value);
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
     * <p>
     * If you do not specify a cluster, the default cluster is assumed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
     * <p>
     * If you do not specify a cluster, the default cluster is assumed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCluster(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cluster", value);
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * The deployment controller to use for the service.
     * <p>
     * If no deployment controller is specified, the default value of <code>ECS</code> is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentController() {
        return software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deployment controller to use for the service.
     * <p>
     * If no deployment controller is specified, the default value of <code>ECS</code> is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentController(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentControllerProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentController", value);
    }

    /**
     * The deployment controller to use for the service.
     * <p>
     * If no deployment controller is specified, the default value of <code>ECS</code> is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentController(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentController", value);
    }

    /**
     * The number of instantiations of the specified task definition to place and keep running on your cluster.
     * <p>
     * For new services, if a desired count is not specified, a default value of <code>1</code> is used. When using the <code>DAEMON</code> scheduling strategy, the desired count is not required.
     * <p>
     * For existing services, if a desired count is not specified, it is omitted from the operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of instantiations of the specified task definition to place and keep running on your cluster.
     * <p>
     * For new services, if a desired count is not specified, a default value of <code>1</code> is used. When using the <code>DAEMON</code> scheduling strategy, the desired count is not required.
     * <p>
     * For existing services, if a desired count is not specified, it is omitted from the operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "desiredCount", value);
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableEcsManagedTags() {
        return software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableEcsManagedTags(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableEcsManagedTags", value);
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableEcsManagedTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableEcsManagedTags", value);
    }

    /**
     * Determines whether the execute command functionality is enabled for the service.
     * <p>
     * If <code>true</code> , the execute command functionality is enabled for all containers in tasks as part of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableExecuteCommand() {
        return software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Determines whether the execute command functionality is enabled for the service.
     * <p>
     * If <code>true</code> , the execute command functionality is enabled for all containers in tasks as part of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableExecuteCommand(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableExecuteCommand", value);
    }

    /**
     * Determines whether the execute command functionality is enabled for the service.
     * <p>
     * If <code>true</code> , the execute command functionality is enabled for all containers in tasks as part of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableExecuteCommand(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableExecuteCommand", value);
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.
     * <p>
     * If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a> .
     * <p>
     * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckGracePeriodSeconds() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.
     * <p>
     * If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a> .
     * <p>
     * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckGracePeriodSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckGracePeriodSeconds", value);
    }

    /**
     * The launch type on which to run your service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
        return software.amazon.jsii.Kernel.get(this, "launchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The launch type on which to run your service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "launchType", value);
    }

    /**
     * A list of load balancer objects to associate with the service.
     * <p>
     * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancers() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of load balancer objects to associate with the service.
     * <p>
     * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancers", value);
    }

    /**
     * A list of load balancer objects to associate with the service.
     * <p>
     * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "loadBalancers", value);
    }

    /**
     * The network configuration for the service.
     * <p>
     * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network configuration for the service.
     * <p>
     * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The network configuration for the service.
     * <p>
     * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
        return software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of five strategy rules per service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacementStrategies() {
        return software.amazon.jsii.Kernel.get(this, "placementStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of five strategy rules per service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementStrategies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placementStrategies", value);
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     * <p>
     * You can specify a maximum of five strategy rules per service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementStrategies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "placementStrategies", value);
    }

    /**
     * The platform version that your tasks in the service are running on.
     * <p>
     * A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
        return software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The platform version that your tasks in the service are running on.
     * <p>
     * A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "platformVersion", value);
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during service creation. To add tags to a task after service creation, use the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during service creation. To add tags to a task after service creation, use the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
     * <p>
     * This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
     * <p>
     * <blockquote>
     * <p>
     * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * If your specified role has a path other than <code>/</code> , then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
     * <p>
     * This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
     * <p>
     * <blockquote>
     * <p>
     * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * If your specified role has a path other than <code>/</code> , then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", value);
    }

    /**
     * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) .
     * <p>
     * There are two service scheduler strategies available:
     * <p>
     * <ul>
     * <li><code>REPLICA</code> -The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</li>
     * <li><code>DAEMON</code> -The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedulingStrategy() {
        return software.amazon.jsii.Kernel.get(this, "schedulingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) .
     * <p>
     * There are two service scheduler strategies available:
     * <p>
     * <ul>
     * <li><code>REPLICA</code> -The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</li>
     * <li><code>DAEMON</code> -The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulingStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedulingStrategy", value);
    }

    /**
     * The name of your service.
     * <p>
     * Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your service.
     * <p>
     * Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", value);
    }

    /**
     * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) .
     * <p>
     * <blockquote>
     * <p>
     * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceRegistries() {
        return software.amazon.jsii.Kernel.get(this, "serviceRegistries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) .
     * <p>
     * <blockquote>
     * <p>
     * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", value);
    }

    /**
     * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) .
     * <p>
     * <blockquote>
     * <p>
     * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", value);
    }

    /**
     * The `family` and `revision` ( `family:revision` ) or full ARN of the task definition to run in your service.
     * <p>
     * The <code>revision</code> is required in order for the resource to stabilize.
     * <p>
     * A task definition must be specified if the service is using either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The `family` and `revision` ( `family:revision` ) or full ARN of the task definition to run in your service.
     * <p>
     * The <code>revision</code> is required in order for the resource to stabilize.
     * <p>
     * A task definition must be specified if the service is using either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskDefinition(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskDefinition", value);
    }
    /**
     * An object representing the networking details for a task or service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AwsVpcConfigurationProperty awsVpcConfigurationProperty = AwsVpcConfigurationProperty.builder()
     *         .subnets(List.of("subnets"))
     *         // the properties below are optional
     *         .assignPublicIp("assignPublicIp")
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the subnets associated with the task or service.
         * <p>
         * There's a limit of 16 subnets that can be specified per <code>AwsVpcConfiguration</code> .
         * <p>
         * <blockquote>
         * <p>
         * All specified subnets must be from the same VPC.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * Whether the task's elastic network interface receives a public IP address.
         * <p>
         * The default value is <code>DISABLED</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * The IDs of the security groups associated with the task or service.
         * <p>
         * If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per <code>AwsVpcConfiguration</code> .
         * <p>
         * <blockquote>
         * <p>
         * All specified security groups must be from the same VPC.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            java.util.List<java.lang.String> subnets;
            java.lang.String assignPublicIp;
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets The IDs of the subnets associated with the task or service. This parameter is required.
             *                There's a limit of 16 subnets that can be specified per <code>AwsVpcConfiguration</code> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                All specified subnets must be from the same VPC.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Whether the task's elastic network interface receives a public IP address.
             *                       The default value is <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups The IDs of the security groups associated with the task or service.
             *                       If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per <code>AwsVpcConfiguration</code> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       All specified security groups must be from the same VPC.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.assignPublicIp = builder.assignPublicIp;
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of a capacity provider strategy.
     * <p>
     * A capacity provider strategy can be set when using the <code>RunTask</code> or <code>CreateService</code> APIs or as the default capacity provider strategy for a cluster with the <code>CreateCluster</code> API.
     * <p>
     * Only capacity providers that are already associated with a cluster and have an <code>ACTIVE</code> or <code>UPDATING</code> status can be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New Auto Scaling group capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used in a capacity provider strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .base(123)
     *         .capacityProvider("capacityProvider")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The short name of the capacity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProvider() {
            return null;
        }

        /**
         * The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
         * <p>
         * If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
         * <p>
         * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.Number base;
            java.lang.String capacityProvider;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
             *               <p>
             *               If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
             *               <p>
             *               An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.Number base;
            private final java.lang.String capacityProvider;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.base = builder.base;
                this.capacityProvider = builder.capacityProvider;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getCapacityProvider() != null) {
                    data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                if (this.capacityProvider != null ? !this.capacityProvider.equals(that.capacityProvider) : that.capacityProvider != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.base != null ? this.base.hashCode() : 0;
                result = 31 * result + (this.capacityProvider != null ? this.capacityProvider.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * > The deployment circuit breaker can only be used for services using the rolling update ( `ECS` ) deployment type.
     * <p>
     * The <code>DeploymentCircuitBreaker</code> property determines whether a service deployment will fail if the service can't reach a steady state. If deployment circuit breaker is enabled, a service deployment will transition to a failed state and stop launching new tasks. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentCircuitBreakerProperty deploymentCircuitBreakerProperty = DeploymentCircuitBreakerProperty.builder()
     *         .enable(false)
     *         .rollback(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentCircuitBreakerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentCircuitBreakerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentCircuitBreakerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether to use the deployment circuit breaker logic for the service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnable();

        /**
         * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails.
         * <p>
         * If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRollback();

        /**
         * @return a {@link Builder} of {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentCircuitBreakerProperty> {
            java.lang.Object enable;
            java.lang.Object rollback;

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getEnable}
             * @param enable Determines whether to use the deployment circuit breaker logic for the service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getEnable}
             * @param enable Determines whether to use the deployment circuit breaker logic for the service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(java.lang.Boolean rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(software.amazon.awscdk.IResolvable rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentCircuitBreakerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentCircuitBreakerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentCircuitBreakerProperty {
            private final java.lang.Object enable;
            private final java.lang.Object rollback;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollback = software.amazon.jsii.Kernel.get(this, "rollback", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enable = java.util.Objects.requireNonNull(builder.enable, "enable is required");
                this.rollback = java.util.Objects.requireNonNull(builder.rollback, "rollback is required");
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            public final java.lang.Object getRollback() {
                return this.rollback;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enable", om.valueToTree(this.getEnable()));
                data.set("rollback", om.valueToTree(this.getRollback()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentCircuitBreakerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentCircuitBreakerProperty.Jsii$Proxy that = (DeploymentCircuitBreakerProperty.Jsii$Proxy) o;

                if (!enable.equals(that.enable)) return false;
                return this.rollback.equals(that.rollback);
            }

            @Override
            public final int hashCode() {
                int result = this.enable.hashCode();
                result = 31 * result + (this.rollback.hashCode());
                return result;
            }
        }
    }
    /**
     * The `DeploymentConfiguration` property specifies optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentConfigurationProperty deploymentConfigurationProperty = DeploymentConfigurationProperty.builder()
     *         .deploymentCircuitBreaker(DeploymentCircuitBreakerProperty.builder()
     *                 .enable(false)
     *                 .rollback(false)
     *                 .build())
     *         .maximumPercent(123)
     *         .minimumHealthyPercent(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * > The deployment circuit breaker can only be used for services using the rolling update ( `ECS` ) deployment type that are not behind a Classic Load Balancer.
         * <p>
         * The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If enabled, a service deployment will transition to a failed state and stop launching new tasks. You can also enable Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentCircuitBreaker() {
            return null;
        }

        /**
         * If a service is using the rolling update ( `ECS` ) deployment type, the `maximumPercent` parameter represents an upper limit on the number of your service's tasks that are allowed in the `RUNNING` or `PENDING` state during a deployment, as a percentage of the `desiredCount` (rounded down to the nearest integer).
         * <p>
         * This parameter enables you to define the deployment batch size. For example, if your service is using the <code>REPLICA</code> service scheduler and has a <code>desiredCount</code> of four tasks and a <code>maximumPercent</code> value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default <code>maximumPercent</code> value for a service using the <code>REPLICA</code> service scheduler is 200%.
         * <p>
         * If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the <em>maximum percent</em> value is set to the default value and is used to define the upper limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If the tasks in the service use the Fargate launch type, the maximum percent value is not used, although it is returned when describing your service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumPercent() {
            return null;
        }

        /**
         * If a service is using the rolling update ( `ECS` ) deployment type, the `minimumHealthyPercent` represents a lower limit on the number of your service's tasks that must remain in the `RUNNING` state during a deployment, as a percentage of the `desiredCount` (rounded up to the nearest integer).
         * <p>
         * This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a <code>desiredCount</code> of four tasks and a <code>minimumHealthyPercent</code> of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks.
         * <p>
         * For services that <em>do not</em> use a load balancer, the following should be noted:
         * <p>
         * <ul>
         * <li>A service is considered healthy if all essential containers within the tasks in the service pass their health checks.</li>
         * <li>If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a <code>RUNNING</code> state before the task is counted towards the minimum healthy percent total.</li>
         * <li>If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings.</li>
         * </ul>
         * <p>
         * For services are that <em>do</em> use a load balancer, the following should be noted:
         * <p>
         * <ul>
         * <li>If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
         * <li>If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
         * </ul>
         * <p>
         * If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the EC2 launch type, the <em>minimum healthy percent</em> value is set to the default value and is used to define the lower limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumHealthyPercent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigurationProperty> {
            java.lang.Object deploymentCircuitBreaker;
            java.lang.Number maximumPercent;
            java.lang.Number minimumHealthyPercent;

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getDeploymentCircuitBreaker}
             * @param deploymentCircuitBreaker > The deployment circuit breaker can only be used for services using the rolling update ( `ECS` ) deployment type that are not behind a Classic Load Balancer.
             *                                 The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If enabled, a service deployment will transition to a failed state and stop launching new tasks. You can also enable Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentCircuitBreaker(software.amazon.awscdk.services.ecs.CfnService.DeploymentCircuitBreakerProperty deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getDeploymentCircuitBreaker}
             * @param deploymentCircuitBreaker > The deployment circuit breaker can only be used for services using the rolling update ( `ECS` ) deployment type that are not behind a Classic Load Balancer.
             *                                 The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If enabled, a service deployment will transition to a failed state and stop launching new tasks. You can also enable Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentCircuitBreaker(software.amazon.awscdk.IResolvable deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getMaximumPercent}
             * @param maximumPercent If a service is using the rolling update ( `ECS` ) deployment type, the `maximumPercent` parameter represents an upper limit on the number of your service's tasks that are allowed in the `RUNNING` or `PENDING` state during a deployment, as a percentage of the `desiredCount` (rounded down to the nearest integer).
             *                       This parameter enables you to define the deployment batch size. For example, if your service is using the <code>REPLICA</code> service scheduler and has a <code>desiredCount</code> of four tasks and a <code>maximumPercent</code> value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default <code>maximumPercent</code> value for a service using the <code>REPLICA</code> service scheduler is 200%.
             *                       <p>
             *                       If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the <em>maximum percent</em> value is set to the default value and is used to define the upper limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If the tasks in the service use the Fargate launch type, the maximum percent value is not used, although it is returned when describing your service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumPercent(java.lang.Number maximumPercent) {
                this.maximumPercent = maximumPercent;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getMinimumHealthyPercent}
             * @param minimumHealthyPercent If a service is using the rolling update ( `ECS` ) deployment type, the `minimumHealthyPercent` represents a lower limit on the number of your service's tasks that must remain in the `RUNNING` state during a deployment, as a percentage of the `desiredCount` (rounded up to the nearest integer).
             *                              This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a <code>desiredCount</code> of four tasks and a <code>minimumHealthyPercent</code> of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks.
             *                              <p>
             *                              For services that <em>do not</em> use a load balancer, the following should be noted:
             *                              <p>
             *                              <ul>
             *                              <li>A service is considered healthy if all essential containers within the tasks in the service pass their health checks.</li>
             *                              <li>If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a <code>RUNNING</code> state before the task is counted towards the minimum healthy percent total.</li>
             *                              <li>If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings.</li>
             *                              </ul>
             *                              <p>
             *                              For services are that <em>do</em> use a load balancer, the following should be noted:
             *                              <p>
             *                              <ul>
             *                              <li>If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
             *                              <li>If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
             *                              </ul>
             *                              <p>
             *                              If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the EC2 launch type, the <em>minimum healthy percent</em> value is set to the default value and is used to define the lower limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumHealthyPercent(java.lang.Number minimumHealthyPercent) {
                this.minimumHealthyPercent = minimumHealthyPercent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigurationProperty {
            private final java.lang.Object deploymentCircuitBreaker;
            private final java.lang.Number maximumPercent;
            private final java.lang.Number minimumHealthyPercent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentCircuitBreaker = software.amazon.jsii.Kernel.get(this, "deploymentCircuitBreaker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumPercent = software.amazon.jsii.Kernel.get(this, "maximumPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumHealthyPercent = software.amazon.jsii.Kernel.get(this, "minimumHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
                this.maximumPercent = builder.maximumPercent;
                this.minimumHealthyPercent = builder.minimumHealthyPercent;
            }

            @Override
            public final java.lang.Object getDeploymentCircuitBreaker() {
                return this.deploymentCircuitBreaker;
            }

            @Override
            public final java.lang.Number getMaximumPercent() {
                return this.maximumPercent;
            }

            @Override
            public final java.lang.Number getMinimumHealthyPercent() {
                return this.minimumHealthyPercent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeploymentCircuitBreaker() != null) {
                    data.set("deploymentCircuitBreaker", om.valueToTree(this.getDeploymentCircuitBreaker()));
                }
                if (this.getMaximumPercent() != null) {
                    data.set("maximumPercent", om.valueToTree(this.getMaximumPercent()));
                }
                if (this.getMinimumHealthyPercent() != null) {
                    data.set("minimumHealthyPercent", om.valueToTree(this.getMinimumHealthyPercent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigurationProperty.Jsii$Proxy that = (DeploymentConfigurationProperty.Jsii$Proxy) o;

                if (this.deploymentCircuitBreaker != null ? !this.deploymentCircuitBreaker.equals(that.deploymentCircuitBreaker) : that.deploymentCircuitBreaker != null) return false;
                if (this.maximumPercent != null ? !this.maximumPercent.equals(that.maximumPercent) : that.maximumPercent != null) return false;
                return this.minimumHealthyPercent != null ? this.minimumHealthyPercent.equals(that.minimumHealthyPercent) : that.minimumHealthyPercent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentCircuitBreaker != null ? this.deploymentCircuitBreaker.hashCode() : 0;
                result = 31 * result + (this.maximumPercent != null ? this.maximumPercent.hashCode() : 0);
                result = 31 * result + (this.minimumHealthyPercent != null ? this.minimumHealthyPercent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deployment controller to use for the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentControllerProperty deploymentControllerProperty = DeploymentControllerProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentControllerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentControllerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentControllerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The deployment controller type to use. There are three deployment controller types available:.
         * <p>
         * <ul>
         * <li><strong>ECS</strong> - The rolling update ( <code>ECS</code> ) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeploymentConfiguration.html">DeploymentConfiguration</a> .</li>
         * <li><strong>CODE_DEPLOY</strong> - The blue/green ( <code>CODE_DEPLOY</code> ) deployment type uses the blue/green deployment model powered by AWS CodeDeploy , which allows you to verify a new deployment of a service before sending production traffic to it.</li>
         * <li><strong>EXTERNAL</strong> - The external ( <code>EXTERNAL</code> ) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentControllerProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link DeploymentControllerProperty#getType}
             * @param type The deployment controller type to use. There are three deployment controller types available:.
             *             <ul>
             *             <li><strong>ECS</strong> - The rolling update ( <code>ECS</code> ) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeploymentConfiguration.html">DeploymentConfiguration</a> .</li>
             *             <li><strong>CODE_DEPLOY</strong> - The blue/green ( <code>CODE_DEPLOY</code> ) deployment type uses the blue/green deployment model powered by AWS CodeDeploy , which allows you to verify a new deployment of a service before sending production traffic to it.</li>
             *             <li><strong>EXTERNAL</strong> - The external ( <code>EXTERNAL</code> ) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentControllerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentControllerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentControllerProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentControllerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentControllerProperty.Jsii$Proxy that = (DeploymentControllerProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `LoadBalancer` property specifies details on a load balancer that is used with a service.
     * <p>
     * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When you are creating an AWS CodeDeploy deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code> ). Each target group binds to a separate task set in the deployment. The load balancer can also have up to two listeners, a required listener for production traffic and an optional listener that allows you to test new revisions of the service before routing production traffic to it.
     * <p>
     * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the target type, not <code>instance</code> . Tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * LoadBalancerProperty loadBalancerProperty = LoadBalancerProperty.builder()
     *         .containerPort(123)
     *         // the properties below are optional
     *         .containerName("containerName")
     *         .loadBalancerName("loadBalancerName")
     *         .targetGroupArn("targetGroupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.LoadBalancerProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port on the container to associate with the load balancer.
         * <p>
         * This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getContainerPort();

        /**
         * The name of the container (as it appears in a container definition) to associate with the load balancer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The name of the load balancer to associate with the Amazon ECS service or task set.
         * <p>
         * A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
         * <p>
         * A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you're using a Classic Load Balancer, omit the target group ARN.
         * <p>
         * For services using the <code>ECS</code> deployment controller, you can specify one or multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering multiple target groups with a service</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * For services using the <code>CODE_DEPLOY</code> deployment controller, you're required to define two target groups for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/green deployment with CodeDeploy</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If your service's task definition uses the <code>awsvpc</code> network mode, you must choose <code>ip</code> as the target type, not <code>instance</code> . Do this when creating your target groups because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            java.lang.Number containerPort;
            java.lang.String containerName;
            java.lang.String loadBalancerName;
            java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerPort}
             * @param containerPort The port on the container to associate with the load balancer. This parameter is required.
             *                      This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerName}
             * @param containerName The name of the container (as it appears in a container definition) to associate with the load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getLoadBalancerName}
             * @param loadBalancerName The name of the load balancer to associate with the Amazon ECS service or task set.
             *                         A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerName(java.lang.String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getTargetGroupArn}
             * @param targetGroupArn The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
             *                       A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you're using a Classic Load Balancer, omit the target group ARN.
             *                       <p>
             *                       For services using the <code>ECS</code> deployment controller, you can specify one or multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering multiple target groups with a service</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                       <p>
             *                       For services using the <code>CODE_DEPLOY</code> deployment controller, you're required to define two target groups for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/green deployment with CodeDeploy</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       If your service's task definition uses the <code>awsvpc</code> network mode, you must choose <code>ip</code> as the target type, not <code>instance</code> . Do this when creating your target groups because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerProperty {
            private final java.lang.Number containerPort;
            private final java.lang.String containerName;
            private final java.lang.String loadBalancerName;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPort = java.util.Objects.requireNonNull(builder.containerPort, "containerPort is required");
                this.containerName = builder.containerName;
                this.loadBalancerName = builder.loadBalancerName;
                this.targetGroupArn = builder.targetGroupArn;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.String getLoadBalancerName() {
                return this.loadBalancerName;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerPort", om.valueToTree(this.getContainerPort()));
                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getLoadBalancerName() != null) {
                    data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.LoadBalancerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerProperty.Jsii$Proxy that = (LoadBalancerProperty.Jsii$Proxy) o;

                if (!containerPort.equals(that.containerPort)) return false;
                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPort.hashCode();
                result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
                result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `NetworkConfiguration` property specifies an object representing the network configuration for a task or service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                 .subnets(List.of("subnets"))
     *                 // the properties below are optional
     *                 .assignPublicIp("assignPublicIp")
     *                 .securityGroups(List.of("securityGroups"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC subnets and security groups that are associated with a task.
         * <p>
         * <blockquote>
         * <p>
         * All specified subnets and security groups must be from the same VPC.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsvpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object awsvpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration The VPC subnets and security groups that are associated with a task.
             *                            <blockquote>
             *                            <p>
             *                            All specified subnets and security groups must be from the same VPC.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.services.ecs.CfnService.AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration The VPC subnets and security groups that are associated with a task.
             *                            <blockquote>
             *                            <p>
             *                            All specified subnets and security groups must be from the same VPC.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsvpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsvpcConfiguration = software.amazon.jsii.Kernel.get(this, "awsvpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsvpcConfiguration = builder.awsvpcConfiguration;
            }

            @Override
            public final java.lang.Object getAwsvpcConfiguration() {
                return this.awsvpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsvpcConfiguration() != null) {
                    data.set("awsvpcConfiguration", om.valueToTree(this.getAwsvpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsvpcConfiguration != null ? this.awsvpcConfiguration.equals(that.awsvpcConfiguration) : that.awsvpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsvpcConfiguration != null ? this.awsvpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `PlacementConstraint` property specifies an object representing a constraint on task placement in the task definition.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * PlacementConstraintProperty placementConstraintProperty = PlacementConstraintProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of constraint.
         * <p>
         * Use <code>distinctInstance</code> to ensure that each task in a particular group is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A cluster query language expression to apply to the constraint.
         * <p>
         * The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is <code>distinctInstance</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            java.lang.String type;
            java.lang.String expression;

            /**
             * Sets the value of {@link PlacementConstraintProperty#getType}
             * @param type The type of constraint. This parameter is required.
             *             Use <code>distinctInstance</code> to ensure that each task in a particular group is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PlacementConstraintProperty#getExpression}
             * @param expression A cluster query language expression to apply to the constraint.
             *                   The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is <code>distinctInstance</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementConstraintProperty {
            private final java.lang.String type;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.PlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementConstraintProperty.Jsii$Proxy that = (PlacementConstraintProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `PlacementStrategy` property specifies the task placement strategy for a task or service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * PlacementStrategyProperty placementStrategyProperty = PlacementStrategyProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .field("field")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of placement strategy.
         * <p>
         * The <code>random</code> placement strategy randomly places tasks on available candidates. The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the <code>field</code> parameter. The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that's specified with the <code>field</code> parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The field to apply the placement strategy against.
         * <p>
         * For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code> , which has the same effect), or any platform or custom attribute that's applied to a container instance, such as <code>attribute:ecs.availability-zone</code> . For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code> . For the <code>random</code> placement strategy, this field is not used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            java.lang.String type;
            java.lang.String field;

            /**
             * Sets the value of {@link PlacementStrategyProperty#getType}
             * @param type The type of placement strategy. This parameter is required.
             *             The <code>random</code> placement strategy randomly places tasks on available candidates. The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the <code>field</code> parameter. The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that's specified with the <code>field</code> parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PlacementStrategyProperty#getField}
             * @param field The field to apply the placement strategy against.
             *              For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code> , which has the same effect), or any platform or custom attribute that's applied to a container instance, such as <code>attribute:ecs.availability-zone</code> . For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code> . For the <code>random</code> placement strategy, this field is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementStrategyProperty {
            private final java.lang.String type;
            private final java.lang.String field;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.field = builder.field;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.PlacementStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementStrategyProperty.Jsii$Proxy that = (PlacementStrategyProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.field != null ? this.field.equals(that.field) : that.field == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ServiceRegistry` property specifies details of the service registry.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceRegistryProperty serviceRegistryProperty = ServiceRegistryProperty.builder()
     *         .containerName("containerName")
     *         .containerPort(123)
     *         .port(123)
     *         .registryArn("registryArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceRegistryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceRegistryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container name value to be used for your service discovery service.
         * <p>
         * It's already specified in the task definition. If the task definition that your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition that your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The port value to be used for your service discovery service.
         * <p>
         * It's already specified in the task definition. If the task definition your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * The port value used if your service discovery service specified an SRV record.
         * <p>
         * This field might be used if both the <code>awsvpc</code> network mode and SRV records are used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the service registry.
         * <p>
         * The currently supported service registry is AWS Cloud Map . For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegistryArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            java.lang.String containerName;
            java.lang.Number containerPort;
            java.lang.Number port;
            java.lang.String registryArn;

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerName}
             * @param containerName The container name value to be used for your service discovery service.
             *                      It's already specified in the task definition. If the task definition that your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition that your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerPort}
             * @param containerPort The port value to be used for your service discovery service.
             *                      It's already specified in the task definition. If the task definition your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getPort}
             * @param port The port value used if your service discovery service specified an SRV record.
             *             This field might be used if both the <code>awsvpc</code> network mode and SRV records are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getRegistryArn}
             * @param registryArn The Amazon Resource Name (ARN) of the service registry.
             *                    The currently supported service registry is AWS Cloud Map . For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryArn(java.lang.String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceRegistryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceRegistryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceRegistryProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.Number port;
            private final java.lang.String registryArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.registryArn = software.amazon.jsii.Kernel.get(this, "registryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = builder.containerName;
                this.containerPort = builder.containerPort;
                this.port = builder.port;
                this.registryArn = builder.registryArn;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getRegistryArn() {
                return this.registryArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRegistryArn() != null) {
                    data.set("registryArn", om.valueToTree(this.getRegistryArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceRegistryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceRegistryProperty.Jsii$Proxy that = (ServiceRegistryProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.registryArn != null ? this.registryArn.equals(that.registryArn) : that.registryArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.registryArn != null ? this.registryArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The capacity provider strategy to use for the service.
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         * <p>
         * Review the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html#capacity-providers-considerations">Capacity provider considerations</a> in the <em>Amazon Elastic Container Service Developer Guide.</em>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         * <p>
         * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         * <p>
         * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategy The capacity provider strategy to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategy(final software.amazon.awscdk.IResolvable capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }
        /**
         * The capacity provider strategy to use for the service.
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         * <p>
         * Review the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html#capacity-providers-considerations">Capacity provider considerations</a> in the <em>Amazon Elastic Container Service Developer Guide.</em>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         * <p>
         * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         * <p>
         * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategy The capacity provider strategy to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategy(final java.util.List<? extends java.lang.Object> capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
         * <p>
         * If you do not specify a cluster, the default cluster is assumed.
         * <p>
         * @return {@code this}
         * @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final java.lang.String cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         * <p>
         * @return {@code this}
         * @param deploymentConfiguration Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.services.ecs.CfnService.DeploymentConfigurationProperty deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }
        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         * <p>
         * @return {@code this}
         * @param deploymentConfiguration Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.IResolvable deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        /**
         * The deployment controller to use for the service.
         * <p>
         * If no deployment controller is specified, the default value of <code>ECS</code> is used.
         * <p>
         * @return {@code this}
         * @param deploymentController The deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.CfnService.DeploymentControllerProperty deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }
        /**
         * The deployment controller to use for the service.
         * <p>
         * If no deployment controller is specified, the default value of <code>ECS</code> is used.
         * <p>
         * @return {@code this}
         * @param deploymentController The deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.IResolvable deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        /**
         * The number of instantiations of the specified task definition to place and keep running on your cluster.
         * <p>
         * For new services, if a desired count is not specified, a default value of <code>1</code> is used. When using the <code>DAEMON</code> scheduling strategy, the desired count is not required.
         * <p>
         * For existing services, if a desired count is not specified, it is omitted from the operation.
         * <p>
         * @return {@code this}
         * @param desiredCount The number of instantiations of the specified task definition to place and keep running on your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        /**
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }
        /**
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final software.amazon.awscdk.IResolvable enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Determines whether the execute command functionality is enabled for the service.
         * <p>
         * If <code>true</code> , the execute command functionality is enabled for all containers in tasks as part of the service.
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Determines whether the execute command functionality is enabled for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }
        /**
         * Determines whether the execute command functionality is enabled for the service.
         * <p>
         * If <code>true</code> , the execute command functionality is enabled for all containers in tasks as part of the service.
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Determines whether the execute command functionality is enabled for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final software.amazon.awscdk.IResolvable enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.
         * <p>
         * If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a> .
         * <p>
         * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriodSeconds The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriodSeconds(final java.lang.Number healthCheckGracePeriodSeconds) {
            this.props().healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds);
            return this;
        }

        /**
         * The launch type on which to run your service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param launchType The launch type on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchType(final java.lang.String launchType) {
            this.props().launchType(launchType);
            return this;
        }

        /**
         * A list of load balancer objects to associate with the service.
         * <p>
         * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param loadBalancers A list of load balancer objects to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final software.amazon.awscdk.IResolvable loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }
        /**
         * A list of load balancer objects to associate with the service.
         * <p>
         * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param loadBalancers A list of load balancer objects to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final java.util.List<? extends java.lang.Object> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        /**
         * The network configuration for the service.
         * <p>
         * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param networkConfiguration The network configuration for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The network configuration for the service.
         * <p>
         * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param networkConfiguration The network configuration for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * An array of placement constraint objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         * <p>
         * @return {@code this}
         * @param placementConstraints An array of placement constraint objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final software.amazon.awscdk.IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }
        /**
         * An array of placement constraint objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         * <p>
         * @return {@code this}
         * @param placementConstraints An array of placement constraint objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends java.lang.Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        /**
         * The placement strategy objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of five strategy rules per service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param placementStrategies The placement strategy objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementStrategies(final software.amazon.awscdk.IResolvable placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }
        /**
         * The placement strategy objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of five strategy rules per service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param placementStrategies The placement strategy objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementStrategies(final java.util.List<? extends java.lang.Object> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        /**
         * The platform version that your tasks in the service are running on.
         * <p>
         * A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param platformVersion The platform version that your tasks in the service are running on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final java.lang.String platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during service creation. To add tags to a task after service creation, use the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.String propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
         * <p>
         * This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
         * <p>
         * <blockquote>
         * <p>
         * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * If your specified role has a path other than <code>/</code> , then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @param role The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props().role(role);
            return this;
        }

        /**
         * The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) .
         * <p>
         * There are two service scheduler strategies available:
         * <p>
         * <ul>
         * <li><code>REPLICA</code> -The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</li>
         * <li><code>DAEMON</code> -The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param schedulingStrategy The scheduling strategy to use for the service. For more information, see [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingStrategy(final java.lang.String schedulingStrategy) {
            this.props().schedulingStrategy(schedulingStrategy);
            return this;
        }

        /**
         * The name of your service.
         * <p>
         * Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
         * <p>
         * @return {@code this}
         * @param serviceName The name of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) .
         * <p>
         * <blockquote>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serviceRegistries The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final software.amazon.awscdk.IResolvable serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }
        /**
         * The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) .
         * <p>
         * <blockquote>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serviceRegistries The details of the service discovery registry to associate with this service. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final java.util.List<? extends java.lang.Object> serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        /**
         * The metadata that you apply to the service to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
         * <li>Tag keys and values are case-sensitive.</li>
         * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the service to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The `family` and `revision` ( `family:revision` ) or full ARN of the task definition to run in your service.
         * <p>
         * The <code>revision</code> is required in order for the resource to stabilize.
         * <p>
         * A task definition must be specified if the service is using either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.
         * <p>
         * @return {@code this}
         * @param taskDefinition The `family` and `revision` ( `family:revision` ) or full ARN of the task definition to run in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final java.lang.String taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnService build() {
            return new software.amazon.awscdk.services.ecs.CfnService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnServiceProps.Builder();
            }
            return this.props;
        }
    }
}
