package software.amazon.awscdk.services.ecs;

/**
 * A CloudFormation `AWS::ECS::CapacityProvider`.
 * <p>
 * The <code>AWS::ECS::CapacityProvider</code> resource creates an Amazon Elastic Container Service (Amazon ECS) capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.
 * <p>
 * Only capacity providers using an Auto Scaling group can be created. Amazon ECS tasks on AWS Fargate use the <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers which are already created and available to all accounts in Regions supported by AWS Fargate .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnCapacityProvider cfnCapacityProvider = CfnCapacityProvider.Builder.create(this, "MyCfnCapacityProvider")
 *         .autoScalingGroupProvider(AutoScalingGroupProviderProperty.builder()
 *                 .autoScalingGroupArn("autoScalingGroupArn")
 *                 // the properties below are optional
 *                 .managedScaling(ManagedScalingProperty.builder()
 *                         .instanceWarmupPeriod(123)
 *                         .maximumScalingStepSize(123)
 *                         .minimumScalingStepSize(123)
 *                         .status("status")
 *                         .targetCapacity(123)
 *                         .build())
 *                 .managedTerminationProtection("managedTerminationProtection")
 *                 .build())
 *         // the properties below are optional
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider")
public class CfnCapacityProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ECS::CapacityProvider`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The metadata that you apply to the capacity provider to help you categorize and organize it.
     * <p>
     * Each tag consists of a key and an optional value. You define both.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
     * <li>Tag keys and values are case-sensitive.</li>
     * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAutoScalingGroupProvider() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupProvider", java.util.Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupProvider", java.util.Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    /**
     * The name of the capacity provider.
     * <p>
     * If a name is specified, it cannot start with <code>aws</code> , <code>ecs</code> , or <code>fargate</code> . If no name is specified, a default name in the <code>CFNStackName-CFNResourceName-RandomString</code> format is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the capacity provider.
     * <p>
     * If a name is specified, it cannot start with <code>aws</code> , <code>ecs</code> , or <code>fargate</code> . If no name is specified, a default name in the <code>CFNStackName-CFNResourceName-RandomString</code> format is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * The `AutoScalingGroupProvider` property specifies the details of the Auto Scaling group for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AutoScalingGroupProviderProperty autoScalingGroupProviderProperty = AutoScalingGroupProviderProperty.builder()
     *         .autoScalingGroupArn("autoScalingGroupArn")
     *         // the properties below are optional
     *         .managedScaling(ManagedScalingProperty.builder()
     *                 .instanceWarmupPeriod(123)
     *                 .maximumScalingStepSize(123)
     *                 .minimumScalingStepSize(123)
     *                 .status("status")
     *                 .targetCapacity(123)
     *                 .build())
     *         .managedTerminationProtection("managedTerminationProtection")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingGroupProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingGroupProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) or short name that identifies the Auto Scaling group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn();

        /**
         * The managed scaling settings for the Auto Scaling group capacity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedScaling() {
            return null;
        }

        /**
         * The managed termination protection setting to use for the Auto Scaling group capacity provider.
         * <p>
         * This determines whether the Auto Scaling group has managed termination protection. The default is disabled.
         * <p>
         * <blockquote>
         * <p>
         * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
         * <p>
         * </blockquote>
         * <p>
         * When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>AWS Auto Scaling User Guide</em> .
         * <p>
         * When managed termination protection is disabled, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManagedTerminationProtection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupProviderProperty> {
            java.lang.String autoScalingGroupArn;
            java.lang.Object managedScaling;
            java.lang.String managedTerminationProtection;

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getAutoScalingGroupArn}
             * @param autoScalingGroupArn The Amazon Resource Name (ARN) or short name that identifies the Auto Scaling group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingGroupArn(java.lang.String autoScalingGroupArn) {
                this.autoScalingGroupArn = autoScalingGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling The managed scaling settings for the Auto Scaling group capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedScalingProperty managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling The managed scaling settings for the Auto Scaling group capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.IResolvable managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedTerminationProtection}
             * @param managedTerminationProtection The managed termination protection setting to use for the Auto Scaling group capacity provider.
             *                                     This determines whether the Auto Scaling group has managed termination protection. The default is disabled.
             *                                     <p>
             *                                     <blockquote>
             *                                     <p>
             *                                     When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
             *                                     <p>
             *                                     </blockquote>
             *                                     <p>
             *                                     When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>AWS Auto Scaling User Guide</em> .
             *                                     <p>
             *                                     When managed termination protection is disabled, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedTerminationProtection(java.lang.String managedTerminationProtection) {
                this.managedTerminationProtection = managedTerminationProtection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingGroupProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingGroupProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupProviderProperty {
            private final java.lang.String autoScalingGroupArn;
            private final java.lang.Object managedScaling;
            private final java.lang.String managedTerminationProtection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScalingGroupArn = software.amazon.jsii.Kernel.get(this, "autoScalingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedScaling = software.amazon.jsii.Kernel.get(this, "managedScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedTerminationProtection = software.amazon.jsii.Kernel.get(this, "managedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScalingGroupArn = java.util.Objects.requireNonNull(builder.autoScalingGroupArn, "autoScalingGroupArn is required");
                this.managedScaling = builder.managedScaling;
                this.managedTerminationProtection = builder.managedTerminationProtection;
            }

            @Override
            public final java.lang.String getAutoScalingGroupArn() {
                return this.autoScalingGroupArn;
            }

            @Override
            public final java.lang.Object getManagedScaling() {
                return this.managedScaling;
            }

            @Override
            public final java.lang.String getManagedTerminationProtection() {
                return this.managedTerminationProtection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoScalingGroupArn", om.valueToTree(this.getAutoScalingGroupArn()));
                if (this.getManagedScaling() != null) {
                    data.set("managedScaling", om.valueToTree(this.getManagedScaling()));
                }
                if (this.getManagedTerminationProtection() != null) {
                    data.set("managedTerminationProtection", om.valueToTree(this.getManagedTerminationProtection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingGroupProviderProperty.Jsii$Proxy that = (AutoScalingGroupProviderProperty.Jsii$Proxy) o;

                if (!autoScalingGroupArn.equals(that.autoScalingGroupArn)) return false;
                if (this.managedScaling != null ? !this.managedScaling.equals(that.managedScaling) : that.managedScaling != null) return false;
                return this.managedTerminationProtection != null ? this.managedTerminationProtection.equals(that.managedTerminationProtection) : that.managedTerminationProtection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoScalingGroupArn.hashCode();
                result = 31 * result + (this.managedScaling != null ? this.managedScaling.hashCode() : 0);
                result = 31 * result + (this.managedTerminationProtection != null ? this.managedTerminationProtection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ManagedScaling` property specifies the settings for the Auto Scaling group capacity provider.
     * <p>
     * When managed scaling is enabled, Amazon ECS manages the scale-in and scale-out actions of the Auto Scaling group. Amazon ECS manages a target tracking scaling policy using an Amazon ECS-managed CloudWatch metric with the specified <code>targetCapacity</code> value as the target value for the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling">Using Managed Scaling</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * If managed scaling is disabled, the user must manage the scaling of the Auto Scaling group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedScalingProperty managedScalingProperty = ManagedScalingProperty.builder()
     *         .instanceWarmupPeriod(123)
     *         .maximumScalingStepSize(123)
     *         .minimumScalingStepSize(123)
     *         .status("status")
     *         .targetCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
         * <p>
         * If this parameter is omitted, the default value of <code>300</code> seconds is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceWarmupPeriod() {
            return null;
        }

        /**
         * The maximum number of container instances that Amazon ECS scales in or scales out at one time.
         * <p>
         * If this parameter is omitted, the default value of <code>10000</code> is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumScalingStepSize() {
            return null;
        }

        /**
         * The minimum number of container instances that Amazon ECS scales in or scales out at one time.
         * <p>
         * If this parameter is omitted, the default value of <code>1</code> is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumScalingStepSize() {
            return null;
        }

        /**
         * Determines whether to use managed scaling for the capacity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The target capacity value for the capacity provider.
         * <p>
         * The specified value must be greater than <code>0</code> and less than or equal to <code>100</code> . A value of <code>100</code> results in the Amazon EC2 instances in your Auto Scaling group being completely used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedScalingProperty> {
            java.lang.Number instanceWarmupPeriod;
            java.lang.Number maximumScalingStepSize;
            java.lang.Number minimumScalingStepSize;
            java.lang.String status;
            java.lang.Number targetCapacity;

            /**
             * Sets the value of {@link ManagedScalingProperty#getInstanceWarmupPeriod}
             * @param instanceWarmupPeriod The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
             *                             If this parameter is omitted, the default value of <code>300</code> seconds is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceWarmupPeriod(java.lang.Number instanceWarmupPeriod) {
                this.instanceWarmupPeriod = instanceWarmupPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getMaximumScalingStepSize}
             * @param maximumScalingStepSize The maximum number of container instances that Amazon ECS scales in or scales out at one time.
             *                               If this parameter is omitted, the default value of <code>10000</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumScalingStepSize(java.lang.Number maximumScalingStepSize) {
                this.maximumScalingStepSize = maximumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getMinimumScalingStepSize}
             * @param minimumScalingStepSize The minimum number of container instances that Amazon ECS scales in or scales out at one time.
             *                               If this parameter is omitted, the default value of <code>1</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumScalingStepSize(java.lang.Number minimumScalingStepSize) {
                this.minimumScalingStepSize = minimumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getStatus}
             * @param status Determines whether to use managed scaling for the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getTargetCapacity}
             * @param targetCapacity The target capacity value for the capacity provider.
             *                       The specified value must be greater than <code>0</code> and less than or equal to <code>100</code> . A value of <code>100</code> results in the Amazon EC2 instances in your Auto Scaling group being completely used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacity(java.lang.Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedScalingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedScalingProperty {
            private final java.lang.Number instanceWarmupPeriod;
            private final java.lang.Number maximumScalingStepSize;
            private final java.lang.Number minimumScalingStepSize;
            private final java.lang.String status;
            private final java.lang.Number targetCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceWarmupPeriod = software.amazon.jsii.Kernel.get(this, "instanceWarmupPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumScalingStepSize = software.amazon.jsii.Kernel.get(this, "maximumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumScalingStepSize = software.amazon.jsii.Kernel.get(this, "minimumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetCapacity = software.amazon.jsii.Kernel.get(this, "targetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceWarmupPeriod = builder.instanceWarmupPeriod;
                this.maximumScalingStepSize = builder.maximumScalingStepSize;
                this.minimumScalingStepSize = builder.minimumScalingStepSize;
                this.status = builder.status;
                this.targetCapacity = builder.targetCapacity;
            }

            @Override
            public final java.lang.Number getInstanceWarmupPeriod() {
                return this.instanceWarmupPeriod;
            }

            @Override
            public final java.lang.Number getMaximumScalingStepSize() {
                return this.maximumScalingStepSize;
            }

            @Override
            public final java.lang.Number getMinimumScalingStepSize() {
                return this.minimumScalingStepSize;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Number getTargetCapacity() {
                return this.targetCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceWarmupPeriod() != null) {
                    data.set("instanceWarmupPeriod", om.valueToTree(this.getInstanceWarmupPeriod()));
                }
                if (this.getMaximumScalingStepSize() != null) {
                    data.set("maximumScalingStepSize", om.valueToTree(this.getMaximumScalingStepSize()));
                }
                if (this.getMinimumScalingStepSize() != null) {
                    data.set("minimumScalingStepSize", om.valueToTree(this.getMinimumScalingStepSize()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTargetCapacity() != null) {
                    data.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedScalingProperty.Jsii$Proxy that = (ManagedScalingProperty.Jsii$Proxy) o;

                if (this.instanceWarmupPeriod != null ? !this.instanceWarmupPeriod.equals(that.instanceWarmupPeriod) : that.instanceWarmupPeriod != null) return false;
                if (this.maximumScalingStepSize != null ? !this.maximumScalingStepSize.equals(that.maximumScalingStepSize) : that.maximumScalingStepSize != null) return false;
                if (this.minimumScalingStepSize != null ? !this.minimumScalingStepSize.equals(that.minimumScalingStepSize) : that.minimumScalingStepSize != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.targetCapacity != null ? this.targetCapacity.equals(that.targetCapacity) : that.targetCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceWarmupPeriod != null ? this.instanceWarmupPeriod.hashCode() : 0;
                result = 31 * result + (this.maximumScalingStepSize != null ? this.maximumScalingStepSize.hashCode() : 0);
                result = 31 * result + (this.minimumScalingStepSize != null ? this.minimumScalingStepSize.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.targetCapacity != null ? this.targetCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder();
        }

        /**
         * The Auto Scaling group settings for the capacity provider.
         * <p>
         * @return {@code this}
         * @param autoScalingGroupProvider The Auto Scaling group settings for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }
        /**
         * The Auto Scaling group settings for the capacity provider.
         * <p>
         * @return {@code this}
         * @param autoScalingGroupProvider The Auto Scaling group settings for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.IResolvable autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * If a name is specified, it cannot start with <code>aws</code> , <code>ecs</code> , or <code>fargate</code> . If no name is specified, a default name in the <code>CFNStackName-CFNResourceName-RandomString</code> format is used.
         * <p>
         * @return {@code this}
         * @param name The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The metadata that you apply to the capacity provider to help you categorize and organize it.
         * <p>
         * Each tag consists of a key and an optional value. You define both.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
         * <li>Tag keys and values are case-sensitive.</li>
         * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the capacity provider to help you categorize and organize it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.CfnCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
