package software.amazon.awscdk.services.ecr;

/**
 * Indicates whether server-side encryption is enabled for the object, and whether that encryption is from the AWS Key Management Service (AWS KMS) or from Amazon S3 managed encryption (SSE-S3).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository.Builder.create(this, "Repo")
 *         .encryption(RepositoryEncryption.KMS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.064Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.RepositoryEncryption")
public class RepositoryEncryption extends software.amazon.jsii.JsiiObject {

    protected RepositoryEncryption(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RepositoryEncryption(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AES_256 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.RepositoryEncryption.class, "AES_256", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.RepositoryEncryption.class));
        KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.RepositoryEncryption.class, "KMS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.RepositoryEncryption.class));
    }

    /**
     * @param value the string value of the encryption. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RepositoryEncryption(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * 'AES256'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.RepositoryEncryption AES_256;

    /**
     * 'KMS'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.RepositoryEncryption KMS;

    /**
     * the string value of the encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
