package software.amazon.awscdk.services.ec2;

/**
 * The following table describes all of the available fields for a flow log record.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc = new Vpc(this, "Vpc");
 * vpc.addFlowLog("FlowLog", FlowLogOptions.builder()
 *         .logFormat(List.of(LogFormat.DST_PORT, LogFormat.SRC_PORT))
 *         .build());
 * // If you just want to add a field to the default field
 * vpc.addFlowLog("FlowLog", FlowLogOptions.builder()
 *         .logFormat(List.of(LogFormat.VERSION, LogFormat.ALL_DEFAULT_FIELDS))
 *         .build());
 * // If AWS CDK does not support the new fields
 * vpc.addFlowLog("FlowLog", FlowLogOptions.builder()
 *         .logFormat(List.of(LogFormat.SRC_PORT, LogFormat.custom("${new-field}")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.985Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LogFormat")
public class LogFormat extends software.amazon.jsii.JsiiObject {

    protected LogFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACCOUNT_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "ACCOUNT_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        ALL_DEFAULT_FIELDS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "ALL_DEFAULT_FIELDS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        AZ_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "AZ_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        BYTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "BYTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        DST_ADDR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "DST_ADDR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        DST_PORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "DST_PORT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        FLOW_DIRECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "FLOW_DIRECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        INTERFACE_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "INTERFACE_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PACKETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PACKETS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PKT_DST_ADDR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PKT_DST_ADDR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PKT_DST_AWS_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PKT_DST_AWS_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PKT_SRC_ADDR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PKT_SRC_ADDR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PKT_SRC_AWS_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PKT_SRC_AWS_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        PROTOCOL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "PROTOCOL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        REGION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "REGION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        SRC_ADDR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "SRC_ADDR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        SRC_PORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "SRC_PORT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        SUBLOCATION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "SUBLOCATION_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        SUBLOCATION_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "SUBLOCATION_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        TRAFFIC_PATH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "TRAFFIC_PATH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
        VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.LogFormat.class, "VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class));
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LogFormat(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A custom format string.
     * <p>
     * Gives full control over the format string fragment.
     * <p>
     * @param formatString This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LogFormat custom(final @org.jetbrains.annotations.NotNull java.lang.String formatString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.LogFormat.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class), new Object[] { java.util.Objects.requireNonNull(formatString, "formatString is required") });
    }

    /**
     * A custom field name.
     * <p>
     * If there is no ready-made constant for a new field yet, you can use this.
     * The field name will automatically be wrapped in <code>${ ... }</code>.
     * <p>
     * @param field This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LogFormat field(final @org.jetbrains.annotations.NotNull java.lang.String field) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.LogFormat.class, "field", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class), new Object[] { java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * The AWS account ID of the owner of the source network interface for which traffic is recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat ACCOUNT_ID;

    /**
     * The default format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat ALL_DEFAULT_FIELDS;

    /**
     * The ID of the Availability Zone that contains the network interface for which traffic is recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat AZ_ID;

    /**
     * The number of bytes transferred during the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat BYTES;

    /**
     * The destination address for outgoing traffic, or the IPv4 or IPv6 address of the network interface for incoming traffic on the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat DST_ADDR;

    /**
     * The destination port of the traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat DST_PORT;

    /**
     * The direction of the flow with respect to the interface where traffic is captured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat FLOW_DIRECTION;

    /**
     * The ID of the network interface for which the traffic is recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat INTERFACE_ID;

    /**
     * The number of packets transferred during the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PACKETS;

    /**
     * The packet-level (original) destination IP address for the traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PKT_DST_ADDR;

    /**
     * The name of the subset of IP address ranges for the pkt-dstaddr field, if the destination IP address is for an AWS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PKT_DST_AWS_SERVICE;

    /**
     * The packet-level (original) source IP address of the traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PKT_SRC_ADDR;

    /**
     * The name of the subset of IP address ranges for the pkt-srcaddr field, if the source IP address is for an AWS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PKT_SRC_AWS_SERVICE;

    /**
     * The IANA protocol number of the traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat PROTOCOL;

    /**
     * The Region that contains the network interface for which traffic is recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat REGION;

    /**
     * The source address for incoming traffic, or the IPv4 or IPv6 address of the network interface for outgoing traffic on the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat SRC_ADDR;

    /**
     * The source port of the traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat SRC_PORT;

    /**
     * The ID of the sublocation that contains the network interface for which traffic is recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat SUBLOCATION_ID;

    /**
     * The type of sublocation that's returned in the sublocation-id field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat SUBLOCATION_TYPE;

    /**
     * The path that egress traffic takes to the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat TRAFFIC_PATH;

    /**
     * The VPC Flow Logs version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.LogFormat VERSION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
