package software.amazon.awscdk.services.ec2;

/**
 * An abstract Provider of IpAddresses.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.ec2.IpAddresses;
 * CfnIPAMPool pool;
 * Vpc.Builder.create(stack, "TheVPC")
 *         .ipAddresses(IpAddresses.awsIpamAllocation(AwsIpamProps.builder()
 *                 .ipv4IpamPoolId(pool.getRef())
 *                 .ipv4NetmaskLength(18)
 *                 .defaultSubnetIpv4NetmaskLength(24)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.976Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpAddresses")
public class IpAddresses extends software.amazon.jsii.JsiiObject {

    protected IpAddresses(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IpAddresses(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Used to provide centralized Ip Address Management services for your VPC.
     * <p>
     * Uses VPC Cidr allocations from AWS IPAM
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-it-is-ipam.html">https://docs.aws.amazon.com/vpc/latest/ipam/what-it-is-ipam.html</a>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IIpAddresses awsIpamAllocation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AwsIpamProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.IpAddresses.class, "awsIpamAllocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IIpAddresses.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Used to provide local Ip Address Management services for your VPC.
     * <p>
     * VPC Cidr is supplied at creation and subnets are calculated locally
     * <p>
     * @param cidrBlock This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IIpAddresses cidr(final @org.jetbrains.annotations.NotNull java.lang.String cidrBlock) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.IpAddresses.class, "cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IIpAddresses.class), new Object[] { java.util.Objects.requireNonNull(cidrBlock, "cidrBlock is required") });
    }
}
