package software.amazon.awscdk.services.ec2;

/**
 * What size of instance to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Build build;
 * BuildFleet fleet = BuildFleet.Builder.create(this, "Game server fleet")
 *         .fleetName("test-fleet")
 *         .content(build)
 *         .instanceType(InstanceType.of(InstanceClass.C4, InstanceSize.LARGE))
 *         .runtimeConfiguration(RuntimeConfiguration.builder()
 *                 .serverProcesses(List.of(ServerProcess.builder()
 *                         .launchPath("/local/game/GameLiftExampleServer.x86_64")
 *                         .build()))
 *                 .build())
 *         .ingressRules(List.of(IngressRule.builder()
 *                 .source(Peer.anyIpv4())
 *                 .port(Port.tcpRange(100, 200))
 *                 .build()))
 *         .build();
 * // Allowing a specific CIDR for port 1111 on UDP Protocol
 * fleet.addIngressRule(Peer.ipv4("1.2.3.4/32"), Port.udp(1111));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.971Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceSize")
public enum InstanceSize {
    /**
     * Instance size NANO (nano).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NANO,
    /**
     * Instance size MICRO (micro).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MICRO,
    /**
     * Instance size SMALL (small).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     * Instance size MEDIUM (medium).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Instance size LARGE (large).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     * Instance size XLARGE (xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE,
    /**
     * Instance size XLARGE2 (2xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE2,
    /**
     * Instance size XLARGE3 (3xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE3,
    /**
     * Instance size XLARGE4 (4xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE4,
    /**
     * Instance size XLARGE6 (6xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE6,
    /**
     * Instance size XLARGE8 (8xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE8,
    /**
     * Instance size XLARGE9 (9xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE9,
    /**
     * Instance size XLARGE10 (10xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE10,
    /**
     * Instance size XLARGE12 (12xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE12,
    /**
     * Instance size XLARGE16 (16xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE16,
    /**
     * Instance size XLARGE18 (18xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE18,
    /**
     * Instance size XLARGE24 (24xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE24,
    /**
     * Instance size XLARGE32 (32xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE32,
    /**
     * Instance size XLARGE48 (48xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE48,
    /**
     * Instance size XLARGE56 (56xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE56,
    /**
     * Instance size XLARGE56 (112xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE112,
    /**
     * Instance size METAL (metal).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    METAL,
}
