package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's Read/Write capacity modes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .billingMode(BillingMode.PAY_PER_REQUEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.534Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.BillingMode")
public enum BillingMode {
    /**
     * Pay only for what you use.
     * <p>
     * You don't configure Read/Write capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PAY_PER_REQUEST,
    /**
     * Explicitly specified Read/Write capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PROVISIONED,
}
