package software.amazon.awscdk.services.dynamodb;

/**
 * Data types for attributes within a table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .build();
 * IMetric metric = table.metricThrottledRequestsForOperations(OperationsMetricOptions.builder()
 *         .operations(List.of(Operation.PUT_ITEM))
 *         .period(Duration.minutes(1))
 *         .build());
 * Alarm.Builder.create(stack, "Alarm")
 *         .metric(metric)
 *         .evaluationPeriods(1)
 *         .threshold(1)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.534Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.AttributeType")
public enum AttributeType {
    /**
     * Up to 400KiB of binary data (which must be encoded as base64 before sending to DynamoDB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BINARY,
    /**
     * Numeric values made of up to 38 digits (positive, negative or zero).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NUMBER,
    /**
     * Up to 400KiB of UTF-8 encoded text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
}
