package software.amazon.awscdk.services.docdb;

/**
 * Connection endpoint of a database cluster or instance.
 * <p>
 * Consists of a combination of hostname and port.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * Endpoint endpoint = new Endpoint("address", 123);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.528Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.Endpoint")
public class Endpoint extends software.amazon.jsii.JsiiObject {

    protected Endpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Endpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs an Endpoint instance.
     * <p>
     * @param address - The hostname or address of the endpoint. This parameter is required.
     * @param port - The port number of the endpoint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Endpoint(final @org.jetbrains.annotations.NotNull java.lang.String address, final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(address, "address is required"), java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * Returns the port number as a string representation that can be used for embedding within other strings.
     * <p>
     * This is intended to deal with CDK's token system. Numeric CDK tokens are not expanded when their string
     * representation is embedded in a string. This function returns the port either as an unresolved string token or
     * as a resolved string representation of the port value.
     * <p>
     * @return An (un)resolved string representation of the endpoint's port number
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String portAsString() {
        return software.amazon.jsii.Kernel.call(this, "portAsString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The hostname of the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHostname() {
        return software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number of the endpoint.
     * <p>
     * This can potentially be a CDK token. If you need to embed the port in a string (e.g. instance user data script),
     * use {&#64;link Endpoint.portAsString}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The combination of ``HOSTNAME:PORT`` for this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSocketAddress() {
        return software.amazon.jsii.Kernel.get(this, "socketAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
