package software.amazon.awscdk.services.cognito;

/**
 * User pool operations to which lambda triggers can be attached.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authChallengeFn = Function.Builder.create(this, "authChallengeFn")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build();
 * UserPool userpool = UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .lambdaTriggers(UserPoolTriggers.builder()
 *                 .createAuthChallenge(authChallengeFn)
 *                 .build())
 *         .build();
 * userpool.addTrigger(UserPoolOperation.USER_MIGRATION, Function.Builder.create(this, "userMigrationFn")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.183Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolOperation")
public class UserPoolOperation extends software.amazon.jsii.JsiiObject {

    protected UserPoolOperation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolOperation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CREATE_AUTH_CHALLENGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CREATE_AUTH_CHALLENGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_EMAIL_SENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_EMAIL_SENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_MESSAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_MESSAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_SMS_SENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_SMS_SENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        DEFINE_AUTH_CHALLENGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "DEFINE_AUTH_CHALLENGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        POST_AUTHENTICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "POST_AUTHENTICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        POST_CONFIRMATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "POST_CONFIRMATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_AUTHENTICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_AUTHENTICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_SIGN_UP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_SIGN_UP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_TOKEN_GENERATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_TOKEN_GENERATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        USER_MIGRATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "USER_MIGRATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        VERIFY_AUTH_CHALLENGE_RESPONSE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "VERIFY_AUTH_CHALLENGE_RESPONSE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
    }

    /**
     * A custom user pool operation.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolOperation of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Creates a challenge in a custom auth flow.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CREATE_AUTH_CHALLENGE;

    /**
     * Amazon Cognito invokes this trigger to send email notifications to users.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-email-sender.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-email-sender.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_EMAIL_SENDER;

    /**
     * Advanced customization and localization of messages.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_MESSAGE;

    /**
     * Amazon Cognito invokes this trigger to send email notifications to users.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sms-sender.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sms-sender.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_SMS_SENDER;

    /**
     * Determines the next challenge in a custom auth flow.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation DEFINE_AUTH_CHALLENGE;

    /**
     * Event logging for custom analytics.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation POST_AUTHENTICATION;

    /**
     * Custom welcome messages or event logging for custom analytics.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation POST_CONFIRMATION;

    /**
     * Custom validation to accept or deny the sign-in request.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_AUTHENTICATION;

    /**
     * Custom validation to accept or deny the sign-up request.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_SIGN_UP;

    /**
     * Add or remove attributes in Id tokens.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_TOKEN_GENERATION;

    /**
     * Migrate a user from an existing user directory to user pools.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation USER_MIGRATION;

    /**
     * Determines if a response is correct in a custom auth flow.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation VERIFY_AUTH_CHALLENGE_RESPONSE;

    /**
     * The key to use in `CfnUserPool.LambdaConfigProperty`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOperationName() {
        return software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
