package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of {@link ServerDeploymentConfig}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .deploymentConfigName("MyDeploymentConfiguration") // optional property
 *         // one of these is required, but both cannot be specified at the same time
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.914Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.ServerDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(ServerDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.BaseDeploymentConfigOptions {

    /**
     * Minimum number of healthy hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerDeploymentConfigProps> {
        software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link ServerDeploymentConfigProps#getMinimumHealthyHosts}
         * @param minimumHealthyHosts Minimum number of healthy hosts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerDeploymentConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerDeploymentConfigProps {
        private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minimumHealthyHosts = software.amazon.jsii.Kernel.get(this, "minimumHealthyHosts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minimumHealthyHosts = java.util.Objects.requireNonNull(builder.minimumHealthyHosts, "minimumHealthyHosts is required");
            this.deploymentConfigName = builder.deploymentConfigName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
            return this.minimumHealthyHosts;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.ServerDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerDeploymentConfigProps.Jsii$Proxy that = (ServerDeploymentConfigProps.Jsii$Proxy) o;

            if (!minimumHealthyHosts.equals(that.minimumHealthyHosts)) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minimumHealthyHosts.hashCode();
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
