package software.amazon.awscdk.services.cloudwatch;

/**
 * Statistic to use over the aggregation period.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BuildFleet fleet;
 * // Alarm that triggers when the per-second average of not used instances exceed 10%
 * MathExpression instancesUsedRatio = MathExpression.Builder.create()
 *         .expression("1 - (activeInstances / idleInstances)")
 *         .usingMetrics(Map.of(
 *                 "activeInstances", fleet.metric("ActiveInstances", MetricOptions.builder().statistic(Statistic.SUM).build()),
 *                 "idleInstances", fleet.metricIdleInstances()))
 *         .build();
 * Alarm.Builder.create(this, "Alarm")
 *         .metric(instancesUsedRatio)
 *         .threshold(0.1)
 *         .evaluationPeriods(3)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Statistic")
public enum Statistic {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAMPLE_COUNT,
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AVERAGE,
    /**
     * All values submitted for the matching metric added together.
     * <p>
     * This statistic can be useful for determining the total volume of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SUM,
    /**
     * The lowest value observed during the specified period.
     * <p>
     * You can use this value to determine low volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MINIMUM,
    /**
     * The highest value observed during the specified period.
     * <p>
     * You can use this value to determine high volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAXIMUM,
}
