package software.amazon.awscdk.services.athena;

/**
 * A CloudFormation `AWS::Athena::DataCatalog`.
 * <p>
 * The AWS::Athena::DataCatalog resource specifies an Amazon Athena data catalog, which contains a name, description, type, parameters, and tags. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_DataCatalog.html">DataCatalog</a> in the <em>Amazon Athena API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnDataCatalog cfnDataCatalog = CfnDataCatalog.Builder.create(this, "MyCfnDataCatalog")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.116Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnDataCatalog")
public class CfnDataCatalog extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataCatalog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataCatalog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.athena.CfnDataCatalog.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Athena::DataCatalog`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataCatalog(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.athena.CfnDataCatalogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the data catalog.
     * <p>
     * The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data catalog.
     * <p>
     * The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A description of the data catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the data catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the Lambda function or functions to use for the data catalog.
     * <p>
     * The mapping used depends on the catalog type.
     * <p>
     * <ul>
     * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
     * <p>
     * <ul>
     * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
     * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
     * </ul>
     * <p>
     * <code>function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
     * </ul>
     * <p>
     * <code>catalog-id= *catalog_id*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
     * <li>Queries that specify a GLUE data catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</li>
     * <li>In Regions where Athena engine version 2 is not available, creating new GLUE data catalogs results in an <code>INVALID_INPUT</code> error.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the Lambda function or functions to use for the data catalog.
     * <p>
     * The mapping used depends on the catalog type.
     * <p>
     * <ul>
     * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
     * <p>
     * <ul>
     * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
     * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
     * </ul>
     * <p>
     * <code>function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
     * </ul>
     * <p>
     * <code>catalog-id= *catalog_id*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
     * <li>Queries that specify a GLUE data catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</li>
     * <li>In Regions where Athena engine version 2 is not available, creating new GLUE data catalogs results in an <code>INVALID_INPUT</code> error.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * Specifies the Lambda function or functions to use for the data catalog.
     * <p>
     * The mapping used depends on the catalog type.
     * <p>
     * <ul>
     * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
     * <p>
     * <ul>
     * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
     * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
     * </ul>
     * <p>
     * <code>function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
     * </ul>
     * <p>
     * <code>catalog-id= *catalog_id*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
     * <li>Queries that specify a GLUE data catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</li>
     * <li>In Regions where Athena engine version 2 is not available, creating new GLUE data catalogs results in an <code>INVALID_INPUT</code> error.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.athena.CfnDataCatalog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.athena.CfnDataCatalog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.athena.CfnDataCatalogProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.athena.CfnDataCatalogProps.Builder();
        }

        /**
         * The name of the data catalog.
         * <p>
         * The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
         * <p>
         * @return {@code this}
         * @param name The name of the data catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
         * <p>
         * @return {@code this}
         * @param type The type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * A description of the data catalog.
         * <p>
         * @return {@code this}
         * @param description A description of the data catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the Lambda function or functions to use for the data catalog.
         * <p>
         * The mapping used depends on the catalog type.
         * <p>
         * <ul>
         * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
         * </ul>
         * <p>
         * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
         * <p>
         * <ul>
         * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
         * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
         * </ul>
         * <p>
         * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
         * <p>
         * <ul>
         * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
         * </ul>
         * <p>
         * <code>function= *lambda_arn*</code>
         * <p>
         * <ul>
         * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
         * </ul>
         * <p>
         * <code>catalog-id= *catalog_id*</code>
         * <p>
         * <ul>
         * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
         * <li>Queries that specify a GLUE data catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</li>
         * <li>In Regions where Athena engine version 2 is not available, creating new GLUE data catalogs results in an <code>INVALID_INPUT</code> error.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param parameters Specifies the Lambda function or functions to use for the data catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * Specifies the Lambda function or functions to use for the data catalog.
         * <p>
         * The mapping used depends on the catalog type.
         * <p>
         * <ul>
         * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
         * </ul>
         * <p>
         * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
         * <p>
         * <ul>
         * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
         * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
         * </ul>
         * <p>
         * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
         * <p>
         * <ul>
         * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
         * </ul>
         * <p>
         * <code>function= *lambda_arn*</code>
         * <p>
         * <ul>
         * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
         * </ul>
         * <p>
         * <code>catalog-id= *catalog_id*</code>
         * <p>
         * <ul>
         * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
         * <li>Queries that specify a GLUE data catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</li>
         * <li>In Regions where Athena engine version 2 is not available, creating new GLUE data catalogs results in an <code>INVALID_INPUT</code> error.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param parameters Specifies the Lambda function or functions to use for the data catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The tags (key-value pairs) to associate with this resource.
         * <p>
         * @return {@code this}
         * @param tags The tags (key-value pairs) to associate with this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.athena.CfnDataCatalog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.athena.CfnDataCatalog build() {
            return new software.amazon.awscdk.services.athena.CfnDataCatalog(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
